<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT . '/projet/class/project.class.php'; 
require_once DOL_DOCUMENT_ROOT . '/projet/class/task.class.php'; 
 
class justif_task extends CommonObject{ 


	public $errors = array();
	public $rowid;
	

	public $element='justif_task';
	public $table_element='justif_task';


	public function __construct($db){
		$this->db = $db;
		return 1;
	}


	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";
		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}
		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			echo "Merci de réactiver le module, Si l'erreur persiste, n'hésite pas à nous contacter";
			die;
			return 0;
		} 
		return $this->db->db->insert_id;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = "UPDATE " . MAIN_DB_PREFIX .get_class($this). " SET ";

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : "'". $val ."'";
                $sql .= "`". $key. "` = ". $val .",";
            }

        $sql  = substr($sql, 0, -1);
        $sql .= " WHERE rowid = " . $id;
        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    		 =  $obj->rowid;
                $line->rowid         =  $obj->rowid;
                $line->presence      =  $obj->presence;
				$line->fk_user 		 =  $obj->fk_user;
				$line->fk_task 	     =  $obj->fk_task;
				$line->dure 	     =  $obj->dure;
				$line->date 	     =  $obj->date;
				$line->justif 	     =  $obj->justif;
				$line->msg_justif 	 =  $obj->msg_justif;

				$line->duretask 	 =  $obj->duretask;
				// $line->tempcons 	 =  $obj->tempcons;

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			   = $this->db->fetch_object($resql);
                $this->id          = $obj->rowid;
                $this->rowid       = $obj->rowid;
                $this->presence       = $obj->presence;
                $this->fk_user 	   = $obj->fk_user;
				$this->fk_task 	   = $obj->fk_task;
				$this->date 	   = $obj->date;
				$this->dure 	   = $obj->dure;
				$this->justif 	   = $obj->justif;
				$this->msg_justif  = $obj->msg_justif;

				
				$line->duretask 	 =  $obj->duretask;
				// $line->tempcons 	 =  $obj->tempcons;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='suivi_essence',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose=dol_buildpath('/presences/card.php?rowid='.$this->rowid);
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
       
    	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/presences/img/object_presences.png" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }

    public function array_project($id)
    {
    	$html ='<option value="0"></option>';
    	$sql = 'SELECT * FROM '.MAIN_DB_PREFIX.'projet';
    	$resql = $this->db->query($sql);
    	if($resql){
    		$num_rows = $this->db->num_rows($resql);
            if ($num_rows)
            {
                while ($obj = $this->db->fetch_object($resql)) {
                	if($obj->rowid == $id){
                		$select = 'selected';
                	}else
                		$select ='';
	                $html .= '<option '.$select.' value="'.$obj->rowid.'" >'.$obj->ref.'</option>';
                }
            }
    	}
    	return $html;
    }

    public function array_task($id, $id_task=0)
    {
    	$html ='<option value="0"></option>';
    	$sql = 'SELECT * FROM '.MAIN_DB_PREFIX.'projet_task WHERE fk_projet ='.$id;
    	$resql = $this->db->query($sql);
    	if($resql){
    		$num_rows = $this->db->num_rows($resql);
            if ($num_rows)
            {
                while ($obj = $this->db->fetch_object($resql)) {
                	if($id_task == $obj->rowid){
                		$select ="selected";
                	}else{
                		$select ="";
                	}
	                $html .= '<option '.$select.' value="'.$obj->rowid.'" >'.$obj->ref.'</option>';
                }
            }
    	}
    	return $html;
    }

   

   


}