    <?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *     \file        admin/admin.php
 *     \ingroup    nexttheme
 *     \brief        This file is an example module setup page
 *                 Put some comments here
 */
// Dolibarr environment
$res=@include("../../main.inc.php");                    // For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
    $res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../../main.inc.php");        // For "custom" directory

// Libraries
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';

dol_include_once('/presences/class/presences.class.php');

// Translations
$langs->load("admin");
$langs->load("avancementtravaux@avancementtravaux");

// Access control
if (! $user->admin) accessforbidden();
$presence = new presences($db);


/*
 * Actions
*/

$mesg="";
$action = GETPOST('action', 'alpha');


if ($action == 'set_horaire_societe') {
    // die(); 
    $type_horaire = GETPOST("type_horaire");
    $nb_h_w = GETPOST("nb_h_w");

    $time_in = GETPOST("heure_in").':'.GETPOST("minute_in");
    $time_out = GETPOST("heure_out").':'.GETPOST("minute_out");
    
    $time_in_m = GETPOST("heure_in_m").':'.GETPOST("minute_in_m");
    $time_out_m = GETPOST("heure_out_m").':'.GETPOST("minute_out_m");
    $time_in_s= GETPOST("heure_in_s").':'.GETPOST("minute_in_s");
    $time_out_s = GETPOST("heure_out_s").':'.GETPOST("minute_out_s");

    $timezone = GETPOST("timezone");


    dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_TYPE_HORAIRE", $type_horaire, 'chaine', 0, '', $conf->entity);

    dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_TYPE_NB_HEUR_WEEK", $nb_h_w, 'chaine', 0, '', $conf->entity);
    if($time_in){
        dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_IN", $time_in, 'time', 0, '', $conf->entity);
    }
    if($time_out){
        dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_OUT", $time_out, 'time', 0, '', $conf->entity);
    }
    if($time_in_m){
        dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_IN_M", $time_in_m, 'time', 0, '', $conf->entity);
    }
    if($time_out_m){
        dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_OUT_M", $time_out_m, 'time', 0, '', $conf->entity);
    }
    if($time_in_s){
        dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_IN_S", $time_in_s, 'time', 0, '', $conf->entity);
    }
    if($time_out_s){
        dolibarr_set_const($db, "MAIN_INFO_SOCIETE_TIME_OUT_S", $time_out_s, 'time', 0, '', $conf->entity);
    }
    if($timezone){
        dolibarr_set_const($db, "MAIN_DATE_IN_MEMORY_ARE_GMT_PRESENCES", $timezone, 'chaine', 0, '', 0);
    }
}

// Get settings
$societetype=$conf->global->AVANCEMENTTRAVAUX_SOCIETE_TYPE;
if(empty($societetype))
    $societetype = "BET";

/*
 * View
 */

$page_name = "presencesSetup";
llxHeader('', $langs->trans($page_name),'','','','', array(''),'' );

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'    . $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);


dol_htmloutput_mesg($mesg);

?>
<style>
    #fr_const_temps td.type_horaire{
        padding-left: 35px;
    }
    #fr_const_temps td.timezone>span{
        width: 400px !important;
    }
</style>
<?php
// Setup page goes here

print '<br>'."\n";

// COLORS
// print '<div class="subsetting-title">' . $langs->trans("AS_SettingsColors") . '</div>';
print '<form  method="post" action="admin.php" id="fr_const_temps">';
    print '<input type="hidden" value="set_horaire_societe" name="action">';
    print '<table class="noborder as-settings-colors">';

        // HEADER ROW
        
        
        print '
        <tr class="liste_titre">
            <th colspan="4">' . $langs->trans("temps_horaire") . '</td>
        </tr>
        '."\n";

        print '<tr class="">';
            print '<td>' . $langs->trans("timezone") . '</td>';
            print '<td colspan="3" class="timezone">';
                print $presence->selectTimezone();
            print '</td>';
        print "</tr>\n";

        // SET PRIMARY COLOR

        print '<tr class="pair">';
            print '<td>' . $langs->trans("temps_travail") . '</td>';
            print '<td colspan="3">';
            $nb_h = ($conf->global->MAIN_INFO_SOCIETE_TIME_TYPE_NB_HEUR_WEEK ? $conf->global->MAIN_INFO_SOCIETE_TIME_TYPE_NB_HEUR_WEEK : 0);
            print '<input type="number" value="'.$nb_h.'" min="0" name="nb_h_w">';
            print '</td>';
        print '</tr>';

        print '<tr class="pair">';
            print '<td>' . $langs->trans("type_horaire") . '</td>';
            print '<td class="type_horaire" colspan="3">';

                print '<div class="confidential">';
                $check_1 = '';$check_2 = '';
                if($conf->global->MAIN_INFO_SOCIETE_TIME_TYPE_HORAIRE == 'partiel'){
                    $check_1 = 'checked';
                }else{
                    $check_2 = 'checked';
                }
                    print '<input type="radio" value="partiel" '.$check_1.' class="check_conf" name="type_horaire" id="check_part"  style="display:none">';
                    print '<label class="confidential label" for="check_part">'.$langs->trans("temp_part").'</label>';
                print '</div>';
                
                print '<div class="confidential">';
                    print '<input type="radio" value="continu" '.$check_2.' class="check_conf" name="type_horaire" id="check_compl" style="display:none">';
                    print '<label class="confidential label" for="check_compl">'.$langs->trans("temp_complt").'</label>';
                print '</div>';
                
            print '</td>';
        print '</tr>';
        
        $sty = '';
        if($check_2)
            $sty = 'display:none;';
        print '<tr class="tr_partiel" style="'.$sty.'">';
            print '<td style="width: 215px;">'.$langs->trans("matin").'</td>';
            print '<td style="width: 150px;"><b>'.$langs->trans("From").' </b>';
                $data_time_d = explode(':',$conf->global->MAIN_INFO_SOCIETE_TIME_IN_M);
                print '<select name="heure_in_m" >';
                    for ($i=0; $i < 24; $i++) { 
                        $select_h ='';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[0]){
                            $select_h = 'selected';
                        }else{
                            $select_h = '';
                        }
                        print '<option value="'.$i.'" '.$select_h.'>'.$i.'</option>';
                    }
                print '</select>';
                print ' : ';
                print '<select name="minute_in_m" >';
                    for ($i=0; $i < 60; $i++) { 
                        $select_min = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[1]){
                            $select_min = 'selected';
                        }else{
                            $select_min = '';
                        }
                        print '<option value="'.$i.'" '.$select_min.'>'.$i.'</option>';
                    }
                print '</select>';
            print '</td>';
            print '<td><b>'. $langs->trans("To").' </b>';
                $data_time_d = explode(':',$conf->global->MAIN_INFO_SOCIETE_TIME_OUT_M);
                print '<select name="heure_out_m" >';
                    for ($i=0; $i < 24; $i++) { 
                        $select_h ='';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[0]){
                            $select_h = 'selected';
                        }else{
                            $select_h = '';
                        }
                        print '<option value="'.$i.'" '.$select_h.'>'.$i.'</option>';
                    }
                print '</select>';
                print ' : ';
                print '<select name="minute_out_m" >';
                    for ($i=0; $i < 60; $i++) { 
                        $select_min = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[1]){
                            $select_min = 'selected';
                        }else{
                            $select_min = '';
                        }
                        print '<option value="'.$i.'" '.$select_min.'>'.$i.'</option>';
                    }
                print '</select>';
            print '</td>';
        print '</tr>';

        print '<tr class="tr_partiel" style="'.$sty.'">';
            print '<td style="width: 215px;">' . $langs->trans("apres_midi")  .'</td>';
            print '<td style="width: 150px;"><b>'. $langs->trans("From").' </b>';
                $data_time_f = explode(':',$conf->global->MAIN_INFO_SOCIETE_TIME_IN_S);
                print '<select name="heure_in_s" >';
                    for ($i=0; $i < 24; $i++) { 
                        $select_h = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_f[0]){
                            $select_h = 'selected';
                        }else{
                            $select_h = '';
                        }
                        print '<option value="'.$i.'" '.$select_h.'>'.$i.'</option>';
                    }
                print '</select>';
                print ' : ';
                print '<select name="minute_in_s" >';
                    for ($i=0; $i < 60; $i++) { 
                        $select_min = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_f[1]){
                            $select_min = 'selected';
                        }else{
                            $select_min = '';
                        }
                        print '<option value="'.$i.'" '.$select_min.'>'.$i.'</option>';
                    }
                print '</select>';
            print '</td>';
            print '<td><b>'.$langs->trans('To').'</b>';
                $data_time_d = explode(':',$conf->global->MAIN_INFO_SOCIETE_TIME_OUT_S);
                print '<select name="heure_out_s" >';
                    for ($i=0; $i < 24; $i++) { 
                        $select_h ='';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[0]){
                            $select_h = 'selected';
                        }else{
                            $select_h = '';
                        }
                        print '<option value="'.$i.'" '.$select_h.'>'.$i.'</option>';
                    }
                print '</select>';
                print ' : ';
                print '<select name="minute_out_s" >';
                    for ($i=0; $i < 60; $i++) { 
                        $select_min = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[1]){
                            $select_min = 'selected';
                        }else{
                            $select_min = '';
                        }
                        print '<option value="'.$i.'" '.$select_min.'>'.$i.'</option>';
                    }
                print '</select>';
            print '</td>';


        print '</tr>';

        $sty = '';
        if($check_1)
            $sty = 'display:none;';
        print '<tr class="tr_complet" style="'.$sty.'">';
            print '<td style="width: 215px;">'.$langs->trans("temp_horaire").'</td>';
            print '<td style="width: 150px;"><b>'.$langs->trans("From").' </b>';
                $data_time_d = explode(':',$conf->global->MAIN_INFO_SOCIETE_TIME_IN);
                print '<select name="heure_in" >';
                    for ($i=0; $i < 24; $i++) { 
                        $select_h ='';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[0]){
                            $select_h = 'selected';
                        }else{
                            $select_h = '';
                        }
                        print '<option value="'.$i.'" '.$select_h.'>'.$i.'</option>';
                    }
                print '</select>';
                print ' : ';
                print '<select name="minute_in" >';
                    for ($i=0; $i < 60; $i++) { 
                        $select_min = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_d[1]){
                            $select_min = 'selected';
                        }else{
                            $select_min = '';
                        }
                        print '<option value="'.$i.'" '.$select_min.'>'.$i.'</option>';
                    }
                print '</select>';
            print '</td>';

            print '<td><b>'.$langs->trans("To").'  </b>';
                $data_time_f = explode(':',$conf->global->MAIN_INFO_SOCIETE_TIME_OUT);
                print '<select name="heure_out" >';
                    for ($i=0; $i < 24; $i++) { 
                        $select_h = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_f[0]){
                            $select_h = 'selected';
                        }else{
                            $select_h = '';
                        }
                        print '<option value="'.$i.'" '.$select_h.'>'.$i.'</option>';
                    }
                print '</select>';
                print ' : ';
                print '<select name="minute_out" >';
                    for ($i=0; $i < 60; $i++) { 
                        $select_min = '';
                        if (strlen($i) < 2) $i = "0" . $i;
                        if($i == $data_time_f[1]){
                            $select_min = 'selected';
                        }else{
                            $select_min = '';
                        }
                        print '<option value="'.$i.'" '.$select_min.'>'.$i.'</option>';
                    }
                print '</select>';
            print '</td>';
        print '</tr>';
                   
        
        // print '<tr>';
        
        //     print '<td colspan="4" align="center">';
        //         print '<input type="submit" class="button" value="'.$langs->trans('Validate').'">';
        //     print '</td>';
        // print '</tr>

        // '."\n";


    print '</table>';
print '<br>';
 print '<div style="text-align:center;">';
                print '<input type="submit" class="button" value="'.$langs->trans('Validate').'">';
            print '</div>';
print '</form>';
print '
<br>
<br>
';




// Page end
dol_fiche_end();

?>

<script>
    $(document).ready(function(){
        $('#check_compl').change(function(){
            // console.log('complet');
            // if($('#check_compl').is(':checked')){
                $('tr.tr_complet').show();
                $('tr.tr_partiel').hide();
            // }
        })
        $('#check_part').change(function(){
            // console.log('partiel');

            // if($('#check_part').is(':checked')){
                $('tr.tr_complet').hide();
                $('tr.tr_partiel').show();
            // }
        });
        $('#fr_const_temps select.timezone').select2();
    });
</script>


<?php
llxFooter();
$db->close();
?>

