<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   polemploi     Module polemploi
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/polemploi/core/modules directory.
 *  \file       htdocs/polemploi/core/modules/modpolemploi.class.php
 *  \ingroup    polemploi
 *  \brief      Description and activation file for module polemploi
*/


include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 *  Description and activation class for module polemploi
 */
class modpolemploi extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

		$this->numero = 999119995; 
		$this->rights_class = 'polemploi';
		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "other";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		$this->description = "ModuleDescpolemploi";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '2.0';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='polemploi@polemploi';
		
		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		// for default path (eg: /polemploi/core/xxxxx) (0=disable, 1=enable)
		// for specific path of parts (eg: /polemploi/core/modules/barcode)
		// for specific css file (eg: /polemploi/css/polemploi.css.php)
		//$this->module_parts = array(
		//                        	'triggers' => 0,                                 	// Set this to 1 if module has its own trigger directory (core/triggers)
		//							'login' => 0,                                    	// Set this to 1 if module has its own login method directory (core/login)
		//							'substitutions' => 0,                            	// Set this to 1 if module has its own substitution function file (core/substitutions)
		//							'menus' => 0,                                    	// Set this to 1 if module has its own menus handler directory (core/menus)
		//							'theme' => 0,                                    	// Set this to 1 if module has its own theme directory (theme)
		//                        	'tpl' => 0,                                      	// Set this to 1 if module overwrite template dir (core/tpl)
		//							'barcode' => 0,                                  	// Set this to 1 if module has its own barcode directory (core/modules/barcode)
		//							'models' => 0,                                   	// Set this to 1 if module has its own models directory (core/modules/xxx)
		//							'css' => array('/polemploi/css/polemploi.css.php'),	// Set this to relative path of css file if module has its own css file
	 	//							'js' => array('/polemploi/js/polemploi.js'),          // Set this to relative path of js file if module must load a js on all pages
		//							'hooks' => array('hookcontext1','hookcontext2')  	// Set here all hooks context managed by module
		//							'dir' => array('output' => 'othermodulename'),      // To force the default directories names
		//							'workflow' => array('WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2'=>array('enabled'=>'! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)', 'picto'=>'yourpicto@polemploi')) // Set here all workflow context managed by module
		//                        );
		$this->module_parts = array(
		    'hooks' => array('completetabs','main'),
		    'css' => array("/polemploi/css/polemploi.css"),
		    'js' => array("/polemploi/js/polemploi.js"),
		);

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/polemploi/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into polemploi/admin directory, to use to setup module.
		$this->config_page_url = array("admin_poste.php@polemploi");

		// $this->config_page_url = array("admin.php@polemploi");
		// $this->config_page_url = array("polemploi_setup.php@polemploi");

		$this->hidden = false;			// A condition to hide module

		
		

		// Dependencies
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("polemploi@polemploi");

		// Constants
		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
		// Example: $this->const=array(0=>array('MYMODULE_MYNEWCONST1','chaine','myvalue','This is a constant to add',1),
		//                             1=>array('MYMODULE_MYNEWCONST2','chaine','myvalue','This is another constant to add',0, 'current', 1)
		// );
		$this->const = array();
        // $this->tabs = array();

		// Array to add new pages in new tabs

		// Example: $this->tabs = array('objecttype:+tabname1:Title1:polemploi@polemploi:$user->rights->polemploi->read:/polemploi/mynewtab1.php?id=__ID__',  	// To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:polemploi@polemploi:$user->rights->othermodule->read:/polemploi/mynewtab2.php?id=__ID__',  	// To add another new tab identified by code tabname2
        //                              'objecttype:-tabname:NU:conditiontoremove');    
		
		// $this->tabs = array(
  //           'thirdparty:+candidat_frn:Candidatures:polemploi@polemploi:$user->rights->polemploi->gestion->consulter:/polemploi/candidatclt.php?socid=__ID__',
  //           'contact:+candidat_contct:Candidatures:polemploi@polemploi:$user->rights->polemploi->gestion->consulter:/polemploi/contact.php'
  //       );                                                     						
		// 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
		// 'contact'          to add a tab in contact view
		// 'contract'         to add a tab in contract view
		// 'group'            to add a tab in group view
		// 'intervention'     to add a tab in intervention view
		// 'invoice'          to add a tab in customer invoice view
		// 'invoice_supplier' to add a tab in supplier invoice view
		// 'member'           to add a tab in fundation member view
		// 'opensurveypoll'	  to add a tab in opensurvey poll view
		// 'order'            to add a tab in customer order view
		// 'order_supplier'   to add a tab in supplier order view
		// 'payment'		  to add a tab in payment view
		// 'payment_supplier' to add a tab in supplier payment view
		// 'product'          to add a tab in product view
		// 'propal'           to add a tab in propal view
		// 'project'          to add a tab in project view
		// 'stock'            to add a tab in stock view
		// 'thirdparty'       to add a tab in third party view
		// 'user'             to add a tab in user view

        // Dictionaries
	    if (! isset($conf->polemploi->enabled))
        {
        	$conf->polemploi=new stdClass();
        	$conf->polemploi->enabled=0;
        }
		$this->dictionaries=array();
        
        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes
		// Example:
		//$this->boxes=array(array(0=>array('file'=>'myboxa.php','note'=>'','enabledbydefaulton'=>'Home'),1=>array('file'=>'myboxb.php','note'=>''),2=>array('file'=>'myboxc.php','note'=>'')););

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=1;

		// Add here list of permission defined by an id, a label, a boolean and two constant strings.

		$this->rights[$r][0] = $this->numero+$r;	// Permission id (must not be already used)
		$this->rights[$r][1] = 'consulter';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'gestion';				
		$this->rights[$r][5] = 'consulter';				
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Ajouter/Modifier';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'update';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Supprimer';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'delete';
		$r++;

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;
		// Add here entries to declare new menus
		// Top Menu
		$this->menu[$r]=array(	'fk_menu'=>0,
			'type'=>'top',
			'titre'=>'polemploi',
			'mainmenu'=>'polemploi',
			'leftmenu'=>'polemploi',
			'url'=>'/polemploi/index.php',
			'langs'=>'polemploi@polemploi',
			'position'=>201,
			'enabled'=>'1',
			'perms'=>'$user->rights->polemploi->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;


		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=polemploi',
					'type'=>'left',
					'titre'=>'recru_recherche_avancee',
		            'leftmenu'=>'ecv4',
					'url'=>'/polemploi/search.php',
					'langs'=>'polemploi@polemploi',
					'position'=>2,
					'enabled'=>'1',
					'perms'=>'$user->rights->polemploi->gestion->consulter',
					'target'=>'',
					'user'=>2);
			$r++;

		// Left Menu
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=polemploi',
			'type'=>'left',
			'titre'=>'postes',
            'leftmenu'=>'postes',
			'url'=>'/polemploi/index.php',
			'langs'=>'polemploi@polemploi',
			'position'=>3,
			'enabled'=>'1',
			'perms'=>'$user->rights->polemploi->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;
			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=postes',
				'type'=>'left',
				'titre'=>'liste_des_postes',
				'url'=>'/polemploi/index.php',
				'langs'=>'polemploi@polemploi',
				'position'=> 4,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=postes',
				'type'=>'left',
				'titre'=>'add_poste',
				'url'=>'/polemploi/card.php?action=add',
				'langs'=>'polemploi@polemploi',
				'position'=> 5,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->update',
				'target'=>'',
				'user'=>2);
			$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi',
			'type'=>'left',
			'titre'=>'candidatures',
            'leftmenu'=>'candidatures',
			'url'=>'/polemploi/candidatures/kanban.php?page=0',
			'langs'=>'polemploi@polemploi',
			'position'=>4,
			'enabled'=>'1',
			'perms'=>'$user->rights->polemploi->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;
			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=candidatures',
				'type'=>'left',
				'titre'=>'liste_des_candidatures',
				'url'=>'/polemploi/candidatures/index.php?page=0',
				'langs'=>'polemploi@polemploi',
				'position'=> 5,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=candidatures',
				'type'=>'left',
				'titre'=>'add_candidature',
				'url'=>'/polemploi/candidatures/card.php?action=add',
				'langs'=>'polemploi@polemploi',
				'position'=> 6,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

		
		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi',
			'type'=>'left',
			'titre'=>'cv',
		    'leftmenu'=>'cv',
			'url'=>'/polemploi/cv/list.php',
			'langs'=>'polemploi@polemploi',
			'position'=>7,
			'enabled'=>'1',
			'perms'=>'$user->rights->polemploi->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi',
			'type'=>'left',
			'titre'=>'rapports',
            'leftmenu'=>'rapports',
			'url'=>'/polemploi/rapports.php',
			'langs'=>'polemploi@polemploi',
			'position'=>8,
			'enabled'=>'1',
			'perms'=>'$user->rights->polemploi->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi',
			'type'=>'left',
			'titre'=>'configuration',
            'leftmenu'=>'configuration',
			'url'=>'/polemploi/admin/admin_poste.php',
			'langs'=>'polemploi@polemploi',
			'position'=>9,
			'enabled'=>'1',
			'perms'=>'$user->rights->polemploi->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;

			// $this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=configuration',
			// 	'type'=>'left',
			// 	'titre'=>'configuration',
			// 	// 'url'=>'/polemploi/candidatures/candidatures.php',
			// 	'langs'=>'polemploi@polemploi',
			// 	'position'=> 10,
			// 	'enabled'=>'1',
			// 	'perms'=>'$user->rights->polemploi->gestion->consulter',
			// 	'target'=>'',
			// 	'user'=>2);		
			// $r++;

			// $this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=configuration',
			// 	'type'=>'left',
			// 	'titre'=>'postes',
			// 	'url'=>'/polemploi/index.php',
			// 	'langs'=>'polemploi@polemploi',
			// 	'position'=> 11,
			// 	'enabled'=>'1',
			// 	'perms'=>'$user->rights->polemploi->gestion->consulter',
			// 	'target'=>'',
			// 	'user'=>2);		
			// $r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=configuration',
				'type'=>'left',
				'titre'=>'departements',
				'url'=>'/polemploi/departements/index.php',
				'langs'=>'polemploi@polemploi',
				'position'=> 12,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=configuration',
				'type'=>'left',
				'titre'=>'etiquettes_candidature',
				'url'=>'/polemploi/etiquettes/index.php',
				'langs'=>'polemploi@polemploi',
				'position'=> 13,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=configuration',
				'type'=>'left',
				'titre'=>'origines_pole',
				'url'=>'/polemploi/origines/index.php',
				'langs'=>'polemploi@polemploi',
				'position'=> 26,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=configuration',
				'type'=>'left',
				'titre'=>'postes',
				'url'=>'/polemploi/admin/admin_dict.php',
				'langs'=>'polemploi@polemploi',
				'position'=> 27,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;
			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=polemploi,fk_leftmenu=configuration',
				'type'=>'left',
				'titre'=>'candidatures',
				'url'=>'/polemploi/admin/admin_dict_candid.php',
				'langs'=>'polemploi@polemploi',
				'position'=> 28,
				'enabled'=>'1',
				'perms'=>'$user->rights->polemploi->gestion->consulter',
				'target'=>'',
				'user'=>2);		
			$r++;





		$r=1;
	}

	function init($options='')
	{
		global $conf;
		$sqlm = array();

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_departements` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`label` varchar(255),
		  	`type` varchar(355),
		  	`gestionnaire` int(11) NULL
		);";
		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_postes` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`label` varchar(100) NULL,
		  	`status` varchar(100) NULL,
		  	`lieu` int(11) NULL,
		  	`email` varchar(100) NULL,
		    `tel` varchar(100) NULL,
		    `mobile` varchar(100) NULL,
		  	`date` date NULL,
		  	`departement` int(11) NULL,
		  	`responsable_recrutement` int(11) NULL,
		  	`nb_nouveauemploye` int(11) NULL,
		  	`description` text NULL,
		   	`responsable_RH` int(11) NULL
		);";
		$resql = $this->db->query($sql);


		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_origines` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`source` varchar(255) NULL
		);";
		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_cv` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`nom` varchar(255) NULL,
		  	`fichier` varchar(255) NULL,
		  	`poste` int(11) NULL,
		  	`candidature` int(11) NULL,
		  	`type` varchar(20) NULL,
		  	`date` date NULL
		);";
		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_candidatures` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		    `sujet` varchar(355) NULL,
		    `email` varchar(100) NULL,
		    `tel` varchar(100) NULL,
		    `mobile` varchar(100) NULL,
		    `etiquettes`  varchar(355) NULL,
		    `apport_par` int(11) NULL,
		    `resume` text NULL,
		   	`poste` int(11)  NULL,
		  	`departement` int(11) NULL,
		   	`responsable` int(11) NULL,
		   	`contact` int(11) NULL,
		   	`origine` int(11) NULL,
		   	`salaire_demande` int(11) NULL,
		   	`salaire_propose` int(11) NULL,
		   	`date_disponible` date  NULL,
		   	`date_depot` date  NULL,
		   	`etape` int(11) NULL,
		   	`employe` int(2) NULL,
		   	`refuse` int(2) NULL
		);";
		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_etapescandidature` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`label` varchar(255) NULL,
		  	`color` varchar(10) NULL
		);";
		$resql = $this->db->query($sql);

		// $sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_etapescandidature` (
		// 	  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		// 	  	`label` varchar(255) NULL
		// 	);";
		$resql = $this->db->query($sql);

		$sql = "INSERT INTO `".MAIN_DB_PREFIX."pole_etapescandidature` (`rowid`, `label`, `color`) VALUES
			(1, 'plus_interss','#DBE270'),
			(2, 'en_formation','#F59A9A'),
			(3, 'en_emploi','#62B0F7'),
			(4, 'en_relation','#FFB164'),
			(5, 'pas_info','#59D859');";

		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_etiquettes` (
			  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
			  	`label` varchar(255) NULL,
			  	`color` varchar(255) NULL
			);";
		$resql = $this->db->query($sql);

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_postes_extrafields` (
			  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
			    `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			    `fk_object` int(11) NOT NULL,
			    `import_key` varchar(14) DEFAULT NULL
			);";
		$resql = $this->db->query($sql);

		$sql = 'ALTER TABLE `'.MAIN_DB_PREFIX.'pole_postes_extrafields` CHANGE rowid rowid INT(10)AUTO_INCREMENT PRIMARY KEY';
		$resql = $this->db->query($sql);



		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."pole_candidatures_extrafields` (
			  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
			    `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			    `fk_object` int(11) NOT NULL,
			    `import_key` varchar(14) DEFAULT NULL
			);";
		$resql = $this->db->query($sql);

		$sql = 'ALTER TABLE `'.MAIN_DB_PREFIX.'pole_candidatures_extrafields` CHANGE rowid rowid INT(10)AUTO_INCREMENT PRIMARY KEY';
		$resql = $this->db->query($sql);


		$sql = "CREATE TABLE  IF NOT EXISTS `".MAIN_DB_PREFIX."dict_poste` (
		        `rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		        `label` varchar(355) NULL
		);";
		$resql = $this->db->query($sql);
			
		$sql = "INSERT INTO `".MAIN_DB_PREFIX."dict_poste` (`rowid`, `label`) VALUES
			(1, 'Architecte'),
			(2, 'Ingénieur'),
			(3, 'Chef de chantier'),
			(4, 'Géomètre topographe'),
			(5, 'Designer'),
			(6, 'Assistant'),
			(7, 'Caissière'),
			(8, 'Directeur financier'),
			(9, 'Gérent'),
			(10, 'Secrétaire'),
			(11, 'Electricien'),
			(12, 'Mécanicien');
			";

		$resql = $this->db->query($sql);


		$sql = "CREATE TABLE  IF NOT EXISTS `".MAIN_DB_PREFIX."dict_candid` (
		        `rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		        `label` varchar(355) NULL
		);";
		$resql = $this->db->query($sql);
			
		$sql = "INSERT INTO `".MAIN_DB_PREFIX."dict_candid` (`rowid`, `label`) VALUES
			(1, 'Architecte'),
			(2, 'Ingénieur'),
			(3, 'Chef de chantier'),
			(4, 'Géomètre topographe'),
			(5, 'Designer'),
			(6, 'Assistant'),
			(7, 'Adminstrateur'),
			(8, 'Responsable'),
			(9, 'Caissière'),
			(10, 'Directeur financier'),
			(11, 'Gérent'),
			(12, 'Secrétaire'),
			(13, 'Electricien'),
			(14, 'Mécanicien'),
			(15, 'Téchnicien');
			";

		$resql = $this->db->query($sql);

		$sql = "INSERT INTO `".MAIN_DB_PREFIX."pole_etiquettes` (`rowid`, `label`, `color`) VALUES
			(1, 'JAVA', '#000000'),
			(2, 'ADELIA', '#00ff00'),
			(3, 'Photoshop', '#ff0080'),
			(4, 'PHP', '#0000a0');";
		$resql = $this->db->query($sql);

		// $result=$this->_load_tables('/polemploi/sql/');
		return $this->_init($sqlm, $options);	
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();

		return $this->_remove($sql, $options);
	}

}
