<?php 
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT .'/product/stock/class/mouvementstock.class.php';
 
dol_include_once('/polemploi/class/departement.class.php');

class postes_pole extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $label;
	public $status;
	public $lieu;
	public $email;
	public $tel;
	public $mobile;
	public $departement;
	public $responsable_recrutement;
	public $nb_nouveauemploye;
	public $responsable_RH;
	public $description;
	public $date;

	public $element='postes_pole';
	public $table_element='pole_postes';
	
	public function __construct($db){ 
		$this->db = $db;
		$this->array_options=array();

		return 1;
    }

	public function create($echo_sql=0)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX.$this->table_element." ( ";

		$sql.= " label,lieu,email,tel,mobile,date,departement,nb_nouveauemploye,responsable_recrutement,responsable_RH,status,description)";
		$sql.= " VALUES (";
		$sql.= ($this->label?"'".$this->db->escape($this->label)."'":"null");
		$sql.= ", ".($this->lieu>0?$this->lieu:"null");	
		$sql.= ", ".($this->email?"'".$this->db->escape($this->email)."'":"null");
		$sql.= ", ".($this->tel?"'".$this->db->escape($this->tel)."'":"null");
		$sql.= ", ".($this->mobile?"'".$this->db->escape($this->mobile)."'":"null");
		$sql.= ", '".$this->db->idate($this->date)."'";
		$sql.= ", ".($this->departement>0?$this->departement:"null");	
		$sql.= ", ".($this->nb_nouveauemploye>0?$this->nb_nouveauemploye:"null");	
		$sql.= ", ".($this->responsable_recrutement>0?$this->responsable_recrutement:"null");	
		$sql.= ", ".($this->responsable_RH>0?$this->responsable_RH:"null");	
		$sql.= ", ".($this->status?"'".$this->db->escape($this->status)."'":"null");
		$sql.= ", ".($this->description?"'".$this->db->escape($this->description)."'":"null");
		$sql.= ")";
		// die($sql);
		$resql = $this->db->query($sql);
		if($resql){
			$this->id=$this->db->last_insert_id(MAIN_DB_PREFIX.'pole_postes');
			$result = $this->insertExtraFields();
			return $this->id;
		}
		else {
			$this->db->rollback();
			$this->errors[] = 'Error '.$this->table_element.' '. $this->db->lasterror();
			print_r($this->errors);die();

			return 0;
		} 
	}

	public function update($id)
	{
		// dol_syslog(__METHOD__, LOG_DEBUG);
		dol_syslog(get_class($this)."::update");

		if (!$id || $id <= 0)
			return false;
        $sql = 'UPDATE ' . MAIN_DB_PREFIX .$this->table_element. ' SET ';
			$sql.= " `label` = ".($this->label?"'".$this->db->escape($this->label)."'":"null").",";
			$sql.= " `description` = ".($this->description?"'".$this->db->escape($this->description)."'":"null").",";
			$sql.= " `lieu` = ".($this->lieu>0?$this->db->escape($this->lieu):"null").',';
			$sql.= " `email` = ".($this->email?"'".$this->db->escape($this->email)."'":"null").",";
			$sql.= " `tel` = ".($this->tel?"'".$this->db->escape($this->tel)."'":"null").",";
			$sql.= " `mobile` = ".($this->mobile?"'".$this->db->escape($this->mobile)."'":"null").",";
			$sql.= " `date` = ".($this->date?"'".$this->db->idate($this->date)."'":"null").",";
			$sql.= " `status` = ".($this->status?"'".$this->db->escape($this->status)."'":"null").",";
			$sql.= " `description` = ".($this->description?"'".$this->db->escape($this->description)."'":"null").",";
			$sql.= " `responsable_RH` = ".($this->responsable_RH>0?$this->db->escape($this->responsable_RH):"null").',';
			$sql.= " `departement` = ".($this->departement>0?$this->db->escape($this->departement):"null").',';
			$sql.= " `nb_nouveauemploye` = ".($this->nb_nouveauemploye>0?$this->db->escape($this->nb_nouveauemploye):"null").',';
			$sql.= " `responsable_recrutement` = ".($this->responsable_recrutement>0?$this->db->escape($this->responsable_recrutement):"null").',';

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        // die($sql);

        $resql = $this->db->query($sql);
        if($resql){
			$result=$this->insertExtraFields();
        }

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.$this->table_element.' : '. $this->db->lasterror();
			print_r($this->errors);die();
			
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .$this->table_element.' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.$this->table_element.' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '',$join='')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$sql = "SELECT ".MAIN_DB_PREFIX.$this->table_element.".* FROM ";
		$sql .= MAIN_DB_PREFIX .$this->table_element;

		if (!empty($join)) {
			$sql .= " ".$join; 
		}
		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    		 =  $obj->rowid;
				$line->rowid 		 =  $obj->rowid;
				$line->label 	     =  $obj->label;
				$line->status 		 =  $obj->status;
				$line->lieu 		 =  $obj->lieu;
				$line->email 		 =  $obj->email;
				$line->tel 	     	 =  $obj->tel;
				$line->mobile 	     =  $obj->mobile;
				$line->date 		 =  $obj->date;
				$line->departement 	 =  $obj->departement;
				$line->nb_nouveauemploye 	 =  $obj->nb_nouveauemploye;
				$line->responsable_RH 		 =  $obj->responsable_RH;
				$line->responsable_recrutement 	 =  $obj->responsable_recrutement;
				$line->description =  $obj->description;
				// Retreive all extrafield
				// fetch optionals attributes and labels

                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element. ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
                $this->id         	  = $obj->rowid;
                $this->rowid      	  = $obj->rowid;
				$this->label 	  	  = $obj->label;
				$this->status 	  	  = $obj->status;
				$this->lieu 	  	  = $obj->lieu;
				$this->email   	      = $obj->email;
				$this->tel   	  	  = $obj->tel;
				$this->mobile   	  = $obj->mobile;
				$this->date   	      = $obj->date;
				$this->departement    = $obj->departement;
				$this->responsable_RH = $obj->responsable_RH;
				$this->responsable_recrutement  	  = $obj->responsable_recrutement;
				$this->nb_nouveauemploye  = $obj->nb_nouveauemploye;
				$this->description 	  = $obj->description;
                // ....
                // Retreive all extrafield
				// fetch optionals attributes and labels
				$this->fetch_optionals();

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function showNavigations($object, $linkback, $paramid = 'id', $fieldid = 'rowid', $moreparam = '')
	{

		global $langs, $conf;

		$ret = $result = '';
		$previous_ref = $next_ref = '';

		$fieldref = $fieldid;

		$object->ref = $object->rowid;

		$object->load_previous_next_ref('', $fieldid, 0);

		$navurl = $_SERVER["PHP_SELF"];

		$page = GETPOST('page');

		// accesskey is for Windows or Linux:  ALT + key for chrome, ALT + SHIFT + KEY for firefox
		// accesskey is for Mac:               CTRL + key for all browsers
		$stringforfirstkey = $langs->trans("KeyboardShortcut");
		if ($conf->browser->name == 'chrome')
		{
		    $stringforfirstkey .= ' ALT +';
		}
		elseif ($conf->browser->name == 'firefox')
		{
		    $stringforfirstkey .= ' ALT + SHIFT +';
		}
		else
		{
		    $stringforfirstkey .= ' CTL +';
		}

		$previous_ref = $object->ref_previous ? '<a accesskey="p" title="'.$stringforfirstkey.' p" class="classfortooltip" href="'.$navurl.'?'.$paramid.'='.urlencode($object->ref_previous).$moreparam.'"><i class="fa fa-chevron-left"></i></a>' : '<span class="inactive"><i class="fa fa-chevron-left opacitymedium"></i></span>';
		
		$next_ref     = $object->ref_next ? '<a accesskey="n" title="'.$stringforfirstkey.' n" class="classfortooltip" href="'.$navurl.'?'.$paramid.'='.urlencode($object->ref_next).$moreparam.'"><i class="fa fa-chevron-right"></i></a>' : '<span class="inactive"><i class="fa fa-chevron-right opacitymedium"></i></span>';

		$ret = '';
		// print "xx".$previous_ref."x".$next_ref;
		$ret .= '<!-- Start banner content --><div style="vertical-align: middle">';


		if ($previous_ref || $next_ref || $linkback)
		{
		    $ret .= '<div class="pagination paginationref"><ul class="right">';
		}
		if ($linkback)
		{
		    $ret .= '<li class="noborder litext">'.$linkback.'</li>';
		}
		if (($previous_ref || $next_ref))
		{
		    $ret .= '<li class="pagination">'.$previous_ref.'</li>';
		    $ret .= '<li class="pagination">'.$next_ref.'</li>';
		}
		if ($previous_ref || $next_ref || $linkback)
		{
		    $ret .= '</ul></div>';
		}

		$result .= '<div style="height: 41px;">';
		$result .= $ret;
		$result .= '</div>';
		$result .= '</div style="clear:both;"></div>';

		return $result;
    }

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.$this->table_element;
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;
        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url = dol_buildpath('/polemploi/card.php?id='.$this->id,2);

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
        if(!empty($this->label)){
        	$ref=$this->label;
        }else
        	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.dol_buildpath('/polemploi/img/object_polemploi.png',2).'" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }

    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.$this->table_element;
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.$this->table_element;
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.$this->table_element.' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }


	public function select_user($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style> >#'.$name.'{ width: 100% !important;}</style>';
	    $moreforfilter.='<script>$(function(){$("#'.$name.'").select2();})</script>';
	    return $moreforfilter;
	}


	public function select_product($selected=0,$name='product')
	{
	    $id = (!empty($id)) ? $id : $name;

	    $select = '';
		// $select.='<select class="flat" id="'.$id.'" name="'.$name.'" >';
	    $select.='<option value="0">&nbsp;</option>';
		global $conf;
    	$sql = "SELECT rowid ,ref,entity,label FROM ".MAIN_DB_PREFIX."product WHERE fk_product_type = 0";
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);
    	$select.='<option value="0"></option>'; 
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$select.='<option value="'.$obj->rowid.'"';
	            if ($obj->rowid == $selected) $select.='selected';
	            $select.='>'.$obj->label.'</option>';
			}
			$this->db->free($resql);
		}

		// $select.='</select>';
		// $select.='<script>$(function(){$("#'.$id.'").select2()})</script>';
	    return $select;
	}


	
	public function select_postes($selected=0,$name='postes',$showsoc=0,$required='')
	{
		global $conf;
		$id = (!empty($id)) ? $id : $name;


		$postes = $this->fetchAll();

		$nb=count($this->rows);
		$select = '<select class="flat" id="select_'.$id.'" name="'.$name.'" '.$required.'>';
	    	$select.='<option value="0">&nbsp;</option>';
			for ($i=0; $i < $nb; $i++) { 
				$item=$this->rows[$i];
				$select.='<option value="'.$item->rowid.'"';
	            if ($item->rowid == $selected) $select.='selected';
	            $select.='>';
	            $select .= $item->label;
				if($item->lieu && $showsoc){
					$soc = new Societe($this->db);
					$soc->fetch($item->lieu);
					$select .= ' - '.$soc->nom;
				}
	            $select .= '</option>';
			}
    	
		$select.='</select>';
		$select.='<script>$(function(){$("#select_'.$id.'").select2()})</script>';
	    return $select;
	}
	
	public function select_departement($selected='', $name, $type="poste")
	{
		global $conf;
		$id = (!empty($id)) ? $id : $name;
		$departement = new departements_pole($this->db);
		if($type) $filter = ' AND type="depart_'.$type.'"';
		$departement->fetchAll('','',0,0,$filter);
		$nb=count($departement->rows);
		$select = '<select class="flat" id="select_'.$id.'" name="'.$name.'" >';
	    	$select.='<option value="0">&nbsp;</option>';
			for ($i=0; $i < $nb; $i++) { 
				$item=$departement->rows[$i];
				$select.='<option value="'.$item->rowid.'"';
	            if ($item->rowid == $selected) $select.='selected';
	            $select.='>'.$item->label.'</option>';
			}
    	
		$select.='</select>';
		$select.='<script>$(function(){$("#select_'.$id.'").select2()})</script>';
	    return $select;
	}
	
	public function polemploipermissionto($source){
	    if(is_dir($source)) {
	    	@chmod($source, 0775);
	        $dir_handle=opendir($source);
	        while($file=readdir($dir_handle)){
	            if($file!="." && $file!=".."){
	                if(is_dir($source."/".$file)){
	                    @chmod($source."/".$file, 0775);
	                    $this->polemploipermissionto($source."/".$file);
	                } else {
	                    @chmod($source."/".$file, 0664);
	                }
	            }
	        }
	        closedir($dir_handle);
	    } else {
	        @chmod($source, 0664);
	    }
	}



	public function select_post_deoulants($val=0)
	{
		$array_posts = $this->AllMetiers('poste');
		$list = '<select id="post_deroulant" name="label">';
	        $list .= '<option value="">&nbsp;</option>';
	      	foreach ($array_posts as $value) {
		        $list .= '<option value="'.$value->label.'" ';
	        		if($val == $value->label) $list .= 'selected';
		        $list .= '>'.$value->label.'</option>';
	      	}
			// $sql = 'SELECT label FROM '.MAIN_DB_PREFIX.$this->table_element;
			// $resql = $this->db->query($sql);
			// if($resql){
			// 	while ($obj = $this->db->fetch_object($resql)) {
			// 		if(!in_array($obj->label, $array_posts)){
			//         	$list .= '<option value="'.$obj->label.'" ';
   			// 		if($val == $obj->label) $list .= 'selected';
			//         	$list .= '>'.$obj->label.'</option>';
			// 		}
			// 	}
			// }

	    $list .= '</select>';
	    return $list;
	}
	
	public function select_candid_deroulants($val=0)
	{
		$array_posts = $this->AllMetiers('candid');
		
		$list = '<select id="post_deroulant" name="sujet">';
	        $list .= '<option value="">&nbsp;</option>';
	      	foreach ($array_posts as $value) {
		        $list .= '<option value="'.$value->label.'" ';
	        		if($val == $value->label) $list .= 'selected';
		        $list .= '>'.$value->label.'</option>';
	      	}
			// $sql = 'SELECT sujet FROM '.MAIN_DB_PREFIX.'pole_candidatures';

			// $resql = $this->db->query($sql);
			// if($resql){
			// 	while ($obj = $this->db->fetch_object($resql)) {
			// 		if(!in_array($obj->sujet, $array_posts)){
			//         	$list .= '<option value="'.$obj->sujet.'" ';
   //      				if($val == $obj->sujet) $list .= 'selected';
			//         	$list .= '>'.$obj->sujet.'</option>';
			// 		}
			// 	}
			// }

	    $list .= '</select>';
	    return $list;
	}

	public function soc_of_post($label='')
	{
		$entrpris .= '<select class="select_entpris" name="entpris_post">';
		$sql = 'select * from '.MAIN_DB_PREFIX.'societe where rowid IN (select lieu from '.MAIN_DB_PREFIX.'pole_postes where label ="'.$label.'")';
		$resql = $db->query($sql);
		if($resql){
			while ($obj = $db->fetch_object($resql)) {
				$entrpris .= '<option value="'.$obj->rowid.'">'.$obj->nom.'</option>';
			}
		}
		$entrpris .= '</select>';
	}

	public function AllMetiers($type,$orderfield="label",$ordertype="ASC")
	{
		$arr = [];
		$sql = 'SELECT * FROM '.MAIN_DB_PREFIX.'dict_'.$type.' ORDER BY '.$orderfield.' '.$ordertype;
		$resql = $this->db->query($sql);
		if($resql){
			while ($obj = $this->db->fetch_object($resq)) {
				$line = new stdClass;

				$line->id = $obj->rowid;
				$line->rowid = $obj->rowid;
				$line->label = $obj->label;

				$arr[] = $line;
			}
		}
		return $arr;
	}	

	public function get_arraypos($type)
	{
		$arr_posts = [];
		foreach ($this->AllMetiers($type) as $key => $value) {
			$arr_posts[] = $value->label;
		}
		return $arr_posts;
	}

	
} 


class polemploicls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('polemploi@polemploi');

		dol_include_once('/polemploi/core/modules/modpolemploi.class.php');
        $modulrecrut = new modpolemploi($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_polemploi',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_polemploi','https://www.'.$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_polemploi',0))
            dolibarr_set_const($this->db,'ID_MODULE_polemploi',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_polemploi',0))
            dolibarr_set_const($this->db,'DATE_MODULE_polemploi',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_polemploi',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_polemploi',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_polemploi',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

        	$id_modul = urlencode($id_modul);

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_polemploi', 1, 'chaine',0,'',0);
                unActivateModule("modpolemploi");
            }elseif($response && $response->actif == 1){
				dolibarr_set_const($this->db,'DATE_MODULE_polemploi', date("Y-m-d", time() + 86400), 'chaine',0,'',0);
			}else{
				dolibarr_set_const($this->db,'DATE_MODULE_polemploi', date("Y-m-d"), 'chaine',0,'',0);
			}
        }
        return 1;
    } 
}

?>