<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *     \file        admin/admin.php
 *     \ingroup    nexttheme
 *     \brief        This file is an example module setup page
 *                 Put some comments here
 */
// Dolibarr environment
$res=@include("../../main.inc.php");                    // For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
    $res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../../main.inc.php");        // For "custom" directory

// Libraries
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

dol_include_once('/core/class/html.form.class.php');

dol_include_once('/polemploi/class/postes.class.php');
dol_include_once('/polemploi/class/candidatures.class.php');
dol_include_once('/polemploi/lib/polemploi.lib.php');


// dol_include_once('/nexttheme/lib/nexttheme.lib.php');


// Translations
$langs->load("admin");
$langs->load("polemploi@polemploi");

// Access control
// if (! $user->admin) accessforbidden();



/*
 * Actions
 */

$modname = $langs->trans("polemploiSetup");


$extrafields = new ExtraFields($db);
$form         = new Form($db);
$poste       = new postes_pole($db);
$candidatures = new candidatures_pole($db);

// List of supported format
$tmptype2label=ExtraFields::$type2label;
$type2label=array('');
foreach ($tmptype2label as $key => $val) $type2label[$key]=$langs->transnoentitiesnoconv($val);


$var                = true;
$sortfield          = ($_GET['sortfield']) ? $_GET['sortfield'] : "rowid";
$sortorder          = ($_GET['sortorder']) ? $_GET['sortorder'] : "DESC";
$id                 = $_GET['id'];
$action             = $_GET['action'];


$morejs  = array();
$action=GETPOST('action', 'alpha');
$id_delete = GETPOST('id_delete','alpha');
$confirm = GETPOST('confirm');

if($action == 'add'){
	$label = GETPOST('newlabel');
	$sql = 'INSERT INTO '.MAIN_DB_PREFIX.'dict_candid (label) values("'.addslashes($label).'")';
    $resql = $db->query($sql);

	if(!$resql){
		$this->db->rollback();
		$this->errors[] = 'Error '.$this->table_element.' : '. $this->db->lasterror();
		print_r($this->errors);die();
	}

	header("Location: admin_dict_candid.php");
}


if($action == 'update'){
	$label = GETPOST('label');
	$id = GETPOST('id');
	$sql = "UPDATE ".MAIN_DB_PREFIX."dict_candid SET label = '".$label."' WHERE rowid=".$id;
	$resql = $db->query($sql);

	if(!$resql){
		$this->db->rollback();
		$this->errors[] = 'Error '.$this->table_element.' : '. $this->db->lasterror();
		print_r($this->errors);die();
	}

	header("Location: admin_dict_candid.php");
}


if ($action == 'confirm_delete' && $confirm == 'yes')
{
   	$sql = 'DELETE FROM '.MAIN_DB_PREFIX.'dict_candid WHERE rowid='.$id;
	$resql = $db->query($sql);
	if(!$resql){
		$this->db->rollback();
		$this->errors[] = 'Error '.$this->table_element.' : '. $this->db->lasterror();
		print_r($this->errors);die();
	}

	header("Location: admin_dict_candid.php");
}

llxHeader(array(), $modname,'','','','',$morejs,0,0);

print load_fiche_titre($modname);
	
$head = menu_config($id);
dol_fiche_head(
    $head,
    'DictionarySetup',
    '', 
    0,
    "polemploi@polemploi"
);

	print '<div class="inline-block divButAction" style="float:right"><a class="butAction" href="'.$_SERVER["PHP_SELF"]."?action=create\">".$langs->trans("Add").'</a></div>';

	
$head = menu_dict($id);
dol_fiche_head(
    $head,
    'candidature',
    '', 
    0,
    "polemploi@polemploi"
);
print '<form action="'.$_SERVER["PHP_SELF"].'" method="POST" >';
	print '<input type="hidden" name="id" value="'.$id.'" >';

	if ($action == 'delete')
    {
        print $form->formconfirm($_SERVER["PHP_SELF"]."?id=".$id, $langs->trans("Delete"), $langs->trans("ConfirmDelete"), "confirm_delete", '', 0, 1);
    }



	print '<table class="noborder" width="100%" style="border:none !important">';
		$url = $_SERVER["PHP_SELF"];
		if($action == "create"){
			print '<tr>';
				print '<td><input name="newlabel" style="width:100%"></td>';

		    	print '<td colspan="2" align="center" >';
					print '<input type="hidden" name="action" value="add" >';
		    		print '<input type="submit" class="button" name="actionadd" value="sauvg">';
		            print '<a href="'.$url.'" class="button" name="actioncancel">'.$langs->trans("Cancel").'</a>';
		    	print '</td>';

			print '</tr>';
		}
		$data = $poste->AllMetiers('candid','rowid','DESC');
		if($data && count($data) >0 ){
			foreach ($data as $key => $value) {
				print '<tr>';
				    print '<td align="center">'. $value->rowid .'</td>';

				    print '<td align="center">';
						if($action == 'edit' && $value->rowid == $id) print '<input type="text" name="label" class="label_edit" value="'.$value->label.'">';
						else print $value->label;
					print '</td>';

			    	print '<td align="center" >';
		    			if($user->rights->polemploi->gestion->update){

				    		if($action == 'edit' && $value->rowid == $id){
								print '<input type="hidden" name="action" value="update" >';
					    		print '<input type="submit" class="button" name="actionmodify" value="'.$langs->trans("Modify").'">';
					            print '<input type="submit" class="button" name="actioncancel" value="'.$langs->trans("Cancel").'">';
							}else{
						    	print '<a class="reposition" href="'.$url.'?action=edit&id='.$value->rowid.'">'.img_edit().'</a>'; // Modify link
							    print '<a href="'.$url.'?action=delete&id='.$value->rowid.'">'.img_delete().'</a>'; // Delete link
							}
						}
					print '</td>';

				print '</tr>';
			}
		}
		print '<tr>';
			print '<td></td>';
			print '<td></td>';
			print '<td></td>';
		print '</tr>';
	print '</table>';
print '</form>';

llxFooter();
if (is_object($db)) $db->close();
