<?php
/* Copyright (C) 2015 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       htdocs/ovfournisseur/index.php
 *      \ingroup    ovfournisseur
 *		\brief     	List of transfer orders
 */

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 



require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/paiementfourn.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/companybankaccount.class.php';


dol_include_once('/ovfournisseur/class/ovfournisseur.class.php');


$langs->loadLangs(array('companies', 'bills', 'banks', 'compta'));
$langs->load('ovfournisseur@ovfournisseur');

//  Genere pdf all supplier
$action_pdf = GETPOST('action_pdf');


if($action_pdf == 'export'){
	$dt_check = GETPOST('check_ov');
	$dt_check = explode(',', $dt_check);
	$title = "Ordre de virement";

	require_once dol_buildpath('/ovfournisseur/pdf/pdf.lib.php');
	$pdf->SetFont('dejavusans', '', 14, '', true);

	// Add a page
	$pdf->AddPage();

	// set text shadow effect
	$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

	require_once dol_buildpath('/ovfournisseur/tpl/ovfournisseur.php');
	// Print text using writeHTMLCell()
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

	// ---------------------------------------------------------

	// Close and output PDF document
	// This method has several options, check the source code documentation for more information.
	$pdf->Output('order_virement-'.$cd .'-'. $cm .'-'. $cy.'.pdf');
	die();
}

$search_ref 	  = GETPOST('search_ref','int');
$search_label 	  = GETPOST('search_label','alpha');
$search_author 	  = GETPOST('search_author','alpha');
$search_account   = GETPOST('search_account','alpha');
$search_bill      = GETPOST('search_bill','alpha');
$search_supplier  = GETPOST('search_supplier','alpha');
$search_reglement = GETPOST('search_reglement','alpha');
$search_etat      = GETPOST('search_etat','alpha');
$search_facture   = GETPOST('search_facture','alpha');
$search_montant   = GETPOST('search_montant','alpha');

$search_date_ordre= GETPOST('search_date_ordre','alpha');

// die();

$ovfournisseurcls = new ovfournisseurcls($db);
$result = $ovfournisseurcls->fetch();

// Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref 		= "";
	$search_label 		= "";
	$search_author		= "";
    $search_account		= "";
    $search_bill        = "";
    $search_supplier    = "";
    $search_facture     = "";
    $search_date_ordre  = "";
    $search_reglement   = "";
    $search_etat        = "";
    $search_montant     = "";
}
if ($search_ref)	$filter.= " AND rowid=".$search_ref;
if ($search_label)   $filter.= " AND label like '%".$search_label."%'";
if ($search_author && $search_author > 0)   $filter.= " AND fk_user_author=".$search_author;
if ($search_account && $search_account > 0) 	$filter.= " AND fk_account=".$search_account;
if ($search_reglement && $search_reglement > 0) 	$filter.= " AND fk_reglement=".$search_reglement;
if ($search_supplier && $search_supplier > 0) $filter.= ' AND fk_supplier ='.$search_supplier;
if ($search_facture && $search_facture > 0) $filter.= ' AND  fk_facture ='.$search_facture;
if ($search_etat ) $filter.= ' AND  etat ="'.$search_etat.'"';
if ($search_montant ) $filter.= ' AND  montant ='.$search_montant.'';

if ($search_date_ordre && false !== strpos($search_date_ordre, '/')) {
	$date = explode('/', $search_date_ordre);
	$date_ov = $date[2]."-".$date[1]."-".$date[0];
	$filter.= " AND CAST(date_ordre as date) ='". $date_ov ."'";
}

$sortfield 		= GETPOST("sortfield",'alpha');
$sortorder 		= GETPOST("sortorder",'alpha');
$page 			= GETPOST("page",'int');
$my_limit = $conf->liste_limit;
$limit = GETPOST('limit', 'int')?GETPOST('limit', 'int'):$my_limit;
$page = (empty($page) ? 0 : $page);
if ($page == -1) { $page = 0; }
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

if ($limit > 0 && $limit != $my_limit) $param.='&limit='.$limit;
/*
 * View
*/
$check_ov = (GETPOST("ov_checked") ? GETPOST("ov_checked") : GETPOST("check_ov"));
// if(empty(GETPOST('ov_checked'))){
	 $param .= '&ov_checked='.$check_ov;

// }
$morejs = array('/ovfournisseur/js/ovfournisseur.js');
llxHeader(array(),$langs->trans("ovfournisseurs"),'','','','',$morejs);

$form 				= new Form($db);
$ov 	            = new ovfournisseur($db);
$ovfournisseurT     = new ovfournisseur($db);
$userstatic 		= new User($db);
$bankAccountstatic 	= new Account($db);


$nbtotalofrecords = '';
if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST))
{
	$nbtotalofrecords = $ovfournisseurT->fetchAll($sortorder, $sortfield, "", "", $filter);
	if (($page * $limit) > $nbtotalofrecords)	// if total resultset is smaller then paging size (filtering), goto and load page 0
	{
		$page = 0;
		$offset = 0;
	}
}

$num = $ov->fetchAll($sortorder, $sortfield, $limit+1, $offset, $filter);


$const_color = [
	'en_cours' =>(dolibarr_get_const($db,'COLOR_OV_ENCOUR',$conf->entity) ? dolibarr_get_const($db,'COLOR_OV_ENCOUR',$conf->entity) : ovfournisseur::COLORS_ETAT['en_cours'] ),
	'traite' =>(dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) ? dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) : ovfournisseur::COLORS_ETAT['traite'] )
];

    $total 	= 0 ;
	$var 	= true;


	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'" id="list_ov" >';
		print_barre_liste($langs->trans("list_ovfournisseur"), $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $nbtotalofrecords, 'title_accountancy.png', 0, '', '', $limit);

		$check_arr = $check_ov;
    	$check_arr =urldecode($check_arr);
    	$check_arr = explode(',', $check_arr);

		print '<input name="pagem" type="hidden" value="'.$page.'">';
		print '<input name="offsetm" type="hidden" value="'.$offset.'">';
		print '<input name="limitm" type="hidden" value="'.$limit.'">';
		print '<input name="filterm" type="hidden" value="'.$filter.'">';
		print '<input name="rowid" type="hidden" value="'.$id.'">';
		print '<input name="check_ov" type="hidden" id="check_ov" value="'.$check_ov.'">';
		print '<input name="action_pdf" class="action_pdf" type="hidden" value="">';
		print '<div style="display: block; width:100%;">';
			print '<div class="colorstatusov" style="display: block;">';
				
				print '<a target="_blank" href="'.dol_buildpath('/ovfournisseur/admin/admin.php',2).'" class="config" title="'.$langs->trans("Setup").'">'.img_picto(ucfirst($langs->trans("Setup")),"setup").'</a>';

				print '<span class="etatname">';
					print '<span class="coloretat" style="background:'.$const_color['en_cours'].';"></span>';
					print '<span class="labeletat"><span class="counteleme">'.$ovfournisseurT->arr_status('en_cours').'</span></span>&nbsp';
					print $langs->trans('en_cours');
				print '</span>';

				print '<span class="etatname">';
					print '<span class="coloretat" style="background:'.$const_color['traite'].';"></span>';
					print '<span class="labeletat"><span class="counteleme">'.$ovfournisseurT->arr_status('traite').'</span></span>&nbsp';
					print $langs->trans('traite');
				print '</span>';

			print '</div>';
			$title = $langs->trans('title_info');
			print '<div class="genere_ov" >';
				print '<a target="_blank"  class="ov_all_frn" align="right" title="'.$langs->trans("Setup").'">'.$langs->trans("genere_ov").'</a>';
				print '<div style="float:right;line-height: 2;">'.$form->textwithpicto('', $title, 1, "info").'</div>';
				print '<span class="name_compt">'.$langs->trans("BankAccount").': </span>';
				$form->select_comptes('',"all_ov_account",0,'',1);
			print '</div>';
		print '</div>';
	    
	    print '<table class="noborder" width="100%">';


		    print '<tr class="liste_titre">';
				print_liste_field_titre($langs->trans("Ref"), $_SERVER["PHP_SELF"], "rowid", "", $param, "", $sortfield, $sortorder);
				print_liste_field_titre($langs->trans("Label"),$_SERVER["PHP_SELF"],"label","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("date"),$_SERVER["PHP_SELF"],"date_ordre","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("Author"),$_SERVER["PHP_SELF"],"fk_user_author","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("Supplier"),$_SERVER["PHP_SELF"],"fk_supplier","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("Invoice"),$_SERVER["PHP_SELF"],"fk_facture","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("Amount").' ('.$conf->currency.')',$_SERVER["PHP_SELF"],"montant","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("reglement"),$_SERVER["PHP_SELF"],"fk_reglement","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("BankAccount"),$_SERVER["PHP_SELF"],"fk_account","",$param,'align="center"',$sortfield,$sortorder);
				print_liste_field_titre($langs->trans("Status"),$_SERVER["PHP_SELF"],"etat","",$param,'align="center"',$sortfield,$sortorder);
				// print_liste_field_titre('',$_SERVER["PHP_SELF"],"","",$param,'align="center"',$sortfield,$sortorder);
				print '<th colspan="2" align="center">';
					print '<input type="checkbox"  name="check_all" class="check_all">';
				print '</th>';
		    print "</tr>\n";

			print '<tr class="liste_titre">';
				// Ref
				print '<td class="liste_titre" align="left"></td>';
				// Label
				print '<td class="liste_titre" align="center">';
					print '<input class="flat" type="text" size="20" name="search_label" value="'.$search_label.'">';
				print '</td>';
				// Created Date
				print '<td class="liste_titre" align="center">';
					print '<input class="flat datepickerp center" type="text" size="20" name="search_date_ordre" value="'.$search_date_ordre.'">';
				print '</td>';
				// People
				print '<td class="liste_titre" align="center">';
		   			print $form->select_dolusers($search_author,"search_author",1,"",0,'','',0,32);
				print '</td>';
				// Supplier
				print '<td class="liste_titre srch_supplier" align="center" style="max-width:200px">';
					print $form->select_thirdparty($search_supplier, 'search_supplier');
				print '</td>';
				// Invoice
				print '<td class="liste_titre" align="center">';
					print $form->selectarray('search_facture',$ov->getFact_Fournisseur(),$search_facture, 1, 0, 0, ' required ');
				print '</td>';
				// Paiement
				print '<td class="liste_titre" align="center">';
					print '<input type="number" style="width:115px;" name="search_montant" value="'.$search_montant.'">';
				print '</td>';
				// Paiement
				print '<td class="liste_titre" align="center">';
					print $ov->select_with_filter('','search_reglement');
				print '</td>';
				// Account
				print '<td class="liste_titre" align="center">';
					$form->select_comptes($search_account,"search_account",0,'',1);
				print '</td>';
				// Account
				print '<td class="liste_titre" align="center">';
				print '<select id="etat_ov" name="search_etat">';
						print '<option></option>';
						$options = '<option value="en_cours">'.$langs->trans('en_cours').'</option>';
						$options .= '<option value="traite">'.$langs->trans('traite').'</option>';
						if($search_etat)
							$options = str_replace('<option value="'.$search_etat.'"', '<option value="'.$search_etat.'" selected',$options);
						print $options;
					print '</select>';  //etat ov
				print '</td>';

				print '<td class="liste_titre" align="center" colspan="2">';
					print '<input type="image" style="padding:0px !important;" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
					print '<input type="image" style="padding:0px !important;" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
				print "</td>";
			print "</tr>\n";

			$i =0;
			// for ($i=0; $i < count($ov->rows) ; $i++) {
			while ($i < min($num, $limit)){

		        $obj = $ov->rows[$i];
		        $var = !$var;
	        	$ov_ = new ovfournisseur($db);
	        	$ov_->fetch($obj->rowid);
	        	$cl_tr = ($ov_->etat ? $const_color[$ov_->etat] : $const_color['en_cours'] ); 
		        print '<tr '.$bc[$var].' style="background:'.$cl_tr.' !important">';
			        // Ref
					print '<td align="left" style="width: 50px;">'. $ov_->getNomUrl(1)."</td>\n";
			        // Label
					print '<td align="center">'. ucfirst($ov_->label) ."</td>\n";
					// User name
			        print '<td align="center">'.dol_print_date($db->jdate($obj->date_ordre),'day')."</td>\n";
					print '<td align="center">';
			        	if($ov_->fk_user_author){
			        		$user_ = new User($db);
			        		$user_->fetch($ov_->fk_user_author);
							print $user_->getNomUrl(1);
			        	}
					print "</td>\n";
					// Supplier
					print '<td align="center">';
			        	if($ov_->fk_supplier){
							$supplier = new Societe($db);
							$supplier->fetch($ov_->fk_supplier);
							print $supplier->getNomUrl(1);
			        	}
					print "</td>\n";
					// Supplier
					print '<td align="center">';
			        	if($ov_->fk_facture){
							$facture = new FactureFournisseur($db);
							$facture->fetch($ov_->fk_facture);
							print $facture->getNomUrl(1);
			        	}
					print "</td>\n";
			        // Montant
			        print '<td align="center">';
			        	print price($ov_->montant);
			        print '</td>';
			        // Paiement
			        print '<td align="center">';
			        	if($ov_->fk_reglement){
					        $payement = new PaiementFourn($db); 
			        		$payement->fetch($ov_->fk_reglement);
			        		print $payement->getNomUrl(1);
			        	}else
			        		print '__';

			        print '</td>';
					// Date payment
					// Account
					print '<td align="center">';
						$bankAccount2 = new Account($db);
						$bankAccount2->fetch($ov_->fk_account);
						print $bankAccount2->getNomUrl(1).' - '.$bankAccount2->label ;
					print "</td>\n";
					print '<td align="center">';
						print $langs->trans($ov_->etat);
					print "</td>\n";
			        print "<td align='center'><a target='_blank' href='card.php?id=". $obj->rowid ."&action=pdf'><img src='".DOL_URL_ROOT."/theme/common/mime/pdf.png' alt='' title='Télécharger ordre de virement' /></a></td>";
			        print '<td align="center">';
			        	
			        	$checked ='';
			        	if( in_array($ov_->rowid, $check_arr) ){
			        		$checked = 'checked';
			        	}
			         	print '<input type="checkbox" '.$checked.' name="check_line[]" onclick="change_check(this)" id="check_line_'.$i.'" value="'.$ov_->rowid.'" class="check_line">';
			        print '</td>';
		        print "</tr>\n";

		        $total = $total + $ov_->montant;
		        $i++;
		    }
			$outputlangs = $langs;
	    
		    print '<tr class="liste_total">';
		    	print '<td colspan="6" class="liste_total">';
			    	if ($num < $limit && empty($offset)) print $langs->trans("Total");
					else print $langs->trans("Totalforthispage");
		    	print '</td>';
		    	print '<td  class="liste_total" align="right">'.price($total,0,$outputlangs,1,-1,-1,$conf->currency)."</td>";
				print '<td colspan="5"></td>';
			print '</tr>';
    	print "</table>";

	    print '<div style="float: right; margin-top: 8px;">';
			print '<a href="./card.php?action=create&leftmenu=tax_salary" class="butAction">'.$langs->trans('AddNewovfournisseur').'</a>';
		print '</div>';
	print '</form>';


llxFooter();

$db->close();


