<?php
/* Copyright (C) 2005-2009	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2009-2017	Regis Houssin		<regis.houssin@inodbox.com>
 * Copyright (C) 2014		Marcos García		<marcosgdf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       htdocs/core/triggers/interface_20_all_Glpitodolibarr.class.php
 *  \ingroup    core
 *  \brief      Trigger file for
 */

require_once DOL_DOCUMENT_ROOT.'/core/triggers/dolibarrtriggers.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/paiementfourn.class.php';

dol_include_once('/ovfournisseur/class/ovfournisseur.class.php');

/**
 *  Class of triggers 
 */
class InterfaceOvfournisseurtrigger extends DolibarrTriggers
{
	protected $db;
    /**
     * Constructor
     *
     *  @param      DoliDB      $db     Database handler
     */
    public function __construct($db)
    {
        $this->db = $db;
        $this->name = preg_replace('/^Interface/i', '', get_class($this));
        $this->family = "Next";
        $this->description = "Triggers of this module are empty functions.";
        $this->version = 'development';
        $this->picto = 'glpitodolibarr@glpitodolibarr';
    }

	/**
	 * Function called when a Dolibarrr security audit event is done.
	 * All functions "runTrigger" are triggered if file is inside directory htdocs/core/triggers or htdocs/module/code/triggers (and declared)
	 *
	 * @param string		$action		Event action code
	 * @param Object		$object     Object
	 * @param User			$user       Object user
	 * @param Translate		$langs      Object langs
	 * @param conf			$conf       Object conf
	 * @return int         				<0 if KO, 0 if no triggered ran, >0 if OK
	 */
	public function runTrigger($action, $object, User $user, Translate $langs, Conf $conf)
    {


        $date = dol_now();

        // die($action);
        // Actions
        if ($action == 'PAYMENT_SUPPLIER_CREATE')
        {   
            $this->create_ov($object);
        }
        elseif($action == 'PAYMENT_SUPPLIER_DELETE'){
            $this->delete_ov($object);
        }
        elseif($action == 'PAYMENT_ADD_TO_BANK'){
            $this->update_ov($object);
        }
        
    }


    public function create_ov($object){
        global $user;

        $payement = new PaiementFourn($this->db); 
        $payement->fetch($object->id);
        $ov = new ovfournisseur($this->db);
        $fk_soc = $ov->get_supplier($object->id);
        $ov->fk_supplier       = (int)$fk_soc;
        $data = $ov->get_Facture($fk_soc,$object->id);
        foreach ($data as $key => $value) {
            $id_fact = $key;
            continue;
        }
        $ov->fk_facture        = ($id_fact ? $id_fact : 0);
        $ov->label = $ov->getRefov();
        $ov->date_ordre = date('Y-m-d',$payement->datepaye);
        $ov->fk_user_author = $user->id;
        $ov->fk_reglement = $object->id;
        $ov->montant = $payement->montant;
        $ov->etat = 'en_cours';
        $result = $ov->create();
        
    }

    public function update_ov($object)
    {
        $ov = new ovfournisseur($this->db);
        $ov->fetchAll('','',0,0,' AND fk_reglement = '.$object->id);
        if(count($ov->rows) > 0){
            $id_ov = $ov->rows[0]->rowid;
            $ov_ = new ovfournisseur($this->db);
            $ov_->fetch($id_ov);
            $ov_->fk_account = $object->fk_account;
            $r = $ov_->update($id_ov);
            if($r){
                $msql = 'UPDATE '.MAIN_DB_PREFIX.'paiementfourn SET ov = 1 where rowid='.$object->id;
                $remsql = $this->db->query($msql);
            }
        }
        
    }
    public function delete_ov($object){
        $ovfournisseur = new ovfournisseur($this->db);
        $ovfournisseur->fetchAll('', '', '', '', " AND fk_reglement = ".$object->id);
        if (count($ovfournisseur->rows) > 0) {
            $item = $ovfournisseur->rows[0];
            $ov = new  ovfournisseur($this->db);
            $ov->fetch($item->rowid);
            if($ov){
                $result = $ov->delete();
                
            }
        }
    }


}
