<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	OwnTheme	OwnTheme module
 * 	\brief		OwnTheme module descriptor.
 * 	\file		core/modules/modOwnTheme.class.php
 * 	\ingroup	mytheme
 * 	\brief		Description and activation file for module OwnTheme
 */

include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';


/**
 * Description and activation class for module OwnTheme
 */
class modMyTheme extends DolibarrModules
{

	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;
		$this->numero = 6887109240;
		$this->rights_class = 'mytheme';

		$this->family = "Next Thèmes";
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		$this->description = "Thème de Dolibarr, Affichage responsive et Couleurs personnalisées";
		$this->version = '12.0';
		$this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special = 0;
		$this->picto = 'thumb@mytheme';

		$this->module_parts = array(
			'menus' => 1,
			'css' => array('mytheme/css/as_style.min.css'),
			'js' => array('mytheme/js/dol_url_root.js.php','mytheme/js/as_code.min.js'),
			'hooks' => array('toprightmenu')
		);

		$this->dirs = array();
		$this->config_page_url = array("admin.php@mytheme");
		$this->hidden = false;
		$this->depends = array();
		$this->requiredby = array();
		$this->conflictwith = array();
		$this->phpmin = array(5, 3);
		$this->need_dolibarr_version = array(4, 0);
		$this->langfiles = array("mytheme@mytheme");

		// Dictionaries
		if (! isset($conf->mytheme->enabled)) {
			$conf->mytheme=new stdClass();
			$conf->mytheme->enabled = 0;
		}
		$this->dictionaries = array();
		$this->boxes = array(); // Boxes list

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 0;

		// Exports
		$r = 0;

		// Constants
		$this->const = array ();
		$r = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_FORCETHEME";	// name
		$this->const [$r] [1] = "chaine";			// type
		$this->const [$r] [2] = 'mytheme';		// def value
		$this->const [$r] [3] = '';					// note
		$this->const [$r] [4] = 0;					// visible
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'mytheme_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'mytheme_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'mytheme_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'mytheme_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;
		
		$r ++;
		$this->const [$r] [0] = "DOL_VERSION";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = '';
		$this->const [$r] [3] = 'Dolibarr version';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 0;

	}



	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();

		$result = $this->loadTables();

		$arraythems = array("modNextTheme","modOwnTheme","modTheme3d","modMenu3dResponsive","modLightTheme","modBeCreative","modBlueTheme","modOrangTheme");
		global $conf;
		foreach ($arraythems as $value) {
			$keymodulelowercase=strtolower(preg_replace('/^mod/','',$value));
			if (in_array($keymodulelowercase, $conf->modules)) 
				$result=unActivateModule($value);
		}

	    // on first module activation only
	    $new = dol_buildpath('/mytheme/inst/firstUse');
	    // print_r($new);
	    // die();
	    if (file_exists($new)) {

			if ( !file_exists(dol_buildpath('/mytheme/css/as_style_custom.css')) ) 
				copy(dol_buildpath('/mytheme/inst/css/as_style_custom.css'),dol_buildpath('/mytheme/css/as_style_custom.css'));
			if ( !file_exists(dol_buildpath('/mytheme/js/as_code_custom.js')) ) 
				copy(dol_buildpath('/mytheme/inst/js/as_code_custom.js'),dol_buildpath('/mytheme/js/as_code_custom.js'));

		    // set old primary and secondary colors
			$file = dol_buildpath('/mytheme/css/as_style.min.css');
	    	$def_col1 = "#6a89cc";
	    	$def_col2 = "#60a3bc";
	    	$col1 = dolibarr_get_const($this->db,'MYTHEME_COL1');
	    	$col2 = dolibarr_get_const($this->db,'MYTHEME_COL2');

			if ( !empty($col1) || !empty($col2) )	{
				$file_contents = file_get_contents($file);
				if ( !empty($col1) ) $file_contents = str_replace($def_col1,$col1,$file_contents);
				if ( !empty($col2) ) $file_contents = str_replace($def_col2,$col2,$file_contents);
				file_put_contents($file,$file_contents);
			}
	    	if(!$col1) dolibarr_set_const($this->db,'MYTHEME_COL1',$def_col1,'chaine',0,'',1);
	    	if(!$col2) dolibarr_set_const($this->db,'MYTHEME_COL2',$def_col2,'chaine',0,'',1);

			//delete older version files
			if (file_exists(dol_buildpath('/mytheme/js/custom.min.js'))) 
				unlink(dol_buildpath('/mytheme/js/custom.min.js'));
			if (file_exists(dol_buildpath('/mytheme/css/style.min.css'))) 
				unlink(dol_buildpath('/mytheme/css/style.min.css'));

			// rmdir($new);
	    }

	    // update or create mytheme theme folder from inst folder
		$source = dol_buildpath('/mytheme/inst/theme');
		$dest = dol_buildpath('/theme');

		// cpy9($source,$dest);

		$dcd = dolCopyDir($source, $dest, 0775, 1);

		if($dcd){

			// replace weather images
			$source = dol_buildpath('/mytheme/img/weather.new');
			$dest = dol_buildpath('/theme/mytheme/weather');
			dolCopyDir($source, $dest, 0775, 1);
			
			// copy images from eldy theme
			$source = dol_buildpath('/theme/eldy/img');
			$dest = dol_buildpath('/theme/mytheme/img');
			dolCopyDir($source, $dest, 0775, 1);


			$theperm = dol_buildpath('/theme/mytheme');
			mythemepermissionto($theperm);

	    	// update webmail file
	    	if ( dolibarr_get_const($this->db,'MAIN_MODULE_WEBMAIL') ) {
				copy(dol_buildpath('/webmail/list_messages.php'),dol_buildpath('/mytheme/inst/webmail/list_messages.php'));
				copy(dol_buildpath('/mytheme/inst/webmail/list_messages_modified.php'),dol_buildpath('/webmail/list_messages.php'));
			}

			$installed_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_INSTALL',0);
			$upgraded_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_UPGRADE',0);
			if ($upgraded_ver!="") {
				$dol_version = $upgraded_ver;
			} else {
				$dol_version = $installed_ver;
			}
			dolibarr_set_const($this->db,'DOL_VERSION',$dol_version,'chaine',0,'Dolibarr version',1);
			dolibarr_set_const($this->db,'MAIN_THEME','mytheme','chaine',0,'Sets Mytheme Theme',1);
			dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','mytheme_menu.php','chaine',0,'',1);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','mytheme_menu.php','chaine',0,'',1);
			dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','mytheme_menu.php','chaine',0,'',1);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','mytheme_menu.php','chaine',0,'',1);
			
			if (!dolibarr_get_const($this->db,'MYTHEME_COL1'))
				dolibarr_set_const($this->db,'MYTHEME_COL1',"#26a69a",'chaine',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_COL2'))
				dolibarr_set_const($this->db,'MYTHEME_COL2',"#ee6e73",'chaine',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_COL_BODY_BCKGRD'))
				dolibarr_set_const($this->db,'MYTHEME_COL_BODY_BCKGRD',"#E9E9E9",'chaine',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_COL_LOGO_BCKGRD'))
				dolibarr_set_const($this->db,'MYTHEME_COL_LOGO_BCKGRD',"#26a69a",'chaine',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_COL_TXT_MENU'))
				dolibarr_set_const($this->db,'MYTHEME_COL_TXT_MENU',"#b8c6e5",'chaine',0,'',1);
			
			if (!dolibarr_get_const($this->db,'MYTHEME_COL_HEADER_BCKGRD'))
				dolibarr_set_const($this->db,'MYTHEME_COL_HEADER_BCKGRD',"#26a69a",'chaine',0,'',1);
			if ( !dolibarr_get_const($this->db,'MYTHEME_CUSTOM_CSS')) 
				dolibarr_set_const($this->db,'MYTHEME_CUSTOM_CSS',0,'yesno',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_CUSTOM_JS'))
				dolibarr_set_const($this->db,'MYTHEME_CUSTOM_JS',0,'yesno',0,'',1);
			// if (!dolibarr_get_const($this->db,'MYTHEME_FIXED_MENU'))
				dolibarr_set_const($this->db,'MYTHEME_FIXED_MENU',0,'yesno',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_D_HEADER_FONT_SIZE'))
				dolibarr_set_const($this->db,'MYTHEME_D_HEADER_FONT_SIZE','1.7rem','chaine',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_S_HEADER_FONT_SIZE'))
				dolibarr_set_const($this->db,'MYTHEME_S_HEADER_FONT_SIZE','1.6rem','chaine',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_D_VMENU_FONT_SIZE'))
				dolibarr_set_const($this->db,'MYTHEME_D_VMENU_FONT_SIZE','1.2rem','chaine',0,'',1);
			if (!dolibarr_get_const($this->db,'MYTHEME_S_VMENU_FONT_SIZE'))
				dolibarr_set_const($this->db,'MYTHEME_S_VMENU_FONT_SIZE','1.2rem','chaine',0,'',1);

			return $this->_init($sql, $options);
		}
		return '';

	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = array();

		dolibarr_set_const($this->db,'MAIN_THEME','eldy','chaine',0,'',1);
		dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','eldy_menu.php','chaine',0,'',1);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','eldy_menu.php','chaine',0,'',1);
		dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','eldy_menu.php','chaine',0,'',1);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','eldy_menu.php','chaine',0,'',1);
		dolibarr_del_const($this->db,'MAIN_FORCETHEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED');

		$source = dol_buildpath('/mytheme/img/weather.org');
		$dest = dol_buildpath('/theme/mytheme/weather');

		dolCopyDir($source, $dest, 0775, 1);

		$todlt = dol_buildpath('/theme/mytheme');
		removeDirRecursivelyMyTheme($todlt);

		if ( file_exists( dol_buildpath('/webmail/list_messages.php') ) ) 
			copy(dol_buildpath('/mytheme/inst/webmail/list_messages.php'),dol_buildpath('/webmail/list_messages.php'));

		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /mytheme/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/mytheme/sql/');
	}

}



//ADEDDCODE
function removeDirRecursivelyMyTheme($dir){
	$count = 0;
	if (dol_is_dir($dir))
	{
		$dir_osencoded=dol_osencode($dir);
		if ($handle = opendir("$dir_osencoded"))
		{
			while (false !== ($item = readdir($handle)))
			{
				if (! utf8_check($item)) $item=utf8_encode($item);  // should be useless

				if ($item != "." && $item != "..")
				{
					if (is_dir(dol_osencode("$dir/$item")) && ! is_link(dol_osencode("$dir/$item")))
					{
						$count=removeDirRecursivelyMyTheme("$dir/$item");
					}
					else
					{
						@chmod("$dir/$item", octdec(777));
						$result=dol_delete_file("$dir/$item",0,1);
					}
				}
			}
			
			closedir($handle);

			// if (empty($onlysub))
			// {
			$result=dol_delete_dir($dir, $nophperrors);
			// }
		}
	}
}

function mythemepermissionto($source){
    if(is_dir($source)) {
    	@chmod($source, 0775);
        $dir_handle=opendir($source);
        while($file=readdir($dir_handle)){
            if($file!="." && $file!=".."){
                if(is_dir($source."/".$file)){
                    @chmod($source."/".$file, 0775);
                    mythemepermissionto($source."/".$file);
                } else {
                    @chmod($source."/".$file, 0664);
                }
            }
        }
        closedir($dir_handle);
    } else {
        @chmod($source, 0664);
    }
}