<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	Menu3dResponsive	Menu3dResponsive module
 * 	\brief		Menu3dResponsive module descriptor.
 * 	\file		core/modules/modMenu3dResponsive.class.php
 * 	\ingroup	menu3dresponsive
 * 	\brief		Description and activation file for module Menu3dResponsive
 */

include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';

/**
 * Description and activation class for module Menu3dResponsive
 */
class modMenu3dResponsive extends DolibarrModules
{

	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;
		$this->numero = 677720030;
		$this->rights_class = 'menu3dresponsive';

		$this->family = "Next Thèmes";
		$this->module_position = '45';
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		$this->description = "Personnalisez les menus";
		// $this->version = '10.0.2';
		$this->version = '12.0';
		$this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special = 0;
		$this->picto = 'thumb@menu3dresponsive';

		// $this->module_parts = array(
		// 	'menus' => 1,
		// 	'css' => array('menu3dresponsive/css/as_style.min.css'),
		// 	'js' => array('menu3dresponsive/js/dol_url_root.js.php','menu3dresponsive/js/as_code.min.js'),
		// 	'hooks' => array('toprightmenu')
		// );
		
		$this->module_parts = array(
			'menus' => 1,
			'css' => array('data'=>array("menu3dresponsive/css/menu3dresponsive.css"), 'entity'=>'0'), 
			'js' => array('data'=>array("menu3dresponsive/js/menu3dresponsive.js"), 'entity'=>'0'), 
			'hooks' => array('data'=>array('toprightmenu'), 'entity'=>'0'), 
		);

		$this->dirs = array();
		$this->config_page_url = array("admin.php@menu3dresponsive");
		$this->hidden = false;
		$this->depends = array();
		$this->requiredby = array();
		$this->conflictwith = array();
		$this->phpmin = array(5, 3);
		$this->need_dolibarr_version = array(4, 0);
		$this->langfiles = array("menu3dresponsive@menu3dresponsive");

		// Dictionaries
		if (! isset($conf->menu3dresponsive->enabled)) {
			$conf->menu3dresponsive=new stdClass();
			$conf->menu3dresponsive->enabled = 0;
		}
		$this->dictionaries = array();
		$this->boxes = array(); // Boxes list

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 0;

		// Exports
		$r = 0;

		// Constants
		$this->const = array ();
		$r = 0;
		
		$r ++;
		$this->const [$r] [0] = "SHOW_MENU_TOP_MENU3DRESPONSIVE";	// name
		$this->const [$r] [1] = "chaine";			// type
		$this->const [$r] [2] = '';		// def value
		$this->const [$r] [3] = '';					// note
		$this->const [$r] [4] = 0;					// visible
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "HIDE_MENU_VERTICAL_DOLIBARR_MENU3DRESPONSIVE";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = '';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';

		$r ++;
		$this->const [$r] [0] = "MAIN_FORCETHEME";	// name
		$this->const [$r] [1] = "chaine";			// type
		$this->const [$r] [2] = 'menu3dresponsive';		// def value
		$this->const [$r] [3] = '';					// note
		$this->const [$r] [4] = 0;					// visible
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'menu3dresponsive_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_STANDARD_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'menu3dresponsive_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENU_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'menu3dresponsive_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "MAIN_MENUFRONT_SMARTPHONE_FORCED";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = 'menu3dresponsive_menu.php';
		$this->const [$r] [3] = '';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
		$r ++;
		$this->const [$r] [0] = "DOL_VERSION";
		$this->const [$r] [1] = "chaine";
		$this->const [$r] [2] = '';
		$this->const [$r] [3] = 'Dolibarr version';
		$this->const [$r] [4] = 0;
		$this->const [$r] [5] = 'allentities';
		
	}



	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();

		$result = $this->loadTables();

		$res = dolibarr_set_const($this->db, "PACKTHEMEACTIVATEDTHEME", "modMenu3dResponsive", 'chaine', 0, '', 0);

		$arraythems = array("modNextTheme","modLightTheme","modOwnTheme","modTheme3d","modMyTheme","modBeCreative");
		global $conf;
		foreach ($arraythems as $value) {
			$keymodulelowercase=strtolower(preg_replace('/^mod/','',$value));
			if (in_array($keymodulelowercase, $conf->modules)) 
				$result=unActivateModule($value);
		}

		// on first module activation only
	    $new = dol_buildpath('/menu3dresponsive/inst/firstUse');
	    // print_r($new);
	    // die();
		// if (file_exists($new)) {
		// 	$source = dol_buildpath('/menu3dresponsive/inst/theme');
		// 	$dest = dol_buildpath('/theme');
		// 	cpy5($source,$dest);
		//     // update or create menu3dresponsive theme folder from inst folder
		// 	$source = dol_buildpath('/theme/eldy');
		// 	$dest = dol_buildpath('/theme/menu3dresponsive');
		// 	cpy5($source,$dest);

		// 	// rmdir($new);
		// }

		$source = dol_buildpath('/menu3dresponsive/inst/theme');
		$dest = dol_buildpath('/theme');
		// cpy5($source,$dest);

		$dcd = dolCopyDir($source, $dest, 0775, 1);

	    // $check = dol_buildpath('/theme/menu3dresponsive');
	    // if (!file_exists($check)) {
		    // update or create menu3dresponsive theme folder from inst folder
	    // }

		// replace weather images
		// $source = dol_buildpath('/menu3dresponsive/img/weather.new');
		// $dest = dol_buildpath('/theme/menu3dresponsive/weather');
		// cpy5($source,$dest);
		
		// copy images from eldy theme
		// $source = dol_buildpath('/theme/eldy/img');
		// $dest = dol_buildpath('/theme/menu3dresponsive/img');
		// cpy5($source,$dest);

		$source = dol_buildpath('/theme/eldy');
		$dest = dol_buildpath('/theme/menu3dresponsive');
		$dcd = dolCopyDir($source, $dest, 0775, 1);

		if($dcd){


			$theperm = dol_buildpath('/theme/menu3dresponsive');
			menu3dresponsivepermissionto($theperm);

		
			dolibarr_set_const($this->db,'SHOW_MENU_TOP_MENU3DRESPONSIVE','','chaine',0,'',0);
			dolibarr_set_const($this->db,'HIDE_MENU_VERTICAL_DOLIBARR_MENU3DRESPONSIVE','','chaine',0,'',0);

			// Theme
			$installed_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_INSTALL',0);
			$upgraded_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_UPGRADE',0);
			if ($upgraded_ver!="") {
				$dol_version = $upgraded_ver;
			} else {
				$dol_version = $installed_ver;
			}
			dolibarr_set_const($this->db,'DOL_VERSION',$dol_version,'chaine',0,'Dolibarr version',0);
			dolibarr_set_const($this->db,'MAIN_THEME','menu3dresponsive','chaine',0,'Sets menu3dresponsive Theme',0);
			dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','menu3dresponsive_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','menu3dresponsive_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','menu3dresponsive_menu.php','chaine',0,'',0);
			dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','menu3dresponsive_menu.php','chaine',0,'',0);
			
			if (!dolibarr_get_const($this->db,'MENU3DRESPONSIVE_FIXED_MENU',0))
				dolibarr_set_const($this->db,'MENU3DRESPONSIVE_FIXED_MENU',0,'yesno',0,'',0);

			if (!dolibarr_get_const($this->db,'MENU3DRESPONSIVE_SHOW_VERTICAL_MENU',0))
				dolibarr_set_const($this->db,'MENU3DRESPONSIVE_SHOW_VERTICAL_MENU',1,'yesno',0,'',0);
			if (!dolibarr_get_const($this->db,'MENU3DRESPONSIVE_HIDE_ICONS_HORIZENTAL_MENU',0))
				dolibarr_set_const($this->db,'MENU3DRESPONSIVE_HIDE_ICONS_HORIZENTAL_MENU',0,'yesno',0,'',0);
			if (!dolibarr_get_const($this->db,'MENU3DRESPONSIVE_HIDE_TEXT_HORIZENTAL_MENU',0))
				dolibarr_set_const($this->db,'MENU3DRESPONSIVE_HIDE_TEXT_HORIZENTAL_MENU',0,'yesno',0,'',0);


			return $this->_init($sql, $options);
		}
		
		return '';
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = array();

		dolibarr_del_const($this->db,'MAIN_FORCETHEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED');
		dolibarr_del_const($this->db,'MAIN_THEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE');
		
		// Local
		dolibarr_del_const($this->db,'MAIN_MODULE_MENU3DRESPONSIVE_CSS');
		dolibarr_del_const($this->db,'MAIN_MODULE_MENU3DRESPONSIVE_HOOKS');
		dolibarr_del_const($this->db,'MAIN_MODULE_MENU3DRESPONSIVE_JS');
		dolibarr_del_const($this->db,'MAIN_MODULE_MENU3DRESPONSIVE_CSS',0);
		dolibarr_del_const($this->db,'MAIN_MODULE_MENU3DRESPONSIVE_HOOKS',0);
		dolibarr_del_const($this->db,'MAIN_MODULE_MENU3DRESPONSIVE_JS',0);
		// Theme
		dolibarr_set_const($this->db,'MAIN_THEME','eldy','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','eldy_menu.php','chaine',0,'',0);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','eldy_menu.php','chaine',0,'',0);
		dolibarr_del_const($this->db,'MAIN_FORCETHEME',0);
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED',0);
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED',0);
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED',0);
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED',0);

		$todlt = dol_buildpath('/theme/menu3dresponsive');
		removeDirRecursivelymenu3dresponsive($todlt);

		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /menu3dresponsive/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/menu3dresponsive/sql/');
	}

}

//ADEDDCODE
function removeDirRecursivelyMenu3DResponsive($dir){
	$count = 0;
	if (dol_is_dir($dir))
	{
		$dir_osencoded=dol_osencode($dir);
		if ($handle = opendir("$dir_osencoded"))
		{
			while (false !== ($item = readdir($handle)))
			{
				if (! utf8_check($item)) $item=utf8_encode($item);  // should be useless

				if ($item != "." && $item != "..")
				{
					if (is_dir(dol_osencode("$dir/$item")) && ! is_link(dol_osencode("$dir/$item")))
					{
						$count=removeDirRecursivelyMenu3DResponsive("$dir/$item");
					}
					else
					{
						@chmod("$dir/$item", octdec(777));
						$result=dol_delete_file("$dir/$item",0,1);
					}
				}
			}
			
			closedir($handle);

			// if (empty($onlysub))
			// {
			$result=dol_delete_dir($dir, $nophperrors);
			// }
		}
	}
}

function menu3dresponsivepermissionto($source){
    if(is_dir($source)) {
    	@chmod($source, 0775);
        $dir_handle=opendir($source);
        while($file=readdir($dir_handle)){
            if($file!="." && $file!=".."){
                if(is_dir($source."/".$file)){
                    @chmod($source."/".$file, 0775);
                    menu3dresponsivepermissionto($source."/".$file);
                } else {
                    @chmod($source."/".$file, 0664);
                }
            }
        }
        closedir($dir_handle);
    } else {
        @chmod($source, 0664);
    }
}


// copy recursive
function cpy5($source, $dest){
    if(is_dir($source)) {
        $dir_handle=opendir($source);
        while($file=readdir($dir_handle)){
            if($file!="." && $file!=".."){
                if(is_dir($source."/".$file)){
                    if(!is_dir($dest."/".$file)){
                        mkdir($dest."/".$file);
                    }
                    cpy5($source."/".$file, $dest."/".$file);
                } else {
                    copy($source."/".$file, $dest."/".$file);
                }
            }
        }
        closedir($dir_handle);
    } else {
        copy($source, $dest);
    }
}