<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/recap/index.php
 * \ingroup    list
 * \brief      List of recap related to given mid
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
dol_include_once('/marches/lib/marches.lib.php');
dol_include_once('/marches/marche/class/marche.class.php');
dol_include_once('/marches/recap/class/recap.class.php');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$mid 	 = GETPOST('mid', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$mid)
	die('ID marché n\'existe pas!');

$object = new Recap($db);
$recapstatic = new Recap($db);
$marche = new Marches($db);
$form   = new Form($db);

/**
 * Actions
 */

// None

/**
 * View
 */

$morejs  = array("/marches/js/marches.js");
llxHeader(array(), $langs->trans('RecapMarket'),'','','','',$morejs,array(),0,0);
//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');

print_fiche_titre($langs->trans('RecapMarket'),'','object_marches@marches');

if (GETPOST('notification')) {
    $notif = '';
    switch(GETPOST('notification')) {
        case 'noenddate' :
            $notif = $langs->trans('NoendDateMissed');
            break;
    }

    setEventMessage($notif);
}

// Récupération de l'ID de l'utilisateur
$object->fetchAll($mid, true);
$marche->fetch($mid);
$head  = marches_prepare_head($marche);
dol_fiche_head($head, 'recap', $langs->trans('RecapMarket'), 0, '');

echo $marche->getMarketHeader();

print '<form method="post" action="./card.php">';
print '<input name="action" value="add" type="hidden" />';
print '<input name="mid" value="'. $mid .'" type="hidden" />';
print '<input id="btnAddText" value="'. $langs->trans('Add') .'" type="hidden" />';
print '<h3>'. $langs->trans('RecapMainTitle') .': </h3>';

echo '<table class="" width="100%"><tr><td width="50%">';
echo '<table class="border" width="100%"><tr><td colspan="2">';
print '<h4>'. $langs->trans('RecapDefaultTitle'). ' ('. $langs->trans('MissedPiecesPhrase') .')</h4>';
echo '</td></tr>';

$checkDefPcs = 0;
if (count($object->lines)) {
	$defaultPcs = $object->lines;
	$spaces = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
	$object->fetchAll($mid, false, 1);
	$getDefaultInsertedPcs = $object->lines;
	
	foreach ($defaultPcs as $key => $obj) {
		$checked = '';
		$comment = '';
		if (count($getDefaultInsertedPcs) && in_array($obj->ref, $object->getRowsRefs($object->lines))) {
			$checked = ' checked="checked"';
			$checkDefPcs++;
			$recapstatic->fetchByRef($obj->ref, $mid, false);
			$comment = $recapstatic->comment;
		}
		$disabled = ($marche->statut == 3 ? ' disabled="disabled"' : '');

		print '<tr>';
		print '<td width="35%"><label for="pc-'. $key .'"><input id="pc-'. $key .'" name="origin_pieces[]" type="checkbox" value="'. $obj->ref .'"'. $checked . $disabled .' /> '. $obj->ref .'</label></td>';
		print '<td width="65%"><textarea name="origin_pieces_comments['. $obj->ref .']" cols="70" rows="2">'. $comment .'</textarea></td>';
		print '</tr>';
	}
}

if ($marche->statut == 3) {
	print '<tr>';
	print '<td>'. $langs->trans('RealEndDate') .'</td>';
	print '<td>'. dol_print_date($marche->finished_date, 'day') .'</td>';
	print '</tr>';
}

if ($checkDefPcs == count($defaultPcs) && $marche->statut != 3 && $checkDefPcs != 0) {
	print '<tr>';
	print '<td>'. $langs->trans('RealEndDate') .'</td>';
	print '<td><input type="text" class="sel_end_date flat" name="marche_end_date" value="" required="required" /></td>';
	print '</tr>';
}

echo '</table>';

echo '</td><td valign="top" width="50%"><table class="border pcs_container" width="100%"><tr><td colspan="2">';
print '<h4>'. $langs->trans('RecapNewTitle') .'</h4>';
echo '</td></tr>';

$object->fetchAll($mid, false);
if (count($object->lines)) {
	foreach ($object->lines as $key => $obj) {
		$disabled = ($marche->statut == 3 ? ' disabled="disabled"' : '');
		print '<tr>';
		print '<td width="35%"><label for="npc-'. $key .'"><input class="new_pcs" id="npc-'. $key .'" name="new_pieces[]" type="checkbox" value="'. $obj->id .'" checked="checked"'. $disabled .' /> '.$obj->ref .'</label></td>';
			print '<td width="65%"><textarea name="new_pieces_comments[]" cols="70" rows="2"'. $disabled .'>'. $obj->comment .'</textarea></td>';
		print '</tr>';
	}
}

echo '</table>';
echo '</td></tr></table>';
/*echo '<table width="50%" class="border"><tr><td width="25%">';
echo $langs->trans('RealEndDate') .'</td>';
echo '<td><input type="text" class="sel_end_date flat" name="marche_end_date" value="" /></td>';
echo '</tr></table>';*/

if ($user->id && $user->rights->marches->write_marche) {
	print '<br>';
	print '<div style="float:right; margin-top: 8px;">';

	if ($marche->statut != 3) {
		print '<input type="submit" class="butAction" value="'. $langs->trans('Save') .'" />';
		print '<a id="addNewPiece" href="javascript:void(0);" class="butAction">'. $langs->trans('Add') .'</a>';
	}

	if ($checkDefPcs == count($defaultPcs) && $marche->statut != 3 && $checkDefPcs != 0)
		print '<a href="./card.php?action=archive&mid='. $mid .'" class="butAction recap_archived">'. $langs->trans('ArchiveMarket') .'</a>';
	
	print '</div>';
}
print '</form>';

llxFooter();

$db->close();

?>