<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       marches/purchaseorder/index.php
 * \ingroup    marche
 * \brief      List of markets
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/marches/purchaseorder/class/purchaseorder.class.php');
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/marches/marche/class/marche.class.php');
dol_include_once('/marches/lib/marches.lib.php');
dol_include_once('/marches/lib/tools.lib.php');

$langs->load('users');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$tasktab   = GETPOST("tasktab",'int');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');

$search_num = GETPOST('search_num');
$search_subject = GETPOST('search_subject');
$search_tier      = GETPOST('search_tier');
$search_city       = GETPOST('search_city');
$search_startdate       = GETPOST('search_startdate');
$search_enddate       = GETPOST('search_enddate');
$search_budget     = GETPOST('search_budget');
$search_status     = GETPOST('search_status');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_num        = "";
	$search_subject    = "";
	$search_tier  	   = "";
    $search_budget     = "";
    $search_status     = "";
    $search_city       = "";
    $search_startdate  = "";
    $search_enddate    = "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$object = new PurchaseOrder($db);
$filter = '';

llxHeader(array(), $langs->trans('ListOfPurchaseOrder'),'','','','',array("/marches/js/marches.js"),array(),0,0);
//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');

// Filter
$filter .= (!empty($search_num) && $search_num != -1) ? ' AND num = "'. $db->escape($search_num) .'"' : '';
$filter .= (!empty($search_subject) && $search_subject != -1) ? ' AND subject LIKE "%'. $db->escape($search_subject) .'%"' : '';
$filter .= (!empty($search_tier) && $search_tier != -1) ? " AND fk_third_party = ". $db->escape($search_tier) : '';
$filter .= (!empty($search_budget) && $search_budget != -1) ? " AND budget = ". $db->escape($search_budget) : "";
$filter .= (!empty($search_city) && $search_city != -1) ? ' AND city = "'. $db->escape($search_city) .'"' : "";
$filter .= (isset($search_startdate) && !empty($search_startdate)) ? ' AND reception_date = "'. $db->escape(Tools::convertDateTo($search_startdate, 'sql')) .'"' : "";
$filter .= (isset($search_enddate) && !empty($search_enddate)) ? ' AND deadline = "'. $db->escape(Tools::convertDateTo($search_enddate, 'sql')) .'"' : "";
$filterStatus = (!empty($search_status) && $search_status != -1 ? ($search_status == 0 ? " AND statut = 0" : " AND statut <> 0") : '');
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getMarchesList = $object->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $filterStatus);

// Si erreur SQL
if ($getMarchesList == '-1') {
    print_fiche_titre($langs->trans('ListOfPurchaseOrder'), '', '');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($object->lines);
$form 		= new Form($db);

if ($id > 0) {
	$object->fetch($id);

	$head = purchaseorder_prepare_head($object);
	dol_fiche_head($head, 'purchaseorder', $langs->trans("PurchaseOrderFile"), 0, '');

	$thirdParty = '';

	if (isset($object->fk_third_party) && !empty($object->fk_third_party)) {
		$socstatic = new Societe($db);
		$socstatic->fetch($object->fk_third_party);
		$thirdParty = $socstatic->getNomUrl(1);
	}

	print '<table class="border" width="100%" data-row-id="0">';
    print '<tbody>';

    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("PONum").'</td><td>';
    print $object->num;
    print '</td></tr>';

    print '<tr><td>'.$langs->trans("Subject").'</td><td>';
    print nl2br($object->subject);
    print '</td></tr>';

	print '<tr><td class="fieldrequired">'.$langs->trans("Label").'</td><td>';
    print ucfirst($object->label);
    print '</td></tr>';

    // Thirdparty
    print '<tr><td>'.$langs->trans("ThirdPartyMarket").'</td><td>';
	print $thirdParty;
    print '</td></tr>';

    print '<tr><td class="">'.$langs->trans("Ref").'</td><td>';
    print ucfirst($object->ref);
    print '</td></tr>';

    print '<tr><td>'.$langs->trans("CreationDate").'</td><td>';
    print  dol_print_date($object->creation_date, 'day') .'</td></tr>';

    print '<tr><td class="">'.$langs->trans("Country").'</td><td>';
    print ucfirst($object->country) .'</td></tr>';

    print '<tr><td class="">'.$langs->trans("Province").'</td><td>';
    print ucfirst($object->state) .'</td></tr>';

    print '<tr><td class="">'.$langs->trans("City").'</td><td>';
    print ucfirst($object->city) .'</td></tr>';

    print '</tbody>';
    print '</table>';

	print_barre_liste($langs->trans("BCDetail"), '', '', '', '', '', "", "", "", '');

    print '<table class="border" width="100%" data-row-id="0">';
    print '<tbody>';

    print '<tr><td class="" width="25%">'.$langs->trans("BCDateEtab").'</td><td>';
    print dol_print_date($object->date_etabli, 'day');
    print '</td></tr>';

    print '<tr><td>'.$langs->trans("AmountTtc").'</td><td>';
    print number_format($object->budget, 2);
    print '</td></tr>';

     print '</tbody>';
    print '</table>';

    print_barre_liste($langs->trans("BCInfoConsLetter"), '', '', '', '', '', "", "", "", '');

    print '<table class="border" width="100%" data-row-id="0">';
    print '<tbody>';

    print '<tr><td class="" width="25%">'.$langs->trans("StartDate").'</td><td>';
    print dol_print_date($object->reception_date, 'day');
    print '</td></tr>';

    print '<tr><td>'.$langs->trans("EndDate").'</td><td>';
    print dol_print_date($object->deadline, 'day');
    print '</td></tr>';

    print '</tbody>';
    print '</table>';

	if ($user->id && $user->rights->marches->write_bcs) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=edit&id='.$id.'" class="butAction">'.$langs->trans('Modify').'</a>';
		if ($user->rights->marches->delete)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
		print '</div>';
	}
}
else {
	print_barre_liste($langs->trans("ListOfPurchaseOrder"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("PONum"),$_SERVER["PHP_SELF"], "num", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Subject"),$_SERVER["PHP_SELF"],"subject", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ThirdPartyMarket"), $_SERVER["PHP_SELF"],"fk_third_party", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("City"), $_SERVER["PHP_SELF"], 'city', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("StartDate"),$_SERVER["PHP_SELF"], 'reception_date', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("EndDate"),$_SERVER["PHP_SELF"], 'deadline', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Amount"),$_SERVER["PHP_SELF"], 'budget', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Status"),$_SERVER["PHP_SELF"], 'statut', '', '', 'align="center"', $sortfield, $sortorder);
	
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre">';
	// Num
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="14" name="search_num" value="'.$search_num.'"></td>';

	// Objet
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="25" name="search_subject" value="'.$search_subject.'"></td>';

	// Thirdparty
    print '<td>';
    $filteronlist='';
    if (! empty($conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST)) $filteronlist=$conf->global->PROJECT_FILTER_FOR_THIRDPARTY_LIST;
    print $form->select_thirdparty_list(GETPOST('search_tier','int'),'search_tier',$filteronlist,1,1);
    print '</td>';

	// ville
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_city" value="'.$search_city.'">';
	print '</td>';

	// date rec
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat datepicker" type="text" size="14" name="search_startdate" value="'.$search_startdate.'">';
	print '</td>';
	// date eche
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat datepicker" type="text" size="14" name="search_enddate" value="'.$search_enddate.'">';
	print '</td>';

	// Budget
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="14" name="search_budget" value="'.$search_budget.'"></td>';

	// Status
	print '<td class="liste_titre" colspan="1" align="center">';
	$statuts = array(0 => $langs->trans('Still'), 1 => $langs->trans('Archived'));
	print $form->selectarray('search_status', $statuts, (GETPOST('search_status') ? GETPOST('search_status') : $search_status), 1, 0, 0, '');
	print '</td>';

	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (!empty($object->lines)) {
		$marche = new Marches($db);

		foreach($object->lines as $line) {
			$var = !$var;
			
			$thirdParty = '';

			if (isset($line->fk_third_party) && !empty($line->fk_third_party)) {
				$socstatic = new Societe($db);
				$socstatic->fetch($line->fk_third_party);
				$thirdParty = $socstatic->getNomUrl(1);
			}

			$num      = $line->num ?: $line->ref;
			$city     = $line->city ?: '';
			$reception_date = $line->reception_date ?: '';
			$deadline     = $line->deadline ?: '';

			$subject = $fullsubject = '';
			if (null !== $line->subject) {
				$fullsubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject 	= substr($line->subject, 0, 100);
				$subject 	= strlen($line->subject) > 100 ? $subject.'...' : $subject;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="20%">';
				print $object->getNomUrl(1,  $line->id, $num);
			print '</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullsubject .'">'. $subject .'</span></td>';
			print '<td align="center">'. $thirdParty .'</td>';
			print '<td align="center">'. $city .'</td>';
			print '<td align="center">'. dol_print_date($reception_date, 'day') .'</td>';
			print '<td align="center">'. dol_print_date($deadline, 'day') .'</td>';
			print '<td align="center">'. number_format($line->budget, 2, ',', '.') .' DH</td>';
			print '<td align="center">'. $marche->statusLevel($line->statut) .'</td>';
			print '<td></td>';
			print '</tr>'."\n";

		}
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->marches->write_bcs) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('CreateBC').'</a>';
		print '</div>';
	}
}

llxFooter();

$db->close();

?>