<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/recap/card.php
 * \ingroup    list
 * \brief      CRUD for recap
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
dol_include_once('/marches/purchaseorder/class/purchaseorder.class.php');
dol_include_once('/marches/po_recap/class/po_recap.class.php');
dol_include_once('/marches/lib/marches.lib.php');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$poid 	 = GETPOST('poid', 'int');
$action	 = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');

if (!$poid)
	die('ID bon de commande n\'existe pas!');

$object = new PORecap($db);
$purchaseorder = new PurchaseOrder($db);

if ($action == 'add' && $poid) {
	/*
	$getSubmittedDefPcs = array_map('strtolower', $_POST['origin_pieces']);

	$toBeDeleted = array();
	$toBeIgnored = array();
	$originPiecesComments = array();
	$object->fetchAll($poid, false, 1);
	
	foreach ($getSubmittedDefPcs as $key => $ref)
		$originPiecesComments[strtoupper($ref)] = $_POST['origin_pieces_comments'][$key];

	if (count($object->lines)) {
		foreach ($object->lines as $key => $obj) {
			$ref = strtolower($obj->ref);
			if (!in_array($ref, $getSubmittedDefPcs)) {
				$toBeDeleted[] = $obj->id;
			} else {
				$toBeIgnored[] = $ref;
			}
			
		}
	}

	if (count($toBeIgnored)) {
		$getSubmittedDefPcs = array_diff($getSubmittedDefPcs, $toBeIgnored);

		foreach ($toBeIgnored as $key => $ref) {
			$ref = strtoupper($ref);
			$object->fetchByRef($ref, $poid, false);
			
			$objectstatic = new Recap($db);
			$objectstatic->update($object->id, array(
				'comment' => (array_key_exists($ref, $originPiecesComments) ? $originPiecesComments[$ref] : '')
			));
		}
	}

	if (count($toBeDeleted))
		foreach ($toBeDeleted as $key => $id) {
			$objectstatic = new Recap($db);
			$objectstatic->delete($id);
		}

	if (count($getSubmittedDefPcs))
		foreach ($getSubmittedDefPcs as $key => $ref) {
			$ref 	= strtoupper($ref);
			$getRef = $object->fetchByRef($ref);

			if ($getRef) {
				$objectstatic 			= new Recap($db);
				$objectstatic->ref 	  	= $object->ref;
				$objectstatic->statut 	= 1;
				$objectstatic->fk_po= $poid;
				$objectstatic->fk_created_by= $user->id;
				$objectstatic->comment  = array_key_exists($object->ref, $originPiecesComments) ? $originPiecesComments[$object->ref] : '';
				$objectstatic->create();
			}
		}*/

	$getSubmittedPcs 	= $_POST['new_pieces'];
	$getNewSubmittedPcs = $_POST['new_added_pieces'];

	$getNewPcsFromDb = $object->fetchAll($poid, false);
	if ($getNewPcsFromDb) {
		foreach ($object->lines as $key => $obj) {
			if (null === $getSubmittedPcs || !in_array($obj->id, $getSubmittedPcs)) {
				$objectstatic = new PORecap($db);
				$objectstatic->delete($obj->id);
			} else {
				$comment 	  = trim($_POST['new_pieces_comments'][$key]);
				$objectstatic = new PORecap($db);
				$objectstatic->update($obj->id, array(
					'comment' => $comment
				));
			}
		}
	}

	if (count($getNewSubmittedPcs)) {
		$getNewSubmittedPcs = array_filter($getNewSubmittedPcs);

		foreach ($getNewSubmittedPcs as $key => $ref) {
			$comment 				= trim($_POST['new_added_pieces_comments'][$key]);
			$objectstatic 			= new PORecap($db);
			$objectstatic->ref 	  	= $ref;
			$objectstatic->comment 	= $comment;
			$objectstatic->statut 	= 0;
			$objectstatic->fk_po 	= $poid;
			$objectstatic->fk_created_by= $user->id;
			$objectstatic->create();
			$objectstatic = null;
		}
	
	}

	header("Location: ./index.php?poid=".$poid);
	die();
}

if ($action == 'archive' && $poid) {
	$object->fetchAll($poid, true);
	$countDefaultPcs = count($object->lines);

	$purchaseorder->update($poid, array('statut' => 3));

	header("Location: ./index.php?poid=".$poid);
	die();
}