<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/po_managementpackingslip/index.php
 * \ingroup    po_managementpackingslip
 * \brief      List of po_managementpackingslip
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
dol_include_once('/marches/purchaseorder/class/purchaseorder.class.php');
dol_include_once('/marches/po_managementpackingslip/class/po_managementpackingslip.class.php');
dol_include_once('/marches/lib/marches.lib.php');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

$sortfield 	= GETPOST("sortfield",'alpha');
$sortorder 	= GETPOST("sortorder",'alpha');
$page 		= GETPOST("page",'int');
$page 		= is_numeric($page) ? $page : 0;
$page 		= $page == -1 ? 0 : $page;
$filter 	= '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$poid 	  = GETPOST('poid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$poid)
	die("ID bon de commande n'existe pas!");

$object	 		= new POManagementPackingSlip($db);
$purchaseorder 	= new PurchaseOrder($db);

$search_ref			= GETPOST('search_ref');
$search_date_at		= GETPOST('search_date_at');
$search_created_by 	= GETPOST('search_created_by');
$search_subject     = GETPOST('search_subject');
$search_number     	= GETPOST('search_number');
$search_observ     	= GETPOST('search_observ');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref 		= "";
	$search_date_at 	= "";
	$search_created_by 	= "";
	$search_subject  	= "";
    $search_number     	= "";
    $search_observ     	= "";
}


/**
 * Actions
 */

// None

/**
 * View
 */
llxHeader(array(), $langs->trans('ListOfmanagementpackingslip'));

// Filter
$filter .= (!empty($search_ref) && $search_ref != -1) ? " AND rowid = ". (int) $db->escape($search_ref) : "";
$filter .= (!empty($search_number) && $search_number != -1) ? " AND number = ". (int)$db->escape($search_number) : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ".(int)$db->escape($search_created_by) : "";
$filter .= (!empty($search_subject) && $search_subject != -1) ? " AND subject like '%".$db->escape($search_subject)."%'\n" : "";
$filter .= (!empty($search_observ) && $search_observ != -1) ? " AND observation like '%".$db->escape($search_observ)."%'\n" : "";
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getpo_managementpackingslip = $object->fetchAll($poid,$sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getpo_managementpackingslip == '-1') {
    print_fiche_titre($langs->trans('ListOfmanagementpackingslip'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new Form($db);

if ($id > 0) {
	$object->fetch($id);
	$purchaseorder->fetch($poid);
	$head = purchaseorder_prepare_head($purchaseorder);
	dol_fiche_head($head, 'po_managementpackingslip', $langs->trans("ManagementPackingSlipBC"), 0, '');
	
	echo $purchaseorder->getMarketHeader();
	
	$subject 	 = $object->subject ? nl2br($object->subject) : '';
	$observation = $object->observation ? nl2br($object->observation) : '';

	print '<table class="border" width="100%">';

	/*print '<tr><td width="25%">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'. dol_print_date($object->date_at, 'day') .'</td></tr>';*/
	
	print '<tr><td width="25%">'.$langs->trans("Number").'</td>';
	print '<td colspan="2">'. $object->number .'</td></tr>';

	print '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. $subject .'</td></tr>';

	print '<tr><td width="25%">'.$langs->trans("Observation").'</td>';
	print '<td colspan="2">'. $observation .'</td></tr>';

	print '</table><br />';

	print '<div style="float: right;">';
	print '<a href="./index.php?poid='. $poid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id && $user->rights->marches->write_bcs) {
		print '<a href="./card.php?action=edit&id='.$id.'&poid='. $poid .'" class="butAction">'.$langs->trans('Modify').'</a>';
	}

	if ( $user->rights->marches->delete_bcs)	{
    	print '<a href="./index.php?id='.$id.'&action=delete&poid='. $poid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
    }
	print '</div>';

	if ($action == 'delete') {
        if( $user->rights->marches->delete_bcs) {
            print $form->formconfirm("./card.php?poid=".$poid."&id=".$id, $langs->trans("TitleDeletePackingSlip"),$langs->trans("ConfirmDeletePackingSlip"),"confirm_delete", '', 0, 1);
        }
    }
} else {
	$title = $langs->trans("ListOfmanagementpackingslip");
	$purchaseorder->fetch($poid);
	$head = purchaseorder_prepare_head($purchaseorder);
	dol_fiche_head($head, 'po_managementpackingslip', $langs->trans("ManagementPackingSlipBC"), 0, '');
	
	echo $purchaseorder->getMarketHeader();
	$moreparam = '&poid='. $poid;

	print '<table class="border" width="100%">';
	print '<tbody>';
	print '<tr><td>';
	print '<a href="./card.php?poid='. $poid .'&action=pdf"><img src="'.DOL_URL_ROOT.'/theme/common/mime/pdf.png" alt="" title="'. $langs->trans('DownloadPackingSlip') .'" /> '. $langs->trans('DownloadPackingSlip') .'</a>';
	print '</td></tr>';
	print '</tbody>';
	print '</table><br />';

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'?poid='. $poid .'">';
	print '<input type="hidden" value="'. $poid .'" name="poid" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Subject"), $_SERVER["PHP_SELF"], 'subject', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Observation"), $_SERVER["PHP_SELF"], 'observation', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Number"), $_SERVER["PHP_SELF"], 'number', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	// print_liste_field_titre($langs->trans("Date"),$_SERVER["PHP_SELF"],"date_at","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat center" size="30" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="30" name="search_subject" value="'.$search_subject.'"></td>';
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="30" name="search_observ" value="'.$search_observ.'"></td>';
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="number" min="1" size="30" name="search_number" value="'.$search_number.'"></td>';

	/*print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="14" name="search_date_at" value="'.$search_date_at.'"></td>';*/
	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		$createdBy = new User($db);

		foreach($object->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_created_by));
			$number		 = $line->number ? $line->number : '';
			// $date_at	 = $line->date_at ? dol_print_date($line->date_at, 'day'): '';
			$subject 	 = '';
			$fullsubject = '';
			if (null !== $line->subject) {
				$fullsubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject 	= substr($line->subject, 0, 100);
				$subject 	= strlen($line->subject) > 100 ? $subject.'...' : $subject;
			}

			$observation 	 = '';
			$fullobservation = '';
			if (null !== $line->observation) {
				$fullobservation = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->observation)));
				$observation 	= substr($line->observation, 0, 100);
				$observation 	= strlen($line->observation) > 100 ? $observation.'...' : $observation;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $object->getNomUrl(1,  $line->id, $poid);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullsubject .'">'. $subject .'</span></td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullobservation .'">'. $observation .'</span></td>';
			print '<td align="center">'.$number.'</td>';
			// print '<td align="center">'. $date_at .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->marches->write_bcs) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&poid='. $poid .'" class="butAction">'.$langs->trans('AddPackingSlip').'</a>';
		print '</div>';
	}
}

llxFooter();

$db->close();

?>