<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/competitors/card.php
 *		\ingroup    card
 *		\brief      Gestion des concurrents
 */

//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
dol_include_once('/marches/class/appeloffre.class.php');
dol_include_once('/marches/monitorings/class/monitoring.class.php');
dol_include_once('/marches/lib/marches.lib.php');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$ao 	 = GETPOST('ao', 'int');
$id 	 = GETPOST('id', 'int');

if ((empty($ao) || $ao <= 0) && $_SERVER['REQUEST_METHOD'] !== 'POST')
	die('ID Appel offre n\'existe pas!');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 		 = false;
$monitorings = new Monitoring($db);

if ($_POST['action'] == 'create' && $_SERVER['REQUEST_METHOD'] === 'POST') {

    // If no right to create a request
    if (empty($user->rights->marches->write)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }

    $demand_date 		= '';
    $response_st_date	= '';
    $ao 				= trim(GETPOST('ao', 'int'));
    $demand_num 		= trim(GETPOST('demand_num'));
    $response_st_num 	= trim(GETPOST('response_st_num'));
    $delay_justfication = trim(GETPOST('delay_justfication'));
    $observation 		= trim(GETPOST('observation'));

    if (!$ao || !$demand_num)
    	return;

    if (isset($_POST['demand_date']) && !empty($_POST['demand_date'])) {
        list($etd, $etm, $ety) = explode("/", $_POST['demand_date']);
        $demand_date = $ety.'-'.$etm.'-'.$etd;
    }

    if (isset($_POST['response_st_date']) && !empty($_POST['response_st_date'])) {
        list($etd, $etm, $ety) = explode("/", $_POST['response_st_date']);
        $response_st_date = $ety.'-'.$etm.'-'.$etd;
    }

    $moyens = array();
    if (isset($_POST['moyens']) && !empty($_POST['moyens']) && count($_POST['moyens'])) {
    	foreach ($_POST['moyens'] as $key => $moyen) {
    		$comment  = strtolower(trim($_POST['moyen_coms'][$key]));
    		$moyens[strtolower($moyen)] = $comment;
    	}
    }

    $monitorings->fk_created_by  	 = $user->id;
    $monitorings->fk_appel_offre 	 = $ao;
    $monitorings->demand_num 		 = $demand_num;
    $monitorings->demand_date 		 = $demand_date;
	$monitorings->response_st_num 	 = $response_st_num;
	$monitorings->response_st_date   = $response_st_date;
	$monitorings->delay_justfication = $delay_justfication;
	$monitorings->moyens    	 	 = $moyens;
	$monitorings->observation    	 = $observation;

	$getMonitoringId = $monitorings->create();

    // If no SQL error we redirect to the request card
    header('Location: ./index.php?ao='.$ao);
    die();
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['ao'] > 0 && $_SERVER['REQUEST_METHOD'] === 'POST') {

	// If no right to create a request
    if (empty($user->rights->marches->write) ) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {
	    $demand_date 		= '';
	    $response_st_date	= '';
	    $ao 				= trim(GETPOST('ao', 'int'));
	    $id 				= trim(GETPOST('id', 'int'));
	    $demand_num 		= trim(GETPOST('demand_num'));
	    $response_st_num 	= trim(GETPOST('response_st_num'));
	    $delay_justfication = trim(GETPOST('delay_justfication'));
	    $observation 		= trim(GETPOST('observation'));

	    if (!$ao || !$demand_num)
	    	return;

	    if (isset($_POST['demand_date']) && !empty($_POST['demand_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['demand_date']);
	        $demand_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['response_st_date']) && !empty($_POST['response_st_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['response_st_date']);
	        $response_st_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $moyens = array();
	    if (isset($_POST['moyens']) && !empty($_POST['moyens']) && count($_POST['moyens'])) {
	    	$comments = array_values(array_filter($_POST['moyen_coms']));
	    	foreach ($_POST['moyens'] as $key => $moyen) {
	    		$comment  = strtolower(trim($comments[$key]));
	    		$moyens[strtolower($moyen)] = $comment;
	    	}
	    }

	    $data = array(
		    'demand_num' 		 => $demand_num,
		    'demand_date' 		 => $demand_date,
			'response_st_num' 	 => $response_st_num,
			'response_st_date'   => $response_st_date,
			'delay_justfication' => $delay_justfication,
			'observation'    	 => $observation,
			'moyens'    	 	 => serialize($moyens)
		);

		$monitorings->update($id, $ao, $data);

    	header('Location: ./index.php?ao='.$ao);
        die();
	}
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->marches->delete) {
	$error = 0;
	$ao = GETPOST('ao', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$ao || !$id)
		return;

	$db->begin();

	$canedit = ( $user->rights->marches->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $monitorings->id = (int) $id;
        $monitorings->fk_appel_offre = (int) $ao;
		$monitorings->delete();
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php?leftmenu=marches&ao='.$ao);
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php?leftmenu=marches&ao='.$ao);
        exit;
	}
}

$form 	 	= new Form($db);
$appeloffre = new AppelOffre($db);
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/includes/jquery/plugins/timepicker/timepicker-fr.js", "/marches/js/marches.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css", "/marches/css/marches.css");

llxHeader(array(), $langs->trans('ListOfCompetitors'),'','','','',$morejs,$morecss,0,0);
//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');

if (empty($ao) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) ) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {
        // Formulaire de concurrents
		$appeloffre->fetch($ao);
		$head = appeloffre_prepare_head($appeloffre);
		dol_fiche_head($head, 'monitoring', $langs->trans('AddMonitoring'), 0, '');

		echo $appeloffre->getAppelOffreHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="ao" value="'. $ao .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="400px">'.$langs->trans("MonitoringLetterDemand").'</td><td>';
        print '<input type="text" class="" value="" name="demand_num" required="required" />&nbsp;&nbsp;'. $langs->trans("MonitoringDate").' &nbsp;&nbsp;<input type="text" class="datepicker" value="" name="demand_date" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("MonitoringResponseCompagnyNum").'</td><td>';
        print '<input type="text" class="" value="" name="response_st_num" />&nbsp;&nbsp;'. $langs->trans("MonitoringDate").' &nbsp;&nbsp;<input type="text" class="datepicker" value="" name="response_st_date" />';
        print '</td></tr>';
        
        print '<tr><td>'.$langs->trans("MonitoringDelayJustify").'</td><td>';
        print '<input type="text" class="" value="" name="delay_justfication" />';
        print '</td></tr>';

        print '<tr><td valign="top">'.$langs->trans("ByAveraging").'</td><td>';
        print ' <div style="">
        	<span class="moniroting_moyen_blocks"><label for="fax"><input id="fax" type="checkbox" name="moyens[]" value="Fax" /> Fax</label></span>
        	<input type="text" class="" value="" name="moyen_coms[]" size="50" />
        </div>';
        print ' <div style="">
        	<span class="moniroting_moyen_blocks"><label for="bordereau"><input id="bordereau" type="checkbox" name="moyens[]" value="Bordereau" /> Bordereau</label></span>
        	<input type="text" class="" value="" name="moyen_coms[]" size="50" />
        </div>';
        print ' <div style="">
        	<span class="moniroting_moyen_blocks"><label for="autres"><input id="autres" type="checkbox" name="moyens[]" value="Autres" /> Autres</label></span>
        	<input type="text" class="" value="" name="moyen_coms[]" size="50" />
        </div>';
        	// <!--textarea cols="10" rows="6" name="moyen_coms[]"></textarea-->
        print '</td></tr>';

        print '<tr><td valign="top">'.$langs->trans("MonitoringObserv").'</td><td>';
        print '<textarea cols="49" rows="6" name="observation"></textarea>';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateMonitoring") .'" name="bouton" class="button">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="button" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $ao > 0) {
		$monitorings->fetch($id, $ao);
		$appeloffre->fetch($ao);
		$head  = appeloffre_prepare_head($appeloffre, $monitorings);
		$canedit = ($user->rights->marches->delete );

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?ao=".$ao."&id=".$id, $langs->trans("TitleDeleteMonitoring"),$langs->trans("ConfirmDeleteMonitoring"),"confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'monitoring', $langs->trans('AddMonitoring'), 0, '');
				$checked = $monitorings->name == 1 ? ' checked="checked"' : '';
				
				echo $appeloffre->getAppelOffreHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="ao" value="'. $ao .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$demand_num 		  = $monitorings->demand_num ? $monitorings->demand_num : '';
		      	$demand_date		  = $monitorings->demand_date ? dol_print_date($monitorings->demand_date, 'day'): '';
				$delay_justfication	  = $monitorings->delay_justfication ? $monitorings->delay_justfication : '';
				$response_st_num	  = $monitorings->response_st_num ? $monitorings->response_st_num : '';
				$response_st_date	  = $monitorings->response_st_date ? dol_print_date($monitorings->response_st_date, 'day') : '';
				$observation		  = $monitorings->observation ? $monitorings->observation : '';
				$defaultMoyens 		  = array('fax', 'bordereau', 'autres');

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired" width="400px">'.$langs->trans("MonitoringLetterDemand").'</td><td>';
		        print '<input type="text" class="" value="'. $demand_num .'" name="demand_num" required="required" />&nbsp;&nbsp;'. $langs->trans("MonitoringDate").' &nbsp;&nbsp;<input type="text" class="datepicker" value="'. $demand_date .'" name="demand_date" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("MonitoringResponseCompagnyNum").'</td><td>';
		        print '<input type="text" class="" value="'. $response_st_num .'" name="response_st_num" />&nbsp;&nbsp;'. $langs->trans("MonitoringDate").' &nbsp;&nbsp;<input type="text" class="datepicker" value="'. $response_st_date .'" name="response_st_date" />';
		        print '</td></tr>';
		        
		        print '<tr><td>'.$langs->trans("MonitoringDelayJustify").'</td><td>';
		        print '<input type="text" class="" value="'. $delay_justfication .'" name="delay_justfication" />';
		        print '</td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("ByAveraging").'</td><td>';

				foreach ($defaultMoyens as $key => $moyen) {
					$lmoyen = strtolower($moyen);
					$comment = $checked = '';

					if ($monitorings->moyens && array_key_exists($moyen, $monitorings->moyens)) {
						$checked = ' checked="checked"';
						$comment = $monitorings->moyens[$moyen];
					}

			        print ' <div style="">
			        	<span class="moniroting_moyen_blocks"><label for="'. $lmoyen .'"><input id="'. $lmoyen .'" type="checkbox" name="moyens[]" value="'. ucfirst($moyen) .'"'. $checked .' /> '. ucfirst($moyen) .'</label></span>
			        	<input type="text" class="" value="'. $comment .'" name="moyen_coms[]" size="50" />
			        </div>';
				}
			        print '</td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("MonitoringObserv").'</td><td>';
		        print ' <textarea cols="49" rows="6" name="observation">'. $observation .'</textarea>';
		        print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    
                    // If draft
                    if ($user->rights->marches->delete)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete&ao='. $ao .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>