$(function(){
	$('.datepicker').datepicker({
	    	dateFormat: 'dd/mm/yy',
		});
	
	if ($.fn.timepicker) {
		$('.timepicker').timepicker({
			showSecond: true,
			timeOnly: true
		});
	}

	if ($.fn.datepicker) {
		$('.datepicker').datepicker({
	    	dateFormat: 'dd/mm/yy',
		});
		$('.sel_end_date').datepicker({
			onSelect: function(date) {
				if ($('.recap_archived').length) {
					var getHref = $('.recap_archived').attr("href");

					if (getHref.indexOf('&marche_end_date') > -1) {
						getHref = getHref.split("&marche_end_date")[0];
					}

					$('.recap_archived').attr("href", getHref+"&marche_end_date="+ date);
	            	console.log(date);
				}
	        }
		});
	}

	// add new line
	$('#addMoreDefQulif').on('click', function() {
		var clonedLine = $('.def_qualif_wrapper_0').clone(),
			lineNum  = $('tr.counted_lines_def').length,
			nextline = lineNum;

		$('#to_parent_wrapper').append(clonedLine);

		// Generale
		clonedLine.attr('data-trans-order', nextline)
		  .removeClass('def_qualif_wrapper_0')
		  .addClass('def_qualif_wrapper_'+ nextline);
		
		var newWrapper = $('.def_qualif_wrapper_'+ nextline);

		newWrapper.find('input.def_sector, input.def_qualif, input.def_class').val("");
		newWrapper.find('a.delete_def_img').css("display","block");
	});

	$(document).on('click', 'a.delete_def_img', function() {
		var getId = $(this).attr('data-id');

		if (getId == "") {
			$(this).parents('.counted_lines_def').remove();
		}
	});

	$('#addMoreProvQulif').on('click', function() {
		var clonedLine = $('.prov_qualif_wrapper_0').clone(),
			lineNum  = $('tr.counted_lines').length,
			nextline = lineNum;

		$('#to_parent_wrapper_prov').append(clonedLine);

		// Generale
		clonedLine.attr('data-trans-order', nextline)
		  .removeClass('prov_qualif_wrapper_0')
		  .addClass('prov_qualif_wrapper_'+ nextline);
		
		var newWrapper = $('.prov_qualif_wrapper_'+ nextline);

		newWrapper.find('input.prov_sector, input.prov_qualif, input.prov_class').val("");
		newWrapper.find('a.delete_prov_img').css("display","block");
	});

	$(document).on('click', 'a.delete_prov_img', function() {
		var getId = $(this).attr('data-id');

		if (getId == "") {
			$(this).parents('.counted_lines').remove();
		}
	});

	$('#addMoreCompetitors').on('click', function() {
		var clonedLine = $('.row-0').clone(),
			lineNum  = $('table.rows-num').length,
			nextline = lineNum;

		$('#competitors_wrapper').append(clonedLine);

		// Generale
		clonedLine.removeClass('row-0').addClass('row-'+ nextline);
		
		var newWrapper = $('.row-'+ nextline);
		newWrapper.attr('data-row-id', nextline);
		newWrapper.find('input.comp_name, input.comp_amount, input.comp_city, input.comp_address, input.comp_country').val("");
		newWrapper.find('input.comp_winner').attr("checked", false);
		newWrapper.find('a.delete_img').css("display","block");
	});

	$(document).on('click', '.delete_img', function() {
		$(this).parents('.rows-num').remove();
	});

	$(document).on('change', '.comp_winner', function() {
		var lines = 0, checked = true;
		if ($(this).is(':checked')) {
			$('.comp_winner').each(function(index) {
				if ($(this).is(':checked'))
					lines += 1;
			});
		} else {
			lines = 0;
			$('#awarded').val("");
			checked = false;
		}

		if (lines > 1) {
			$(this).attr('checked', false);
			alert('Vous pouvez assigner l\'attributaire à un concurrent');
			return false;
		} else {
			if (checked != false)
				$('#awarded').val($(this).parents('.rows-num').attr('data-row-id'));
		}
	});

	$('.amount').on('keyup, keydown, change', function() {
		var amount = parseFloat($(this).val()),
			tva    = calculateTva(amount),
			total  = parseFloat(tva + amount);

		$('.tva').val(tva);
		$('.total_amout').val(total);
	});

	$('.approved').on('change', function() {
		if ($(this).val() == '0') {
			$('.bail_info').removeClass('hidden');
			$(".check_confirm_btn").removeClass('confirmActionToGo');
		} else {
			$('.bail_info').addClass('hidden');
			$(".check_confirm_btn").addClass('confirmActionToGo');
		}
	});

	if ($('input.approved').length > 0) {
		$('input.approved').each(function(index) {
			if ($(this).is(':checked')) {
				if ($(this).val() == '1') {
					$('.bail_info').addClass('hidden');
				}
				else {
					$('.bail_info').removeClass('hidden');
				}
			}
		});
	}

	// update execution status
	$('#updateStatus').on('click', function() {
		var val = parseInt($(this).attr('data-id'));
		var status = 0;
		
		$('.sel-rg-type').each(function() {
			if ($(this).is(':checked')) {
				status = parseInt($(this).val());
			}
		});

		if (val == 0) {
			return false;
		}

		var options = {"status": status, "exec_id": val, "action": 'updateStatus'};

		$.post(main_dir+customtxtinurl+'/marches/ajax/execution.php', options, function(response) {
			if (response.statut) {
				alert('Le statut a été mise à jour avec succès.');
			}
		}, 'json');

	});

	$('#selectbank_, #selectaccount_, #bank_').on('change', function() {
		var val = $(this).val();

		if (val == -1) {
			$('.bank_number').html("");
			return false; 
		}

		var options = {
			'account_id': val
		};

		$.post(main_dir+customtxtinurl+'/marches/ajax/ao.php', options, function(response) {
			// console.log(customtxtinurl);
			var status = response.status;
			var number = response.number;
			var html   = '';

			if (status == 200 && number != "") {
				html = "&nbsp;&nbsp;( <b><u>"+ number +"</u></b> )";
			}

			$('.bank_number').html(html);

		}, 'json');
	});

	$('#addCerts').on('click', function() {
		var certs_container = $('#certificates_wrapper'),
		addBtn = $('.sub_cert'), cs = $('#chargesociales_list');

		if (cs.val() == 0)
			return;

		$.post(main_dir+customtxtinurl+'/marches/ajax/chargesociales.php', {'chargesociales': cs.val(), 'mid':$(this).attr('data-mid')}, function(response) {
			var status = response.status;
			var lines = response.lines;
			var html   = '';
		// console.log(response);

			if (status == 200 && lines.length) {
				for (var i = 0; i < lines.length; i++) {
					var classe = i % 2 == 0 ? 'pair' : 'impair'; 	
					html += "<tr class='"+ classe +"'>"+
						"<td align='center'>"+ lines[i].ref +"</td>"+
						"<td align='center'>"+ lines[i].lib +"</td>"+
						"<td align='center'>"+ lines[i].periode +"</td>"+
						"<td align='center'>"+ lines[i].amount +"</td>"+
						"<td align='center'>"+ lines[i].date_ech +"</td>"+
						"<td align='center'><input class='sc_checks' type='checkbox' name='cs[]' value='"+ parseInt(lines[i].id) +"' /></td>"+
					"</tr>";
				}
			}

			certs_container.append(html).fadeIn('slow');
			addBtn.parent().fadeIn('slow');

		}, 'json');

		$('#chargesociales_list option:selected').remove();
	});

	$(document).on('click', '.sub_cert', function(e) {
		e.preventDefault();
		var isOneChecked = false;

		$('.sc_checks').each(function(index) {
			if ($(this).is(':checked'))
				isOneChecked = true;
		});

		if (!isOneChecked) {
			alert('Veuillez cocher au moins une ligne!');
			return false;
		} else {
			$('#cs-form').submit();
		}
	});

	$(document).on('click', '#addExeTime', function(){
		if ($(this).attr("data-oper") == '1') {
			calculateEndDate($('#start_date'), $('#months'), $('#days'), $(this).attr('data-mid'), 1);
		} else {
			$("#start_date, .mon_day_inp").removeClass('hidden');
			$('.start_date_static, .mon_day').addClass('hidden');
			
			$(this).html("Modifier").attr("data-oper", 1);	
		}
	});

	$('.sel-rg-type').on('change', function() {
		var getVal = $(this).val(),// 0: man, 1: auto
			leftSide = $('.rg-left-side'),
			rightSide = $('.rg-right-side'); 

		if (getVal == 0) {
			leftSide.css({"opacity": 0.5});
			rightSide.css({"opacity": 0.5});
		} else if (getVal == 1) {
			leftSide.css({"opacity": 0.5});
			rightSide.css({"opacity": 1});
		} else {
			leftSide.css({"opacity": 1});
			rightSide.css({"opacity": 0.5});
		}
	});

	$(document).on('click', "#addManualRG", function() {
		var getBtnState = $(this).attr("data-update");

		if (getBtnState == 0) {
			var options = {
				"execution_id": $(this).attr("data-id"),
				"ref":     		$("#ref").val(),
				"amount":  		$("#amount").val(),
				"sig_date":  	$("#sig_date").val(),
				"deposit_date": $("#deposit_date").val(),
				"bank":    		$("#selectbank_, #selectaccount_").val(),
				"mid":     		$(this).attr("data-mid")
			};

			updateRGFields(options);
			
			// document.location = document.location.href;
		} else {
			$(".static_ref, .static_amount, .static_account, .sig_date_static, .deposit_date_static").addClass('hidden');
			$(".account_inp, .amount_inp, .ref_inp, #sig_date, #deposit_date").removeClass('hidden');
			$("#selectbank_, #selectaccount_").trigger("change");

			$(this).attr("data-update", 0);
		}
	});

	$('#addNewPiece').on('click', function() {
		$('.pcs_container').append('<tr><td width="35%"><div class="new_pc_row"><input name="new_added_pieces[]" type="text" value="" /></td><td width="65%"><textarea name="new_added_pieces_comments[]" cols="70" rows="2"></textarea></td></tr>');
	});

	$(document).on('click', ".confirmActionToGo", function(e) {
		e.preventDefault();

		if (confirm('Est ce que vous êtes sûr de lancer cette action')) {
			$("form.sub_form_prt").submit();
		}

		return false;
	});

});

var tagsToReplace = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;'
};

function replaceTag(tag) {
    return tagsToReplace[tag] || tag;
}

function safe_tags_replace(str) {
    return str.replace(/[&<>]/g, replaceTag);
}

function updateRGFields(options) {
	var ref	= options.ref;
	var mid	= parseInt(Math.floor(options.mid));

	if (mid == "" || mid == "undefined" || mid == 0) {
	    console.log('marche empty');
	    return false;
	}
	     
	if (ref == "" || ref == "undefined") {
	     console.log('ref empty');
	    return false;
	}

	options.rg_section = true;
  	$.post(main_dir+customtxtinurl+'/marches/ajax/execution.php', options, function(response) {
			$(".static_ref").html(response.ref);
			$(".static_amount").html(response.amount);
			$("#selectbank_").val(response.account);
			$(".sig_date_static").html(options.sig_date);
			$(".deposit_date_static").html(options.deposit_date);

			$(".account_inp, .amount_inp, .ref_inp, #sig_date, #deposit_date").addClass('hidden');
			$(".static_ref, .static_amount, .static_account, .sig_date_static, .deposit_date_static").removeClass('hidden');
			$('.static_account').html(response.account_url).append("<span class='bank_number'></span>");
			$(".acount_cls").attr("title", "");

			// var encodeTitle = safe_tags_replace($(".acount_cls").attr("title"));
			// console.log(encodeTitle);
			// $(".acount_cls").attr("title", encodeTitle);

			$("#addManualRG").attr("data-update", 1).html("Modifier");
			if (response.last_id)
				$("#addManualRG").attr("data-id", response.last_id);

			$("#selectbank_").trigger("change");
	}, 'json');
}

function calculateEndDate(start_date, months, days, data_mid, data_oper) {
	var startDate = start_date.val();
	var months  = parseInt(Math.floor(months.val()));
	var days    = parseInt(Math.floor(days.val()));
	var mid 	= parseInt(data_mid);

	if (startDate == '' || startDate == "undefined") {
	    console.log('start date empty');
	    return false;
	}
	     
	if (months == '' || months == "undefined" || months == 0) {
	     console.log('month empty');
	    return false;
	}
	  
	if (days == '' || days == "undefined" || days == 0)
	   days = 0;
	  
	var options = {
		"start_date": startDate,
		"months": months.toString().substr(0, 4),
		"days": days.toString().substr(0, 2),
		"mid": mid,
		"exec_id": $("#addExeTime").attr("data-exec-id")
	};
  	
	if (data_oper == 1) {
	  	$.post(main_dir+customtxtinurl+'/marches/ajax/execution.php', options, function(response) {
				$("#start_date, .mon_day_inp").addClass('hidden');

				$(".start_date_static").html(startDate);
				$(".months_static").html(months);
				$(".days_static").html(days);

				$('.end_date_static').html(response.end_date);
				$('.start_date_static, .mon_day').removeClass('hidden');

				$("#addExeTime").html("Modifier").attr("data-oper", 2).attr("data-exec-id", response.last_id);
		}, 'json');
	}
}

function calculateTva(amount) {
	return parseFloat((amount*20)/100);
}