<?php 
/* Copyright (C) 2016  Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/documentmanagement/index.php
 *		\ingroup    list
 *		\brief      Gestion des documents
 */

//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
dol_include_once('/marches/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/marches/documentmanagement/class/documentmanagement.class.php');
dol_include_once('/marches/marche/class/marche.class.php');
dol_include_once('/marches/lib/marches.lib.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';

if ($user->societe_id > 0) $socid = $user->societe_id;

$langs->load('marches');

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$mid 	  = GETPOST('mid','int');
$type 	  = GETPOST('type','int');
$action  = GETPOST('action','alpha');
$confirm = GETPOST('confirm', 'alpha');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid || !$type)
	die('Marche ou type de document introuvable!');

$search_doc_date 			= GETPOST('search_doc_date', '', 1);
$search_created_by 	= (int) GETPOST('search_created_by', '', 1);
$search_observes   	= GETPOST('search_observes', '', 1);
$search_ref     	= GETPOST('search_ref', '', 1);

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_doc_date = "";
	$search_created_by = "";
	$search_observes  	   = "";
    $search_ref     = "";
}

$filter .= (!empty($search_ref)) ? " AND ref = '". $db->escape($search_ref) ."'" : "";
$filter .= !empty($search_observes) ? " AND observes like '%". $db->escape($search_observes) ."%'" : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ". $db->escape($search_created_by) : "";
if (isset($search_doc_date) && !empty($search_doc_date)) {
	list($sd, $sm, $sy)  = explode("/", $search_doc_date);
	$filter .=  " AND doc_date = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}

$object	 	= new DocumentManagement($db);
$marche 	= new Marches($db);
$userstatic	= new User($db);
$form 		= new FormChild($db);
$marche->fetch($mid);
$document_dirs = $object->getDocumentTypesDir();

if ($id) {
	$object->fetch($id);	
    $param = '&mid='. $mid .'&type='. $type;

	$upload_dir = $conf->marches->dir_output.'/'. $document_dirs[($type-1)].'/'. $mid .'/'.$object->id;
	$modulepart = 'marches';
	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	include_once dol_buildpath('/marches/core/tpl/document_actions_pre_headers.tpl.php');
}

$morejs  = array('/marches/js/marches.js');
$morecss = array();
llxHeader(array(), $langs->trans('MarketDocuments'),'','','','',$morejs,$morecss,0,0);
//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');

print_fiche_titre($langs->trans('MarketDocuments'),'','object_marches@marches');
$getDocumentsByType = $object->fetchAll($mid, $type, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getDocumentsByType == '-1') {
    print_fiche_titre($langs->trans('MarketDocuments'), '', '');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var = true;
$num = count($object->lines);

if ($id) {
	$object->fetch($id);

	$head = marches_prepare_head($marche);
	dol_fiche_head($head, 'documentmanagement', $langs->trans('MarketDocuments'), 0, '');

    $module_name = (in_array($type, array(99, 10, 11, 12)) ? 'technical_file' : $document_dirs[($type-1)]);
	$headBtm = marche_documents_prepare_head($marche);
    dol_fiche_head($headBtm, $module_name, $langs->trans("DocumentTypes"), 0, '');

    /*$headBtm2 = marche_documents2_prepare_head($marche);
    dol_fiche_head($headBtm2, $module_name, $langs->trans("DocumentTypes"), 0, '');*/

	echo $marche->getMarketHeader();

	$userstatic->fetch($object->fk_created_by);
	
	print '<table class="border" width="100%">';
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $userstatic->getNomUrl(1) .'</td></tr>';
	print '<tr><td width="25%">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. dol_print_date($object->created_at, 'day') .'</td></tr>';
	
	print '<tr><td width="25%">'.$langs->trans("Label").'</td>';
	print '<td colspan="2">'. $object->ref .'</td></tr>';
	
	print '<tr><td width="25%">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'. dol_print_date($object->doc_date, 'day') .'</td></tr>';

	print '<tr><td width="25%">'.$langs->trans("type").'</td>';
	print '<td colspan="2">'. $object->getDocumentTypeById($object->type_id) .'</td></tr>';

	print '<tr><td width="25%">'.$langs->trans("Remarks").'</td>';
	print '<td colspan="2">'. nl2br($object->observes) .'</td></tr>';

	print '</table><br />';

	print '<div style="float: right;">';

	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id && $user->rights->marches->write_marche) {
		print '<a href="./card.php?action=edit&id='.$id.'&mid='. $mid .'&type='. $object->type_id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	}

	if ($user->rights->marches->delete_marche)	{
    	print '<a href="./list.php?id='.$id.'&action=delete_section&mid='. $mid .'&type='. $object->type_id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
    }
	print '</div>';

	// Confirmation de la suppression d'une ligne categorie
	if ($action == 'delete_section') {
	    print $form->formconfirm('./card.php?id='.$id.'&mid='. $mid, $langs->trans('DeleteFile'), $langs->trans('ConfirmDeleteFile',$ecmdir->label), 'confirm_delete','','',1);
	}
	// End confirm

    $modulepart = 'marches';
    $permission = $user->rights->marches->write;
    $param 		= '&mid='. $mid .'&type='. $type;
    $relativepathwithnofile = $document_dirs[($object->type_id-1)] .'/'. $mid .'/'. $object->id .'/';


    include_once dol_buildpath('/marches/core/tpl/document_actions_post_headers.tpl.php');
} else {
	$title = $langs->trans("objectsList");
	$marche->fetch($mid);
	$head = marches_prepare_head($marche);
	dol_fiche_head($head, 'documentmanagement', $langs->trans('MarketDocuments'), 0, '');

    $module_name = (in_array($type, array(99, 10, 11, 12)) ? 'technical_file' : $document_dirs[($type-1)]);
	$headBtm = marche_documents_prepare_head($marche);
    dol_fiche_head($headBtm, $module_name, $langs->trans("DocumentTypes"), 0, '');


    /*$headBtm2 = marche_documents2_prepare_head($marche);
    dol_fiche_head($headBtm2, $module_name, $langs->trans("DocumentTypes"), 0, '');*/

	echo $marche->getMarketHeader();
   	$moreparam = 'mid='.$mid.'&type='.$type;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">';
	print '<input type="hidden" name="mid" value="'. $mid .'" />';
	print '<input type="hidden" name="type" value="'. $type .'" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "ref", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"], 'doc_date', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Remarks"),$_SERVER["PHP_SELF"],"observes","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat center" size="30" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="20" name="search_doc_date" value="'.$search_doc_date.'"></td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="30" name="search_observes" value="'.$search_observes.'"></td>';

	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach($object->lines as $line) {
			$var = !$var;
			$userstatic->fetch($db->escape($line->fk_created_by));
			$ref 		 = $line->ref ? $line->ref : $line->id;
			$doc_date	 = $line->doc_date ? dol_print_date($line->doc_date, 'day'): '';
			$observes	 = $line->observes ? nl2br($line->observes): '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $object->getNomUrl(1,  $line->id, $line->type_id, $line->ref, $mid);
			print '</td>';
			print '<td align="center">'.$userstatic->getNomUrl('1').'</td>';
			print '<td align="center">'. $doc_date .'</td>';
			print '<td align="center">'. $observes .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->marches->write_marche) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='. $mid .'&type='. $type .'" class="butAction">'.$langs->trans('Add').'</a>';
		print '</div><br /><br />';
	}
}

llxFooter();

$db->close();

?>

