<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/approval/.class.php
 * \ingroup marches
 * \brief   This file is approval CRUD class file
 *
 */

dol_include_once('/marches/db/nxdb.class.php');

/**
 * Class marches
 *
 * Contract Management class
 */
class Approval extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_approval';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'm_approval';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_created_by;
	public $fk_appel_offre;
	public $amount_ht;
	public $amount_tva;
	public $amount_ttc;
	public $signature_num;
	public $signature_date;
	public $approval_num;
	public $approval_date;
	public $visa_num;
	public $visa_date;
	public $approved;
	public $statut;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		  = $db;
		$this->now 		  = new \DateTime("now");
		$this->now 		  = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_appel_offre 	= $this->fk_appel_offre ?: null;
		$this->fk_created_by  	= $this->fk_created_by ?: null;
		$amount_ht 				= $this->amount_ht ?: null;
		$amount_tva 			= $this->amount_tva ?: null;
		$amount_ttc 			= $this->amount_ttc ?: null;
		$signature_num 			= $this->signature_num ?: null;
		$signature_date 		= $this->signature_date ?: null;
		$approval_num 			= $this->approval_num ?: null;
		$approval_date 			= $this->approval_date ?: null;
		$visa_num 				= $this->visa_num ?: null;
		$visa_date 				= $this->visa_date ?: null;
		$approved 				= $this->approved ?: null;
		$bail_date 				= $this->bail_date ?: null;
		$bail_num 				= $this->bail_num ?: null;
		$bail_amount			= $this->bail_amount ?: null;
		$this->created_at 	  	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_appel_offre, fk_created_by, amount_ht, amount_tva, created_at, updated_at, amount_ttc, signature_num, signature_date, approval_num, approval_date, visa_num, visa_date, approved, bail_date, bail_num, bail_amount) VALUES (';
		$sql .= $this->fk_appel_offre.', '.$this->fk_created_by.', "'.$this->amount_ht.'", "'.$this->amount_tva.'", "'.$this->created_at.'", "'.$this->updated_at .'", "'.$this->amount_ttc.'", "'.$this->signature_num.'", "'.$this->signature_date.'", "'.$this->approval_num.'", "'.$this->approval_date.'", "'.$this->visa_num.'", "'.$this->visa_date.'", '.$this->approved.', "'. $bail_date .'", "'. $bail_num .'", "'. $bail_amount .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error Concurrents ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id = null, $ao_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $id) {
			$sql .= ' WHERE rowid = ' . $id;
		} else {
			$sql .= ' WHERE fk_appel_offre = '. $ao_id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->id 		  	  = $obj->rowid;
				$this->fk_appel_offre = $obj->fk_appel_offre;
				$this->fk_created_by  = $obj->fk_created_by;
				$this->amount_ht 	  = $obj->amount_ht;
				$this->amount_tva 	  = $obj->amount_tva;
				$this->amount_ttc 	  = $obj->amount_ttc;
				$this->signature_num  = $obj->signature_num;
				$this->signature_date = $this->db->jdate($obj->signature_date);
				$this->approval_num   = $obj->approval_num;
				$this->approval_date  = $this->db->jdate($obj->approval_date);
				$this->visa_num 	  = $obj->visa_num;
				$this->visa_date 	  = $this->db->jdate($obj->visa_date);
				$this->approved 	  = $obj->approved;
				$this->bail_date 	  = $this->db->jdate($obj->bail_date);
				$this->bail_num 	  = $obj->bail_num;
				$this->bail_amount    = $obj->bail_amount;
				$this->statut	  	  = $obj->statut;
				$this->updated_at 	  = $this->db->jdate($obj->updated_at);
				$this->created_at 	  = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($ao_id, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element . ' WHERE fk_appel_offre ='. (int) $ao_id;

		if (!empty($filter)) {
			$sql .= substr($filter, 4);
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		  	  = $obj->rowid;
				$line->fk_appel_offre = $obj->fk_appel_offre;
				$line->fk_created_by  = $obj->fk_created_by;
				$line->amount_ht 	  = $obj->amount_ht;
				$line->amount_tva 	  = $obj->amount_tva;
				$line->amount_ttc 	  = $obj->amount_ttc;
				$line->signature_num  = $obj->signature_num;
				$line->signature_date = $this->db->jdate($obj->signature_date);
				$line->approval_num   = $obj->approval_num;
				$line->approval_date  = $this->db->jdate($obj->approval_date);
				$line->visa_num 	  = $obj->visa_num;
				$line->visa_date 	  = $this->db->jdate($obj->visa_date);
				$line->approved 	  = $obj->approved;
				$line->bail_date 	  = $this->db->jdate($obj->bail_date);
				$line->bail_num 	  = $obj->bail_num;
				$line->bail_amount    = $obj->bail_amount;
				$line->statut	  	  = $obj->statut;
				$line->updated_at 	  = $this->db->jdate($obj->updated_at);
				$line->created_at 	  = $this->db->jdate($obj->created_at);
				$this->lines[] 	  	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, $ao_id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $val ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int) $id . ' AND fk_appel_offre ='. (int) $ao_id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $this->id .' AND fk_appel_offre ='. $this->fk_appel_offre;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id, $monitoring_id, $num = null)
    {
        global $langs;

        $result	= '';
        $num = (null !== $num) ? $num : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $num;

    	

        $link 	 = '<a href="'.dol_buildpath('/marches/monitorings/index.php?id='. $id .'&monitoring_id='. $monitoring_id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip picto_marche_module">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$num.$linkend;
        return $result;
    }

    public function statusLevel($statut)
	{
		global $langs;

		switch ($statut) {
			case 1:
				return $langs->trans('Approved').' '.img_picto($langs->trans('Approved'), 'statut6');
				break;
			
			case 0:
				return $langs->trans('NotApproved').' '.img_picto($langs->trans('NotApproved'),'statut5');
				break;
		}
    }
}
