<?php
/* Copyright (C) Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/appel_offre.class.php
 * \ingroup marches
 * \brief   This file is marches CRUD class file
 *
 */
dol_include_once('/marches/db/nxdb.class.php');

/**
 * Class marches
 *
 * Contract Management class
 */
class Qualifications extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_qualifications';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'm_qualifications';

	/**
	 * @var int ID
	 */
	public $id;
	public $num;
	public $type;
	public $fk_created_by;
	public $delivered; // date
	public $expired; // date
	public $subject;
	public $created_at;
	public $updated_at;
	public $months; // string -> difference of delivered and expired
	public $definitive; // string -> serialized array
	public $provisional; // string -> serialized array

	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->num 		  = $this->num ? $this->db->escape($this->num) : null;
		$this->type 	  = $this->type ?: null;
		$this->delivered  = $this->delivered ? $this->delivered : null;
		$this->expired	  = $this->expired ? $this->expired : null;
		$this->subject	  = $this->subject ? $this->db->escape($this->subject) : null;
		$this->months	  = $this->countMonths() ? ceil($this->countMonths()) : null;
		$this->definitive = serialize($this->definitive);
		$this->provisional= serialize($this->provisional);
		$this->created_at = $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (num, fk_created_by, type, delivered, created_at, updated_at, expired, months, definitive, provisional, subject) VALUES (';		
		$sql .= '"'.$this->num.'", '.$this->fk_created_by.', '.$this->type.', "'.$this->delivered.'", "'.$this->created_at.'", "'.$this->updated_at .'", "'.$this->expired.'", "'.$this->months.'",';
		$sql .= "'".$this->definitive."', '".$this->provisional."', '".$this->subject."')";

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error Appel d\'offre ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $num = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		
		if (null !== $num) {
			$sql .= ' WHERE num = ' . '\'' . $num . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  = $this->db->fetch_object($resql);
				$this->id 		  = $obj->rowid;
				$this->num 		  = $obj->num;
				$this->fk_created_by= $obj->fk_created_by;
				$this->type 	  = $obj->type;
				$this->delivered  = $this->db->jdate($obj->delivered);
				$this->expired	  = $this->db->jdate($obj->expired);
				$this->subject	  = $obj->subject;
				$this->months	  = $obj->months;
				$this->definitive = unserialize($obj->definitive);
				$this->provisional= unserialize($obj->provisional);
				$this->updated_at = $this->db->jdate($obj->updated_at);
				$this->created_at = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		  = $obj->rowid;
				$line->num 		  = $obj->num;
				$line->fk_created_by= $obj->fk_created_by;
				$line->type 	  = $obj->type;
				$line->delivered  = $this->db->jdate($obj->delivered);
				$line->expired	  = $this->db->jdate($obj->expired);
				$line->subject	  = $obj->subject;
				$line->months	  = $obj->months;
				$line->definitive = unserialize($obj->definitive);
				$line->provisional= unserialize($obj->provisional);
				$line->updated_at = $this->db->jdate($obj->updated_at);
				$line->created_at = $this->db->jdate($obj->created_at);
				$this->lines[] 	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $val ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     * return contract by salary id with filters if available
     *
     * @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     * @return integer
     */
	public function fetchByUser($user_id, $order = '', $filter = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE fk_created_by = '. (int) $user_id.' '. $order;

		// Manage filter
		if (!empty($filter)) {
			$sql .= $filter;
		}

		$this->lines = array();

		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$this->id 		  = $obj->rowid;
				$this->num 		  = $obj->num;
				$this->type 	  = $obj->type;
				$this->delivered  = unserialize($obj->delivered);
				$this->expired	  = $obj->expired;
				$this->subject	  = $obj->subject;
				$this->months	  = $obj->months;
				$this->definitive = unserialize($obj->definitive);
				$this->provisional= $obj->provisional;
				$this->updated_at = $this->db->jdate($obj->updated_at);
				$this->created_at = $this->db->jdate($obj->created_at);
				$this->lines[] 	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $num = null)
    {
        global $langs;

        $result	= '';
        $num = (null !== $num) ? $num : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $num;

        $link 	 = '<a href="'.dol_buildpath('/marches/qualifications/index.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).')" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$num.$linkend;
        return $result;
    }

    public function getTypes()
    {
    	global $langs;

    	return array(
    		1 => $langs->trans('QualificationType1'),
    		2 => $langs->trans('QualificationType2')
    	);
    }

    public function getTypeById($type_id)
    {
    	global $langs;

    	$type = '';
    	switch ((int) $type_id) {
    		case 1:
		    	$type = $langs->trans('QualificationType1');
    			break;
    		case 2:
		    	$type = $langs->trans('QualificationType2');
    			break;
    	}

    	return $type;
    }

    public function countMonths()
    {
    	if ((isset($this->delivered) && !empty($this->delivered)) && (isset($this->expired) && !empty($this->expired))) {
			$del = new DateTime($this->delivered);
			$pro = new DateTime($this->expired);

    		if ($pro->getTimestamp() > $del->getTimestamp()) {
    			$diff = $del->diff($pro);
    			$months = 0;
    			$years  = 0;

    			if ($diff->format('%y') > 0)
    				$years = $diff->format('%y')*12;
    			if ($diff->format('%d') >= 30)
    				$months += 1;

    			return $diff->format('%m')+$years+$months;
    		}
    	}
    }

    public function getQualifications()
    {
    	$this->fetchAll();
    	$qualifications = array();

    	if (count($this->lines))
    	foreach ($this->lines as $key => $line) {
			$qualifications[$line->id] = $line->num;    		
    	}

    	return $qualifications;
    }
}
