<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   mandarin     Module mandarin
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/mandarin/core/modules directory.
 *  \file       htdocs/mandarin/core/modules/modmandarin.class.php
 *  \ingroup    mandarin
 *  \brief      Description and activation file for module mandarin
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module mandarin
 */
class modmandarin extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 104996; // 104000 to 104999 for ATM CONSULTING
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'mandarin';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "ATM";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = "Description of module mandarin";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '1.2.0';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='mandarin@mandarin';

		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		// for default path (eg: /mandarin/core/xxxxx) (0=disable, 1=enable)
		// for specific path of parts (eg: /mandarin/core/modules/barcode)
		// for specific css file (eg: /mandarin/css/mandarin.css.php)
		//$this->module_parts = array(
		//                        	'triggers' => 0,                                 	// Set this to 1 if module has its own trigger directory (core/triggers)
		//							'login' => 0,                                    	// Set this to 1 if module has its own login method directory (core/login)
		//							'substitutions' => 0,                            	// Set this to 1 if module has its own substitution function file (core/substitutions)
		//							'menus' => 0,                                    	// Set this to 1 if module has its own menus handler directory (core/menus)
		//							'theme' => 0,                                    	// Set this to 1 if module has its own theme directory (theme)
		//                        	'tpl' => 0,                                      	// Set this to 1 if module overwrite template dir (core/tpl)
		//							'barcode' => 0,                                  	// Set this to 1 if module has its own barcode directory (core/modules/barcode)
		//							'models' => 0,                                   	// Set this to 1 if module has its own models directory (core/modules/xxx)
		//							'css' => array('/mandarin/css/mandarin.css.php'),	// Set this to relative path of css file if module has its own css file
	 	//							'js' => array('/mandarin/js/mandarin.js'),          // Set this to relative path of js file if module must load a js on all pages
		//							'hooks' => array('hookcontext1','hookcontext2')  	// Set here all hooks context managed by module
		//							'dir' => array('output' => 'othermodulename'),      // To force the default directories names
		//							'workflow' => array('WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2'=>array('enabled'=>'! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)', 'picto'=>'yourpicto@mandarin')) // Set here all workflow context managed by module
		//                        );
		$this->module_parts = array(
			'triggers'=>1
			,'hooks'=>array('pricesuppliercard')
		);

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/mandarin/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into mandarin/admin directory, to use to setup module.
		$this->config_page_url = array("mandarin_setup.php@mandarin");

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("mandarin@mandarin");

		// Constants
		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
		// Example: $this->const=array(0=>array('MYMODULE_MYNEWCONST1','chaine','myvalue','This is a constant to add',1),
		//                             1=>array('MYMODULE_MYNEWCONST2','chaine','myvalue','This is another constant to add',0, 'current', 1)
		// );
		$this->const = array();

		// Array to add new pages in new tabs
		// Example: $this->tabs = array('objecttype:+tabname1:Title1:mylangfile@mandarin:$user->rights->mandarin->read:/mandarin/mynewtab1.php?id=__ID__',  	// To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:mylangfile@mandarin:$user->rights->othermodule->read:/mandarin/mynewtab2.php?id=__ID__',  	// To add another new tab identified by code tabname2
        //                              'objecttype:-tabname:NU:conditiontoremove');                                                     						// To remove an existing tab identified by code tabname
		// where objecttype can be
		// 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
		// 'contact'          to add a tab in contact view
		// 'contract'         to add a tab in contract view
		// 'group'            to add a tab in group view
		// 'intervention'     to add a tab in intervention view
		// 'invoice'          to add a tab in customer invoice view
		// 'invoice_supplier' to add a tab in supplier invoice view
		// 'member'           to add a tab in fundation member view
		// 'opensurveypoll'	  to add a tab in opensurvey poll view
		// 'order'            to add a tab in customer order view
		// 'order_supplier'   to add a tab in supplier order view
		// 'payment'		  to add a tab in payment view
		// 'payment_supplier' to add a tab in supplier payment view
		// 'product'          to add a tab in product view
		// 'propal'           to add a tab in propal view
		// 'project'          to add a tab in project view
		// 'stock'            to add a tab in stock view
		// 'thirdparty'       to add a tab in third party view
		// 'user'             to add a tab in user view
        $this->tabs = array(
			'project:+mandarin_rapport:'.$langs->trans('Rapport').':mandarin@mandarin:$user->rights->mandarin->graph->project_task:/mandarin/graph_project_task.php?id=__ID__'
		);

        // Dictionaries
	    if (! isset($conf->mandarin->enabled))
        {
        	$conf->mandarin=new stdClass();
        	$conf->mandarin->enabled=0;
        }
		$this->dictionaries=array();
        /* Example:
        if (! isset($conf->mandarin->enabled)) $conf->mandarin->enabled=0;	// This is to avoid warnings
        $this->dictionaries=array(
            'langs'=>'mylangfile@mandarin',
            'tabname'=>array(MAIN_DB_PREFIX."table1",MAIN_DB_PREFIX."table2",MAIN_DB_PREFIX."table3"),		// List of tables we want to see into dictonnary editor
            'tablib'=>array("Table1","Table2","Table3"),													// Label of tables
            'tabsql'=>array('SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table1 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table2 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table3 as f'),	// Request to select fields
            'tabsqlsort'=>array("label ASC","label ASC","label ASC"),																					// Sort order
            'tabfield'=>array("code,label","code,label","code,label"),																					// List of fields (result of select to show dictionary)
            'tabfieldvalue'=>array("code,label","code,label","code,label"),																				// List of fields (list of fields to edit a record)
            'tabfieldinsert'=>array("code,label","code,label","code,label"),																			// List of fields (list of fields for insert)
            'tabrowid'=>array("rowid","rowid","rowid"),																									// Name of columns with primary key (try to always name it 'rowid')
            'tabcond'=>array($conf->mandarin->enabled,$conf->mandarin->enabled,$conf->mandarin->enabled)												// Condition to show each dictionary
        );
        */

        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes
		// Example:
		//$this->boxes=array(array(0=>array('file'=>'myboxa.php','note'=>'','enabledbydefaulton'=>'Home'),1=>array('file'=>'myboxb.php','note'=>''),2=>array('file'=>'myboxc.php','note'=>'')););

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=0;

		// Add here list of permission defined by an id, a label, a boolean and two constant strings.
		// Example:
		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphCACumule');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'ca_cumule';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphCAHoraire');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'ca_horaire';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphInterim');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'cout_interim';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphTotalHeure');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'total_heure';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphEffectif');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'effectif';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphHoraireMoyen');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'horaire_moyen';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphPropalFacture');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'propal_facture';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphProject');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'project';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphProjectTask');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'project_task';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphProjectExceed');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'project';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permReportActionByUser');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'action_by_user';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphProjectByUser');	// Permission label
		$this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'project_by_user';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

        $this->rights[$r][0] = $this->numero . $r;      // Permission id (must not be already used)
        $this->rights[$r][1] = 'costPriceTraceGraph';
        $this->rights[$r][3] = 0;                                       // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'graph';                         // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'product_cost_price';                               // In php code, permission will be checked by test if ($user->rights->permkey->$
        $r++;

        $this->rights[$r][0] = $this->numero . $r;      // Permission id (must not be already used)
        $this->rights[$r][1] = 'permCAClientMonth';
        $this->rights[$r][3] = 0;                                       // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'graph';                         // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'ca_client_month';                               // In php code, permission will be checked by test if ($user->rights->permkey->$
        $r++;

        $this->rights[$r][0] = $this->numero . $r;      // Permission id (must not be already used)
        $this->rights[$r][1] = 'RapportMoyenneProduitsVendusCommandesEnvoyes';
        $this->rights[$r][3] = 0;                                       // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'graph';                         // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'products_average';                               // In php code, permission will be checked by test if ($user->rights->permkey->$
        $r++;

        $this->rights[$r][0] = $this->numero . $r;      // Permission id (must not be already used)
        $this->rights[$r][1] = 'RapportTempsMoyenReceptionProduits';
        $this->rights[$r][3] = 0;                                       // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'graph';                         // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'products_receipt_average';                               // In php code, permission will be checked by test if ($user->rights->permkey->$
        $r++;

        $this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
        $this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphDiffByCommercial');	// Permission label
        $this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
        $this->rights[$r][4] = 'list';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'diff_by_commercial';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
        $this->rights[$r][1] = $langs->transnoentitiesnoconv('permReportRepartitionBySupplier');	// Permission label
        $this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
        $this->rights[$r][4] = 'list';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'repartition_by_supplier';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
        $this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphPropalCommercial');	// Permission label
        $this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
        $this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'propal_commercial';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero . $r;	// Permission id (must not be already used)
        $this->rights[$r][1] = $langs->transnoentitiesnoconv('permGraphPropalAllCommercial');	// Permission label
        $this->rights[$r][3] = 0; 					// Permission by default for new user (0/1)
        $this->rights[$r][4] = 'graph';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'propal_alldata';	// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;
		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=sig',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphCACumule'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_ca_cumule.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>200,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->ca_cumule',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=sig',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphCAHoraire'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_ca_horaire.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>210,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->ca_horaire',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=sig',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphInterim'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_cout_interim.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>220,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->cout_interim',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=sig',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphTotalHeure'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_total_heure.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>230,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->total_heure',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=sig',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphHoraireMoyen'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_horaire_moyen.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>240,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->horaire_moyen',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=sig',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphEffectif'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_effectif.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>250,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->effectif',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=sig',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphPropalFacture'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_propal_facture.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>260,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->propal_facture',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=project,fk_leftmenu=projects',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphProject'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_project.php?fk_statut=1',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>270,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->project',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=project,fk_leftmenu=projects',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuProjectExceedReport'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_timeSpent_exceed.php?fk_statut=1',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>280,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->project',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=project,fk_leftmenu=projects',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuProjectByUserReportShort'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_project_by_user.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>290,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->project_by_user',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=project,fk_leftmenu=projects',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('RapportCapaciteProduction'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_time_period.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>300,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$conf->global->MANDARIN_GRAPH_TIME_ON_PERIOD',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=agenda',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('Reports'),
			'mainmenu'=>'agenda',
			'leftmenu'=>'ReportAgenda',
			'url'=>'/mandarin/graph_action_by_user.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>100,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->action_by_user',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=agenda,fk_leftmenu=ReportAgenda',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('RapportEvenementsParCommerciaux'),
			'mainmenu'=>'ReportAgenda',
			'leftmenu'=>'ReportActionByUser',
			'url'=>'/mandarin/graph_action_by_user.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>110,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->action_by_user',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=gpao,fk_leftmenu=assetOFlist',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('RapportAnalyseCoutProduct'),
			'mainmenu'=>'RapportAnalyseCoutProduct',
			'leftmenu'=>'assetOFlist',
			'url'=>'/mandarin/graph_cost_price.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>400,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->product_cost_price',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=customers_bills',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('CAClientMonth'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_ca_by_month.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>400,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->ca_client_month',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=commercial,fk_leftmenu=orders',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('CAClientMonth'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_ca_by_month.php?mode=order',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>400,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->ca_client_month',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;


		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=products',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('Reports'),
			'mainmenu'=>'products',
			'leftmenu'=>'ReportProducts',
			'url'=>'/mandarin/graph_sent_products_average.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>100,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->products_average',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=products,fk_leftmenu=ReportProducts',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('AverageProducts'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_sent_products_average.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>400,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->products_average',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=products,fk_leftmenu=ReportProducts',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('AverageReceipProducts'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/graph_product_receipt_time_average.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>400,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->graph->products_receipt_average',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=commercial,fk_leftmenu=orders',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphByCommercial'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/list_diff_by_commercial.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>400,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->list->diff_by_commercial',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=commercial,fk_leftmenu=propals',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuGraphByCommercial'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/list_diff_by_commercial.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>401,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->list->diff_by_commercial',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=commercial,fk_leftmenu=propals',			                // Put 0 if this is a top menu
		    'type'=>'left',			                // This is a Top menu entry
		    'titre'=>$langs->transnoentitiesnoconv('linkMenuPropalesByCommercial'),
		    'mainmenu'=>'',
		    'leftmenu'=>'',
		    'url'=>'/mandarin/graph_propales_by_commercial.php',
		    'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		    'position'=>401,
		    'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
		    'perms'=>'$user->rights->mandarin->graph->propal_commercial',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
		    'target'=>'',
		    'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=commercial,fk_leftmenu=propals',			                // Put 0 if this is a top menu
		    'type'=>'left',			                // This is a Top menu entry
		    'titre'=>$langs->transnoentitiesnoconv('linkMenuCAPropalesByCommercial'),
		    'mainmenu'=>'',
		    'leftmenu'=>'',
		    'url'=>'/mandarin/graph_propales_by_commercial.php?ca=true',
		    'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		    'position'=>401,
		    'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
		    'perms'=>'$user->rights->mandarin->graph->propal_commercial',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
		    'target'=>'',
		    'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=accountancy,fk_leftmenu=suppliers_bills',			                // Put 0 if this is a top menu
			'type'=>'left',			                // This is a Top menu entry
			'titre'=>$langs->transnoentitiesnoconv('linkMenuRepartitionAchatsBySupplier'),
			'mainmenu'=>'',
			'leftmenu'=>'',
			'url'=>'/mandarin/report_repartition_achats_fournisseurs.php',
			'langs'=>'mandarin@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
			'position'=>100,
			'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
			'perms'=>'$user->rights->mandarin->list->repartition_by_supplier',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
			'target'=>'',
			'user'=>2				                // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

        $this->menu[$r]=array(
            'fk_menu'=>'fk_mainmenu=tools',
            'type'=>'left',
            'titre'=>$langs->transnoentitiesnoconv('Reports'),
            'mainmenu'=>'tools',
            'leftmenu'=>'rapports',
            'url'=>'/core/tools.php',
            'position'=>100,
            'perms'=>'$user->rights->facture->lire',
            'target'=>'',
            'user'=>2
        );
        $r++;

        $this->menu[$r]=array(
            'fk_menu'=>'fk_mainmenu=tools,fk_leftmenu=rapports',
            'type'=>'left',
            'titre'=>$langs->transnoentitiesnoconv('linkMenuReportVentesArticles'),
            'mainmenu'=>'tools',
            'leftmenu'=>'rapports_vente_prod',
            'url'=>'/mandarin/evo_ventes_articles.php',
            'position'=>100,
            'perms'=>'$user->rights->facture->lire',
            'target'=>'',
            'user'=>2
        );
        $r++;

        $this->menu[$r]=array(
            'fk_menu'=>'fk_mainmenu=tools,fk_leftmenu=rapports',
            'type'=>'left',
            'titre'=>$langs->transnoentitiesnoconv('linkMenuReportCAArticles'),
            'mainmenu'=>'tools',
            'leftmenu'=>'rapports_ca_prod',
            'url'=>'/mandarin/evo_ventes_articles.php?mode=CA',
            'position'=>100,
            'perms'=>'$user->rights->facture->lire',
            'target'=>'',
            'user'=>2
        );
        $r++;

		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=tools,fk_leftmenu=rapports',
			'type'=>'left',
			'titre'=>$langs->transnoentitiesnoconv('linkMenuReportAchatsArticles'),
			'mainmenu'=>'tools',
			'leftmenu'=>'rapports_achats_prod',
			'url'=>'/mandarin/evo_achats_articles.php',
			'position'=>100,
			'perms'=>'$user->rights->facture->lire',
			'target'=>'',
			'user'=>2
		);
		$r++;


		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=tools,fk_leftmenu=rapports',
			'type'=>'left',
			'titre'=>$langs->transnoentitiesnoconv('linkMenuReportAchatsCAArticles'),
			'mainmenu'=>'tools',
			'leftmenu'=>'rapports_achats_ca_prod',
			'url'=>'/mandarin/evo_achats_articles.php?mode=CA',
			'position'=>100,
			'perms'=>'$user->rights->facture->lire',
			'target'=>'',
			'user'=>2
		);
		$r++;

		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=tools,fk_leftmenu=rapports',
			'type'=>'left',
			'titre'=>$langs->transnoentitiesnoconv('linkMenuReportAchatsFournisseurs'),
			'mainmenu'=>'tools',
			'leftmenu'=>'rapports_achats_fourn',
			'url'=>'/mandarin/evo_achats_fournisseurs.php',
			'position'=>100,
			'perms'=>'$user->rights->facture->lire',
			'target'=>'',
			'user'=>2
		);
		$r++;


		$this->menu[$r]=array(
			'fk_menu'=>'fk_mainmenu=tools,fk_leftmenu=rapports',
			'type'=>'left',
			'titre'=>$langs->transnoentitiesnoconv('linkMenuReportAchatsCAFournisseurs'),
			'mainmenu'=>'tools',
			'leftmenu'=>'rapports_achats_ca_fourn',
			'url'=>'/mandarin/evo_achats_fournisseurs.php?mode=CA',
			'position'=>100,
			'perms'=>'$user->rights->facture->lire',
			'target'=>'',
			'user'=>2
		);
		$r++;

		// Add here entries to declare new menus
		//
		// Example to declare a new Top Menu entry and its Left menu entry:
		// $this->menu[$r]=array(	'fk_menu'=>0,			                // Put 0 if this is a top menu
		//							'type'=>'top',			                // This is a Top menu entry
		//							'titre'=>'mandarin top menu',
		//							'mainmenu'=>'mandarin',
		//							'leftmenu'=>'mandarin',
		//							'url'=>'/mandarin/pagetop.php',
		//							'langs'=>'mylangfile@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		//							'position'=>100,
		//							'enabled'=>'$conf->mandarin->enabled',	// Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled.
		//							'perms'=>'1',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
		//							'target'=>'',
		//							'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		// $r++;
		//
		// Example to declare a Left Menu entry into an existing Top menu entry:
		// $this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=xxx',		    // Use 'fk_mainmenu=xxx' or 'fk_mainmenu=xxx,fk_leftmenu=yyy' where xxx is mainmenucode and yyy is a leftmenucode
		//							'type'=>'left',			                // This is a Left menu entry
		//							'titre'=>'mandarin left menu',
		//							'mainmenu'=>'xxx',
		//							'leftmenu'=>'mandarin',
		//							'url'=>'/mandarin/pagelevel2.php',
		//							'langs'=>'mylangfile@mandarin',	        // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
		//							'position'=>100,
		//							'enabled'=>'$conf->mandarin->enabled',  // Define condition to show or hide menu entry. Use '$conf->mandarin->enabled' if entry must be visible if module is enabled. Use '$leftmenu==\'system\'' to show if leftmenu system is selected.
		//							'perms'=>'1',			                // Use 'perms'=>'$user->rights->mandarin->level1->level2' if you want your menu with a permission rules
		//							'target'=>'',
		//							'user'=>2);				                // 0=Menu for internal users, 1=external users, 2=both
		// $r++;


		// Exports
		$r=1;

		// Example:
		// $this->export_code[$r]=$this->rights_class.'_'.$r;
		// $this->export_label[$r]='CustomersInvoicesAndInvoiceLines';	// Translation key (used only if key ExportDataset_xxx_z not found)
        // $this->export_enabled[$r]='1';                               // Condition to show export in list (ie: '$user->id==3'). Set to 1 to always show when module is enabled.
		// $this->export_permission[$r]=array(array("facture","facture","export"));
		// $this->export_fields_array[$r]=array('s.rowid'=>"IdCompany",'s.nom'=>'CompanyName','s.address'=>'Address','s.zip'=>'Zip','s.town'=>'Town','s.fk_pays'=>'Country','s.phone'=>'Phone','s.siren'=>'ProfId1','s.siret'=>'ProfId2','s.ape'=>'ProfId3','s.idprof4'=>'ProfId4','s.code_compta'=>'CustomerAccountancyCode','s.code_compta_fournisseur'=>'SupplierAccountancyCode','f.rowid'=>"InvoiceId",'f.facnumber'=>"InvoiceRef",'f.datec'=>"InvoiceDateCreation",'f.datef'=>"DateInvoice",'f.total'=>"TotalHT",'f.total_ttc'=>"TotalTTC",'f.tva'=>"TotalVAT",'f.paye'=>"InvoicePaid",'f.fk_statut'=>'InvoiceStatus','f.note'=>"InvoiceNote",'fd.rowid'=>'LineId','fd.description'=>"LineDescription",'fd.price'=>"LineUnitPrice",'fd.tva_tx'=>"LineVATRate",'fd.qty'=>"LineQty",'fd.total_ht'=>"LineTotalHT",'fd.total_tva'=>"LineTotalTVA",'fd.total_ttc'=>"LineTotalTTC",'fd.date_start'=>"DateStart",'fd.date_end'=>"DateEnd",'fd.fk_product'=>'ProductId','p.ref'=>'ProductRef');
		// $this->export_entities_array[$r]=array('s.rowid'=>"company",'s.nom'=>'company','s.address'=>'company','s.zip'=>'company','s.town'=>'company','s.fk_pays'=>'company','s.phone'=>'company','s.siren'=>'company','s.siret'=>'company','s.ape'=>'company','s.idprof4'=>'company','s.code_compta'=>'company','s.code_compta_fournisseur'=>'company','f.rowid'=>"invoice",'f.facnumber'=>"invoice",'f.datec'=>"invoice",'f.datef'=>"invoice",'f.total'=>"invoice",'f.total_ttc'=>"invoice",'f.tva'=>"invoice",'f.paye'=>"invoice",'f.fk_statut'=>'invoice','f.note'=>"invoice",'fd.rowid'=>'invoice_line','fd.description'=>"invoice_line",'fd.price'=>"invoice_line",'fd.total_ht'=>"invoice_line",'fd.total_tva'=>"invoice_line",'fd.total_ttc'=>"invoice_line",'fd.tva_tx'=>"invoice_line",'fd.qty'=>"invoice_line",'fd.date_start'=>"invoice_line",'fd.date_end'=>"invoice_line",'fd.fk_product'=>'product','p.ref'=>'product');
		// $this->export_sql_start[$r]='SELECT DISTINCT ';
		// $this->export_sql_end[$r]  =' FROM ('.MAIN_DB_PREFIX.'facture as f, '.MAIN_DB_PREFIX.'facturedet as fd, '.MAIN_DB_PREFIX.'societe as s)';
		// $this->export_sql_end[$r] .=' LEFT JOIN '.MAIN_DB_PREFIX.'product as p on (fd.fk_product = p.rowid)';
		// $this->export_sql_end[$r] .=' WHERE f.fk_soc = s.rowid AND f.rowid = fd.fk_facture';
		// $this->export_sql_order[$r] .=' ORDER BY s.nom';
		// $r++;

		 $this->export_code[$r]=$this->rights_class.'_'.$r;
		 $this->export_label[$r]='CustomerOrderAndBills';	// Translation key (used only if key ExportDataset_xxx_z not found)
         $this->export_enabled[$r]='1';                               // Condition to show export in list (ie: '$user->id==3'). Set to 1 to always show when module is enabled.
		 $this->export_permission[$r]=array(array("facture","facture","export"));
		 $this->export_fields_array[$r]=array('s.rowid'=>"IdCompany",'s.nom'=>'CompanyName','s.address'=>'Address','s.zip'=>'Zip','s.town'=>'Town','f.rowid'=>"InvoiceId",'f.facnumber'=>"InvoiceRef",'f.datec'=>"InvoiceDateCreation",'f.datef'=>"DateInvoice",'f.total'=>"TotalHT",'f.total_ttc'=>"TotalTTC",'f.tva'=>"TotalVAT",'f.paye'=>"InvoicePaid",'f.fk_statut'=>'InvoiceStatus','c.rowid'=>"OrderId",'c.ref'=>"OrderRef",'c.date_creation'=>"OrderDateCreation",'c.date_commande'=>"DateOrder",'c.total_ht'=>"TotalHT",'c.total_ttc'=>"TotalTTC",'c.tva'=>"TotalVAT",'c.fk_statut'=>"OrderStatus");
         $this->export_fields_array[$r]+=array('u.login'=>'SaleRepresentativeLogin','u.firstname'=>'SaleRepresentativeFirstname', 'u.lastname'=>'SaleRepresentativeLastname');
		 $this->export_entities_array[$r]=array('s.rowid'=>"company",'s.nom'=>'company','s.address'=>'company','s.zip'=>'company','s.town'=>'company','f.rowid'=>"invoice",'f.facnumber'=>"invoice",'f.datec'=>"invoice",'f.datef'=>"invoice",'f.total'=>"invoice",'f.total_ttc'=>"invoice",'f.tva'=>"invoice",'f.paye'=>"invoice",'f.fk_statut'=>'invoice','c.rowid'=>"order",'c.ref'=>"order",'c.date_creation'=>"order",'c.date_commande'=>"order",'c.total_ht'=>"order",'c.total_ttc'=>"order",'c.tva'=>"order",'c.fk_statut'=>"order",'u.login'=>'user','u.firstname'=>'user','u.lastname'=>'user');
		 $this->export_TypeFields_array[$r]=array('s.rowid'=>"Numeric", 's.nom'=>"Text",'s.address'=>'Text','s.zip'=>'Text','s.town'=>'Text','f.rowid'=>"Numeric",'f.facnumber'=>"Text",'f.datec'=>"Date",'f.datef'=>"Date",'f.total'=>"Numeric",'f.total_ttc'=>"Numeric",'f.tva'=>"Numeric",'f.paye'=>"Boolean",'f.fk_statut'=>'Numeric','c.rowid'=>"Numeric",'c.ref'=>"Text",'c.date_creation'=>"Date",'c.date_commande'=>"Date",'c.total_ht'=>"Numeric",'c.total_ttc'=>"Numeric",'c.tva'=>"Numeric",'c.fk_statut'=>"Numeric",'u.login'=>'Text','u.firstname'=>'Text','u.lastname'=>'Text');

		 $this->export_sql_start[$r]='SELECT DISTINCT ';

		 $this->export_sql_end[$r]  =' FROM '.MAIN_DB_PREFIX.'commande as c';
		 $this->export_sql_end[$r] .=' LEFT JOIN '.MAIN_DB_PREFIX.'element_element as ee on (ee.fk_source=c.rowid AND ee.sourcetype="commande")';
		 $this->export_sql_end[$r] .=' LEFT JOIN '.MAIN_DB_PREFIX.'facture as f on (f.rowid=ee.fk_target AND  ee.targettype="facture")';
		 $this->export_sql_end[$r] .=' LEFT JOIN '.MAIN_DB_PREFIX.'societe as s on (c.fk_soc = s.rowid)';
		 $this->export_sql_end[$r] .=' LEFT JOIN '.MAIN_DB_PREFIX.'societe_commerciaux as sc ON sc.fk_soc = s.rowid LEFT JOIN '.MAIN_DB_PREFIX.'user as u ON sc.fk_user = u.rowid';

		 $this->export_sql_end[$r] .=' WHERE 1';
		 $this->export_sql_order[$r] .=' ORDER BY s.nom';
		 $r++;

	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		$sql = array();

		define('INC_FROM_DOLIBARR',true);

		dol_include_once('/mandarin/config.php');
		dol_include_once('/mandarin/script/create-maj-base.php');

		$result=$this->_load_tables('/mandarin/sql/');

		dol_include_once('/core/class/extrafields.class.php');
        $extrafields=new ExtraFields($this->db);
		$res = $extrafields->addExtraField('contrat', 'Contrat', 'varchar', 0, 150, 'user');

		$extrafields=new ExtraFields($this->db);
		$res = $extrafields->addExtraField('thm', 'THM', 'double', 0, '', 'user');

		$extrafields=new ExtraFields($this->db);
		$res = $extrafields->addExtraField('horaire', 'Horaire contractuel', 'varchar', 0, 150, 'user');

		$extrafields=new ExtraFields($this->db);
		$res = $extrafields->addExtraField('dds', 'Date de sortie', 'date', 0, 10, 'user');

		return $this->_init($sql, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();

		return $this->_remove($sql, $options);
	}

}
