<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

// dol_include_once('/demande_maintenance/class/demande_maintenance.class.php');
 
class equipement_maintenance extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $nom;
	public $categorie;
	public $type_utilisateur;
	public $employe;
	public $departement;
	public $equipe;
	public $technicien;
	public $lieu;
	public $fournisseur;
	public $ref_fournisseur;
	public $modele;
	public $num_serie;
	public $date_effective;
	public $cout;
	public $date_expire;
	public $freq_prochain_maintenance;
	public $dure_maintenance;
	public $description;

	public $element='equipement_maintenance';
	public $table_element='equipement_maintenance';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function create($echo_sql=0,$insert)
	{

		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ""){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
    	// print_r($sql);die();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			print_r($this->errors);die();

			return 0;
		} 
		// return $this->db->db->insert_id;
		return $this->db->last_insert_id(MAIN_DB_PREFIX.'equipement_maintenance');
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $val = ($val == '') ? 'NULL' : $val;
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			print_r($this->errors);die();
			
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    					  = $obj->rowid;
				$line->rowid 					  = $obj->rowid;
				$line->nom 						  = $obj->nom;
				$line->categorie 	    		  = $obj->categorie;
				$line->type_utilisateur 		  = $obj->type_utilisateur;
				$line->employe 					  = $obj->employe;
				$line->departement 				  = $obj->departement;
				$line->equipe 					  = $obj->equipe;
				$line->technicien 				  = $obj->technicien;
				$line->lieu 					  = $obj->lieu;
				$line->date_effective 			  = $obj->date_effective;
				$line->fournisseur 				  = $obj->fournisseur;
				$line->ref_fournisseur 			  = $obj->ref_fournisseur;
				$line->cout 					  = $obj->cout;
				$line->modele 					  = $obj->modele;
				$line->num_serie 				  = $obj->num_serie;
				$line->date_expire 				  = $obj->date_expire;
				$line->freq_prochain_maintenance  = $obj->freq_prochain_maintenance;
				$line->dure_maintenance 		  =  $obj->dure_maintenance;
				$line->description 				  =  $obj->description;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
                $this->id         			     = $obj->rowid;
                $this->rowid      			     = $obj->rowid;
                $this->nom       			     = $obj->nom;
				$this->categorie 	  		     = $obj->categorie;
				$this->type_utilisateur 	     = $obj->type_utilisateur;
				$this->employe 	  			     = $obj->employe;
				$this->departement 	  		     = $obj->departement;
				$this->equipe 	  			     = $obj->equipe;
				$this->technicien 	  		     = $obj->technicien;
				$this->lieu 	  			     = $obj->lieu;
				$this->date_effective  		     = $obj->date_effective;
				$this->fournisseur 			     = $obj->fournisseur;
				$this->ref_fournisseur 		     = $obj->ref_fournisseur;
				$this->cout 				     = $obj->cout;
				$this->modele 				     = $obj->modele;
				$this->num_serie 			     = $obj->num_serie;
				$this->date_expire 			     = $obj->date_expire;
				$this->freq_prochain_maintenance =  $obj->freq_prochain_maintenance;
				$this->dure_maintenance  		 = $obj->dure_maintenance;
				$this->description               = $obj->description;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="nom",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 75% !important;}</style>';
	    
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
        if(!empty($this->nom)){
        	$ref=$this->nom;
        }else
        	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/demande_maintenance/img/object_demande_maintenance.png" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }








    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }


    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }


	public function select_user($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}


	public function select_fournisseur($selected=0,$name='fournisseur')
	{
	    $id = (!empty($id)) ? $id : $name;

	    $select = '';
		$select.='<select class="flat" id="'.$id.'" name="'.$name.'" >';
	    $select.='<option value="0">&nbsp;</option>';
		global $conf;
    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."societe WHERE fournisseur = 1";
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);
    	$select.='<option value="0"></option>'; 
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$select.='<option value="'.$obj->rowid.'"';
	            if ($obj->rowid == $selected) $select.='selected';
	            $select.='>'.$obj->nom.'</option>';
			}
			$this->db->free($resql);
		}

		$select.='</select>';
		$select.='<script>$(function(){$("#'.$id.'").select2()})</script>';
	    return $select;
	}


	public function format_year($date){
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        
        return $date[0];
    }

    public function maxdate_maintenance($id)
    {
    	$sql='SELECT MAX(date_requete) as max FROM `'.MAIN_DB_PREFIX.'demande_maintenance` WHERE equipement = '.$id;
    	$resql = $this->db->query($sql);
    	$select.='<option value="0"></option>'; 
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$date=$obj->max;
			}
			return $date;
		}

    }
    public function select_departement($selected=0,$name='departement')
    {
    	global $langs;
	    $id = (!empty($id)) ? $id : $name;

    	$select = '';
		$select.='<select class="flat" id="select_'.$id.'" name="'.$name.'" >';
	    $select.='<option value="0">&nbsp;</option>';
		global $conf;
    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."c_hrm_department";
		// echo $sql."<br>";
    	$resql = $this->db->query($sql);
    	$select.='<option value="0"></option>'; 
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$select.='<option value="'.$obj->rowid.'"';
	            if ($obj->rowid == $selected) $select.='selected';
	            $select.='>'.$obj->label.'</option>';
			}
			$this->db->free($resql);
		}

	    // $select.='<option value="autre">'.$langs->trans('autre').'</option>';
		$select.='</select>';
		$select.='<script>$(function(){$("#select_'.$id.'").select2()})</script>';
	    return $select;
    }

    public function get_departement($id)
    {
    	if($id){
    		$label ='';
	    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."c_hrm_department WHERE rowid=".$id;
	    	$resql = $this->db->query($sql);
			if ($resql) {
				$num = $this->db->num_rows($resql);
				while ($obj = $this->db->fetch_object($resql)) {
		            $label = $obj->label;
				}
				$this->db->free($resql);
			}
    	}
    	return $label;
    }
} 


?>