(function(angular) {
    'use strict';
    angular.module('FileManagerApp').provider('fileManagerConfig', function() {

        var values = {
            appName: 'angular-filemanager v1.5',
            defaultLang: 'en',

            listUrl: 'js/angular-fm/bridges/php-local/index.php',
            uploadUrl: 'js/angular-fm/bridges/php-local/index.php',
            renameUrl: 'js/angular-fm/bridges/php-local/index.php',
            copyUrl: 'js/angular-fm/bridges/php-local/index.php',
            moveUrl: 'js/angular-fm/bridges/php-local/index.php',
            removeUrl: 'js/angular-fm/bridges/php-local/index.php',
            editUrl: 'js/angular-fm/bridges/php-local/index.php',
            getContentUrl: 'js/angular-fm/bridges/php-local/index.php',
            createFolderUrl: 'js/angular-fm/bridges/php-local/index.php',
            downloadFileUrl: 'js/angular-fm/bridges/php-local/index.php',
            downloadMultipleUrl: 'js/angular-fm/bridges/php-local/index.php',
            compressUrl: 'js/angular-fm/bridges/php-local/index.php',
            extractUrl: 'js/angular-fm/bridges/php-local/index.php',
            permissionsUrl: 'js/angular-fm/bridges/php-local/index.php',
            basePath: '',

            searchForm: true,
            sidebar: true,
            breadcrumb: true,
            allowedActions: {
                upload: true,
                rename: true,
                move: true,
                copy: true,
                edit: true,
                changePermissions: true,
                compress: true,
                compressChooseName: true,
                extract: true,
                download: true,
                downloadMultiple: true,
                preview: true,
                remove: true,
                createFolder: true,
                pickFiles: false,
                pickFolders: false
            },

            multipleDownloadFileName: 'angular-filemanager.zip',
            filterFileExtensions: [],
            showExtensionIcons: true,
            showSizeForDirectories: false,
            useBinarySizePrefixes: false,
            downloadFilesByAjax: true,
            previewImagesInModal: true,
            enablePermissionsRecursive: true,
            compressAsync: false,
            extractAsync: false,
            pickCallback: null,

            isEditableFilePattern: /\.(txt|diff?|patch|svg|asc|cnf|cfg|conf|html?|.html|cfm|cgi|aspx?|ini|pl|py|md|css|cs|js|jsp|log|htaccess|htpasswd|gitignore|gitattributes|env|json|atom|eml|rss|markdown|sql|xml|xslt?|sh|rb|as|bat|cmd|cob|for|ftn|frm|frx|inc|lisp|scm|coffee|php[3-6]?|java|c|cbl|go|h|scala|vb|tmpl|lock|go|yml|yaml|tsv|lst)$/i,
            isImageFilePattern: /\.(jpe?g|gif|bmp|png|svg|tiff?)$/i,
            isExtractableFilePattern: /\.(gz|tar|rar|bz2|g?zip)$/i,
            tplPath: 'js/angular-fm/src/templates'
        };

        return {
            $get: function() {
                return values;
            },
            set: function (constants) {
                angular.extend(values, constants);
            }
        };

    });
})(angular);
