<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2017  Libre Expert
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    instmod.php
 * \ingroup lemodule
 * \brief   Module PHP page.
 *
 * Put detailed description here.
 */

//if (! defined('NOREQUIREUSER'))	define('NOREQUIREUSER','1');
//if (! defined('NOREQUIREDB'))		define('NOREQUIREDB','1');
//if (! defined('NOREQUIRESOC'))	define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))	define('NOREQUIRETRAN','1');
// Do not check anti CSRF attack test
//if (! defined('NOCSRFCHECK'))		define('NOCSRFCHECK','1');
// Do not check style html tag into posted data
//if (! defined('NOSTYLECHECK'))   define('NOSTYLECHECK','1');
// Do not check anti POST attack test
//if (! defined('NOTOKENRENEWAL'))	define('NOTOKENRENEWAL','1');
// If there is no need to load and show top and left menu
//if (! defined('NOREQUIREMENU'))	define('NOREQUIREMENU','1');
// If we don't need to load the html.form.class.php
//if (! defined('NOREQUIREHTML'))	define('NOREQUIREHTML','1');
//if (! defined('NOREQUIREAJAX'))	define('NOREQUIREAJAX','1');
// If this page is public (can be called outside logged session)
//if (! defined("NOLOGIN"))			define("NOLOGIN",'1');
// Change the following lines to use the correct relative path
// (../, ../../, etc)

// Load Dolibarr environment
if (false === (@include '../main.inc.php')) {  // From htdocs directory
	require '../../main.inc.php'; // From "custom" directory
}



global $db, $langs, $user;


dol_include_once('/lemodule/class/leclass.class.php');
dol_include_once('/lemodule/functions.php');

session_start();
// Don't want a slash at the end of the path
$dol_doc_root = DOL_DOCUMENT_ROOT;

if (substr(DOL_DOCUMENT_ROOT, -1) == '/') {
    $dol_doc_root = substr(DOL_DOCUMENT_ROOT, 0, -1);
}
// Dolibarr's different module's extraction locations
$_SESSION["xfolder"] = array('0' => str_replace("htdocs", "", $dol_doc_root), '1' => $dol_doc_root . '/', '2' => $dol_doc_root . '/custom/');


// Load translation files required by the page
$langs->load("lemodule@lemodule");


// Access control
if ($user->socid > 0) {
	// External user
	accessforbidden();
}


$title=$langs->trans('InstModPageName');
llxHeader('', $title, '');
print load_fiche_titre($title,'','lemodule.png@lemodule');

print $langs->trans("InstModPageDescription").'<br><br>';


$tmp_folder = 'tmp/';
$installation_folder = GETPOST('wheretocopy');

// If the submit button for starting simulation has been pressed
if(isset($_POST["submit"])) {
    $data = uploadAndCheckZipFile($tmp_folder, $installation_folder, $langs);
    
    // If no error on loading zip file
    if ($data[0] > 0) {
        print "<p><input class=\"button\" name=\"button\" value=\"". $langs->trans("Cancel") . 
          "\" onclick=\"window.location.href='" . $_SERVER["PHP_SELF"]. "?cancel=true&filename=" . $data[2] . "';\"> ";
        print "<input class=\"button\" name=\"button\" value=\"". $langs->trans("ConfirmCopy") . 
          "\" onclick=\"window.location.href='" . $_SERVER["PHP_SELF"]. "?confirmcopy=true&filename=" . $data[2] . 
          "&copy=" . $data[3] . "';\"></p>";
    } else {
        unlink ($tmp_folder . $data[2]);
        print "<p><input class=\"button\" style=\"width:50%\" name=\"button\" value=\"". $langs->trans("YourFileIsntACorrectZipFilePleaseRetry") . 
          "\" onclick=\"window.location.href='" . $_SERVER["PHP_SELF"]. "';\"></p>";
    }
    
// Either the initial screen with upload button and location, or the Cancel and Confirm actions    
} else {
    
    $cancel = GETPOST('cancel', 'alpha');
    $confirmcopy = GETPOST('confirmcopy', 'alpha');
    $filename = GETPOST('filename', 'alpha');
    $copy = GETPOST('copy', 'alpha');
    
    // The user has cancelled the importation, delete file
    if ($cancel == 'true') unlink ($tmp_folder . $filename);
    
    // The user has chosen to confirm the importation, the extraction can begin
    if ($confirmcopy == 'true') {
        // print "Where to copy : ";
        // print $_SESSION["xfolder"][$copy];
        if (unzip($filename, $tmp_folder, $_SESSION["xfolder"][$copy]) > 0) {
            print $langs->trans("ZipFileExtrationSucceeded") . ". ";
            print $langs->trans("YouCanNowActivateNewModule")  . "."; // . " : <a href='/admin/modules.php?mainmenu=home'>" . $langs->trans("ModulesConfiguration") . "</a>";
            unlink ($tmp_folder . $filename);
        } else {
            print $langs->trans("ZipFileExtrationFailed");
            unlink ($tmp_folder . $filename);
        }
        
    // The initial screen to choose file and location
    } else {
    
        print '<form action="' . $_SERVER["PHP_SELF"] . '" method="post" enctype="multipart/form-data">';
        print $langs->trans("SelectFileToUpload") . ' :<br>';
        print '<input type="file" name="fileToUpload" id="fileToUpload" class="flat">';
        print '<br><br>';
        print $langs->trans("SelectExtractionFolderLevel") . ' ';
        print '<select name="wheretocopy" class="flat">';
        print '<option value="0">/</option>';
        print '<option value="1">/htdocs</option>';
        print '<option value="2">/htdocs/custom</option>';  
        print '</select> ';
        print '<input type="submit" value="' . $langs->trans("BeginTheExtractionSimulation") . '" name="submit" class="button">';
        print '</form>'; 

    }
}
// End of page
llxFooter();
