<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2017  Libre Expert
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    functions.php
 * \ingroup lemodule
 * \brief   PHP module specific functions.
 *
 * Put detailed description here.
 */


// Unzip file to specific location
function unzip($zip_file, $src_dir, $extract_dir)
{
    $zip = new ZipArchive;
    $path = $src_dir . '/' . $zip_file;
    if (file_exists($path)) {
        if ($zip->open($path) === TRUE) {
            $zip->extractTo($extract_dir);
            $zip->close();
            return 1;
        } else {
            //print $src_dir . '/' . $zip_file;
            //echo 'échec';
            return -1;            
        }
    } else {
        print "No zip file on path : $path";
        return -1;
    }
}

// Load data from generated md5sum file
function md5FileLoad($file)
{
    $handle = fopen($file, "r");
    if ($handle) {
        $i=0;
        while (($line = fgets($handle)) !== false) {
            $result[$i] = explode('*',$line); 
            $i++;
        }

        fclose($handle);
        //print_r($result[0]);
        return $result;
    } else {
        return -1;
    }
}

// Upload and check ZIP file
function uploadAndCheckZipFile($tmp_folder, $installation_folder, $langs) {
    if (!file_exists($tmp_folder)) mkdir($tmp_folder);
    $target_dir = $tmp_folder;
    $target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);
    $uploadOk = 1;
    $fileType = pathinfo($target_file,PATHINFO_EXTENSION);
 
    // Check if file already exists
    //if (file_exists($target_file)) {
    //    echo "File already exists, overwriting";
    //}
    // Check file size 
    print $langs->trans("FileSizeIs") . " : " . $_FILES["fileToUpload"]["size"] . " " . $langs->trans("Bytes") . "<br>";

    // Allow certain file formats
    //if($fileType != "zip") {
    //    print $langs->trans("SorryZipOnly");
    //    $uploadOk = 0;
    //}
    // Check if $uploadOk is set to 0 by an error
    if ($uploadOk == 0) {
        return array(-1,$langs->trans("SorryFileNotUploaded"),$_FILES["fileToUpload"]["name"],$installation_folder);
    // if everything is ok, try to upload file
    } else {
        if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $target_file)) {
            $zip = new ZipArchive();
            $res = $zip->open($target_file, ZipArchive::CHECKCONS);
            if ($res !== TRUE) {
                switch($res) {
                    case ZipArchive::ER_NOZIP:
                    //    print('not a zip archive');
                    case ZipArchive::ER_INCONS :
                    //    print('consistency check failed');
                    case ZipArchive::ER_CRC :
                    //    print('checksum failed');
                    default:
                    //    print('error ' . $res);
                }
                    return array(-1,$langs->trans("SorryZipOnly"),$_FILES["fileToUpload"]["name"],$installation_folder);
            } else {
                print $langs->trans("OkThisIsAZipFile");
            }
            print "<br><br>" . $langs->trans("TheFile") . " " . basename( $_FILES["fileToUpload"]["name"]) . " " . $langs->trans("HasBeenUploaded") 
                  . ". " . $langs->trans("ThisIsHowTheExtractionWouldLookLike") . "<br><br>";
            //print "xfolder: "; 
            //print_r($_SESSION["xfolder"]);
            print '<textarea rows="20" cols="100" readonly="readonly">';
            
            for($i = 0; $i < $zip->numFiles; $i++)
            {  
                 echo $_SESSION["xfolder"][$installation_folder] . $zip->getNameIndex($i) . '&#13;&#10;';
            } 
            print '</textarea>';
            return array(1,$langs->trans("NoProblem"),$_FILES["fileToUpload"]["name"],$installation_folder);
        } else {
            return array(-1,$langs->trans("SorryFileNotUploaded"),$_FILES["fileToUpload"]["name"],$installation_folder);
        }
    }
}

// This class takes directories to ignore. Used by function buildChecklistFile
class IgnoreDirectoriesIterator extends RecursiveFilterIterator
{
    private static $ignore = array();

    public function accept()
    {
        $bResult = true;
        $item = $this->current();
        if ($item instanceof SplFileInfo)
        {
            if (in_array($item->getRealPath(), self::$ignore))
            {
                $bResult = false;
            }
        }
        return $bResult;
    }

    public static function addIgnoreDirectory($item)
    {
        if (!in_array($item, self::$ignore))
        {
            self::$ignore[] = realpath($item);
        }
    }

    public static function removeIgnoreDirectory($item)
    {
        $item = realpath($item);
        if (false !== ($k = array_search($item, self::$ignore)))
        {
            unset(self::$ignore[$k]);
        }
    }
}  

// Create Zip archive containing md5sum information about all files recursively from path
function buildChecklistFile($path, $ignorepath, $wheretocopy, $resultfile) {
    $directoryIterator = new RecursiveDirectoryIterator($path);
    IgnoreDirectoriesIterator::addIgnoreDirectory($ignorepath);
    // Set up the filter iterator
    $filterIterator = new IgnoreDirectoriesIterator($directoryIterator);
    // Set up a recursive iterator iterator
    $iterator = new RecursiveIteratorIterator($filterIterator, RecursiveIteratorIterator::SELF_FIRST);
    
    chdir($wheretocopy);
    if (file_exists($wheretocopy . $resultfile))
    {
        unlink($wheretocopy . $resultfile);
    }
    // Now simply iterate it
    foreach ($iterator AS $item)
    {
        // For security reasons the '..' file musn't be checked otherwise the script crashes
        if ( ! strpos($item,'..')) {
            if ($item->isFile())
            {
                    // Only files can be md5 file'd, so only do so if its a file.
                file_put_contents($resultfile . '.chk', md5_file($item) . 
                                  '*' . substr($item, strlen(DOL_DOCUMENT_ROOT)) . PHP_EOL, FILE_APPEND);

            }
        }
    }
    
    $zip = new ZipArchive(); 
    if($zip->open($resultfile, ZipArchive::CREATE) === true)
    {
      $zip->addFile($resultfile . '.chk');
      $zip->close();
    }
    unlink($resultfile . '.chk');
}

function cleanLastSlashFromPath($path) {
        // No need of a "/" at the end of the path name
    $tmpstring = $path;
    $pos = strrpos($tmpstring, '/');
    
    if (strlen($tmpstring) > 1 && $pos == (strlen($tmpstring) - 1)) {
        $tmpstring = substr($tmpstring, 0, -1);
    }
    return $tmpstring;
}