<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2017  Libre Expert
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    filemanager.php
 * \ingroup lemodule
 * \brief   Module PHP page.
 *
 * Put detailed description here.
 */

//if (! defined('NOREQUIREUSER'))	define('NOREQUIREUSER','1');
//if (! defined('NOREQUIREDB'))		define('NOREQUIREDB','1');
//if (! defined('NOREQUIRESOC'))	define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))	define('NOREQUIRETRAN','1');
// Do not check anti CSRF attack test
//if (! defined('NOCSRFCHECK'))		define('NOCSRFCHECK','1');
// Do not check style html tag into posted data
//if (! defined('NOSTYLECHECK'))   define('NOSTYLECHECK','1');
// Do not check anti POST attack test
//if (! defined('NOTOKENRENEWAL'))	define('NOTOKENRENEWAL','1');
// If there is no need to load and show top and left menu
//if (! defined('NOREQUIREMENU'))	define('NOREQUIREMENU','1');
// If we don't need to load the html.form.class.php
//if (! defined('NOREQUIREHTML'))	define('NOREQUIREHTML','1');
//if (! defined('NOREQUIREAJAX'))	define('NOREQUIREAJAX','1');
// If this page is public (can be called outside logged session)
//if (! defined("NOLOGIN"))			define("NOLOGIN",'1');
// Change the following lines to use the correct relative path
// (../, ../../, etc)

// Load Dolibarr environment
if (false === (@include '../main.inc.php')) {  // From htdocs directory
	require '../../main.inc.php'; // From "custom" directory
}



global $db, $langs, $user;


dol_include_once('/lemodule/class/leclass.class.php');
dol_include_once('/lemodule/functions.php');

//<!-- third party -->
$morejs = array(
0 => '/lemodule/js/angular-fm/bower_components/angular/angular.min.js',
1 => '/lemodule/js/angular-fm/bower_components/angular-translate/angular-translate.min.js',
2 => '/lemodule/js/angular-fm/bower_components/bootstrap/dist/js/bootstrap.min.js',
3 => '/lemodule/js/angular-fm/bower_components/ng-file-upload/ng-file-upload.min.js',
4 => '/lemodule/js/angular-fm/src/js/app.js',
5 => '/lemodule/js/angular-fm/src/js/directives/directives.js',
6 => '/lemodule/js/angular-fm/src/js/filters/filters.js',
7 => '/lemodule/js/angular-fm/src/js/providers/config.js',
8 => '/lemodule/js/angular-fm/src/js/entities/chmod.js',
9 => '/lemodule/js/angular-fm/src/js/entities/item.js',
10 => '/lemodule/js/angular-fm/src/js/services/apihandler.js',
11 => '/lemodule/js/angular-fm/src/js/services/apimiddleware.js',
12 => '/lemodule/js/angular-fm/src/js/services/filenavigator.js',
13 => '/lemodule/js/angular-fm/src/js/providers/translations.js',
14 => '/lemodule/js/angular-fm/src/js/controllers/main.js',
15 => '/lemodule/js/angular-fm/src/js/controllers/selector-controller.js');


// Load translation files required by the page
$langs->load("lemodule@lemodule");


// Access control
if ($user->socid > 0) {
	// External user
	accessforbidden();
}


$title=$langs->trans('FileManagerPageName');
llxHeader('', $title, '', '', 0, 0, $morejs, '', '', '');
//print load_fiche_titre($title,'','lemodule.png@lemodule');

//print $langs->trans("FileManagerPageDescription").'<br><br>';
//echo '<div class="ng-cloak" style="height: 400px;width: 800px;" data-ng-app="FileManagerApp">';
?>
<script type="text/javascript">
angular.module('FileManagerApp').config(['fileManagerConfigProvider', function (config) {
  var defaults = config.$get();
  config.set({
defaultLang: navigator.language,
basePath: '..'
  });
}]);

var linkElement1 = document.createElement("link");
linkElement1.rel = "stylesheet";
linkElement1.href = "js/angular-fm/bower_components/bootswatch/paper/bootstrap.min.css";

document.head.appendChild(linkElement1);

var linkElement2 = document.createElement("link");
linkElement2.rel = "stylesheet";
linkElement2.href = "js/angular-fm/src/css/animations.css";

document.head.appendChild(linkElement2);

var linkElement3 = document.createElement("link");
linkElement3.rel = "stylesheet";
linkElement3.href = "js/angular-fm/src/css/dialogs.css";

document.head.appendChild(linkElement3);

var linkElement4 = document.createElement("link");
linkElement4.rel = "stylesheet";
linkElement4.href = "js/angular-fm/src/css/main.css";

document.head.appendChild(linkElement4);
</script>
<?php
echo '<div data-ng-app="FileManagerApp">';
echo '<angular-filemanager></angular-filemanager>';
echo '</div>';
// End of page
llxFooter();
