<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2017  Libre Expert
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \defgroup    lemodule    LEModule module
 * \brief       LEModule module descriptor.
 *
 * Put detailed description here.
 */

/**
 * \file        core/modules/modLEModule.class.php
 * \ingroup     lemodule
 * \brief       Example module description and activation file.
 *
 * Put detailed description here.
 */

include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

// The class name should start with a lower case mod for Dolibarr to pick it up
// so we ignore the Squiz.Classes.ValidClassName.NotCamelCaps rule.
// @codingStandardsIgnoreStart
/**
 * Description and activation class for module LEModule
 */
class modLEModule extends DolibarrModules
{
	/** @var DoliDB Database handler */
	public $db;

	/**
	 * @var int numero Module unique ID
	 * @see http://wiki.dolibarr.org/index.php/List_of_modules_id Available ranges
	 */
	public $numero = 430300;

	/** @var string Text key to reference module (for permissions, menus, etc.) */
	public $rights_class = 'lemodule';

	/**
	 * @var string Module family.
	 * Used to group modules in module setup page.
	 * Can be one of 'crm', 'financial', 'hr', 'projects', 'products', 'ecm', 'technic', 'other'
	 */
	public $family = 'other';

	/** @var int Module position in the family */
	public $module_position = 500;

	/** @var array Provide a custom family and options */
	public $familyinfo = array(
//        'myownfamily' => array(
//            'position' => '001',
//            'label' => 'MyOwnFamily'
//        )
	);

	/** @var string Module name */
	public $name = "Extra Admin Tools";

	/** @var string Module short description */
	public $description = "Extra Admin Tools provides extra functionalities to Dolibarr";

	/** @var string Module long description */
	public $descriptionlong = "Extra Admin Tools provides Dolibarr files integrity check, extra module easy installer, backup configuration, and filemanager";

	/**
	 * @var string Module editor name
	 * @since 4.0
	 */
	public $editor_name = "Libre Expert";

	/**
	 * @var string Module editor website
	 * @since 4.0
	 */
	public $editor_url = "http://www.libre-expert.com";

	/**
	 * @var string Module version string
	 * Special values to hide the module behind MAIN_FEATURES_LEVEL: development, experimental
	 * @see https://semver.org
	 */
	public $version = '1.2';

	/** @var string Key used in llx_const table to save module status enabled/disabled */
	public $const_name = 'MAIN_MODULE_LEMODULE';

	/**
	 * @var string Module logo
	 * Should be named object_lemodule.png and store under lemodule/img
	 */
	public $picto = 'lemodule@lemodule';

	/** @var array Define module parts */
	public $module_parts = array(
		/** @var bool Module ships triggers in lemodule/core/triggers */
		'triggers' => false,
		/**
		 * @var bool Module ships login in lemodule/core/login
		 * @todo: example
		 */
		'login' => false,
		/**
		 * @var bool Module ships substitution functions
		 * @todo example
		 */
		'substitutions' => false,
		/**
		 * @var bool Module ships menu handlers
		 * @todo example
		 */
		'menus' => true,
		/**
		 * @var bool Module ships theme in lemodule/theme
		 * @todo example
		 */
		'theme' => false,
		/**
		 * @var bool Module shipped templates in lemodule/core/tpl overload core ones
		 * @todo example
		 */
		'tpl' => false,
		/**
		 * @var bool Module ships barcode functions
		 * @todo example
		 */
		'barcode' => false,
		/**
		 * @var bool Module ships models
		 * @todo example
		 */
		'models' => false,
		/** @var string[] List of module shipped custom CSS relative file paths */
		'css' => array(
			'lemodule/css/mycss.css.php'
		),
		/** @var string[] List of module shipped custom JavaScript relative file paths */
		'js' => array(
			'lemodule/js/myjs.js.php'
		),
		/**
		 * @var string[] List of hook contexts managed by the module
		 * @ todo example
		 */
		'hooks' => array(),
		/**
		 * @var array List of default directory names to force
		 * @todo example
		 */
		'dir' => array(),
		/**
		 * @var array List of workflow contexts managed by the module
		 */
		'workflow' => array(),
	);

	/** @var string Data directories to create when module is enabled */
	public $dirs = array(
		'/lemodule/tmp'
	);

	/** @var array Configuration page declaration */
	public $config_page_url = 'setup.php@lemodule';

	/** @var bool Control module visibility */
	public $hidden = false;

	/** @var string[] List of class names of modules to enable when this one is enabled */
	public $depends = array();

	/** @var string[] List of class names of modules to disable when this one is disabled */
	public $requiredby = array();

	/** @var string List of class names of modules this module conflicts with */
	public $conflictwith = array();

	/** @var int[] Minimum PHP version required by this module */
	public $phpmin = array(5, 3);

	/** @var int[] Minimum Dolibarr version required by this module */
	public $need_dolibarr_version = array(3, 2);

	/** @var string[] List of language files */
	public $langfiles = array('lemodule@lemodule');

	/** @var array Indexed list of constants options */
	public $const = array();

	/**
	 * @var string List of pages to add as tab in a specific view
	 * @todo example
	 */
	public $tabs = array();

	/**
	 * @var array Dictionaries declared by the module
	 *@todo example
	 */
	public $dictionaries = array();

	/** @var array Indexed list of boxes options */
//	public $boxes = array(
//		0 => array(
//			'file' => 'mybox@lemodule',
//			'note' => '',
//			'enabledbydefaulton' => 'Home'
//		)
//	);

	/**
	 * @var array Indexed list of cronjobs options
	 * @todo: example
	 */
	public $cronjobs = array();

	/**
	 * @var array Indexed list of permissions options
	 * @todo example
	 */
	public $rights = array();
	
	/**
	* @var array Indexed list of menu options
	* @todo example
	*/
	
        public $menu = array();

	/**
	 * @var array Indexed list of export IDs
	 * @todo example
	 */
	public $export_code = array();

	/**
	 * @var array Indexed list of export names
	 * @todo example
	 */
	public $export_label = array();

	/**
	 * @var array Indexed list of export enabling conditions
	 * @todo example
	 */
	public $export_enabled = array();

	/**
	 * @var array Indexed list of export required permissions
	 * @todo example
	 */
	public $export_permission = array();

	/**
	 * @var array Indexed list of export fields
	 * @todo example
	 */
	public $export_fields_array = array();

	/**
	 * @var array Indexed list of export entities
	 * @todo example
	 */
	public $export_entities_array = array();

	/**
	 * @var array Indexed list of export SQL queries start
	 * @todo example
	 */
	public $export_sql_start = array();

	/**
	 * @var array Indexed list of export SQL queries end
	 * @todo example
	 */
	public $export_sql_end = array();

	/** @var bool Module only enabled / disabled in main company when multi-company is in use */
	public $core_enabled = false;

	// @codingStandardsIgnoreEnd
	/**
	 * Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * @param DoliDB $db Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		// DolibarrModules is abstract in Dolibarr < 3.8
		if (is_callable('parent::__construct')) {
			parent::__construct($db);
		} else {
			global $db;
			$this->db = $db;
		}
                
                $this->description = $langs->trans("ModuleDescription");
                $this->descriptionlong = $langs->trans("ModuleDescriptionLong");
                
                $r=0;
//                $url_prefix="";
//                $file_headers = @get_headers($dolibarr_main_url_root . $dolibarr_main_url_root_alt ."/lemodule/verify.php");
//                if($file_headers[0] == 'HTTP/1.1 404 Not Found')
//                    $url_prefix=$dolibarr_main_url_root_alt;
       
                    
                $this->menu[$r]=array(    
                        'fk_menu'=>'fk_mainmenu=home',	
                        'type'=>'left',			// This is a Left menu entry
                        'titre'=>'Extra Admin Tools',
                        'mainmenu'=>'home',
                        'leftmenu'=>'libreexpert',
                        'url'=>'',
                        'langs'=>'lemodule@lemodule',	// Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
                        'position'=>100,
                        'enabled'=>'1',			// Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
                        'perms'=>'$user->admin',			// Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
                        'target'=>'',
                        'user'=>2);				// 0=Menu for internal users,1=external users, 2=both
                $r++;
                $this->menu[$r]=array(    
                        'fk_menu'=>'fk_mainmenu=home,fk_leftmenu=libreexpert',	
                        'type'=>'left',			// This is a Left menu entry
                        'titre'=>'VerifyDolibarr',
                        'mainmenu'=>'',
                        'leftmenu'=>'',
                        'url'=>'/lemodule/verify.php',
                        'langs'=>'lemodule@lemodule',	// Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
                        'position'=>100,
                        'enabled'=>'1',			// Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
                        'perms'=>'$user->admin',			// Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
                        'target'=>'',
                        'user'=>2);
                $r++;
                $this->menu[$r]=array(    
                        'fk_menu'=>'fk_mainmenu=home,fk_leftmenu=libreexpert',	
                        'type'=>'left',			// This is a Left menu entry
                        'titre'=>'InstallModules',
                        'mainmenu'=>'',
                        'leftmenu'=>'',
                        'url'=>'/lemodule/instmod.php',
                        'langs'=>'lemodule@lemodule',	// Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
                        'position'=>100,
                        'enabled'=>'1',			// Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
                        'perms'=>'$user->admin',			// Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
                        'target'=>'',
                        'user'=>2);
                $r++;
                $this->menu[$r]=array(    
                        'fk_menu'=>'fk_mainmenu=home,fk_leftmenu=libreexpert',	
                        'type'=>'left',			// This is a Left menu entry
                        'titre'=>'FileManager',
                        'mainmenu'=>'',
                        'leftmenu'=>'',
                        'url'=>'/lemodule/filemanager.php',
                        'langs'=>'lemodule@lemodule',	// Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
                        'position'=>100,
                        'enabled'=>'1',			// Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
                        'perms'=>'$user->admin',			// Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
                        'target'=>'',
                        'user'=>2);
                $r++;
                $this->menu[$r]=array(    
                        'fk_menu'=>'fk_mainmenu=home,fk_leftmenu=libreexpert',	
                        'type'=>'left',			// This is a Left menu entry
                        'titre'=>'BackupConfiguration',
                        'mainmenu'=>'',
                        'leftmenu'=>'',
                        'url'=>'/lemodule/backupconfig.php',
                        'langs'=>'lemodule@lemodule',	// Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
                        'position'=>100,
                        'enabled'=>'1',			// Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
                        'perms'=>'$user->admin',			// Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
                        'target'=>'',
                        'user'=>2);
                $r++;
                $this->menu[$r]=array(    
                        'fk_menu'=>'fk_mainmenu=home,fk_leftmenu=libreexpert',	
                        'type'=>'left',			// This is a Left menu entry
                        'titre'=>'DatabaseManager',
                        'mainmenu'=>'',
                        'leftmenu'=>'',
                        'url'=>'/lemodule/databasemanager.php',
                        'langs'=>'lemodule@lemodule',	// Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
                        'position'=>100,
                        'enabled'=>'1',			// Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
                        'perms'=>'$user->admin',			// Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
                        'target'=>'',
                        'user'=>2);
                $r++;
                //$this->module_parts = array('css' => array('/lemodule/js/angular-fm/bower_components/bootswatch/paper/bootstrap.min.css',
                //                            '/lemodule/js/angular-fm/src/css/animations.css', '/lemodule/js/angular-fm/src/css/dialogs.css',
                //                            '/lemodule/js/angular-fm/src/css/main.css'));

		// Dictionaries
		if (! isset($conf->lemodule->enabled)) {
			$conf->lemodule=new stdClass();
			$conf->lemodule->enabled = 0;
		}
	}

	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * @param string $options Options when enabling module ('', 'noboxes')
	 * @return int 1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();

		$result = $this->loadTables();

		return $this->_init($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /lemodule/sql/
	 * This function is called by this->init
	 *
	 * @return int <=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/lemodule/sql/');
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * @param string $options Options when enabling module ('', 'noboxes')
	 * @return int 1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = array();

		return $this->_remove($sql, $options);
	}
	
	// Function to test an url
	public function urlExist($url) 
	{
            $file_headers = @get_headers($url);
            if($file_headers[0] == 'HTTP/1.1 404 Not Found')
                return false;
        
            return true;
        }
}
