<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2017  Libre Expert
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    backupconfig.php
 * \ingroup lemodule
 * \brief   Module PHP page.
 *
 * Put detailed description here.
 */

//if (! defined('NOREQUIREUSER'))	define('NOREQUIREUSER','1');
//if (! defined('NOREQUIREDB'))		define('NOREQUIREDB','1');
//if (! defined('NOREQUIRESOC'))	define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))	define('NOREQUIRETRAN','1');
// Do not check anti CSRF attack test
//if (! defined('NOCSRFCHECK'))		define('NOCSRFCHECK','1');
// Do not check style html tag into posted data
//if (! defined('NOSTYLECHECK'))   define('NOSTYLECHECK','1');
// Do not check anti POST attack test
//if (! defined('NOTOKENRENEWAL'))	define('NOTOKENRENEWAL','1');
// If there is no need to load and show top and left menu
//if (! defined('NOREQUIREMENU'))	define('NOREQUIREMENU','1');
// If we don't need to load the html.form.class.php
//if (! defined('NOREQUIREHTML'))	define('NOREQUIREHTML','1');
//if (! defined('NOREQUIREAJAX'))	define('NOREQUIREAJAX','1');
// If this page is public (can be called outside logged session)
//if (! defined("NOLOGIN"))			define("NOLOGIN",'1');
// Change the following lines to use the correct relative path
// (../, ../../, etc)

// Load Dolibarr environment
if (false === (@include '../main.inc.php')) {  // From htdocs directory
	require '../../main.inc.php'; // From "custom" directory
}



global $db, $langs, $user;


dol_include_once('/lemodule/class/leclass.class.php');
dol_include_once('/lemodule/functions.php');


// Load translation files required by the page
$langs->load("lemodule@lemodule");


// Access control
if ($user->socid > 0) {
	// External user
	accessforbidden();
}


$title=$langs->trans('BackupConfigPageName');
llxHeader('', $title, '');
print load_fiche_titre($title,'','lemodule.png@lemodule');

print $langs->trans("BackupConfigPageDescription").'<br><br>';

$configfile = 'scripts/backupconfig.conf';
$defaultcfgfile = 'scripts/backupconfig.default';

if ( ! file_exists($configfile)) {
    copy($defaultcfgfile, $configfile);
}

// If the submit button for recording data has been pressed
if(isset($_POST["submit"])) {
    $message = $langs->trans("ConfigFileRecorded");
    unlink($configfile);
    if(file_put_contents($configfile, 'ACTIVATED="'.GETPOST('backupactivated', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'LEVEL0DAY="'.GETPOST('dayofweek', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'BACKUPTIME="'.GETPOST('timeofbackup', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'BACKUP_DIR="'. cleanLastSlashFromPath(GETPOST('wherebackups', 'alpha')) . 
            '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'FILESYSTEMS="'.cleanLastSlashFromPath(GETPOST('whatbackup', 'alpha')) . 
            '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'EXCLUDECONFPHP="'.GETPOST('excludeconfphp', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'EMAILADDRESS="'.GETPOST('emailaddress', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'MYSQLDUMP="'.GETPOST('mysqldump', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'DBNAME="'.GETPOST('dbname', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'DBUSER="'.GETPOST('dbuser', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    if(file_put_contents($configfile, 'DBPASSWORD="'.GETPOST('dbpassword', 'alpha') . '"' . PHP_EOL, FILE_APPEND) == false) $message = $langs->trans("ProblemWithConfigFile");
    print '<h4>' . $message . '</h4>';
     
}

$file = fopen($configfile, "r") or die("Unable to open file!");
$configdata = array();
// Output one line until end-of-file
while(!feof($file)) {
  // Carefull because the value is between double quotes  
  $tmp = explode('="',fgets($file));
  $configdata[$tmp[0]]=substr($tmp[1],0,-2);
}
fclose($file);

print '<style>';
print '#table {display: table;}';
print '.row {display: table-row;}';
print '.cell {display: table-cell;padding: 5px;padding-left: 0px;}';
print '</style>';

print '<form action="' . $_SERVER["PHP_SELF"] . '" method="post" enctype="multipart/form-data">';

print '<div id="table">';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("BackupActivated") . ' ';
        print '</span>';
        print '<span class="cell">';
        ?>
            <select name="backupactivated" class="flat">
            <option value="0" <?php if($configdata["ACTIVATED"] == 0){ echo 'selected';} ?> > <?php echo $langs->trans("No") ?> </option>
            <option value="1" <?php if($configdata["ACTIVATED"] == 1){ echo 'selected';} ?> > <?php echo $langs->trans("Yes") ?> </option>
            </select>
        <?php
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("WhichDayOfTheWeekFullBackup") . ' ';
        print '</span>';
        print '<span class="cell">';
        ?>
            <select name="dayofweek" class="flat">
            <option value="0" <?php if($configdata["LEVEL0DAY"] == 0){ echo 'selected';} ?> > <?php echo $langs->trans("Sunday") ?> </option>
            <option value="1" <?php if($configdata["LEVEL0DAY"] == 1){ echo 'selected';} ?> > <?php echo $langs->trans("Monday") ?> </option>
            <option value="2" <?php if($configdata["LEVEL0DAY"] == 2){ echo 'selected';} ?> > <?php echo $langs->trans("Tuesday") ?> </option>
            <option value="3" <?php if($configdata["LEVEL0DAY"] == 3){ echo 'selected';} ?> > <?php echo $langs->trans("Wednesday") ?> </option>
            <option value="4" <?php if($configdata["LEVEL0DAY"] == 4){ echo 'selected';} ?> > <?php echo $langs->trans("Thursday") ?> </option>
            <option value="5" <?php if($configdata["LEVEL0DAY"] == 5){ echo 'selected';} ?> > <?php echo $langs->trans("Friday") ?> </option>
            <option value="6" <?php if($configdata["LEVEL0DAY"] == 6){ echo 'selected';} ?> > <?php echo $langs->trans("Saturday") ?> </option>
            </select>
        <?php
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("WhatTimeBackup") . ' ';
        print '</span>';
        print '<span class="cell">';
        ?>
            <select name="timeofbackup" class="flat">
            <?php for ($i=0; $i<24; $i++) {?>
                <option value="<?php echo $i?>" <?php if($configdata["BACKUPTIME"] == $i){ echo 'selected';} ?> ><?php echo $i?></option>
            <?php
            }
            ?>                
            </select>
        <?php
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("WhereToCreateTheBackups") . ' ';
        print '</span>';
        print '<span class="cell">';
            print '<input type="text" value="' . $configdata["BACKUP_DIR"] . '" name="wherebackups" class="flat" size="50">';
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("WhatToBackup") . ' ';
        print '</span>';
        print '<span class="cell">';
            print '<input type="text" value="' . $configdata["FILESYSTEMS"] . '" name="whatbackup" class="flat" size="50">';
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("ExcludeConfPHP") . ' ';
        print '</span>';
        print '<span class="cell">';
        ?>
            <select name="excludeconfphp" class="flat">
            <option value="0" <?php if($configdata["EXCLUDECONFPHP"] == 0){ echo 'selected';} ?> > <?php echo $langs->trans("No") ?> </option>
            <option value="1" <?php if($configdata["EXCLUDECONFPHP"] == 1){ echo 'selected';} ?> > <?php echo $langs->trans("Yes") ?> </option>
            </select>
        <?php
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("EmailAddressToSendBackupResultsMustBeConfigured") . ' ';
        print '</span>';
        print '<span class="cell">';
            print '<input type="text" value="' . $configdata["EMAILADDRESS"] . '" name="emailaddress" class="flat" size="50">';
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("MysqlDumpLocation") . ' ';
        print '</span>';
        print '<span class="cell">';
            print '<input type="text" value="' . $configdata["MYSQLDUMP"] . '" name="mysqldump" class="flat" size="50">';
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("DatabaseName") . ' ';
        print '</span>';
        print '<span class="cell">';
            print '<input type="text" value="' . $configdata["DBNAME"] . '" name="dbname" class="flat" size="50">';
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("DatabaseUser") . ' ';
        print '</span>';
        print '<span class="cell">';
            print '<input type="text" value="' . $configdata["DBUSER"] . '" name="dbuser" class="flat" size="50">';
        print '</span>';
    print '</div>';
    print '<div class="row">';
        print '<span class="cell">';
            print $langs->trans("DatabasePassword") . ' ';
        print '</span>';
        print '<span class="cell">';
            print '<input type="text" value="' . $configdata["DBPASSWORD"] . '" name="dbpassword" class="flat" size="50">';
        print '</span>';
    print '</div>';
print '</div>';
print '<br><br>';

if(isset($_POST["submit"])) {
    //print "MySQLdump : " . $configdata["MYSQLDUMP"];
    $command1 = $configdata["MYSQLDUMP"] . ' -u ' . $configdata["DBUSER"] . ' -p' . $configdata["DBPASSWORD"] . ' ' . $configdata["DBNAME"] ;
    $command2 = $configdata["MYSQLDUMP"] . " --version";
    $result1 = shell_exec(escapeshellcmd($command1) . " > test.sql");
    $result2 = shell_exec(escapeshellcmd($command2));
    $size = filesize("test.sql");
    //print $command1 . " > test.sql";
    print '<br>';        
    print $result1;
    print '<br>';        
    print $result2;
    print '<br><br><b>';        
    print $langs->trans("DumpTestResultFileSize") . " " . $size . " " . $langs->trans("Bytes");
    print '</b>';
    unlink("test.sql");

}
print '<br><br>';
print '<input type="submit" value="' . $langs->trans("SaveConfigurationTest") . '" name="submit" class="button">';
print '</form>'; 

// If the formular has been submitted


// End of page
llxFooter();
