<?php
/* Copyright (C) 2011-      Kevin Guerrier <guerrier.k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */


$listPredefinedFolders = array("SupplierInvoices", "BankDocument",
    "SocialDocument", "ImpotsTax", "Others");

$archives_output = $conf->kmgarchiged->dir_output . '/archived';




/**
 * Determines if a command exists on the current environment
 *
 * @param string $command The command to check
 * @return bool True if the command has been found ; otherwise, false.
 */
function command_exists ($command) {
  $whereIsCommand = (PHP_OS == 'WINNT') ? 'where' : 'which';

  $process = proc_open(
    "$whereIsCommand $command",
    array(
      0 => array("pipe", "r"), //STDIN
      1 => array("pipe", "w"), //STDOUT
      2 => array("pipe", "w"), //STDERR
    ),
    $pipes
  );
  if ($process !== false) {
    $stdout = stream_get_contents($pipes[1]);
    $stderr = stream_get_contents($pipes[2]);
    fclose($pipes[1]);
    fclose($pipes[2]);
    proc_close($process);

    return $stdout != '';
  }

  return false;
}

/**
 *    	Return Trim Index from Week index
 *
 * 		@param	int		$week		Week Index
 *      @return	int         Trim Index
 */
function getTrimFromWeek($week) {
    if ($week > 39)
        return 4;
    else if ($week > 26)
        return 3;
    else if ($week > 13)
        return 2;
    else
        return 1;
}

/**
 *    	Show html area with actions of code $code
 *
 * 		@param	Conf		$conf		Object conf
 * 		@param	Translate	$langs		Object langs
 * 		@param	DoliDB		$db			Object db
 *      @param  int			$noprint	Return string but does not output it
 *      @param  String			$code	code to filter (default ='AC_OTH')
 *      @param  String			$filtre	label to filter 
 *      @param  int			$limit	limit of list
 *      @return	void
 */
function show_actions_kmgarchiged($conf, $langs, $db, $noprint = 0,
        $code = 'AC_OTH', $filtre = '', $limit = '') {
    global $bc, $user;

    $now = dol_now();
    $out = '';

    if ($conf->agenda->enabled) {
        require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/actioncomm.class.php");
        require_once(DOL_DOCUMENT_ROOT . "/contact/class/contact.class.php");
        $actionstatic = new ActionComm($db);
        $userstatic = new User($db);
        $contactstatic = new Contact($db);

        $out.="\n";
        $out.='<table width="100%" class="noborder">';
        $out.='<tr class="liste_titre">';
        $out.='<td colspan="2">';
        $out.=$langs->trans("Actions" . $code . "Short");
        $out.='</td>';
        $out.='<td colspan="5" align="right">';
        $out.='</td>';
        $out.='</tr>';

        // Recherche histo sur actioncomm
        $sql = "SELECT a.id, a.label,";
        $sql.= " a.datep as dp,";
        $sql.= " a.datep2 as dp2,";
        $sql.= " a.note, a.percent,";
        $sql.= " a.fk_element, a.elementtype,";
        $sql.= " a.fk_user_author, a.fk_contact,";
        $sql.= " c.code as acode, c.libelle,";
        $sql.= " u.login, u.rowid as user_id";
        $sql.= " FROM " . MAIN_DB_PREFIX . "c_actioncomm as c, " . MAIN_DB_PREFIX . "user as u, " . MAIN_DB_PREFIX . "actioncomm as a";
        $sql.= " WHERE u.rowid = a.fk_user_author";
        $sql.= " AND a.entity IN (" . getEntity('actioncomm') . ")";
        if ($filtre)
            $sql.= " AND a.label LIKE '" . $filtre . "' ";
        $sql.= " AND c.id=a.fk_action";
        if ($code)
            $sql.= " AND c.code='" . $code . "'"; // Type appel telephonique
        $sql.= " ORDER BY a.datep DESC, a.id DESC";
        if ($limit)
            $sql .= ' LIMIT ' . $limit;
        dol_syslog("kmgarchiged.lib::show_actions_kmgarchiged sql=" . $sql);
        $result = $db->query($sql);
        $form = new Form($db);
        if ($result) {
            $i = 0;
            $num = $db->num_rows($result);
            $var = true;

            if ($num) {
                while ($i < $num) {
                    $var = !$var;

                    $obj = $db->fetch_object($result);

                    $datep = $db->jdate($obj->dp);

                    $out.="<tr " . $bc[$var] . ">";

                    $out.='<td width="120" align="left" nowrap="nowrap">' . dol_print_date($datep,
                                    'dayhour') . "</td>\n";

                    // Picto warning
                    $out.='<td width="16">';
                    if ($obj->percent >= 0 && $obj->percent < 100 && $datep && $datep
                            < ($now - ($conf->global->MAIN_DELAY_ACTIONS_TODO * 60
                            * 60 * 24)))
                        $out.=' ' . img_warning($langs->trans("Late"));
                    else
                        $out.='&nbsp;';
                    $out.='</td>';

                    $actionstatic->type_code = $obj->acode;
                    $transcode = $langs->trans("Action" . $obj->acode);
                    $libelle = ($transcode != "Action" . $obj->acode ? $transcode : $obj->libelle);
                    //$actionstatic->libelle=$libelle;
                    $actionstatic->libelle = $obj->label;
                    $actionstatic->id = $obj->id;
                    //$out.='<td width="140">'.$actionstatic->getNomUrl(1,16).'</td>';
                    // Title of event
                    //$out.='<td colspan="2">'.dol_trunc($obj->label,40).'</td>';

                    $html = $form->textwithpicto($actionstatic->getNomUrl(1, 40),
                            $obj->note);

                    $out.='<td colspan="2">' . $html . '</td>';

                    // Contact pour cette action
                    if ($obj->fk_contact > 0) {
                        $contactstatic = new Contact($db);
                        $contactstatic->fetch($obj->fk_contact);

                        $out.='<td width="120">' . $contactstatic->getNomUrl(1,
                                        '', 10) . '</td>';
                    }
                    else {
                        $out.='<td>&nbsp;</td>';
                    }

                    $out.='<td width="80" nowrap="nowrap">';
                    $userstatic->id = $obj->fk_user_author;
                    $userstatic->login = $obj->login;
                    $out.=$userstatic->getLoginUrl(1);
                    $out.='</td>';

                    // Statut
                    $out.='<td nowrap="nowrap" width="20">' . $actionstatic->LibStatut($obj->percent,
                                    3) . '</td>';

                    $out.="</tr>\n";
                    $i++;
                }
            }
            else {
                // Aucun action a faire
            }
            $db->free($result);
        }
        else {
            dol_print_error($db);
        }
        $out.="</table>\n";

        $out.="<br>\n";
    }

    if ($noprint)
        return $out;
    else
        print $out;
}
