<?PHP

/* Copyright (C) 2013-2018	Kevin GUERRER	<guerrier.k@æmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *       \file       /kmgarchiged/index.php
 *       \ingroup    ged
 *       \brief      Fichier de réception et de traitement des fichiers reçus
 */
$res = 0;
if (!$res && file_exists("../main.inc.php"))
    $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php"))
    $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php"))
    $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php"))
    $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res)
    die("Include of main fails");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/cactioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/actioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/class/html.formorder.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/class/html.formfile.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/class/html.formmail.class.php");
require_once(DOL_DOCUMENT_ROOT . '/core/lib/files.lib.php');
require_once(DOL_DOCUMENT_ROOT . "/core/lib/functions.lib.php");
require_once(DOL_DOCUMENT_ROOT . "/core/lib/functions2.lib.php");
require_once(DOL_DOCUMENT_ROOT . '/core/lib/usergroups.lib.php');

require_once DOL_DOCUMENT_ROOT . '/fourn/class/fournisseur.class.php';
require_once DOL_DOCUMENT_ROOT . '/fourn/class/fournisseur.facture.class.php';

require_once(DOL_DOCUMENT_ROOT . '/user/class/user.class.php');
require_once(DOL_DOCUMENT_ROOT . '/user/class/usergroup.class.php');

dol_include_once('/kmgarchiged/lib/kmgarchiged.lib.php');
dol_include_once('/kmgarchiged/class/kmgarchigeduserconfig.class.php');

if (!$user->rights->kmgarchiged->kmgarchiged->utiliser)
    accessforbidden();


$langs->load("other");
$langs->load("mails");
$langs->load("kmgarchiged@kmgarchiged");

/*
 * Actions
 */

$action = GETPOST('action');
$srcfile = GETPOST('srcfile');
$reference_fk_id = GETPOST('reference_fk_id');
$reference_type_element = GETPOST('reference_type_element');
$name = GETPOST('name');
$basename = GETPOST('basename');
if ($name == "")
    $name = $basename;
$extension = GETPOST('extension');
if ($extension != "")
    if (strpos($name, $extension) === FALSE)
        $name .= '.' . GETPOST('extension');



$kmgarchigeduserconfig = new Kmgarchigeduserconfig($db);
$kmgarchigeduserconfig->fetch_from_user($user->id);

$usergroup = new UserGroup($db);
$groupslist = $usergroup->listGroupsForUser($user->id);

if (!empty($groupslist)) {
    foreach ($groupslist as $current_group) {
        $listgroup[] = $current_group->id;
    }
}
// Envoi fichier
if ($_POST["sendit"] && !empty($_GET['folder']) && !empty($conf->global->MAIN_UPLOAD_DOC)) {
    $upload_dir = $conf->kmgarchiged->dir_output . '/' . $_GET['folder'];

    if (strpos($_FILES['userfile']['name'], '.pdf') === FALSE) {
        $langs->load("errors");
        $mesg = '<div class="error">' . $langs->trans("PDFFileOnly") . '</div>';
    }
    else {
        if (dol_mkdir($upload_dir) >= 0) {
            $resupload = dol_move_uploaded_file($_FILES['userfile']['tmp_name'],
                    $upload_dir . "/" . dol_unescapefile($_FILES['userfile']['name']),
                    0, 0, $_FILES['userfile']['error']);
            if (is_numeric($resupload) && $resupload > 0) {
                $mesg = '<div class="ok">' . $langs->trans("FileTransferComplete") . '</div>';
            }
            else {
                $langs->load("errors");
                if ($resupload < 0) { // Unknown error
                    $mesg = '<div class="error">' . $langs->trans("ErrorFileNotUploaded") . '</div>';
                }
                else if (preg_match('/ErrorFileIsInfectedWithAVirus/',
                                $resupload)) { // Files infected by a virus
                    $mesg = '<div class="error">' . $langs->trans("ErrorFileIsInfectedWithAVirus") . '</div>';
                }
                else { // Known error
                    $mesg = '<div class="error">' . $langs->trans($resupload) . '</div>';
                }
            }
        }
    }
}


//if ($action == 'delete' && $srcfile != "") {
//    $resupload = dol_delete_file($srcfile);
//
//    if ($resupload) {
//        $mesg = '<div class="ok">' . $langs->trans("FileSuccessfullyDeleted") . '</div>';
//        $src_screenfile = GETPOST('src_screenfile');
//        $resupload_screen = dol_delete_file($src_screenfile);
//
//        $note_ac = '';
//        $note_ac .= $langs->trans('File') . ' : ' . $basename . '<br />';
//        $note_ac .= $langs->trans('Deleted');
//
//        $cactioncomm = new CActionComm($db);
//        $evenement = new ActionComm($db);
//
//        $cactioncomm->fetch('ACGED_DELETE');
//        if (!($cactioncomm->id > 0))
//            $cactioncomm->fetch('AC_OTH_AUTO');
//        if (!($cactioncomm->id > 0))
//            $cactioncomm->fetch('AC_OTH');
//        $evenement->type_id = $cactioncomm->id;
//        $evenement->fk_action = $cactioncomm->id;
//        $evenement->type_code = $cactioncomm->code;
//        $evenement->label = trim($basename . ' ' . $langs->trans('supprimeLe',
//                        dol_print_date(dol_now(), 'dayhour')));
//        $evenement->libelle = $evenement->label;
//        $evenement->datep = dol_now();
//        $evenement->datef = dol_now();
//        $evenement->percentage = -1;
//        $evenement->priority = '';
//        $evenement->fulldayevent = 0;
//        $evenement->location = '';
//        $evenement->societe->id = '';
//        $evenement->contact->id = '';
//        $evenement->fk_project = '';
//        $evenement->note = $note_ac;
//        $evenement->pnote = $note_ac;
//        $evenement->author = $user;
//        $evenement->userownerid = $user->id;
//        $evenement->usertodo = $user;
//        $evenement->userdone = $user;
//        $evenement->userdoneid = $user->id;
//        $evenement->add($user);
//    }
//    else {
//        $langs->load("errors");
//        $mesg = '<div class="error">' . $langs->trans("ErrorFileNotDeleted") . '</div>';
//    }
//}


if ($action == 'archive' && $srcfile != "") {
    $resupload = dol_delete_file($srcfile);

    if ($resupload) {
        $mesg = '<div class="ok">' . $langs->trans("FileSuccessfullyArchived") . '</div>';
        $src_screenfile = GETPOST('src_screenfile');
        $resupload_screen = dol_delete_file($src_screenfile);

        $note_ac = '';
        $note_ac .= $langs->trans('File') . ' : ' . $basename . '<br />';
        $note_ac .= $langs->trans('Archived');

        $cactioncomm = new CActionComm($db);
        $evenement = new ActionComm($db);

        $cactioncomm->fetch('ACGED_ARCHIVED');
        if (!($cactioncomm->id > 0))
            $cactioncomm->fetch('AC_OTH_AUTO');
        if (!($cactioncomm->id > 0))
            $cactioncomm->fetch('AC_OTH');
        $evenement->type_id = $cactioncomm->id;
        $evenement->fk_action = $cactioncomm->id;
        $evenement->type_code = $cactioncomm->code;
        $evenement->label = trim($basename . ' ' . $langs->trans('archiveLe',
                        dol_print_date(dol_now(), 'dayhour')));
        $evenement->libelle = $evenement->label;
        $evenement->datep = dol_now();
        $evenement->datef = dol_now();
        $evenement->percentage = -1;
        $evenement->priority = '';
        $evenement->fulldayevent = 0;
        $evenement->location = '';
        $evenement->societe->id = '';
        $evenement->contact->id = '';
        $evenement->fk_project = '';
        $evenement->note = $note_ac;
        $evenement->pnote = $note_ac;
        $evenement->author = $user;
        $evenement->userownerid = $user->id;
        $evenement->usertodo = $user;
        $evenement->userdone = $user;
        $evenement->userdoneid = $user->id;
        $evenement->add($user);
    }
    else {
        $langs->load("errors");
        $mesg = '<div class="error">' . $langs->trans("ErrorFileNotArchived") . '</div>';
    }
}


if ($action == 'linkto' && $srcfile != "" && $reference_fk_id != "" && $reference_type_element
        != "" && $name != "") {

    switch ($reference_type_element) {
        case 'banque':
            $target_dir = $conf->bank->dir_output;
            $element_type_ac = 'bank';
            break;
        case 'societe':
            $target_dir = $conf->societe->dir_output;
            $element_type_ac = 'societe';
            break;
        case 'propal':
            $target_dir = $conf->propal->dir_output;
            $element_type_ac = 'propal';
            break;
        case 'commande':
            $target_dir = $conf->commande->dir_output;
            $element_type_ac = 'order';
            break;
        case 'facture':
            $target_dir = $conf->facture->dir_output;
            $element_type_ac = 'invoice';
            break;
        case 'commande_fournisseur':
            $target_dir = $conf->fournisseur->commande->dir_output;
            $element_type_ac = 'order_supplier';
            break;
        case 'facture_fournisseur':
            $target_dir = $conf->fournisseur->facture->dir_output;
            $element_type_ac = 'invoice_supplier';
            $generic_fac_fourn = new FactureFournisseur($db);
            $generic_fac_fourn->fetch($reference_fk_id);
            $reference_fk_id = get_exdir($generic_fac_fourn->id, 2, 0, 0,
                            $generic_fac_fourn, $element_type_ac) . dol_sanitizeFileName($generic_fac_fourn->ref);
            $url_file = $reference_fk_id . '/' . $name;
            break;
        case 'projet':
            $target_dir = $conf->projet->dir_output;
            $element_type_ac = 'projet';
            break;
        case 'tache':
            $target_dir = $conf->projet->dir_output;
            $element_type_ac = 'task';
            break;
        case 'chargesociales':
            $target_dir = $conf->tax->dir_output;
            $element_type_ac = 'chargesociales';
            break;
        // TODO HOOK
    }

    if ($target_dir != "" && dol_is_dir($target_dir)) {
        $target_dir .= '/' . $reference_fk_id;

        if (dol_mkdir($target_dir) >= 0) {
            $destfile = $target_dir . '/' . $name;
            $res_link = dol_copy($srcfile, $destfile);
            if ($res_link > 0) {
                $mesg = '<div class="ok">' . $langs->trans("FileTransferComplete") . ' > ' . $name . '</div>';

                $note_ac = '';
                $note_ac .= $langs->trans('File') . ' : ' . $basename . '<br />';
                if ($name != $basename)
                    $note_ac .= $langs->trans('Renamed') . ' : ' . $name . '<br />';
                $note_ac .= $langs->trans('linkedTo') . ' : ' . $langs->trans($reference_type_element) . '<br />';
                $note_ac .= $langs->trans('Link') . ' : ';
                if ($url_file == '')
                    $url_file = str_replace(DOL_DATA_ROOT . '/' . $reference_type_element,
                            '', $destfile);
                $note_ac .= '<a href="' . dol_buildpath('/document.php', 2) . '?modulepart=' . $reference_type_element . '&file=' . $url_file . '" target="_blank">';
                $note_ac .= img_picto($fichier['name'], 'file') . ' ' . $langs->trans('visualiser');
                $note_ac .= '</a>';

                $cactioncomm = new CActionComm($db);
                $evenement = new ActionComm($db);

                $cactioncomm->fetch('ACGED_LINKED');
                if (!($cactioncomm->id > 0))
                    $cactioncomm->fetch('AC_OTH_AUTO');
                if (!($cactioncomm->id > 0))
                    $cactioncomm->fetch('AC_OTH');
                $evenement->type_id = $cactioncomm->id;
                $evenement->fk_action = $cactioncomm->id;
                $evenement->type_code = $cactioncomm->code;
                $evenement->label = trim($basename . ' ' . $langs->trans('traiteLe',
                                dol_print_date(dol_now(), 'dayhour')));
                $evenement->libelle = $evenement->label;
                $evenement->datep = dol_now();
                $evenement->datef = dol_now();
                $evenement->percentage = -1;
                $evenement->priority = '';
                $evenement->fulldayevent = 0;
                $evenement->location = '';
                $evenement->societe->id = '';
                $evenement->contact->id = '';
                $evenement->fk_project = '';
                $evenement->note = $note_ac;
                $evenement->pnote = $note_ac;
                $evenement->author = $user;
                $evenement->userownerid = $user->id;
                $evenement->usertodo = $user;
                $evenement->userdone = $user;
                $evenement->userdoneid = $user->id;
                $evenement->fk_element = GETPOST('reference_fk_id');
                $evenement->elementtype = $element_type_ac;
                $evenement->add($user);
            }
            else {
                $mesg = '<div class="error">' . $langs->trans("ErrorFileNotUploaded") . '</div>';
            }
        }
        else {
            $mesg = '<div class="error">' . $langs->trans("TargetNotFound") . '</div>';
        }
    }
    else {
        $mesg = '<div class="error">' . $langs->trans("TargetNotFound") . '</div>';
    }
}

if ($action == 'notify' && $srcfile != "") {
    $langs->load('mails');
    $langs->load("commercial");
    $destinataire_saisi = GETPOST('destinataire');

    // L'adresse mail a été saisie complètement (pas de liaison avec un élément de Dolibarr)
    if (isValidEmail($destinataire_saisi)) {
        $sendto = $destinataire_saisi;
        $sendtoname = $destinataire_saisi;
    }
    else {
        $sendto = GETPOST('destinataire_email');
        $sendtoname = GETPOST('destinataire_name');
    }
    $fromname = $user->lastname . ' ' . $user->firstname;
    $frommail = $user->email;
    $subject = GETPOST('subject');
    $link_file = GETPOST('link_file');
    $path = GETPOST('srcfile');
    $file = GETPOST('basename');
    $linkviewfile = GETPOST('linkviewfile');
    $indice = GETPOST('indice');
    $mimetype = dol_mimetype($file);
    $sendtosocid = GETPOST('destinataire_socid');
    $destinataire_userid = GETPOST('destinataire_userid');
    if ($sendtosocid < 0)
        $sendtosocid = '';
    $sendtoid = GETPOST('destinataire_id');
    if ($sendtoid < 0)
        $sendtoid = '';

    if (dol_strlen($sendto)) {
        $from = $fromname . ' <' . $frommail . '>';
        $replyto = $fromname . ' <' . $frommail . '>';
        if ($subject == '') {
            $codeparam = 'MAIL_SUBJECT';
            $key = "KMGED_" . $codeparam;
            $subject = ($conf->global->$key) ? $conf->global->$key : $langs->trans("dft_" . $codeparam);
        }
        $message = GETPOST('message_' . $indice);

        $message = str_replace($user->signature, '', $message);

        if ($destinataire_userid) {
            $userdestinataire = new User($db);
            $userdestinataire->fetch($destinataire_userid);

            if (isValidEmail($userdestinataire->email))
                $sendto = $userdestinataire->email;
            if ($sendtoname == '')
                $sendtoname = $userdestinataire->getFullName($langs, 0);

            if ($userdestinataire->rights->kmgarchiged->kmgarchiged->utiliser) {
                $message .= '<br />';
                $message .= $langs->trans('FileURLLink',
                        dol_buildpath('/viewimage.php', 2) . '?modulepart=kmgarchiged&file=/' . $linkviewfile . '&perm=kmgarchiged&subperm=utiliser');
                $message .= '<br />';
            }
            if ($userdestinataire->rights->kmgarchiged->kmgarchiged->utiliser) {
                $message .= '<br />';
                $message .= $langs->trans('AccederArchiGED',
                        dol_buildpath('/kmgarchiged/index.php', 2));
                $message .= '<br />';
            }
        }

        $message .= '<br />' . $user->signature;

        // Create form object
        include_once DOL_DOCUMENT_ROOT . '/core/class/html.formmail.class.php';
        $formmail = new FormMail($db);
        if ($link_file) {
            $formmail->add_attached_files($path, $file, $mimetype);
        }
        $attachedfiles = $formmail->get_attached_files();
        $filepath = $attachedfiles['paths'];
        $filename = $attachedfiles['names'];
        $mimetype = $attachedfiles['mimes'];


        // Send mail
        require_once DOL_DOCUMENT_ROOT . '/core/class/CMailFile.class.php';
        $mailfile = new CMailFile($subject, $sendto, $from, $message, $filepath,
                $mimetype, $filename, $sendtocc, $sendtobcc, $deliveryreceipt,
                -1, '', '', $trackid);
        if ($mailfile->error) {
            $langs->load("errors");
            $mesg = '<div class="error">' . $mailfile->error . '</div>';
        }
        else {
            $result = $mailfile->sendfile();
            if ($result) {
                $formmail->clear_attached_files();
                $mesg = '<div class="ok">' . $langs->trans("FileSuccessfullyNotified") . '</div>';

                $note_ac = $message . '<br />';
                $note_ac .= $langs->trans('File') . ' : ' . $basename . '<br />';
                $note_ac .= $langs->trans('MailTo') . ' : ' . $sendtoname . ' &lt;' . $sendto . '&gt;<br />';

                if ($link_file) {
                    $note_ac .= $langs->trans('filelinkedto');
                }

                $cactioncomm = new CActionComm($db);
                $evenement = new ActionComm($db);

                $cactioncomm->fetch('ACGED_NOTIFY');
                if (!($cactioncomm->id > 0))
                    $cactioncomm->fetch('AC_OTH_AUTO');
                if (!($cactioncomm->id > 0))
                    $cactioncomm->fetch('AC_OTH');
                $evenement->type_id = $cactioncomm->id;
                $evenement->fk_action = $cactioncomm->id;
                $evenement->type_code = $cactioncomm->code;
                $evenement->label = trim($basename . ' ' . $langs->trans('notifieLe',
                                dol_print_date(dol_now(), 'dayhour')));
                $evenement->libelle = $evenement->label;
                $evenement->datep = dol_now();
                $evenement->datef = dol_now();
                $evenement->percentage = -1;
                $evenement->priority = '';
                $evenement->fulldayevent = 0;
                $evenement->location = '';
                $evenement->societe->id = $sendtosocid;
                $evenement->contact->id = $sendtoid;
                $evenement->fk_project = '';
                $evenement->note = $note_ac;
                $evenement->pnote = $note_ac;
                $evenement->author = $user;
                $evenement->userownerid = $user->id;
                $evenement->usertodo = $user;
                $evenement->userdone = $user;
                $evenement->userdoneid = $user->id;
                $evenement->add($user);
            }
            else {
                $langs->load("errors");
                $mesg = '<div class="error">' . $langs->trans("ErrorFileNotNotified") . '</div>';
            }
        }
    }
}


/*
 * View
 */

$help_url = 'EN:Module_ArchiGED|FR:Module_ArchiGED|ES:M&oacute;dulo_ArchiGED';
llxHeader('', $langs->trans("ArchiGED"), $help_url);

dol_htmloutput_mesg($mesg);


$form = new Form($db);
$formfile = new FormFile($db);

$arrayofexclusion = array('temp', 'archived');
if ($kmgarchigeduserconfig->has_fldr == 0) {
    $arrayofexclusion[] = 'user_*';
}
if ($kmgarchigeduserconfig->access_groups_fldr == 0) {
    $arrayofexclusion[] = 'group_*';
}

$list_files = dol_dir_list($conf->kmgarchiged->dir_output, 'directories', 0, '',
        $arrayofexclusion, 'name', SORT_DESC);
print '<div class="titre" >' . $langs->trans('ListOfFiles') . '</div>';
$i = 0;
$i_fichier = 0;
if ($list_files != "") {
    foreach ($list_files as $fichier_list) {

        $displayed_name = $fichier_list['name'];
        $access_allowed = 0;
        if ($user->admin) {
            $access_allowed = 1;
        }
        else {
            switch ($fichier_list['name']) {
                case 'Others':
                    $access_allowed = 1;
                    break;
                case 'BankDocument':
                    if ($user->rights->banque)
                        $access_allowed = 1;
                    break;
                case 'ImpotsTax':
                    if ($user->rights->tax)
                        $access_allowed = 1;
                    break;
                case 'SocialDocument':
                    if ($user->rights->tax)
                        $access_allowed = 1;
                    break;
                case 'SupplierInvoices':
                    if ($user->rights->fournisseur->facture)
                        $access_allowed = 1;
                    break;
                default:
                    if ($user->rights->$fichier_list['name'])
                        $access_allowed = 1;
                    else
                        $access_allowed = 0;
                    break;
            }
        }

        if ($fichier_list['name'] == 'user_' . $user->id) {
            $access_allowed == 1;
            $displayed_name = $langs->trans('KMGARCHIGED_PERSONNALBAN') . ' - ' . $user->getFullName($langs);
        }

        if (substr($fichier_list['name'], 0, 6) == 'group_') {
            list($null, $id_group) = explode('_',$fichier_list['name']);
            if (in_array($id_group, $listgroup)) {
                $access_allowed == 1;
                $displayed_name = $langs->trans('KMGARCHIGED_GROUPBAN') . ' - '.$groupslist[$id_group]->name;
            }
        }

        if ($access_allowed) {
            $var = !$var;
            print '<table class="liste formdoc"  width="100%">';
            print '<tr class="liste_titre">';
            print '<td class="liste_titre" colspan="2">';
            print $langs->trans($displayed_name);
            print '</td>';
            print '</tr>';
            $exclude = array("screen_");
            $list_files_dir = dol_dir_list($conf->kmgarchiged->dir_output . '/' . $fichier_list['name'],
                    'files', 0, '', $exclude, 'date', SORT_DESC);
            $nb_fichiers = sizeof($list_files_dir);
            if ($nb_fichiers > 0) {
                foreach ($list_files_dir as $fichier) {
                    $i_fichier++;

                    if ($fichier['path'] == '')
                        $fichier['path'] = str_replace('/' . $fichier['name'],
                                '', $fichier['fullname']);

                    $info = new SplFileInfo($fichier['path'] . '/' . $fichier['name']);
                    $extension = $info->getExtension();
                    $basename = $info->getBasename($extenstion);

                    $var = !$var;
                    print '<tr ' . $bc[$var] . '>';
                    if (!dol_is_file($fichier['path'] . '/screen_' . $fichier['name'] . '.jpg')) {
                        if (command_exists('convert')) {
                            $ligne_cmd = 'convert -background white -density 125 -crop 100%x30%+0+0 "' . $fichier['path'] . '/' . $fichier['name'] . '[0]" "' . $fichier['path'] . '/screen_' . $fichier['name'] . '.jpg"';
                            exec($ligne_cmd, $output, $return_var);
                        }
                        else {
                            dol_copy(DOL_DOCUMENT_ROOT . '/public/theme/common/nophoto.png',
                                    $fichier['path'] . '/screen_' . $fichier['name'] . '.jpg');
                        }

                        $srcfile = $conf->kmgarchiged->dir_output . '/' . $fichier_list['name'] . '/' . $fichier['name'];
                        $destdir = $conf->kmgarchiged->dir_output . '/archived/' . date('YW') . '/' . $fichier_list['name'];
                        $destfile = $destdir . '/' . date('YmdHis') . '_' . $fichier['name'];

                        if (dol_mkdir($destdir) >= 0) {
                            dol_copy($srcfile, $destfile);

                            $note_ac = '';
                            $note_ac .= $langs->trans('File') . ' : ' . $fichier['name'] . '<br />';
                            $note_ac .= $langs->trans('Categorie') . ' : ' . $langs->trans($fichier_list['name']) . '<br />';
                            $note_ac .= $langs->trans('Link') . ' : ';

                            $note_ac .= '<a href="' . dol_buildpath('/document.php',
                                            2) . '?modulepart=kmgarchiged&file=/archived/' . date('YW') . '/' . $fichier_list['name'] . '/' . date('YmdHis') . '_' . $fichier['name'] . '" target="_blank">';
                            $note_ac .= img_picto($fichier['name'], 'file') . ' ' . $langs->trans('visualiser');
                            $note_ac .= '</a>';

                            $cactioncomm = new CActionComm($db);
                            $evenement = new ActionComm($db);

                            $cactioncomm->fetch('ACGED_RECU');
                            if (!($cactioncomm->id > 0))
                                $cactioncomm->fetch('AC_OTH_AUTO');
                            if (!($cactioncomm->id > 0))
                                $cactioncomm->fetch('AC_OTH');
                            $evenement->type_id = $cactioncomm->id;
                            $evenement->fk_action = $cactioncomm->id;
                            $evenement->type_code = $cactioncomm->code;
                            $evenement->label = trim($fichier['name'] . ' ' . $langs->trans('recuLe',
                                            dol_print_date($fichier['date'],
                                                    'dayhour')));
                            $evenement->libelle = $evenement->label;
                            $evenement->datep = $fichier['date'];
                            $evenement->datef = $fichier['date'];
                            $evenement->percentage = -1;
                            $evenement->priority = '';
                            $evenement->fulldayevent = 0;
                            $evenement->location = '';
                            $evenement->societe->id = '';
                            $evenement->contact->id = '';
                            $evenement->fk_project = '';
                            $evenement->note = $note_ac;
                            $evenement->pnote = $note_ac;
                            $evenement->author = $user;
                            $evenement->userownerid = $user->id;
                            $evenement->usertodo = $user;
                            $evenement->userdone = $user;
                            $evenement->userdoneid = $user->id;
                            $evenement->add($user);
                        }
                    }
                    $htmlimg = '<img style="width:675px" src="' . dol_buildpath('/viewimage.php',
                                    2) . '?modulepart=kmgarchiged&file=/' . $fichier_list['name'] . '/screen_' . $fichier['name'] . '.jpg&perm=kmgarchiged&subperm=utiliser" />';

                    print '<td style="text-align:left;width:700px;padding:5px;">';
                    $file = $fichier['name'];
                    $modulepart = 'kmgarchiged';
                    $filepath = '/' . $fichier_list['name'] . '/';
                    print $formfile->showPreview($file, $modulepart,
                                    $filepath . $file, 0,
                                    '&perm=kmgarchiged&subperm=utiliser');
                    print ' - ';
                    print $langs->trans('transmisle') . ' : ' . dol_print_date($fichier['date'],
                                    'dayhour');

                    print '<br />';
                    print $htmlimg;
                    print '<br />';

                    // List of actel actions
                    show_actions_kmgarchiged($conf, $langs, $db, '', '',
                            $fichier['name'] . '%', 5);

                    print '</td>';
                    print '<td style="text-align:left;vertical-align:top;">';
                    $codeparam = 'MAIL_SUBJECT';
                    $key = "KMGED_" . $codeparam;
                    $subject = ($conf->global->$key) ? $conf->global->$key : $langs->trans("dft_" . $codeparam);
                    print '<form name="notify_' . $i_fichier . '" method="POST">';
                    print '<input type="hidden" name="action" value="notify" />';
                    print '<input type="hidden" id="indice_' . $i_fichier . '" name="indice" value="' . $i_fichier . '" />';
                    print '<input type="hidden" id="src_file_' . $i_fichier . '" name="srcfile" value="' . $fichier['path'] . '/' . $fichier['name'] . '" />';
                    print '<input type="hidden" id="linkviewfile_' . $i_fichier . '"  name="linkviewfile" value="' . $fichier_list['name'] . '/' . $fichier['name'] . '" />';
                    print '<input type="hidden" id="basename_' . $i_fichier . '"  name="basename" value="' . $basename . '" />';
                    print '<input type="hidden" id="type_' . $i_fichier . '"  name="type" value="' . $typefile . '" />';
                    print '<input type="hidden" id="destinataire_id_' . $i_fichier . '"  name="destinataire_id" value="" />';
                    print '<input type="hidden" id="destinataire_socid_' . $i_fichier . '"  name="destinataire_socid" value="" />';
                    print '<input type="hidden" id="destinataire_userid_' . $i_fichier . '"  name="destinataire_userid" value="" />';
                    print '<input type="hidden" id="destinataire_email_' . $i_fichier . '"  name="destinataire_email" value="" />';
                    print '<table class="centpourcent" width="100%">';
                    print '<tr>';
                    print '<td colspan="2">';

                    $formmail = new FormMail($db);
                    $outputlangs = $langs;
                    $out = '';

                    $formmail->param['action'] = 'send';
                    $formmail->param['models'] = 'all';
                    $formmail->param['models_id'] = GETPOST('modelmailselected' . $i . '_document_' . $i_fichier,
                            'int');
                    $formmail->param['id'] = $i . '_document_' . $i_fichier;
                    $formmail->param['returnurl'] = $_SERVER["PHP_SELF"] . '?';
                    $formmail->param['fileinit'] = array($fichier['path'] . '/' . $fichier['name']);

                    // Make substitution in email content
                    $substitutionarray = getCommonSubstitutionArray($outputlangs,
                            0);
//	$substitutionarray['__CHECK_READ__'] = (is_object($object) && is_object($object->thirdparty)) ? '<img src="' . DOL_MAIN_URL_ROOT . '/public/emailing/mailing-read.php?tag=' . $object->thirdparty->tag . '&securitykey=' . urlencode($conf->global->MAILING_EMAIL_UNSUBSCRIBE_KEY) . '" width="1" height="1" style="width:1px;height:1px" border="0"/>' : '';
                    $substitutionarray['__PERSONALIZED__'] = ''; // deprecated
                    $substitutionarray['__CONTACTCIVNAME__'] = '';
                    $parameters = array(
                        'mode' => 'formemail'
                    );
                    complete_substitutions_array($substitutionarray,
                            $outputlangs, $object, $parameters);

                    // Find the good contact adress
                    $custcontact = '';
                    $contactarr = array();
//	$contactarr = $object->liste_contact(- 1, 'external');
//	if (is_array($contactarr) && count($contactarr) > 0) {
//		require_once DOL_DOCUMENT_ROOT . '/contact/class/contact.class.php';
//        $contactstatic = new Contact($db);
//
//		foreach ($contactarr as $contact) {
//            $contactstatic->fetch($contact['id']);
//            $substitutionarray['__CONTACT_NAME_'.$contact['code'].'__'] = $contactstatic->getFullName($langs, 1);
//		}
//	}
                    // Tableau des substitutions
                    $formmail->substit = $substitutionarray;

                    $arraydefaultmessage = -1;
                    $model_id = -2;
                    if ($formmail->param['models'] != 'none') {
                        $model_id = 0;
                        if (array_key_exists('models_id', $formmail->param)) {
                            $model_id = $formmail->param["models_id"];
                        }

                        if ($formmail->param['models_id'] > 0)
                            $arraydefaultmessage = $formmail->getEMailTemplate($db,
                                    $formmail->param["models"], $user,
                                    $outputlangs, $model_id);  // If $model_id is empty, preselect the first one
                    }

                    $modelmail_array = array();

                    $result = $formmail->fetchAllEMailTemplate($formmail->param["models"],
                            $user, $outputlangs);
                    if ($result < 0) {
                        setEventMessages($formmail->error, $formmail->errors,
                                'errors');
                    }

                    foreach ($formmail->lines_model as $line) {
                        $langs->trans("members");
                        if (preg_match('/\((.*)\)/', $line->label, $reg)) {
                            $modelmail_array[$line->id] = $langs->trans($reg[1]);  // langs->trans when label is __(xxx)__
                        }
                        else {
                            $modelmail_array[$line->id] = $line->label;
                        }
                        if ($line->lang)
                            $modelmail_array[$line->id].=' (' . $line->lang . ')';
                        if ($line->private)
                            $modelmail_array[$line->id].=' - ' . $langs->trans("Private");
                        //if ($line->fk_user != $user->id) $modelmail_array[$line->id].=' - '.$langs->trans("By").' ';
                    }

                    // Zone to select email template
                    if (count($modelmail_array) > 0) {
                        // If list of template is filled
                        $out.= '<div class="center" style="padding: 0px 0 12px 0">' . "\n";
                        $out.= '<span class="opacitymedium">' . $langs->trans('SelectMailModel') . ':</span> ' . $formmail->selectarray('modelmailselected' . $i . '_document_' . $i_fichier,
                                        $modelmail_array, 0, 1, 0, 0, '', 0, 0,
                                        0, '', 'minwidth100');
                        if ($user->admin)
                            $out.= info_admin($langs->trans("YouCanChangeValuesForThisListFrom",
                                            $langs->transnoentitiesnoconv('Setup') . ' - ' . $langs->transnoentitiesnoconv('EMails')),
                                    1);
                        $out.= ' &nbsp; ';
                        $out.= '<input class="button" type="submit" value="' . $langs->trans('Apply') . '" name="modelselected" id="modelselected">';
                        $out.= ' &nbsp; ';
                        $out.= '</div>';
                    }
                    elseif (!empty($formmail->param['models']) && in_array($formmail->param['models'],
                                    array(
                                'propal_send', 'order_send', 'facture_send',
                                'shipping_send', 'fichinter_send', 'supplier_proposal_send',
                                'order_supplier_send',
                                'invoice_supplier_send', 'thirdparty', 'contract',
                                'user', 'all'
                            ))) {
                        // If list of template is empty
                        $out.= '<div class="center" style="padding: 0px 0 12px 0">' . "\n";
                        $out.= $langs->trans('SelectMailModel') . ': <select name="modelmailselected" disabled="disabled"><option value="none">' . $langs->trans("NoTemplateDefined") . '</option></select>';    // Do not put 'disabled' on 'option' tag, it is already on 'select' and it makes chrome crazy.
                        if ($user->admin)
                            $out.= info_admin($langs->trans("YouCanChangeValuesForThisListFrom",
                                            $langs->transnoentitiesnoconv('Setup') . ' - ' . $langs->transnoentitiesnoconv('EMails')),
                                    1);
                        $out.= ' &nbsp; ';
                        $out.= '<input class="button" type="submit" value="' . $langs->trans('Apply') . '" name="modelselected" disabled="disabled" id="modelselected">';
                        $out.= ' &nbsp; ';
                        $out.= '</div>';
                    }
                    print $out;
                    print '</td>';
                    print '</tr>';
                    print '<tr>';
                    print '<td>';
                    print $langs->trans('MailTo') . ' : ';
                    print '</td><td>';
                    $out_autocompleter = '';
                    if ($conf->use_javascript_ajax)
                        $out_autocompleter .= ajax_multiautocompleter('destinataire_' . $i_fichier,
                                        array('destinataire_id_' . $i_fichier,
                                    'destinataire_socid_' . $i_fichier,
                                    'destinataire_email_' . $i_fichier,
                                    'destinataire_userid_' . $i_fichier),
                                        dol_buildpath('/kmgarchiged/core/ajax/notify.php',
                                                1), 'num_ligne=' . $i_fichier) . "\n";
                    print $out_autocompleter;
                    print '<input id="destinataire_' . $i_fichier . '" type="text" name="destinataire" />';
                    print '</td>';
                    print '</tr>';
                    print '<tr>';
                    print '<td>';
                    print $langs->trans('Topic') . ' : ';
                    print '</td><td>';
                    if ($arraydefaultmessage && $arraydefaultmessage->topic)
                        $subject = $arraydefaultmessage->topic;

                    $subject = make_substitutions($subject, $formmail->substit);
                    print '<input id="subject_' . $i_fichier . '" type="text" name="subject" size="35" value="' . $subject . '" />';
                    print '</td>';
                    print '</tr>';
                    print '<tr>';
                    print '<td colspan="2">';
                    // Editor wysiwyg
                    $codeparam = 'MAIL_MSG';
                    $key = "KMGED_" . $codeparam;
                    $defaultmessage = ($conf->global->$key) ? $conf->global->$key : $langs->trans("dft_" . $codeparam);
                    $defaultmessage .= '<br />' . $user->signature;

                    if ($arraydefaultmessage && $arraydefaultmessage->content)
                        $defaultmessage = $arraydefaultmessage->content;

                    $defaultmessage = make_substitutions($defaultmessage,
                            $formmail->substit);

                    require_once DOL_DOCUMENT_ROOT . '/core/class/doleditor.class.php';
                    $doleditor = new DolEditor('message_' . $i_fichier,
                            $defaultmessage, '', 100, 'dolibarr_readonly', 'In',
                            true, true, 1, 8, 72);
                    print $doleditor->Create(1);
                    print '</td>';
                    print '</tr>';
                    print '<tr>';
                    print '<td>';
                    print '<input type="checkbox" name="link_file" checked="checked" />' . ' ' . $langs->trans('linkFile');
                    print '</td>';
                    print '<td align="right">';
                    print '<input class="butAction" type="submit" value="' . $langs->trans('SendMail') . '" />';
                    print '</td>';
                    print '</tr>';
                    print '</table>';
                    print '</form>';
                    print '<hr />';

                    print '<form name="link_' . $i_fichier . '" method="POST">';
                    print '<input type="hidden" name="action" value="linkto" />';
                    print '<input type="hidden" id="src_file_' . $i_fichier . '" name="srcfile" value="' . $fichier['path'] . '/' . $fichier['name'] . '" />';
                    print '<input type="hidden" id="basename_' . $i_fichier . '"  name="basename" value="' . $basename . '" />';
                    print '<input type="hidden" id="extension_' . $i_fichier . '"  name="extension" value="' . $extension . '" />';

                    print '<table class="centpourcent" width="100%">';
                    print '<tr>';
                    print '<td>';
                    print $langs->trans('rename') . ' : ';
                    print '</td>';
                    print '<td coslpan="2">';
                    print '<input id="name_' . $i_fichier . '" type="text" name="name" />';
                    print '</td>';
                    print '</tr>';
                    print '<tr>';
                    print '<td>';
                    print 'et ' . $langs->trans('linkto') . ' : ';
                    print '</td>';
                    print '<td>';
                    $out_autocompleter = '';
                    if ($conf->use_javascript_ajax)
                        $out_autocompleter .= ajax_multiautocompleter('reference_' . $i_fichier,
                                        array('reference_type_element_' . $i_fichier,
                                    'reference_fk_id_' . $i_fichier),
                                        dol_buildpath('/kmgarchiged/core/ajax/reference.php',
                                                1), 'num_ligne=' . $i_fichier) . "\n";
                    print $out_autocompleter;
                    print '<input id="reference_' . $i_fichier . '" type="text" name="reference" />';
                    print '<input id="reference_type_element_' . $i_fichier . '" type="hidden" name="reference_type_element" />';
                    print '<input id="reference_fk_id_' . $i_fichier . '" type="hidden" name="reference_fk_id" />';
                    print '</td>';
                    print '<td rowspan="2" align="right">';
                    print '<input class="butAction" type="submit" />';
                    print '</td>';
                    print '</tr>';
                    print '</table>';
                    print '</form>';
                    print '<hr />';
                    print '<table class="centpourcent" width="100%">';
                    print '<tr>';
                    print '<td align="right">';
                    print '<form name="archive_' . $i_fichier . '" method="POST">';
                    print '<input type="hidden" name="action" value="archive" />';
                    print '<input type="hidden" id="src_screen_file_' . $i_fichier . '" name="src_screenfile" value="' . $fichier['path'] . '/screen_' . $fichier['name'] . '" />';
                    print '<input type="hidden" id="src_file_' . $i_fichier . '" name="srcfile" value="' . $fichier['path'] . '/' . $fichier['name'] . '" />';
                    print '<input type="hidden" id="basename_' . $i_fichier . '"  name="basename" value="' . $basename . '" />';
                    print '<input type="hidden" id="extension_' . $i_fichier . '"  name="extension" value="' . $extension . '" />';
                    print '<input class="butAction" type="submit" value="' . $langs->trans('archive') . '" />';
                    print '</form>';
//                    print '</td>';
//                    print '<td align="right">';
//                    print '<form name="delete_' . $i_fichier . '" method="POST">';
//                    print '<input type="hidden" name="action" value="delete" />';
//                    print '<input type="hidden" id="src_screen_file_' . $i_fichier . '" name="src_screenfile" value="' . $fichier['path'] . '/screen_' . $fichier['name'] . '" />';
//                    print '<input type="hidden" id="src_file_' . $i_fichier . '" name="srcfile" value="' . $fichier['path'] . '/' . $fichier['name'] . '" />';
//                    print '<input type="hidden" id="basename_' . $i_fichier . '"  name="basename" value="' . $basename . '" />';
//                    print '<input type="hidden" id="extension_' . $i_fichier . '"  name="extension" value="' . $extension . '" />';
//                    print '<input class="butActionDelete" type="submit" value="' . $langs->trans('delete') . '" />';
//                    print '</form>';
                    print '</td>';
                    print '</tr>';
                    print '</table>';
                    print '</td>';
                    print '</tr>';
                }
            }
            else {
                print '<tr>';
                print '<td colspan="2">';
                print $langs->trans('aucunFichierATraiter');
                print '</td>';
                print '</tr>';
            }

            print '<tr>';
            print '<td colspan="2">';
            print '<hr />';
            $old_value_layout = $conf->browser->layout;
            $conf->browser->layout = 'kmgarchiged';
            // Affiche formulaire upload
            $formfile = new FormFile($db);
            $formfile->form_attach_new_file(dol_buildpath('/kmgarchiged/index.php',
                            2) . '?folder=' . $fichier_list['name'], '', 0, 0,
                    $user->rights->kmgarchiged, 50, $object, '', '', '', 0);
            $conf->browser->layout = $old_value_layout;
            print '</td>';
            print '</tr>';
            print '</table><br />';
        }
        $i++;
    }
}
print '<br />';


llxFooter();
$db->close();
