<?php

/* Copyright (C) 2011-      Kevin Guerrier <guerrier.k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

include_once(DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php");

/**
 *  Description and activation class for module Kmgarchiged
 */
class modKmgarchiged extends DolibarrModules {

    /**
     *   Constructor. Define names, constants, directories, boxes, permissions
     *
     *   @param      DoliDB		$db      Database handler
     */
    function modKmgarchiged($db) {
        global $langs, $conf;

        $this->db = $db;

        // Id for module (must be unique).
        // Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
        $this->numero = 427401;
        // Key text used to identify module (for permissions, menus, etc...)
        $this->rights_class = 'kmgarchiged';

        // Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
        // It is used to group modules in module setup page
        $this->family = "ecm";
        // Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
        $this->name = preg_replace('/^mod/i', '', get_class($this));
        // Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
        $this->description = "Module KMGArchiged";
        $this->editor_name = 'GUERRIER Kevin';
        $this->editor_url = 'https://www.kmg-process.com';
        // Possible values for version are: 'development', 'experimental', 'dolibarr' or version
        $this->version = '2.0';
        // Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
        $this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
        // Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
        $this->special = 0;
        // Name of image file used for this module.
        // If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
        // If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
        $this->picto = 'pictomodule@kmgarchiged';

        // Defined all module parts (triggers, login, substitutions, menus, css, etc...)
        // for default path (eg: /kmgarchiged/core/xxxxx) (0=disable, 1=enable)
        // for specific path of parts (eg: /kmgarchiged/core/modules/barcode)
        // for specific css file (eg: /kmgarchiged/css/kmgarchiged.css.php)
        //$this->module_parts = array(
        //                        	'triggers' => 0,                                 // Set this to 1 if module has its own trigger directory
        //							'login' => 0,                                    // Set this to 1 if module has its own login method directory
        //							'substitutions' => 0,                            // Set this to 1 if module has its own substitution function file
        //							'menus' => 0,                                    // Set this to 1 if module has its own menus handler directory
        //							'barcode' => 0,                                  // Set this to 1 if module has its own barcode directory
        //							'models' => 0,                                   // Set this to 1 if module has its own models directory
        //							'css' => '/kmgarchiged/css/kmgarchiged.css.php',       // Set this to relative path of css if module has its own css file
        //							'hooks' => array('hookcontext1','hookcontext2')  // Set here all hooks context managed by module
        //							'workflow' => array('order' => array('WORKFLOW_ORDER_AUTOCREATE_INVOICE')) // Set here all workflow context managed by module
        //                        );
        $this->module_parts = array('css' => array('/kmgarchiged/css/kmgarchiged.css.php'));

        // Data directories to create when module is enabled.
        // Example: this->dirs = array("/mymodule/temp");
        $this->dirs = array("/kmgarchiged/SupplierInvoices", "/kmgarchiged/BankDocument",
            "/kmgarchiged/SocialDocument", "/kmgarchiged/ImpotsTax", "/kmgarchiged/Others",
            "/kmgarchiged/temp");

        // Config pages. Put here list of php page, stored into kmgarchiged/admin directory, to use to setup module.
        $this->config_page_url = array("admin_kmgarchiged.php@kmgarchiged");

        // Dependencies
        $this->depends = array();  // List of modules id that must be enabled if this module is enabled
        $this->requiredby = array(); // List of modules id to disable if this one is disabled
        $this->phpmin = array(5, 0);     // Minimum version of PHP required by module
        $this->need_dolibarr_version = array(5, 0); // Minimum version of Dolibarr required by module
        $this->langfiles = array("kmgarchiged@kmgarchiged");

        // Constants
        // List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
        // Example: $this->const=array(0=>array('MYMODULE_MYNEWCONST1','chaine','myvalue','This is a constant to add',1),
        //                             1=>array('MYMODULE_MYNEWCONST2','chaine','myvalue','This is another constant to add',0)
        // );
        $this->const = array();

        // Array to add new pages in new tabs
        // Example: $this->tabs = array('objecttype:+tabname1:Title1:langfile@kmgarchiged:$user->rights->kmgarchiged->read:/kmgarchiged/mynewtab1.php?id=__ID__',  // To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:langfile@kmgarchiged:$user->rights->othermodule->read:/kmgarchiged/mynewtab2.php?id=__ID__',  // To add another new tab identified by code tabname2
        //                              'objecttype:-tabname');                                                     // To remove an existing tab identified by code tabname
        // where objecttype can be
        // 'thirdparty'       to add a tab in third party view
        // 'intervention'     to add a tab in intervention view
        // 'order_supplier'   to add a tab in supplier order view
        // 'invoice_supplier' to add a tab in supplier invoice view
        // 'invoice'          to add a tab in customer invoice view
        // 'order'            to add a tab in customer order view
        // 'product'          to add a tab in product view
        // 'stock'            to add a tab in stock view
        // 'propal'           to add a tab in propal view
        // 'member'           to add a tab in fundation member view
        // 'contract'         to add a tab in contract view
        // 'user'             to add a tab in user view
        // 'group'            to add a tab in group view
        // 'contact'          to add a tab in contact view
        // 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
//        $this->tabs = array('product:+prix_specifiques_clients:Prix_specifiques_clients:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->kmgarchiged->prix_specifiques_clients:/kmgarchiged/tabs/produit_prix_client.php?id=__ID__',
//            ':+kmgarchiged:Kmgarchiged:kmgarchiged@kmgarchiged:/kmgarchiged/tabs/client_transport.php?id=__ID__',
//            'thirdparty:+commande_rapide:CommandeRapide:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->kmgarchiged->commande_rapide:/kmgarchiged/tabs/client_commande_rapide.php?id=__ID__',
//            'thirdparty:+cotation_rapide:CotationRapide:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->kmgarchiged->propal_rapide:/kmgarchiged/tabs/client_propal_rapide.php?id=__ID__',
//            'order:+detail_transport:DetailTransport:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->kmgarchiged->commande_tps:/kmgarchiged/tabs/commande_transport.php?id=__ID__',
//            'order:+facturation_transport:FacturationTransport:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->kmgarchiged->facturation_tps:/kmgarchiged/tabs/commande_facturation_transport.php?id=__ID__',
//            'propal:+detail_transport:DetailTransport:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->kmgarchiged->propale_tps:/kmgarchiged/tabs/propal_transport.php?id=__ID__');

        $this->tabs = array('user:+kmgarchigedconfig:KmgarchigedConfig:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->configuration->config_user:/kmgarchiged/usertab_kmgarchigedconfig.php?id=__ID__',
//            'group:+mailboxconfig:KmgarchigedConfig:kmgarchiged@kmgarchiged:$user->rights->kmgarchiged->configuration->config_group:/kmgarchiged/grouptab_kmgarchigedconfig.php?id=__ID__',
            );

        // Dictionnaries
        if (!isset($conf->kmgarchiged->enabled)) {
            $conf->kmgarchiged->enabled = 0;
        }
        $this->dictionnaries = array();
        /* Example:
          if (! isset($conf->kmgarchiged->enabled)) $conf->kmgarchiged->enabled=0;	// This is to avoid warnings
          $this->dictionnaries=array(
          'langs'=>'kmgarchiged@kmgarchiged',
          'tabname'=>array(MAIN_DB_PREFIX."table1",MAIN_DB_PREFIX."table2",MAIN_DB_PREFIX."table3"),		// List of tables we want to see into dictonnary editor
          'tablib'=>array("Table1","Table2","Table3"),													// Label of tables
          'tabsql'=>array('SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table1 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table2 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table3 as f'),	// Request to select fields
          'tabsqlsort'=>array("label ASC","label ASC","label ASC"),																					// Sort order
          'tabfield'=>array("code,label","code,label","code,label"),																					// List of fields (result of select to show dictionnary)
          'tabfieldvalue'=>array("code,label","code,label","code,label"),																				// List of fields (list of fields to edit a record)
          'tabfieldinsert'=>array("code,label","code,label","code,label"),																			// List of fields (list of fields for insert)
          'tabrowid'=>array("rowid","rowid","rowid"),																									// Name of columns with primary key (try to always name it 'rowid')
          'tabcond'=>array($conf->kmgarchiged->enabled,$conf->kmgarchiged->enabled,$conf->kmgarchiged->enabled)												// Condition to show each dictionnary
          );
         */

        // Boxes
        // Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();   // List of boxes
        $r = 0;
        // Example:
        /*
          $this->boxes[$r][1] = "myboxa.php";
          $r++;
          $this->boxes[$r][1] = "myboxb.php";
          $r++;
         */

        // Permissions
        $this->rights = array();  // Permission array used by this module
        $r = 0;

        // Add here list of permission defined by an id, a label, a boolean and two constant strings.
        // Example:
        // $this->rights[$r][0] = 2000; 				// Permission id (must not be already used)
        // $this->rights[$r][1] = 'Permision label';	// Permission label
        // $this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
        // $this->rights[$r][4] = 'level1';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        // $this->rights[$r][5] = 'level2';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        // $r++;

        $this->rights[$r][0] = $this->numero . str_pad($r, 3, "0", STR_PAD_LEFT);     // Permission id (must not be already used)
        $this->rights[$r][1] = 'R_USE_KMGARCHIGED'; // Permission label
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'kmgarchiged';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'utiliser';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero . str_pad($r, 3, "0", STR_PAD_LEFT);     // Permission id (must not be already used)
        $this->rights[$r][1] = 'R_CONSULT_ARCHIVED'; // Permission label
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'archives';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'consulter';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero . str_pad($r, 3, "0", STR_PAD_LEFT);     // Permission id (must not be already used)
        $this->rights[$r][1] = 'R_DELETE_ARCHIVED'; // Permission label
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'archives';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'supprimer';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero . str_pad($r, 3, "0", STR_PAD_LEFT);     // Permission id (must not be already used)
        $this->rights[$r][1] = 'R_CONFIG_GROUP'; // Permission label
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'configuration';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'config_group';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

        $this->rights[$r][0] = $this->numero . str_pad($r, 3, "0", STR_PAD_LEFT);     // Permission id (must not be already used)
        $this->rights[$r][1] = 'R_CONFIG_USER'; // Permission label
        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
        $this->rights[$r][4] = 'configuration';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $this->rights[$r][5] = 'config_user';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
        $r++;

//        $this->rights[$r][0] = $this->numero.str_pad($r, 3, "0", STR_PAD_LEFT);     // Permission id (must not be already used)
//        $this->rights[$r][1] = 'R_MANAGE_KMGARCHIGED'; // Permission label
//        $this->rights[$r][3] = 0;      // Permission by default for new user (0/1)
//        $this->rights[$r][4] = 'kmgarchiged';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
//        $this->rights[$r][5] = 'gerer';    // In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
//        $r++;
        // Main menu entries
        $this->menus = array();   // List of menus to add
        $r = 0;

        $this->menu[$r] = array('fk_menu' => 0, // Put 0 if this is a top menu
            'type' => 'top', // This is a Top menu entry
            'titre' => 'KMGArchiGED',
            'mainmenu' => 'kmgarchiged',
            'leftmenu' => '1', // Use 1 if you also want to add left menu entries using this descriptor. Use 0 if left menu entries are defined in a file pre.inc.php (old school).
            'url' => '/kmgarchiged/index.php',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->kmgarchiged->kmgarchiged->utiliser', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->kmgarchiged->kmgarchiged->utiliser', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '',
            'user' => 0);    // 0=Menu for internal users, 1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r=0', // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_ATRAITER',
            'mainmenu' => 'kmgarchiged',
            'url' => '/kmgarchiged/index.php',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->kmgarchiged->kmgarchiged->utiliser', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->kmgarchiged->kmgarchiged->utiliser', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r_menu_a_traiter = $r;
        $r++;


        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r=0', // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_ARCHIVES',
            'mainmenu' => 'kmgarchiged',
            'url' => '/kmgarchiged/archives.php',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->kmgarchiged->archives->consulter', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->kmgarchiged->archives->consulter', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r_menu_archives = $r;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r=0', // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS',
            'mainmenu' => 'kmgarchiged',
            'url' => '/kmgarchiged/index.php?action=shortcut',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->kmgarchiged->kmgarchiged->utiliser', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->kmgarchiged->kmgarchiged->utiliser', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r_menu_shortcuts = $r;
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_THIRPARTY',
            'mainmenu' => 'kmgarchiged',
            'url' => '/societe/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->societe->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->societe->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_CONTACT',
            'mainmenu' => 'kmgarchiged',
            'url' => '/contact/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->societe->contact->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->societe->contact->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_PROPAL',
            'mainmenu' => 'kmgarchiged',
            'url' => '/comm/propal/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->propale->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->propale->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_ORDER',
            'mainmenu' => 'kmgarchiged',
            'url' => '/commande/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->commande->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->commande->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_INVOICE',
            'mainmenu' => 'kmgarchiged',
            'url' => '/compta/facture/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->facture->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->facture->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_PROPAL_SUPPLIER',
            'mainmenu' => 'kmgarchiged',
            'url' => '/supplier_proposal/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->supplier_proposal->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->supplier_proposal->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_ORDER_SUPPLIER',
            'mainmenu' => 'kmgarchiged',
            'url' => '/fourn/commande/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->fournisseur->commande->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->fournisseur->commande->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_INVOICE_SUPPLIER',
            'mainmenu' => 'kmgarchiged',
            'url' => '/fourn/facture/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->fournisseur->facture->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->fournisseur->facture->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_PROJECT',
            'mainmenu' => 'kmgarchiged',
            'url' => '/projet/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->projet->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->projet->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_SPECIAL_TAX',
            'mainmenu' => 'kmgarchiged',
            'url' => '/compta/sociales/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->tax->charges->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->tax->charges->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
        $this->menu[$r] = array('fk_menu' => 'r='.$r_menu_shortcuts, // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
            'type' => 'left', // This is a Left menu entry
            'titre' => 'M_SHORTCUTS_NEW_EXPENSE',
            'mainmenu' => 'kmgarchiged',
            'url' => '/expensereport/card.php?action=create',
            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
            'position' => 100,
            'enabled' => '$user->rights->expensereport->creer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
            'perms' => '$user->rights->expensereport->creer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
            'target' => '_blank',
            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
        $r++;

        // Example to declare a Left Menu entry:
//        $this->menu[$r] = array('fk_menu' => 'r=0', // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
//            'type' => 'left', // This is a Left menu entry
//            'titre' => 'Configuration',
//            'mainmenu' => 'kmgarchiged',
//            'url' => '/kmgarchiged/index.php',
//            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
//            'position' => 100,
//            'enabled' => '$user->rights->kmgarchiged->kmgarchiged->gerer', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
//            'perms' => '$user->rights->kmgarchiged->kmgarchiged->gerer', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
//            'target' => '',
//            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
//        $r_menu_configuration = $r;
//        $r++;
        // Example to declare a Left Menu entry:
//        $this->menu[$r] = array('fk_menu' => 'r=0', // Use r=value where r is index key used for the parent menu entry (higher parent must be a top menu entry)
//            'type' => 'left', // This is a Left menu entry
//            'titre' => 'Dispatch',
//            'mainmenu' => 'kmgarchiged',
//            'url' => '/kmgarchiged/index.php',
//            'langs' => 'kmgarchiged@kmgarchiged', // Lang file to use (without .lang) by module. File must be in langs/code_CODE/ directory.
//            'position' => 100,
//            'enabled' => '$user->rights->kmgarchiged->dispatch->utiliser', // Define condition to show or hide menu entry. Use '$conf->monmodule->enabled' if entry must be visible if module is enabled.
//            'perms' => '$user->rights->kmgarchiged->dispatch->utiliser', // Use 'perms'=>'$user->rights->monmodule->level1->level2' if you want your menu with a permission rules
//            'target' => '',
//            'user' => 0);    // 0=Menu for internal users,1=external users, 2=both
//        $r_menu_dispatch = $r;
//        $r++;
        // Exports
        $r = 1;

        // Example:
        // $this->export_code[$r]=$this->rights_class.'_'.$r;
        // $this->export_label[$r]='CustomersInvoicesAndInvoiceLines';	// Translation key (used only if key ExportDataset_xxx_z not found)
        // $this->export_enabled[$r]='1';                               // Condition to show export in list (ie: '$user->id==3'). Set to 1 to always show when module is enabled.
        // $this->export_permission[$r]=array(array("facture","facture","export"));
        // $this->export_fields_array[$r]=array('s.rowid'=>"IdCompany",'s.nom'=>'CompanyName','s.address'=>'Address','s.cp'=>'Zip','s.ville'=>'Town','s.fk_pays'=>'Country','s.tel'=>'Phone','s.siren'=>'ProfId1','s.siret'=>'ProfId2','s.ape'=>'ProfId3','s.idprof4'=>'ProfId4','s.code_compta'=>'CustomerAccountancyCode','s.code_compta_fournisseur'=>'SupplierAccountancyCode','f.rowid'=>"InvoiceId",'f.facnumber'=>"InvoiceRef",'f.datec'=>"InvoiceDateCreation",'f.datef'=>"DateInvoice",'f.total'=>"TotalHT",'f.total_ttc'=>"TotalTTC",'f.tva'=>"TotalVAT",'f.paye'=>"InvoicePaid",'f.fk_statut'=>'InvoiceStatus','f.note'=>"InvoiceNote",'fd.rowid'=>'LineId','fd.description'=>"LineDescription",'fd.price'=>"LineUnitPrice",'fd.tva_tx'=>"LineVATRate",'fd.qty'=>"LineQty",'fd.total_ht'=>"LineTotalHT",'fd.total_tva'=>"LineTotalTVA",'fd.total_ttc'=>"LineTotalTTC",'fd.date_start'=>"DateStart",'fd.date_end'=>"DateEnd",'fd.fk_product'=>'ProductId','p.ref'=>'ProductRef');
        // $this->export_entities_array[$r]=array('s.rowid'=>"company",'s.nom'=>'company','s.address'=>'company','s.cp'=>'company','s.ville'=>'company','s.fk_pays'=>'company','s.tel'=>'company','s.siren'=>'company','s.siret'=>'company','s.ape'=>'company','s.idprof4'=>'company','s.code_compta'=>'company','s.code_compta_fournisseur'=>'company','f.rowid'=>"invoice",'f.facnumber'=>"invoice",'f.datec'=>"invoice",'f.datef'=>"invoice",'f.total'=>"invoice",'f.total_ttc'=>"invoice",'f.tva'=>"invoice",'f.paye'=>"invoice",'f.fk_statut'=>'invoice','f.note'=>"invoice",'fd.rowid'=>'invoice_line','fd.description'=>"invoice_line",'fd.price'=>"invoice_line",'fd.total_ht'=>"invoice_line",'fd.total_tva'=>"invoice_line",'fd.total_ttc'=>"invoice_line",'fd.tva_tx'=>"invoice_line",'fd.qty'=>"invoice_line",'fd.date_start'=>"invoice_line",'fd.date_end'=>"invoice_line",'fd.fk_product'=>'product','p.ref'=>'product');
        // $this->export_sql_start[$r]='SELECT DISTINCT ';
        // $this->export_sql_end[$r]  =' FROM ('.MAIN_DB_PREFIX.'facture as f, '.MAIN_DB_PREFIX.'facturedet as fd, '.MAIN_DB_PREFIX.'societe as s)';
        // $this->export_sql_end[$r] .=' LEFT JOIN '.MAIN_DB_PREFIX.'product as p on (fd.fk_product = p.rowid)';
        // $this->export_sql_end[$r] .=' WHERE f.fk_soc = s.rowid AND f.rowid = fd.fk_facture';
        // $r++;
    }

    /**
     * 		Function called when module is enabled.
     * 		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
     * 		It also creates data directories
     *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
     *      @return     int             	1 if OK, 0 if KO
     */
    function init($options = '') {
        $sql = array();

        $result = $this->load_tables();

        return $this->_init($sql, $options);
    }

    /**
     * 		Function called when module is disabled.
     *      Remove from database constants, boxes and permissions from Dolibarr database.
     * 		Data directories are not deleted
     *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
     *      @return     int             	1 if OK, 0 if KO
     */
    function remove($options = '') {
        $sql = array();

        return $this->_remove($sql, $options);
    }

    /**
     * 		Create tables, keys and data required by module
     * 		Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
     * 		and create data commands must be stored in directory /kmgarchiged/sql/
     * 		This function is called by this->init
     *
     * 		@return		int		<=0 if KO, >0 if OK
     */
    function load_tables() {
        return $this->_load_tables('/kmgarchiged/sql/');
    }

}

?>
