<?php

/* Copyright (C) 2011-      Kevin Guerrier <guerrier.k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

if (!defined('NOTOKENRENEWAL'))
    define('NOTOKENRENEWAL', 1); // Disables token renewal
if (!defined('NOREQUIREMENU'))
    define('NOREQUIREMENU', '1');
if (!defined('NOREQUIREHTML'))
    define('NOREQUIREHTML', '1');
if (!defined('NOREQUIREAJAX'))
    define('NOREQUIREAJAX', '1');
if (!defined('NOREQUIRESOC'))
    define('NOREQUIRESOC', '1');
if (!defined('NOCSRFCHECK'))
    define('NOCSRFCHECK', '1');

$res = 0;
if (!$res && file_exists("../main.inc.php"))
    $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php"))
    $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php"))
    $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php"))
    $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res)
    die("Include of main fails");

if (!$user->rights->kmgarchiged->kmgarchiged->utiliser)
    accessforbidden();


$langs->load("kmgarchiged@kmgarchiged");

/*
 * View
 */

top_httphead();

dol_syslog("GET is " . join(',', $_GET));
if (!empty($_GET['reference_' . $_GET['num_ligne']])) {
    $return_arr = array();

    $reference = $_GET['reference_' . $_GET['num_ligne']] ? $_GET['reference_' . $_GET['num_ligne']] : '';
    // Recherche parmis les societes
    $sql = "SELECT s.rowid as rowid, CONCAT_WS(' - ', s.code_client, s.code_fournisseur) as reference, s.nom as nom_societe, 'societe' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "societe as s";
    $sql .= " WHERE ";
    $sql .= " (s.rowid LIKE '" . $db->escape($reference) . "%' OR s.code_client LIKE '%" . $db->escape($reference) . "%' OR s.nom LIKE '%" . $db->escape($reference) . "%' OR s.code_fournisseur LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les banques
    $sql .= "SELECT b.ref as rowid, b.ref as reference, b.label as label, 'banque' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "bank_account as b";
    $sql .= " WHERE ";
    $sql .= " (b.rowid LIKE '" . $db->escape($reference) . "%' OR b.ref LIKE '%" . $db->escape($reference) . "%' OR b.label LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les propales clients
    $sql .= "SELECT p.ref as rowid, CONCAT_WS(' - ', p.ref, p.ref_client) as reference, s.nom as nom_societe, 'propal' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "propal as p";
    $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe as s on s.rowid = p.fk_soc ";
    $sql .= " WHERE ";
    $sql .= " (p.rowid LIKE '" . $db->escape($reference) . "%' OR p.ref LIKE '%" . $db->escape($reference) . "%' OR p.ref_client LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les commandes clients
    $sql .= "SELECT c.ref as rowid, CONCAT_WS(' - ', c.ref, c.ref_client) as reference, s.nom as nom_societe, 'commande' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "commande as c";
    $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe as s on s.rowid = c.fk_soc ";
    $sql .= " WHERE ";
    $sql .= " (c.rowid LIKE '" . $db->escape($reference) . "%' OR c.ref LIKE '%" . $db->escape($reference) . "%' OR c.ref_client LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les factures clients
    $sql .= "SELECT f.ref as rowid, CONCAT_WS(' - ', f.ref, f.ref_client) as reference, s.nom as nom_societe, 'facture' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "facture as f";
    $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe as s on s.rowid = f.fk_soc ";
    $sql .= " WHERE ";
    $sql .= " (f.rowid LIKE '" . $db->escape($reference) . "%' OR f.ref LIKE '%" . $db->escape($reference) . "%' OR f.ref_client LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les commandes fournisseurs
    $sql .= "SELECT c.rowid as rowid, CONCAT_WS(' - ', c.ref, c.ref_supplier) as reference, s.nom as nom_societe, 'commande_fournisseur' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "commande_fournisseur as c";
    $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe as s on s.rowid = c.fk_soc ";
    $sql .= " WHERE ";
    $sql .= " (c.rowid LIKE '" . $db->escape($reference) . "%' OR c.ref LIKE '%" . $db->escape($reference) . "%' OR c.ref_supplier LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les factures fournisseurs
    $sql .= "SELECT f.rowid as rowid, f.ref_supplier as reference, s.nom as nom_societe, 'facture_fournisseur' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "facture_fourn as f";
    $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe as s on s.rowid = f.fk_soc ";
    $sql .= " WHERE ";
    $sql .=" (f.rowid LIKE '" . $db->escape($reference) . "%' OR f.ref LIKE '%" . $db->escape($reference) . "%' OR f.ref_supplier LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les projets
    $sql .= "SELECT p.ref as rowid, p.ref as reference, p.title as nom_societe, 'projet' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "projet as p";
    $sql .= " WHERE ";
    $sql .=" (p.ref LIKE '" . $db->escape($reference) . "%' OR p.title LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les tâches des projets
    $sql .= "SELECT CONCAT(p.ref,'/',pt.rowid) as rowid, p.ref as reference, pt.label as nom_societe, 'tache' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "projet_task as pt";
    $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "projet as p on p.rowid = pt.fk_projet ";
    $sql .= " WHERE ";
    $sql .=" (p.ref LIKE '" . $db->escape($reference) . "%' OR p.title LIKE '%" . $db->escape($reference) . "%' OR pt.label LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " UNION ";
    // Recherche parmis les charges sociales
    $sql .= "SELECT c.rowid as rowid, '' as reference, c.libelle as nom_societe, 'chargesociales' as type_element";
    $sql .= " FROM " . MAIN_DB_PREFIX . "chargesociales as c";
    $sql .= " WHERE ";
    $sql .= " (c.rowid LIKE '" . $db->escape($reference) . "%' OR c.libelle LIKE '%" . $db->escape($reference) . "%')";

    // TODO HOOK MODULE

    $sql .= " ORDER BY reference, nom_societe";

    $sql .= $db->plimit(50); // Avoid pb with bad criteria
    $resql = $db->query($sql);
    if ($resql) {
        while ($row = $db->fetch_array($resql)) {
            $row_array['label'] = $langs->trans($row['type_element']) . ' : ';
            if ($row['reference'] != "")
                $row_array['label'] .= $row['reference'] . ' / ';
            $row_array['label'] .= $row['nom_societe'];
            if ($row['reference'] == "")
                $row_array['value'] = $row['nom_societe'];
            else
                $row_array['value'] = $row['reference'];
            $row_array['reference_type_element_' . $_GET['num_ligne']] = $row['type_element'];
            $row_array['reference_fk_id_' . $_GET['num_ligne']] = $row['rowid'];

            array_push($return_arr, $row_array);
        }
    }

    echo json_encode($return_arr);
} else {
    
}
