<?php

/* Copyright (C) 2011-      Kevin Guerrier <guerrier.k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

if (!defined('NOTOKENRENEWAL'))
    define('NOTOKENRENEWAL', 1); // Disables token renewal
if (!defined('NOREQUIREMENU'))
    define('NOREQUIREMENU', '1');
if (!defined('NOREQUIREHTML'))
    define('NOREQUIREHTML', '1');
if (!defined('NOREQUIREAJAX'))
    define('NOREQUIREAJAX', '1');
if (!defined('NOREQUIRESOC'))
    define('NOREQUIRESOC', '1');
if (!defined('NOCSRFCHECK'))
    define('NOCSRFCHECK', '1');

$res = 0;
if (!$res && file_exists("../main.inc.php"))
    $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php"))
    $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php"))
    $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php"))
    $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res)
    die("Include of main fails");

/*
 * View
 */
top_httphead();

if (!$user->rights->kmgarchiged->kmgarchiged->utiliser)
    accessforbidden();

$langs->load("kmgarchiged@kmgarchiged");

dol_syslog("GET is " . join(',', $_GET));
if (!empty($_GET['destinataire_' . $_GET['num_ligne']])) {
    $return_arr = array();

    $reference = $_GET['destinataire_' . $_GET['num_ligne']] ? $_GET['destinataire_' . $_GET['num_ligne']] : '';
    // Recherche parmis les contacts
    $sql = "SELECT c.rowid as rowid, s.rowid as socid, s.nom as societe, c.lastname as nom, c.firstname as prenom, c.email, '' as userid ";
    $sql .= " FROM " . MAIN_DB_PREFIX . "socpeople as c";
    $sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe as s on s.rowid = c.fk_soc ";
    $sql .= " WHERE ";
    $sql .=" (s.nom LIKE '%" . $db->escape($reference) . "%' ";
    $sql .=" OR c.lastname LIKE '%" . $db->escape($reference) . "%' OR c.firstname LIKE '%" . $db->escape($reference) . "%' OR c.email LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " AND c.email IS NOT NULL AND c.email <> '' ";
    $sql .= " UNION ";
    // Recherche parmis les societes
    $sql .= "SELECT '' as rowid, s.rowid as socid, 'Tiers' as societe, s.nom as nom, '' as prenom, s.email, '' as userid ";
    $sql .= " FROM " . MAIN_DB_PREFIX . "societe as s";
    $sql .= " WHERE ";
    $sql .=" (s.nom LIKE '%" . $db->escape($reference) . "%' ";
    $sql .=" OR s.email LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " AND s.email IS NOT NULL AND s.email <> '' ";
    $sql .= " UNION ";
    // Recherche parmis les utilisateurs
    $sql .= "SELECT '' as rowid, '' as socid, 'Utilisateur' as societe, u.lastname as nom, u.firstname as prenom, u.email, u.rowid as userid ";
    $sql .= " FROM " . MAIN_DB_PREFIX . "user as u";
    $sql .= " WHERE ";
    $sql .=" (u.lastname LIKE '%" . $db->escape($reference) . "%' OR u.firstname LIKE '%" . $db->escape($reference) . "%' OR u.email LIKE '%" . $db->escape($reference) . "%')";
    $sql .= " AND u.email IS NOT NULL AND u.email <> '' ";
    $sql .= " ORDER BY societe, nom, prenom";

    $sql .= $db->plimit(50); // Avoid pb with bad criteria

    $resql = $db->query($sql);
    if ($resql) {
        while ($row = $db->fetch_array($resql)) {
            $row_array['label'] = $row['nom'] . ' ' . $row['prenom'];
            if ($row['societe'] != "")
                $row_array['label'] .= ' (' . $row['societe'] . ')';
            if ($row['email'] != "")
                $row_array['label'] .= ' - ' . $row['email'] . ' ';
            $row_array['value'] = $row_array['label'];
            $row_array['destinataire_id_' . $_GET['num_ligne']] = $row['rowid'];
            $row_array['destinataire_socid_' . $_GET['num_ligne']] = $row['socid'];
            $row_array['destinataire_userid_' . $_GET['num_ligne']] = $row['userid'];
            $row_array['destinataire_email_' . $_GET['num_ligne']] = $row['email'];

            array_push($return_arr, $row_array);
        }
    }

    echo json_encode($return_arr);
} else {
    
}