# Module Dolibarr - KMGArchiGED
version 2.1 - 26/01/2010
Compatible Dolibarr >= 10.0

## Préambule
Le module KMGArchiGED  a été développé pour permettre la gestion des documents entrants au sein d’une structure, leur réception depuis un périphérique de numérisation gérant l’envoi via FTP, leur transmission par email, leur liaison auprès d’éléments natifs de Dolibarr, ainsi que leur archivage.


## Installation 
L’archive d’installation contient un dossier kmgarchiged comprenant l’ensemble des fichiers nécessaire au bon fonctionnement du module. Pour que le module puisse être activé dans l’interface de configuration des modules, il faut copier ce dossier kmgarchiged soit dans le répertoire htdocs, soit dans le répertoire htdocs/custom. 

```
A noter que l’utilisation du répertoire htdocs/custom nécessite que les variables 
$dolibarr_main_url_root_alt 
et 
$dolibarr_main_document_root_alt 
soient correctement renseignées.
```

Une fois ce dossier transmis, le module peut-être activé depuis l’interface de configuration des modules de votre instance Dolibarr (Accueil > Configuration > Modules).


## Configuration
Une fois le module installé, l’accès à la configuration se fait par l’icône .
### Section Types d'événement
Le module KMGArchiGED génère automatiquement des événements dans l’agenda lors du traitement d’un document par un utilisateur. Il est possible de créer des codes d’événement spécifiques pour la suppression, la liaison, la notification d’un document depuis le module, ou encore pour la réception d’un document dans le module. Si ces types d'événements ne sont pas présents dans votre instance de Dolibarr, il est possible de le créer en utilisant le bouton “Ajouter”. A défaut, le type d’événement AC_OTH_AUTO, qui définit les “Évènements insérés automatiquement” sera utilisé.

### Section Email
Si l’envoi par mail est correctement configuré sur votre instance Dolibarr, il est possible de transmettre un document présent dans une bannette par mail. Les informations pré-remplies sont personnalisables dans cette section. Dans tous les cas, l’utilisateur peut modifier les éléments avant chaque envoi. 

### Section Outils
Le module KMGArchiGED utilise des fonctions externes au moteur de Dolibarr et nécessite donc l’utilisation d’outils externes.
A ce jour, il n’y a que la commande convert qui est utilisée, notamment afin de générer les images d’aperçu d’un document. Cette commande est présente sur la majorité des hébergements. Si vous rencontrez un problème d’affichage de l’aperçu d’un document lors de la consultation d’une bannette, merci de vérifier que la commande convert est bien trouvée par le module dans cette section.

Si cette commande n’est pas trouvée, il est nécessaire de l’installer (ou de l’activer) sur votre serveur. Si, malgré cela, le problème persiste, merci de contacter notre support. 

### Section Liens pour envoi direct par FTP
Cette section détaille les chemins relatifs aux différentes bannettes disponibles, informations nécessaires à la configuration de périphériques réseau pour la transmission de documents via FTP (voir ci-dessous : Fonctionnalités > Transmission d’un document via FTP). Ils doivent bien sûr être adaptés selon votre configuration.

## Fonctionnalités
### Accès aux bannettes virtuelles
Les documents peuvent être transmis dans une “bannette virtuelle”. L’accès à chacune de ces bannette est subordonné à des permissions des modules Dolibarr. Par défaut, les bannettes suivantes sont disponibles :

Bannette virtuelle : Module / Permission
* Factures Fournisseurs : Fournisseurs / Consulter les factures fournisseur
* Documents Sociaux : Dépenses spéciales / Lire les charges fiscales ou sociales et paiement de TVA
* Impôts et taxes : Dépenses spéciales / Lire les charges fiscales ou sociales et paiement de TVA
* Documents Bancaires : Banques et caisses / Consulter les comptes financiers
* Autres : KMGArchiGED / Utiliser Kmgarchiged

Il est également possible de définir une bannette virtuelle pour chaque utilisateur, ainsi que pour chaque groupe. 
Un onglet dédié à ces paramétrages est disponible depuis la fiche utilisateur > "Configuration KMGArchiGED"

A noter que le rôle administrateur permet l’accès à l’ensemble des bannettes virtuelles.

Si vous pensez à d’autres bannettes ou si votre fonctionnement nécessite l’utilisation de bannettes spécifiques, n’hésitez pas à nous contacter.

### Transmission d’un document via FTP
Cette fonctionnalité nécessite que le répertoire document ainsi que son contenu soient accessibles via FTP. Cette fonctionnalité est accessible pour la majorité des hébergements. Les informations de connexion (adresse d’accès, utilisateur et mot de passe) seront nécessaires pour configurer le périphérique de numérisation (Copieur, Imprimante multifonctions, Scanner réseau, …).
Il est possible de paramétrer des raccourcis pour une bannette virtuelle en adaptant le chemin d’accès. 

Vous trouverez ci-après un exemple de configuration pour un raccourci direct vers les “Factures fournisseurs”.

```
Informations concernant la connexion FTP
* Adresse du serveur FTP : 	ftp.mon-serveur.net
* Nom d’utilisateur : 		monUser
* Mot de passe : 		monPass
* Racine FTP : 			Dans le dossier contenant les répertoires htdocs et documents de Dolibarr
```

### Configuration du raccourci (issu d’un Xerox WorkCentre 6515DN MFP)

```
* Nom d'hôte :  ftp.mon-serveur.net
* Chemin du document : /documents/kmgarchiged/SupplierInvoices
* Nom de connexion : monUser
* Mot de passe : monPass
* Confirmer le mot de passe : monPass
```

Comme vu précédemment, les informations relatives aux différentes bannettes disponibles sont précisées dans la page de configuration du module. Ils doivent bien sûr être adaptés selon votre configuration.

Le module KMGArchiGED est prévu pour fonctionner avec les fichiers au format PDF. La plein compatibilité du module avec l’utilisation d’autres formats n’est pas garantie. Si vous souhaitez prendre en charge des types de fichiers particuliers, n’hésitez pas à nous contacter.

### Transmission d’un document via upload direct
L’interface principale du module liste les bannettes disponibles pour l’utilisateur en fonction de ces droits. Pour chacune de ces bannettes, la liste des documents présents est affichée, et sous cette liste,  une section permet à l’utilisateur d’ajouter un nouveau document.

## Consultation et gestion des documents d’une bannette
Un document présent dans une bannette est affiché de la manière suivante : 

* Le lien de prévisualisation du document complet (icone fichier avec loupe) ainsi que la date à laquelle le document à été vu pour la première fois par le module sont affichés en entête. Une image représentant le premier tiers de la première page du document est affichée en dessous, suivie de la liste des événements déjà réalisés pour ce document.
* La partie droite permet : 
** de transmettre par email le document à un tiers, à un contact, à un utilisateur, ou directement à une adresse mail. Le sujet et le corps du mail sont pré-remplis et peuvent être ajustés par l’utilisateur avant envoi. Dans le cas où le document est transmis à un utilisateur ayant accès au module KMGArchiGED, un lien direct permettant d’accéder au document et au module est ajouté dans le corps du mail ;
    * de lier le document à un élément natif de Dolibarr (parmis Tiers, Banque, Propale Client, Commande Client, Facture Client, Commande Fournisseur, Facture Fournisseur, Projet, Tâche, Charge Sociale), avec la possibilité de le renommer au passage (l’extension ne doit pas être précisée dans le nouveau nom. Elle est reprise automatiquement) ;
    * d’archiver un document pour lequel plus aucune action n’est requise et dont la conservation dans les archives du module est souhaitée ;
    * de supprimer un document pour lequel plus aucune action n’est requise dont la conservation dans les archives du module n’est pas souhaitée ;

Si vous souhaitez lier un document à d’autres types d’éléments (natifs ou issus d’un module externe) ou si vous souhaitez une autre fonctionnalité, n’hésitez pas à nous contacter.


## Consultation des documents archivés
Une fois archivé, les documents sont accessibles depuis le menu KMGArchiGED > Archives. Cette interface liste les documents en fonction de la période à laquelle ils ont été reçus dans le module (filtre au trimestre, scindé par semaine et par bannette).

Les documents sont listés les uns en dessous des autre, et sont précédés d’un lien de prévisualisation du document complet (icone fichier avec loupe). Le nom du document est cliquable afin de télécharger directement le fichier.
A noter que les bannettes disponibles dépendent également des permissions accordées à l’utilisateur.
Depuis la version 1.51, il est maintenant possible de supprimer un document archivé. Cette fonctionnalitée est soumise à une permission spécifique et doit être activée pour l'utilisateur.

Si vous souhaitez réaliser des actions complémentaires au sein de ces archives ou si vous souhaitez une autre fonctionnalité, n’hésitez pas à nous contacter.


## Développement & Support
Ce module est développé et maintenu par Kevin GUERRIER. Toute demande de renseignement, question technique, proposition d’amélioration, remontée d’anomalie, … doit être transmise par mail à l’adresse support@kmg-process.com.
