<?php
/* Copyright (C) 2020 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file		lib/keepalive.lib.php
 *	\ingroup	keepalive
 *	\brief		This file is an example module library
 *				Put some comments here
 */

/**
 * @return array
 */
function keepaliveAdminPrepareHead()
{
    global $langs, $conf;

    $langs->load('keepalive@keepalive');

    $h = 0;
    $head = array();

    $head[$h][0] = dol_buildpath("/keepalive/admin/keepalive_setup.php", 1);
    $head[$h][1] = $langs->trans("Parameters");
    $head[$h][2] = 'settings';
    $h++;

    $head[$h][0] = dol_buildpath("/keepalive/admin/keepalive_about.php", 1);
    $head[$h][1] = $langs->trans("About");
    $head[$h][2] = 'about';
    $h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    //$this->tabs = array(
    //	'entity:+tabname:Title:@keepalive:/keepalive/mypage.php?id=__ID__'
    //); // to add new tab
    //$this->tabs = array(
    //	'entity:-tabname:Title:@keepalive:/keepalive/mypage.php?id=__ID__'
    //); // to remove a tab
    complete_head_from_modules($conf, $langs, $object, $head, $h, 'keepalive');

    return $head;
}

/**
 * Return array of tabs to used on pages for third parties cards.
 *
 * @param 	KeepAlive	$object		Object company shown
 * @return 	array				Array of tabs
 */
function keepalive_prepare_head(KeepAlive $object)
{
    global $langs, $conf;
    $h = 0;
    $head = array();
    $head[$h][0] = dol_buildpath('/keepalive/card.php', 1).'?id='.$object->id;
    $head[$h][1] = $langs->trans("KeepAliveCard");
    $head[$h][2] = 'card';
    $h++;

	// Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@keepalive:/keepalive/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname:Title:@keepalive:/keepalive/mypage.php?id=__ID__');   to remove a tab
    complete_head_from_modules($conf, $langs, $object, $head, $h, 'keepalive');

	return $head;
}

/**
 * @param Form      $form       Form object
 * @param KeepAlive  $object     KeepAlive object
 * @param string    $action     Triggered action
 * @return string
 */
function getFormConfirmKeepAlive($form, $object, $action)
{
    global $langs, $user;

    $formconfirm = '';

    if ($action === 'valid' && !empty($user->rights->keepalive->write))
    {
        $body = $langs->trans('ConfirmValidateKeepAliveBody', $object->ref);
        $formconfirm = $form->formconfirm($_SERVER['PHP_SELF'] . '?id=' . $object->id, $langs->trans('ConfirmValidateKeepAliveTitle'), $body, 'confirm_validate', '', 0, 1);
    }
    elseif ($action === 'accept' && !empty($user->rights->keepalive->write))
    {
        $body = $langs->trans('ConfirmAcceptKeepAliveBody', $object->ref);
        $formconfirm = $form->formconfirm($_SERVER['PHP_SELF'] . '?id=' . $object->id, $langs->trans('ConfirmAcceptKeepAliveTitle'), $body, 'confirm_accept', '', 0, 1);
    }
    elseif ($action === 'refuse' && !empty($user->rights->keepalive->write))
    {
        $body = $langs->trans('ConfirmRefuseKeepAliveBody', $object->ref);
        $formconfirm = $form->formconfirm($_SERVER['PHP_SELF'] . '?id=' . $object->id, $langs->trans('ConfirmRefuseKeepAliveTitle'), $body, 'confirm_refuse', '', 0, 1);
    }
    elseif ($action === 'reopen' && !empty($user->rights->keepalive->write))
    {
        $body = $langs->trans('ConfirmReopenKeepAliveBody', $object->ref);
        $formconfirm = $form->formconfirm($_SERVER['PHP_SELF'] . '?id=' . $object->id, $langs->trans('ConfirmReopenKeepAliveTitle'), $body, 'confirm_refuse', '', 0, 1);
    }
    elseif ($action === 'delete' && !empty($user->rights->keepalive->write))
    {
        $body = $langs->trans('ConfirmDeleteKeepAliveBody');
        $formconfirm = $form->formconfirm($_SERVER['PHP_SELF'] . '?id=' . $object->id, $langs->trans('ConfirmDeleteKeepAliveTitle'), $body, 'confirm_delete', '', 0, 1);
    }
    elseif ($action === 'clone' && !empty($user->rights->keepalive->write))
    {
        $body = $langs->trans('ConfirmCloneKeepAliveBody', $object->ref);
        $formconfirm = $form->formconfirm($_SERVER['PHP_SELF'] . '?id=' . $object->id, $langs->trans('ConfirmCloneKeepAliveTitle'), $body, 'confirm_clone', '', 0, 1);
    }
    elseif ($action === 'cancel' && !empty($user->rights->keepalive->write))
    {
        $body = $langs->trans('ConfirmCancelKeepAliveBody', $object->ref);
        $formconfirm = $form->formconfirm($_SERVER['PHP_SELF'] . '?id=' . $object->id, $langs->trans('ConfirmCancelKeepAliveTitle'), $body, 'confirm_cancel', '', 0, 1);
    }

    return $formconfirm;
}
