<?php
/**
 * Hosting module library
 *
 * Copyright (C) 2010-2011 Regis Houssin  <regis@dolibarr.fr>
 * Copyright (C) 2011-2018 Jean-François Ferry    <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * or see http://www.gnu.org/
 *
 * @package    hosting
 *
 */

/**
 * Return array head with list of tabs to view object informations
 * @param unknown $object
 * @deprecated
 * @see hostPrepareHead
 */
function hosting_prepare_head($object) {
    return hostPrepareHead($object);
}
/**
 * Return array head with list of tabs to view object informations
 *
 * @param     Object    $object    Host object
 * @return    array    Tabs definition
 */
function hostPrepareHead($object)
{

    global $langs, $conf, $user;
    $langs->load("hosting2@hosting2");
    
    $h = 0;
    $head = array();
    $head[$h][0] = dol_buildpath('/hosting/host_card.php', 1) . '?id=' . $object->id;
    $head[$h][1] = $langs->trans("HostCard");
    $head[$h][2] = 'card';
    $h++;
    
    $head[$h][0] = dol_buildpath('/hosting/host_extensions.php', 1) . '?id=' . $object->id;
    $head[$h][1] = $langs->trans("HostExtensions");
    $nbExtensions = 0;
    $sql = "SELECT COUNT(n.rowid) as nb";
    $sql.= " FROM ".MAIN_DB_PREFIX."host_def as n";
    $sql.= " WHERE fk_host = '".$object->id."'";
    $resql=$object->db->query($sql);
    if ($resql)
    {
        $num = $object->db->num_rows($resql);
        $i = 0;
        while ($i < $num)
        {
            $obj = $object->db->fetch_object($resql);
            $nbExtensions=$obj->nb;
            $i++;
        }
    }
    else {
        dol_print_error($object->db);
    }
    if ($nbExtensions > 0) $head[$h][1].= ' <span class="badge">'.$nbExtensions.'</span>';
    $head[$h][2] = 'extensions';
    $h++;

    
    if (isset($object->fields['note_public']) || isset($object->fields['note_private']))
    {
        $nbNote = 0;
        if (!empty($object->note_private)) $nbNote++;
        if (!empty($object->note_public)) $nbNote++;
        $head[$h][0] = dol_buildpath('/hosting/host_note.php', 1).'?id='.$object->id;
        $head[$h][1] = $langs->trans('Notes');
        if ($nbNote > 0) $head[$h][1].= ' <span class="badge">'.$nbNote.'</span>';
        $head[$h][2] = 'note';
        $h++;
    }
    
    require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
    require_once DOL_DOCUMENT_ROOT.'/core/class/link.class.php';
    $upload_dir = $conf->hosting->dir_output . "/host/" . dol_sanitizeFileName($object->id);
    $nbFiles = count(dol_dir_list($upload_dir,'files',0,'','(\.meta|_preview.*\.png)$'));
    $nbLinks=Link::count($object->db, $object->element, $object->id);
    $head[$h][0] = dol_buildpath("/hosting/host_document.php", 1).'?id='.$object->id;
    $head[$h][1] = $langs->trans('Documents');
    if (($nbFiles+$nbLinks) > 0) $head[$h][1].= ' <span class="badge">'.($nbFiles+$nbLinks).'</span>';
    $head[$h][2] = 'document';
    $h++;
    
    $head[$h][0] = dol_buildpath("/hosting/host_agenda.php", 1).'?id='.$object->id;
    $head[$h][1] = $langs->trans("Events");
    $nbEvent = 0;
    $sql = "SELECT COUNT(n.id) as nb";
    $sql.= " FROM ".MAIN_DB_PREFIX."actioncomm as n";
    $sql.= " WHERE elementtype='hosting_host' AND fk_element = ".$object->id;
    $resql=$object->db->query($sql);
    if ($resql)
    {
        $num = $object->db->num_rows($resql);
        $i = 0;
        while ($i < $num)
        {
            $obj = $object->db->fetch_object($resql);
            $nbEvent=$obj->nb;
            $i++;
        }
    }
    else {
        dol_print_error($object->db);
    }
    if ($nbEvent > 0) $head[$h][1].= ' <span class="badge">'.$nbEvent.'</span>';
    $head[$h][2] = 'agenda';
    $h++;
    /*
    $head[$h][0] = dol_buildpath('/ext_hosting/note.php',1).'?id='.$object->id;
    $head[$h][1] = $langs->trans('Notes');
    $head[$h][2] = 'note';
    $h++;
     */
    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('hosting:MyModule:@mymodule:/mymodule/mypage.php?hostid=__ID__');

    complete_head_from_modules($conf, $langs, $object, $head, $h, 'hosting');

    if ($conf->monitoring->enabled) {

        $head[$h][0] = dol_buildpath('/monitoring/alert.php', 1) . '?hostid=' . $object->id;
        $head[$h][1] = $langs->trans("MonitoringAlertsTitle");
        $head[$h][2] = 'tabMonitorAlerts';
        $h++;
    }

    return $head;
}

/**
 *  Return array head with list of tabs into admin view
 *
 *  @deprecated
 *  @param    Object    $object         Host
 *  @return array                   head
 */
function hosting_admin_prepare_head()
{
    return hostingAdminPrepareHead();
}

function hostingAdminPrepareHead()
{
    global $langs, $conf, $user;

    $h = 0;
    $head = array();
    
    $head[$h][0] = dol_buildpath('/hosting/admin/admin_hosting.php', 1);
    $head[$h][1] = $langs->trans("Setup");
    $head[$h][2] = 'settings';
    $h++;

    $head[$h][0] = dol_buildpath('/hosting/admin/hosting_extrafields.php', 1);
    $head[$h][1] = $langs->trans("ExtraFields");
    $head[$h][2] = 'attributes';
    $h++;

    $head[$h][0] = dol_buildpath("/hosting/admin/about.php", 1);
    $head[$h][1] = $langs->trans("About");
    $head[$h][2] = 'about';
    $h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to remove a tab
    complete_head_from_modules($conf, $langs, $object, $head, $h, 'hosting_admin');

    complete_head_from_modules($conf, $langs, $object, $head, $h, 'hosting_admin', 'remove');

    return $head;
}
