<?php
/* Copyright (C) 2011-2016    Jean-François Ferry    <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *       \file       hosting/host/list.php
 *        \ingroup    hosting
 *        \brief        hosts list
 */

$res = '';
if (file_exists("../../main.inc.php")) {
	$res = include "../../main.inc.php"; // For root directory
} elseif (!$res && file_exists("../../../main.inc.php")) {
	$res = include "../../../main.inc.php"; // For "custom" directory
} else {
	die('Error when include main.inc.php');
}


require_once '../class/host.class.php';
require_once '../lib/hosting.lib.php';

require_once DOL_DOCUMENT_ROOT . '/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT . "/core/class/extrafields.class.php";

$extrafields = new ExtraFields($db);
$object = new Host($db);
$form = new Form($db);

// fetch optionals attributes and labels
$extralabels = $extrafields->fetch_name_optionals_label($object->table_element);
$search_array_options = $extrafields->getOptionalsFromPost($extralabels, '', 'search_');

// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("other");
$langs->load("hosting@hosting");

// Get parameters
$id = (GETPOST('id', 'int') ? GETPOST('id', 'int') : GETPOST('hostid', 'int')); // For backward compatibility
$socid = GETPOST('socid', 'int');

$sortfield = GETPOST("sortfield", 'alpha');
$sortorder = GETPOST("sortorder", 'alpha');

if (!$sortfield) {
	$sortfield = 't.date_creation';
}

if (!$sortorder) {
	$sortorder = 'DESC';
}

$limit = $conf->liste_limit;

$page = GETPOST("page", 'int');
if ($page == -1) {
	$page = 0;
}
$offset = $limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;

// Filters
$search_company = GETPOST("search_company", 'alpha');
$search_hostname = GETPOST("search_hostname", 'alpha');
$search_category = GETPOST("search_category", 'alpha');
$search_actif = GETPOST("search_actif", 'int');

$filter = array();
if (!empty($search_company)) {
	$filter['s.nom'] = $search_company;
	$param .= "&search_company=" . $search_company;
}
if (!empty($search_hostname)) {
	$filter['t.label'] = $search_hostname;
}
if (!empty($search_category)) {
	$filter['t.category_code'] = $search_category;
}
if (!empty($search_actif)) {
	$filter['t.category_code'] = $search_actif;
}

// Initialize context for list
$contextpage=GETPOST('contextpage', 'aZ')?GETPOST('contextpage', 'aZ'):'hostlist';

// Add $param from extra fields
foreach ($search_array_options as $key => $val) {
	$crit=$val;
	$tmpkey=preg_replace('/search_options_/', '', $key);
	$typ=$extrafields->attribute_type[$tmpkey];
	if ($val != '') {
		$param.='&search_options_'.$tmpkey.'='.urlencode($val);
	}
	$mode=0;
	if (in_array($typ, array('int','double'))) {
        $mode=1;    // Search on a numeric
    }
	if ($val && ( ($crit != '' && ! in_array($typ, array('select'))) || ! empty($crit))) {
		$filter['ef.'.$tmpkey]=natural_search('ef.'.$tmpkey, $crit, $mode, 1);
	}
}
if (! empty($contextpage) && $contextpage != $_SERVER["PHP_SELF"]) {
    $param.='&contextpage='.$contextpage;
}

// Definition of fields for list
$arrayfields = array(
		't.date_creationc' => array('label' => $langs->trans("Date"), 'checked' => 1),
		't.label' => array('label' => $langs->trans("HostName"), 'checked' => 1),
		't.category_code' => array('label' => $langs->trans("Category"), 'checked' => 1),
		't.actif'=>array('label'=>$langs->trans("Active"), 'checked'=>1, 'position'=>1000),
		't.fk_soc' => array('label' => $langs->trans("Company"), 'checked' => 1)
);

// Extra fields
if (is_array($extrafields->attribute_label) && count($extrafields->attribute_label)) {
	foreach ($extrafields->attribute_label as $key => $val) {
		$typeofextrafield=$extrafields->attribute_type[$key];
		if ($typeofextrafield!='separate') {
			$arrayfields["ef." . $key] = array(
					'label' => $extrafields->attribute_label[$key],
					'checked' => $extrafields->attribute_list[$key],
					'position' => $extrafields->attribute_pos[$key],
					'enabled' => $extrafields->attribute_perms[$key]
			);
		}
	}
}


// Initialize technical object to manage hooks. Note that conf->hooks_modules contains array
$hookmanager->initHooks(array('hostinglist'));


/***************************************************
 * PAGE
 *
 ****************************************************/
$help_url = 'EN:Module_Hosting|FR:Module_Hosting_FR|ES:Module_Hosting_ES';
llxHeader('', $langs->trans("Hosting"), $help_url);

include DOL_DOCUMENT_ROOT . '/core/actions_changeselectedfields.inc.php';


// Do we click on purge search criteria ?
if (GETPOST("button_removefilter_x")) {
	$search_company = '';
	$search_hostname = '';
	$search_category = '';
	$search_actif = '';
	$search_array_options=array();
	$filter=array();
}

/*
 *
 * Liste des hôtes
 *
 */
if ($user->rights->hosting->read) {
	if ($socid) {
		$soc = new Societe($db);
		$result = $soc->fetch($socid);
		if ($result < 0) {
			dol_print_error($db, $soc->error);
			exit;
		}
		$head = societe_prepare_head($soc);
		dol_fiche_head($head, 'tabHosting', $langs->trans("ThirdParty"), 0, 'company');
		
		dol_banner_tab($soc, 'socid', '', ($user->societe_id?0:1), 'rowid', 'nom');
		
		// filter for list
		$filter = array('fk_soc' => $socid);
		
		print '</div>';
	}
	
	$nbtotalofrecords = 0;
	if (empty($conf->global->MAIN_DISABLE_FULL_SCANLIST)) {
		$num_total = $object->fetch_all($sortorder, $sortfield, -1, $offset, 2, $filter);
	}
	$res = $object->fetch_all($sortorder, $sortfield, $limit, $offset, 2, $filter);
	
	$i = 0;
	$total = 0;
	
	if ($res > 0) {
		if ($socid > 0) {
			$param.= '&socid='.$socid;
		}
		
		print_barre_liste($langs->trans('HostsList'), $page, 'list.php', $param, $sortfield, $sortorder, '', $res, $num_total, '../img/host_32.png', 1);
		
		$varpage = empty($contextpage) ? $_SERVER["PHP_SELF"] : $contextpage;
		$selectedfields=$form->multiSelectArrayWithCheckbox('selectedfields', $arrayfields, $varpage);
		
		
		/*
		 * Search bar
		 */
		print '<form method="post" action="' . $_SERVER['PHP_SELF'] . '" name="search_form">' . "\n";
		print '<input type="hidden" name="mode" value="' . $mode . '" >';
		print '<input type="hidden" name="socid" value="' . $socid . '" />';
		print '<input type="hidden" name="formfilteraction" id="formfilteraction" value="list">';
		print '<input type="hidden" name="sortfield" value="' . $sortfield . '">';
		print '<input type="hidden" name="sortorder" value="' . $sortorder . '">';
		print '<input type="hidden" name="contextpage" value="'.$contextpage.'">';
		
		
		print '<table class="liste ' . ($moreforfilter ? "listwithfilterbefore" : "") . '">';
		
		print '<tr class="liste_titre">';
		if (!empty($arrayfields['t.label']['checked'])) {
			print_liste_field_titre($arrayfields['t.label']['label'], $_SERVER["PHP_SELF"], 't.label', '', $param, '', $sortfield, $sortorder);
		}
		if (!empty($arrayfields['t.category_code']['checked'])) {
			print_liste_field_titre($arrayfields['t.category_code']['label'], $_SERVER["PHP_SELF"], 't.category_code', '', $param, '', $sortfield, $sortorder);
		}
		if (!empty($arrayfields['t.datec']['checked'])) {
			print_liste_field_titre($arrayfields['t.datec']['label'], $_SERVER["PHP_SELF"], 't.datec', '', $param, '', $sortfield, $sortorder);
			
			if (!empty($arrayfields['t.actif']['checked'])) {
				print_liste_field_titre($arrayfields['t.actif']['label'], $_SERVER["PHP_SELF"], 't.actif', '', $param, '', $sortfield, $sortorder);
			}
			if (!empty($arrayfields['t.fk_soc']['checked'])) {
				print_liste_field_titre($arrayfields['t.fk_soc']['label'], $_SERVER["PHP_SELF"], 't.fk_soc', '', $param, '', $sortfield, $sortorder);
			}
			// Extra fields
			if (is_array($extrafields->attribute_label) && count($extrafields->attribute_label)) {
				foreach ($extrafields->attribute_label as $key => $val) {
					if (!empty($arrayfields["ef." . $key]['checked'])) {
						$align = $extrafields->getAlignFlag($key);
						print_liste_field_titre($extralabels[$key], $_SERVER["PHP_SELF"], "ef." . $key, "", $param, ($align ? 'align="' . $align . '"' : ''), $sortfield, $sortorder);
					}
				}
			}
			print_liste_field_titre($selectedfields, $_SERVER["PHP_SELF"], "", '', '', 'align="right"', $sortfield, $sortorder, 'maxwidthsearch ');
			print '</tr>';
			
			
			print '<tr class="liste_titre" >';
			
			
			if (!empty($arrayfields['t.label']['checked'])) {
				print '<td class="liste_titre">';
				print '<input type="text" class="flat" name="search_hostname" value="' . $search_hostname . '" size="20">';
				print '</td>';
			}
			
			if (!empty($arrayfields['t.category_code']['checked'])) {
				print '<td class="liste_titre"></td>';
			}
			
			
			if (!empty($arrayfields['t.datec']['checked'])) {
				print '<td class="liste_titre"></td>';
			}
			
			if (!empty($arrayfields['t.actif']['checked'])) {
				print '<td class="liste_titre"></td>';
			}
			
			if (!empty($arrayfields['t.fk_soc']['checked'])) {
				print '<td class="liste_titre">';
				print '<input type="text" class="flat" name="search_company" value="' . $search_company . '" size="20">';
				print '</td>';
			}
			
			if (is_array($extrafields->attribute_label) && count($extrafields->attribute_label)) {
				foreach ($extrafields->attribute_label as $key => $val) {
					if (! empty($arrayfields["ef.".$key]['checked'])) {
						$align=$extrafields->getAlignFlag($key);
						$typeofextrafield=$extrafields->attribute_type[$key];
						print '<td class="liste_titre'.($align?' '.$align:'').'">';
						if (in_array($typeofextrafield, array('varchar', 'int', 'double', 'select'))) {
							$crit=$val;
							$tmpkey=preg_replace('/search_options_/', '', $key);
							$searchclass='';
							if (in_array($typeofextrafield, array('varchar', 'select'))) {
                                $searchclass='searchstring';
                            }
							if (in_array($typeofextrafield, array('int', 'double'))) {
                                $searchclass='searchnum';
                            }
							print '<input class="flat'.($searchclass?' '.$searchclass:'').'" size="4" type="text" name="search_options_'.$tmpkey.'" value="'.dol_escape_htmltag($search_array_options['search_options_'.$tmpkey]).'">';
						}
						print '</td>';
					}
				}
			}
			print '<td class="liste_titre" align="right">';
			$searchpitco=$form->showFilterAndCheckAddButtons(0);
			print $searchpitco;
			print '</td>';
			print '</tr>';
			
			
			if (count($object->line)>0) {
				// Tableau des journées
				foreach ($object->line as $line) {
					$societe = new Societe($db);
					$societe->fetch($line->fk_soc);
					$var = !$var;
					
					$hoststat = new Host($db);
					$hoststat->id = $line->rowid;
					$hoststat->label = $line->label;
					$hoststat->category_label = $line->category_label;
					print "<tr $bc[$var]>";
					
					if (!empty($arrayfields['t.label']['checked'])) {
						print '<td>'. $hoststat->getNomUrl(1) . '</td>';
					}
					if (!empty($arrayfields['t.category_code']['checked'])) {
						print '<td>' . $hoststat->category_label . '</td>';
					}
					if (!empty($arrayfields['t.datec']['checked'])) {
						print '<td>' . dol_print_date($line->datec) . '</td>';
					}
					if (!empty($arrayfields['t.actif']['checked'])) {
						print '<td>' . ($line->actif > 0 ? $langs->trans('Yes') : $langs->trans('No')) . '</td>';
					}
					if (!empty($arrayfields['t.fk_soc']['checked'])) {
						print '<td>' . ($line->fk_soc > 0 ? $societe->getNomUrl(1) : ' ') . '</td>';
					}
					
					// Extra fields
					if (is_array($extrafields->attribute_label) && count($extrafields->attribute_label)) {
						foreach ($extrafields->attribute_label as $key => $val) {
							if (!empty($arrayfields["ef." . $key]['checked'])) {
								print '<td';
								$align = $extrafields->getAlignFlag($key);
								if ($align) {
									print ' align="' . $align . '"';
								}
								print '>';
								$tmpkey = 'options_' . $key;
								print $extrafields->showOutputField($key, $line->$tmpkey, '', 1);
								print '</td>';
							}
						}
					}
					print '<td></td>';
					print '</tr>';
					$i++;
				}
				print '</table>';
				print '</form>';
			} else {
				print '<div class="info">'.$langs->trans('NoHost').'</div>';
			}
			
			/* New host */
			print '<div class="tabsAction">';
			if ($user->rights->hosting->write) {
				print '<div class="inline-block divButAction">';
				print '<a class="butAction" href="'.dol_buildpath('/hosting/host.php', 1).'?action=add' . ($socid ? "&socid=$socid" : "") . '">' . $langs->trans("HostAdd") . '</a>';
				print '</div>';
			}
			print '</div>';
		}
	} else {
		setEventMessage($object->error, 'errors');
	}
}

dol_fiche_end();
llxFooter();
$db->close();
