# php-google-contacts-v3-api

[![StyleCI](https://styleci.io/repos/38814668/shield)](https://styleci.io/repos/38814668)

PHP library for the Google Contacts API (v3)

## Installation & Dependencies

This package and its dependencies can be installed using `composer`. 

Just add the package to your `composer.json` file as follows and run `composer update`.

```json
{
  "require": {
       "rapidwebltd/php-google-contacts-v3-api": "1.*"
   }
}
```

## Setup

1. Install required dependencies. See the 'Dependencies' section above.
2. Copy or rename `.config_blank.json` to `.config.json`. Note the dot (`.`) at the beginning of the file name.
3. Fill in the `clientID`, `clientSecret` and `redirectUri` in `.config.json`.
  * Note that `redirectUri` should be configure to point towards the `redirect-handler.php` file.
  * The `clientID` and `clientSecret` can be found in the Google Developers console at https://console.developers.google.com/ under 'APIs & auth' -> 'Credentials', after enabling the Contacts API.
4. Go to `authorise-application.php` in a web browser. This should give you a URL to authorise your application for Google Contacts.
5. Go to the authorisation URL provided by the previous step.
6. Accept the permissions requested on the page displayed. You should then be redirected back to the `redirect-handler.php` file.
7. The page generated by the `redirect-handler.php` file should then present you with a refresh token. Copy this into your `.config.json`.
8. Setup is done!

## Usage

For extensive usage instructions, please see the blog post I wrote on the subject here: http://www.rapidweb.biz/news/php-library-for-the-google-contacts-api-v3-06102593/

Also, take a look at the following files for basic examples of how to retrieve contacts. They can also be used to ensure you have currently associated your Google account with the library.

* `test.php`
* `test_individual.php`
