<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file		lib/glpitodolibarr.lib.php
 *	\ingroup	glpitodolibarr
 *	\brief		This file is an example module library
 *				Put some comments here
 */


function menu_document($id)
{
    global $langs, $conf, $db;
	dol_include_once('/glpitodolibarr/class/ged_documents.class.php');
	$documents = new ged_documents($db);
    $documents->fetch($id);
    $item = $documents;
    $act = '';
    $action_2 = GETPOST('action_2');
    if($action_2){
    	$act = '&action_2='.$action_2;
    }
    $langs->load("glpitodolibarr@glpitodolibarr");
    $upload_dir = $conf->glpitodolibarr->multidir_output[1].'/'.dol_sanitizeFileName($item->number);
	$nbFiles = count(dol_dir_list($upload_dir, 'files', 0, '', '(\.meta|_preview.*\.png)$'));
	$h = 0;
    $head = array();


 //    $menu='<div class="tabs" data-role="controlgroup" data-type="horizontal">';
	// 		// <!-- id tab = generale -->
	// 	$menu .='<div class="inline-block tabsElem tabsElemActive">';
	// 		$menu .='<div id="tab_general" class="tabactive tab inline-block" ><b>'.$langs->trans("general").'</b></div>';
	// 	$menu .='</div>';

	// 		// <!-- id tab = fichiers -->
	// 	$menu .='<div class="inline-block tabsElem">';
	// 			$menu .='<div id="tab_fichers" class="tabunactive tab inline-block" ><b>'.$langs->trans("Documents").'('.$nbFiles.')</b></div>';
	// 	$menu .='</div>';
	// $menu .='</div>';

        $head[$h][0] = dol_buildpath("/glpitodolibarr/card.php?id=".$id.''.$act, 1);
        $head[$h][1] = $langs->trans("general");
        $head[$h][2] = 'general';
        $h++;

        $head[$h][0] = dol_buildpath("/glpitodolibarr/files.php?id=".$id.''.$act, 1);
        $head[$h][1] = $langs->trans("Documents").'  <span class="badge">'.($nbFiles).'</span>';
        $head[$h][2] = 'Documents';
        $h++;

	return $head;
}


/**
 *  Return array head with list of tabs to view object informations.
 *
 *  @return array               head array with tabs
 */
function glpitodolibarr_prepare_head($object)
{
    global $db, $langs, $conf;

    $h = 0;
    $head = array();

    $head[$h][0] = dol_buildpath("/glpitodolibarr/show_file.php?id=".$object->id, 1);
    $head[$h][1] = $langs->trans('Card');
    $head[$h][2] = 'card';
    $h++;

    $head[$h][0] = dol_buildpath("/glpitodolibarr/files.php?id=".$object->id, 1);
    $head[$h][1] = $langs->trans('Documents');
    $head[$h][2] = 'documents';
    $h++;

    return $head;
}


/**
 *  Return array head with list of tabs to view object informations.
 *
 *  @return array               head array with tabs
 */
function glpitodolibarr_admin_prepare_head()
{
    global $langs, $conf, $user;

    $h = 0;
    $head = array();

    // $head[$h][0] = DOL_URL_ROOT.'/societe/admin/societe.php';
    // $head[$h][1] = $langs->trans("Miscellaneous");
    // $head[$h][2] = 'general';
    // $h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to remove a tab
    // complete_head_from_modules($conf, $langs, null, $head, $h, 'company_admin');

    
    $head[$h][0] = dol_buildpath("/glpitodolibarr/admin/glpitodolibarr_extrafields.php", 1);
    $head[$h][1] = $langs->trans("ExtraFieldsCategories");
    $head[$h][2] = 'attributes';
    $h++;

    // $head[$h][0] = DOL_URL_ROOT.'/societe/admin/contact_extrafields.php';
    // $head[$h][1] = $langs->trans("ExtraFieldsContacts");
    // $head[$h][2] = 'attributes_contacts';
    // $h++;

    // complete_head_from_modules($conf, $langs, null, $head, $h, 'company_admin', 'remove');

    return $head;
}