<?php 
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

dol_include_once('/gestionvehicules/core/modules/modgestionvehicules.class.php');

class gestion_vehicules extends Commonobject{ 
	public $errors = array();
	public $rowid;
	public $matricule; 
	public $type; 
	public $genre; 
	public $date_service; 
	public $date_achat; 
	public $affectation; 
	public $ville; 
	public $photos; 
	public $product_id; 

	public $element='gestion_vehicules';
	public $table_element='gestion_vehicules';

	public function __construct($db){
		$this->db = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/gestionvehicules/card.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@lproduction';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;

        $result = $link."<div class='icon-gestionvehicules1 mainvmenu'></div>  ".$setRef.$linkend;
        return $result;
    }

	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX ."".get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";

		$this->db->begin();
		$resql = $this->db->query($sql);

		if ($echo_sql)
			echo "<br>".$sql."<br>";

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		// return $this->db->db->insert_id;
		return $this->db->last_insert_id(MAIN_DB_PREFIX.$this->table_element);
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		$sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		
		if ($echo_sql) {
			echo "<br>".$sql."<br>";
		}

		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function get_item($item,$rowid)
	{
		$sql = "SELECT ".$item." FROM ".MAIN_DB_PREFIX.get_class($this)." WHERE rowid=".$rowid;

		$resql = $this->db->query($sql);
		$item ;

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$item = $obj->item;
			}
			$this->db->free($resql);
			return $item;
		}
	}

    public function getYears()
    {
    	$sql = 'SELECT YEAR(date_service) as years FROM ' . MAIN_DB_PREFIX.get_class($this);
    	$resql = $this->db->query($sql);
    	$years = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$years[$obj->years] = $obj->years;
			}
			$this->db->free($resql);
    	}

    	return $years;
    }

    public function getmonth($year)
    {
    	$sql = 'SELECT MONTH(date_service) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(date_service) = '.$year;
    	$resql 		 = $this->db->query($sql);
    	$years = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$years[$obj->years] = $obj->years;
			}
			$this->db->free($resql);
    	}

    	return $years;
    }

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		$this->rows = array();
		$resql = $this->db->query($sql);
		//echo $sql;
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 	= $obj->rowid;
				$line->matricule 	= $obj->matricule;
				$line->type 	= $obj->type;
				$line->genre 	= $obj->genre;
				$line->date_service 	= $obj->date_service;
				$line->date_achat 	= $obj->date_achat;
				$line->affectation 	= $obj->affectation;
				$line->ville 	= $obj->ville;
				$line->photos 	= $obj->photos;
				$line->new_or_article 	= $obj->new_or_article;
				$line->product_id 	= $obj->product_id;
				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}


	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 					= $this->db->fetch_object($resql);
				$this->rowid 	= $obj->rowid;
				$this->matricule 	= $obj->matricule;
				$this->type 	= $obj->type;
				$this->genre 	= $obj->genre;
				$this->date_service 	= $obj->date_service;
				$this->date_achat 	= $obj->date_achat;
				$this->affectation 	= $obj->affectation;
				$this->ville 	= $obj->ville;
				$this->photos 	= $obj->photos;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetchRecaps($class,$id_veh,$veh="vehicule")
	{
		$veh_recap = [];
		$sql = 'SELECT * FROM '.MAIN_DB_PREFIX.'gestion_'.$class.' WHERE '.$veh.' = '. $id_veh;
        $resql = $this->db->query($sql);
        while ($obj = $this->db->fetch_object($resql)) {
			$veh_recap[] = $obj;
		}
		// $veh_recap = $this->db->fetch_object($resql);
        $this->db->free($resql);
        return $veh_recap;
	} 

	public function select_all_products($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt.",".$objet." FROM ".MAIN_DB_PREFIX."product";
    	// if (!empty($selected)) {
    	// 	$sql .= " WHERE rowid not in (select v.product_id from llx_gestionvehicules v where v.product_id != ".$selected.")";
    	// }else{
    	// 	$sql .= " WHERE rowid not in (select v.product_id from llx_gestionvehicules v)";
    	// }

		// echo $sql."<br>";
		// die();
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.' - '.$obj->$objet.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function gestionvehiculespermissionto($source){
	    if(is_dir($source)) {
	    	@chmod($source, 0775);
	        $dir_handle=opendir($source);
	        while($file=readdir($dir_handle)){
	            if($file!="." && $file!=".."){
	                if(is_dir($source."/".$file)){
	                    @chmod($source."/".$file, 0775);
	                    $this->gestionvehiculespermissionto($source."/".$file);
	                } else {
	                    @chmod($source."/".$file, 0664);
	                }
	            }
	        }
	        closedir($dir_handle);
	    } else {
	        @chmod($source, 0664);
	    }
	}
} 


class gestion_vehicules_type extends Commonobject{

	public $errors = array();
	public $rows = array();
	public $rowid;
	public $name;

	public $element='gestion_vehicules_type';
	public $table_element='gestion_vehicules_type';
	
	public function __construct($db){
		$this->db = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/gestionvehicules/type/card.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@lproduction';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        $result = $link."<div class='icon-gestionvehicules2 mainvmenu'></div>  ".$setRef.$linkend;
        return $result;
    }
	public function create()
	{
		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "gestion_vehicules_type (name) VALUES ( '".$this->name."' )";

		$this->db->begin();
		$resql = $this->db->query($sql);
		//echo $sql;
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error gestion_vehicules_type ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			//var_dump($errors);
			return -1;
		} else {
			$this->db->commit();
			return 1;
		}

		return $this->db->last_insert_id(MAIN_DB_PREFIX.$this->table_element);
	}

	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'gestion_vehicules_type WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 					= $this->db->fetch_object($resql);
				$this->rowid 			= $obj->rowid;
				$this->name 	 		= $obj->name;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND',$id_user="all")
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX . "gestion_vehicules_type c where 1>0 ";

		if($id_user != "all" ){
			$sql = "SELECT consulter,`update`,`delete`,`all` FROM ";
			$sql .= MAIN_DB_PREFIX . "gestion_vehicules_type_permission";
			$sql .= " WHERE `all` = 1 and id_user=".$id_user;

			//echo "<div style='background:#fc0;'>".$sql."</div>";

			$resql = $this->db->query($sql);
			$num = $this->db->num_rows($resql);

			if ($num) {
				$this->db->free($resql);
				$sql = "SELECT * FROM ".MAIN_DB_PREFIX."gestion_vehicules_type c where 1>0 ";
			}else{
				$sql = "SELECT c.* FROM ".MAIN_DB_PREFIX."gestion_vehicules_type c , ".MAIN_DB_PREFIX."gestion_vehicules_type_permission g WHERE c.`rowid` = g.id_type and id_user = ".$id_user;
			}
		}
 
		if (!empty($filter)) {
			$sql .= $filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		//echo $sql."<br>";
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 			= $obj->rowid;
				$line->name 	 		= $obj->name;
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'gestion_vehicules_type' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'gestion_vehicules_type' .' WHERE rowid = ' . $this->rowid;
		//echo $sql;
		$resql 	= $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function get_names()
	{
		$sql = "SELECT name FROM ";
		$sql .= MAIN_DB_PREFIX . "gestion_vehicules_type";

		$resql = $this->db->query($sql);
		$names = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$names[ $obj->name ] = $obj->name;
			}
			$this->db->free($resql);
			return $names;
		}
	}


	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}
}


class gestion_vehiculescls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('gestion_vehicules@gestion_vehicules');

        $modulrecrut = new modgestionvehicules($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'https://www.nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_GESTION8VEHICULES',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_GESTION8VEHICULES',$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_GESTION8VEHICULES',0))
            dolibarr_set_const($this->db,'ID_MODULE_GESTION8VEHICULES',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_GESTION8VEHICULES',0))
            dolibarr_set_const($this->db,'DATE_MODULE_GESTION8VEHICULES',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_GESTION8VEHICULES',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_GESTION8VEHICULES',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_GESTION8VEHICULES',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

	        $name = ( $mysoc->name ? $mysoc->name : "(U) ".$user->lastname.' '.$user->firstname);
	        $name = urlencode($name);
        	$id_modul = urlencode($id_modul);
	        $mail = urlencode($mysoc->email); 

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link."&name=".$name."&email=".$mail;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_GESTION8VEHICULES', 1, 'chaine',0,'',0);
                unActivateModule("modgestionvehicules");
            }
            $newdate_modul = date("Y-m-d", strtotime("+ 1 day"));
            dolibarr_set_const($this->db,'DATE_MODULE_GESTION8VEHICULES', $newdate_modul, 'chaine',0,'',0);
        }
        return 1;
    } 
}


?>