<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
 

dol_include_once('/gestionnotifs/class/hrm_presence.class.php');

class gt_comments extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $fk_user;
	public $fk_comment;
	public $comment;
	public $fk_module;
	public $name_module;
	public $date;

	public $element='gt_comments';
	public $table_element='gt_comments';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function create($echo_sql=0,$insert)
	{

		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ""){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			print_r($this->errors);die();
			
			return 0;
		} 
		// return $this->db->db->insert_id;
		return $this->db->last_insert_id(MAIN_DB_PREFIX.'events');
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $val = ($val == '') ? 'NULL' : $val;
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		// echo $sql.'</br>';
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    	     =  $obj->rowid;
				$line->rowid 	     =  $obj->rowid;
				$line->fk_user 	     =  $obj->fk_user;
				$line->date          =  $obj->date;
				$line->fk_comment    =  $obj->fk_comment;
				$line->comment       =  $obj->comment;
				$line->fk_module     =  $obj->fk_module;
				$line->name_module     =  $obj->name_module;

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			    =  $this->db->fetch_object($resql);
                $this->id           =  $obj->rowid;
                $this->rowid        =  $obj->rowid;
				$this->fk_user 	    =  $obj->fk_user;
				$this->date         =  $obj->date;
				$this->fk_comment 	=  $obj->fk_comment;
				$this->comment 	    =  $obj->comment;
				$this->fk_module 	=  $obj->fk_module;
				$this->name_module 	=  $obj->name_module;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->rowid.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$rowid.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;
        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url = dol_buildpath('/gestionnotifs/card.php?id='.$this->id,2);

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";
    	$ref=$this->rowid;
        if ($ref) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.dol_buildpath('/gestionnotifs/img/icon_gt_comments.png',2).'" >&nbsp;';
            if ($withpicto != 2) $result.= $ref;
        }

        $result .= $linkend;

        return $result;
    }

    public function getcountrows($filter){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
        	$sql .= $filter;
		}
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function select_user($selected=0,$name='select_',$multiple=0,$showempty=1,$val="rowid",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    $multi= '';
	    $objet = "label";
	    if($multiple){
	    	$multi = 'multiple';
	    	$name = $name.'[]';
	    }
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.' '.$multi.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" ';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function getcommentschild($module,$fk_module,$fk_comment,$champ="id")
	{
		global $langs, $user;
		$html = '';
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX.get_class($this);
		$sql .= " WHERE name_module='".$module."' AND fk_module=".$fk_module." AND fk_comment=".$fk_comment;
		$sql .= $this->db->order('date', 'DESC');
		$resql = $this->db->query($sql);
		if($resql){
			while ($objt = $this->db->fetch_object($resql)) {
				$html .= '<div class="comment_fild">';
					$user_ = new User($this->db);
					$user_->fetch($objt->fk_user);
					$html .= $user_->getNomUrl(-3, '', 0, 0, 0, 0, '', 'paddingright valigntextbottom');
					$html .= '<span ><b>'.$user_->firstname.' '.$user_->lastname.'</b></span>';
					$html .= '<span class="date_comment">'.date('d/m/Y H:i',strtotime($objt->date)).'</span>';
					if($user->id == $objt->fk_user){
						$html .= '<a class="editcomment" id="editcomment_'.$objt->rowid.'" data-id="'.$objt->rowid.'">'.img_edit($langs->trans('Edit')).'</a>';
						$html .= '<a class="annulcomment" id="annulcomment_'.$objt->rowid.'" data-id="'.$objt->rowid.'">';
							$html .= '<span class="fa fa-remove" title="'.$langs->trans('Cancel').'"></span>';
						$html .= '</a>';
						$html .= '<a href="commentaire.php?rowid='.$fk_module.'&id_delete='.$objt->rowid.'&action=delete" class="removecomment">'.img_delete($langs->trans('Delete')).'</a>';
					}

					$html .= '<a class="repond" id="repond_'.$objt->rowid.'" data-id="'.$objt->rowid.'">'.$langs->trans("repond").'</a>';
					$html .= '<br>';
					$html .= '<div>';
						$html .= '<span id="text_comment_'.$objt->rowid.'" class="text_comment">'.nl2br($objt->comment).'</span>';

						$html .= '<form method="post" action="'.$_SERVER["PHP_SELF"].'" enctype="multipart/form-data">';
							$html .= '<input type="hidden" name="action" value="update" />';
						    $html .= '<input type="hidden" name="'.$champ.'" value="'.$fk_module.'" />';
						    $html .= '<input type="hidden" class="id_edit" name="id_edit" value="'.$objt->rowid.'" />';
							$html .= '<input type="hidden" name="page" value="'.$page.'" />';
							$html .= '<div id="edit_comment_'.$objt->rowid.'" class="edit_comment" >';
								$html .= '<textarea class="comment" name="comment" placeholder="'.$langs->trans('your_comment').'">'.nl2br($objt->comment).'</textarea>';
								$html .= '<input type="submit" value="'.$langs->trans("sauvg").'" class="sauvg">';
							$html .= '</div>';
						$html .= '</form>';

						$html .= '<form method="post" action="'.$_SERVER["PHP_SELF"].'" enctype="multipart/form-data">';

							$html .= '<input type="hidden" name="action" value="reponder" />';
						    $html .= '<input type="hidden" name="'.$champ.'" value="'.$fk_module.'" />';
						    $html .= '<input type="hidden" class="fk_comment" name="fk_comment" value="'.$objt->rowid.'" />';

							$html .= '<div id="repond_comment_'.$objt->rowid.'" class="repond_comment">';
								$html .= $user->getNomUrl(-3, '', 0, 0, 0, 0, '', 'paddingright valigntextbottom');
								$html .= '<textarea class="comment" name="comment" placeholder="'.$langs->trans('your_comment').'"></textarea>';
								$html .= '<div class="action_repond"> ';
									$html .= '<input type="submit" value="'.$langs->trans("sauvg").'" class="btnAction">';
									$html .= '<a class="bntAction cancel">Annuler</a>';
								$html .= '</div>';
							$html .= '</div>';
						$html .= '</form>';
					$html .= '</div>';
				$html .= $this->getcommentschild($module,$fk_module,$objt->rowid);
				$html .= '</div>';
			}
		}
		return $html;
	}

	public function NbCount($value='')
	{
		# code...
	}
	
} 


?>