<?php

// Load Dolibase
dol_include_once('/fileman/autoload.php');
// Load Dolibase Module class
dolibase_include_once('/core/class/module.php');

/**
 *	Class to describe and enable module
 */
class modFileMan extends DolibaseModule
{
	/**
	 * Function called after module configuration.
	 * 
	 */
	public function loadSettings()
	{
		// Update picto for Dolibarr 12++
		if (function_exists('version_compare') && version_compare(DOL_VERSION, '12.0.0') >= 0) {
			$this->picto = "fileman_128.png@fileman";
		}

		// Set permissions
		$this->addPermission("use", "UseFileMan", "u");

		// Set constants
		$this->addConstant('FILEMAN_DOCUMENT_ROOT', DOL_URL_ROOT);

		// Add menus
		$this->addTopMenu($this->config['other']['top_menu_name'], "FileMan", "/fileman/index.php", '$user->rights->fileman->use', '$conf->global->FILEMAN_ADD_TOP_MENU');

		$menu_title = compare_version(DOL_VERSION, '<' ,'7.0.0') ? "FileMan" : "FileManWithIcon";
		$this->addLeftMenu("home", "fileman", $menu_title, "/fileman/index.php", '$user->rights->fileman->use');
	}
}
