<?php
/* Copyright (C) 2014-2019		Charlene BENKE		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/** 		Function called to complete substitution array (before generating on ODT, or a personalized email)
 * 		functions xxx_completesubstitutionarray are called by make_substitutions() if file
 * 		is inside directory htdocs/core/substitutions
 * 
 *		@param	array		$substitutionarray	Array with substitution key=>val
 *		@param	Translate	$langs			Output langs
 *		@param	Object		$object			Object to use to get values
 * 		@return	void					The entry parameter $substitutionarray is modified
 */
function extraodt_completesubstitutionarray(&$substitutionarray, $langs, $object)
{
	global $conf, $db;
	require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

	// si on est sur un odt de socit
	if ($object->element == 'societe') {
		// rcup des lments non prsent mais demand dans l'odt
		// company_commercial
		$sql = "SELECT u.lastname,u.firstname FROM ".MAIN_DB_PREFIX."societe_commerciaux as sc";
		$sql.= " , ".MAIN_DB_PREFIX."user as u" ;
		$sql.= " WHERE sc.fk_soc = ".$object->id;
		$sql.= " AND sc.fk_user = u.rowid";
		
		$resql=$db->query($sql);
		if ($resql) {
			$objp = $db->fetch_object($resql);
			$substitutionarray["company_commercial"]=$objp->lastname." ".$objp->firstname;
		}
	
		//{company_statutprospect}
		$sql = "SELECT pl.label FROM ".MAIN_DB_PREFIX."societe as s, ".MAIN_DB_PREFIX."c_prospectlevel as pl" ;
		$sql.= " WHERE s.rowid = ".$object->id;
		$sql.= " AND pl.code = s.fk_prospectlevel";
	
		$resql=$db->query($sql);
		if ($resql) {
			$objp = $db->fetch_object($resql);
			$substitutionarray["company_statutprospect"]=$objp->label;
		}
		
		//{company_effectif}
		$sql = "SELECT ef.libelle FROM ".MAIN_DB_PREFIX."societe as s, ".MAIN_DB_PREFIX."c_effectif as ef" ;
		$sql.= " WHERE s.rowid = ".$object->id;
		$sql.= " AND ef.id = s.fk_effectif";
	
		$resql=$db->query($sql);
		if ($resql) {
			$objp = $db->fetch_object($resql);
			$substitutionarray["company_effectif"]=$objp->libelle;
		}
	
		// {company_typetiers}
		$sql = "SELECT s.client, s.fournisseur, s.outstanding_limit, te.libelle";
		$sql.= " FROM ".MAIN_DB_PREFIX."societe as s, ".MAIN_DB_PREFIX."c_typent as te" ;
		$sql.= " WHERE s.rowid = ".$object->id;
		$sql.= " AND te.id = s.fk_typent";
	
		$resql=$db->query($sql);
		if ($resql) {
			$objp = $db->fetch_object($resql);
			$substitutionarray["company_typetiers"]=$objp->libelle;
			$substitutionarray["company_outstanding_limit"]=$objp->outstanding_limit;
			if ($objp->client==1)
				$typetiers.="Client";
			elseif ($objp->client==2)
				$typetiers.="Prospect";
			elseif ($objp->client==3)
				$typetiers.="Prospect/Client";
	
			if ($objp->fournisseur)
				$typetiers.=($typetiers?" ":"")."Fournisseur";
				
			$substitutionarray["company_typetiers"]=$objp->outstanding_limit;
	
		}
	
		// {company_maison mre}
		$substitutionarray["company_maisonmere"]="";
		if ($object->parent) {
			$sql = "SELECT nom FROM ".MAIN_DB_PREFIX."societe as s" ;
			$sql.= " WHERE s.rowid = ".$object->parent;
		
			$resql=$db->query($sql);
			if ($resql) {
				$objp = $db->fetch_object($resql);
				$substitutionarray["company_maisonmere"]=$objp->nom;
			}
		}
	
		// {company_categories}
		$substitutionarray["company_categories"]="";
		$sql = "SELECT c.label FROM ".MAIN_DB_PREFIX."categorie as c, ".MAIN_DB_PREFIX."categorie_societe as cs" ;
		$sql.= " WHERE cs.fk_soc = ".$object->id;

		$sql.= " AND cs.fk_categorie= c.rowid";
		$resql=$db->query($sql);
		if ($resql) {
			$num = $db->num_rows($resql);
			if ($num) {
				$i=0;
				while ($i < $num) {
					$objp = $db->fetch_object($resql);
					$categories.=$objp->label." ";
					$i++;
				}
				$substitutionarray["company_categories"]=$categories;
			}
		}
	}

	if ($object->element == 'commande') {
		// element_element
		$sql = "SELECT u.* FROM ".MAIN_DB_PREFIX."element_contact as ec";
		$sql = " , ".MAIN_DB_PREFIX."user as u" ;
		$sql.= " WHERE ec.element_id = ".$object->id;
		$sql.= " AND ec.fk_c_type_contact = 91";
		$sql.= " AND ec.fk_socpeople = u.rowid";

		$resql=$db->query($sql);
		if ($resql) {
			$objp = $db->fetch_object($resql);
			$substitutionarray["internal_contact"]=$objp->lastname." ".$objp->firstname;
			$substitutionarray["internal_contact_office_phone"]=$objp->office_phone;
			$substitutionarray["internal_contact_user_mobile"]=$objp->user_mobile;
			$substitutionarray["internal_contact_email"]=$objp->email;
			$substitutionarray["internal_contact_signature"]=$objp->signature;
		}
	
		// {shipping method}
		$substitutionarray["order_shipping_method"]="";
		if ($object->shipping_method_id) {
			$sql = "SELECT libelle FROM ".MAIN_DB_PREFIX."c_shipment_mode as s" ;
			$sql.= " WHERE s.rowid = ".$object->shipping_method_id;
		
			$resql=$db->query($sql);
			if ($resql) {
				$objp = $db->fetch_object($resql);
				$substitutionarray["order_shipping_method"]=$objp->libelle;
			}
		}
	}

	// en mode dbug
	//var_dump($substitutionarray);
}