<?php

// Load Dolibase
include_once 'autoload.php';
// Load Dolibase Page class
dolibase_include_once('/core/class/page.php');
// Load object class
dol_include_once('/externalsitepro/class/externalsite.class.php');

// Get parameters
$id = GETPOST('wsid', 'int');

// Init object
$externalsite = new ExternalSite();

// Fetch external site
$result = $id > 0 ? $externalsite->fetch($id) : 0;

// Create Page using Dolibase
$page = new Page(($result > 0 ? $externalsite->label : 'ExternalSitePro'), '$user->rights->externalsitepro->read');

if ($result > 0)
{
	if (preg_match('/^\//', $externalsite->url) || preg_match('/^http/i', $externalsite->url))
	{
		global $conf, $heightforframes;

		if ($conf->revampmydolibarr->enabled)
		{
			$page->begin();
		}
		else
		{
			top_htmlhead('', $externalsite->label);

			echo '<body id="mainbody" class="sidebar-collapse">'."\n";

			top_menu('', '', '_top');
		}

		echo '<iframe src="'.$externalsite->url.'" style="position: absolute; top: '.$heightforframes.'px; left: 0px; width:100%; height: calc(100% - '.$heightforframes.'px);" frameborder="0"></iframe>';

		if ($conf->revampmydolibarr->enabled)
		{
			$page->end();
		}
		else
		{
			if (empty($conf->dol_hide_leftmenu) && empty($conf->dol_use_jmobile)) echo '</div>'."\n";

			// Add sidebar toggle script for Dolibarr 11.x
			echo '<script>'."\n";
			echo 'jQuery(document).ready(function() {'."\n";

			echo "\n";
			echo '/* JS CODE TO ENABLE to manage handler to switch left menu page (menuhider) */'."\n";
			echo 'jQuery("li.menuhider").click(function(event) {';
			echo '  if (!$( "body" ).hasClass( "sidebar-collapse" )){ event.preventDefault(); }'."\n";
			echo '  console.log("We click on .menuhider");'."\n";
			echo '  $("body").toggleClass("sidebar-collapse")'."\n";
			echo '});'."\n";

			echo '});'."\n";
			echo "\n".'</script>'."\n";

			echo '</body>'."\n";
			echo '</html>';
		}
	}
	else
	{
		$page->begin();
		echo '<div class="framecontent" style="height: '.($_SESSION['dol_screenheight']-90).'px">'.html_entity_decode($externalsite->url).'<div>';
		$page->end();
	}
}
else
{
	$page->begin();
	$page->end();
}
