<?php

// Load Dolibase CustomObject class
dolibase_include_once('/core/class/custom_object.php');

// Load Dolibase QueryBuilder class
dolibase_include_once('/core/class/query_builder.php');

class ExternalSite extends CustomObject
{
	/**
	 * @var string Id to identify managed object
	 */
	public $element = 'externalsite';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'external_site_pro';
	/**
	 * @var string Primary key name (id field)
	 */
	public $pk_name = 'rowid';

	/**
	 * Constructor
	 * 
	 */
	public function __construct()
	{
		$this->fetch_fields = array('rowid', 'label', 'url', 'icon', 'position', 'target_blank', 'standalone', 'status');

		parent::__construct();
	}

	/**
	 * Add an external site
	 *
	 * @param     $data     data array
	 */
	public function add($data)
	{
		global $user;

		// Add external site
		$id = $this->create($data);

		if ($id > 0) {
			// Add menu entry
			$this->addMenu($data, $id);
		}

		return $id;
	}

	/**
	 * Add a menu for external site
	 *
	 * @param     $data     data array
	 * @param     $id       external site id
	 */
	protected function addMenu($data = array(), $id = 0)
	{
		global $user;

		$label = (empty($data) ? $this->label : $data['label']);
		$url = (empty($data) ? $this->url : $data['url']);
		$position = (empty($data) ? $this->position : $data['position']);
		$target_blank = (empty($data) ? $this->target_blank : $data['target_blank']);
		$website_id = ($id > 0 ? $id : $this->id);
		$standalone = (empty($data) ? $this->standalone : $data['standalone']);

		$menu = new Menubase($this->db);
		$menu->menu_handler = 'all';
		$menu->module = 'externalsitepro';
		$menu->fk_menu = 0;
		$menu->type = 'top';
		$menu->mainmenu = 'externalsitepro website'.$website_id;
		$menu->leftmenu = '';
		$menu->titre = $label;
		$menu->url = ($standalone ? $url : '/externalsitepro/frames.php?wsid='.$website_id);
		$menu->langs = 'other';
		$menu->position = $position;
		$menu->perms = '$user->rights->externalsitepro->read';
		$menu->target = ($target_blank == 1 ? '_blank' : '');
		$menu->user = 2; // 0=Menu for internal users, 1=external users, 2=both
		$menu->enabled = '$conf->externalsitepro->enabled';

		$result = $menu->create($user); // Save menu entry into table llx_menu

		return $result;
	}

	/**
	 * Update external site menu
	 *
	 */
	protected function updateMenu()
	{
		$result = $this->deleteMenu();

		if ($result > 0) {
			$result = $this->addMenu();
		}

		return $result;
	}

	/**
	 * Delete external site menu
	 *
	 */
	protected function deleteMenu()
	{
		return QueryBuilder::getInstance()->delete('menu')->where("titre = '".$this->label."' AND type = 'top' AND module = 'externalsitepro'")->execute();
	}

	/**
	 * Modify an external site
	 *
	 * @param     $data     data array
	 * @param     $id       external site id
	 */
	public function modify($data, $id)
	{
		if ($this->fetch($id) > 0)
		{
			// Update external site
			$result = $this->update($data);

			if ($result > 0 && $this->status == 1) {
				// Update menu entry
				$result = $this->updateMenu();
			}

			return $result;
		}
		else
		{
			return 0;
		}
	}

	/**
	 * Remove an external site
	 *
	 * @param     $id     external site id
	 */
	public function remove($id)
	{
		if ($this->fetch($id) > 0)
		{
			// Delete external site
			$result = $this->delete();

			if ($result > 0) {
				// Delete menu entry
				$result = $this->deleteMenu();
			}

			return $result;
		}
		else
		{
			return 0;
		}
	}

	/**
	 * Enable an external site
	 *
	 * @param     $id     external site id
	 */
	public function enable($id)
	{
		global $user;

		if ($this->fetch($id) > 0)
		{
			// Enable external site
			$result = $this->update(array('status' => 1));

			if ($result > 0) {
				// Add menu entry
				$result = $this->addMenu();
			}

			return $result;
		}
		else
		{
			return 0;
		}
	}

	/**
	 * Disable an external site
	 *
	 * @param     $id     external site id
	 */
	public function disable($id)
	{
		if ($this->fetch($id) > 0)
		{
			// Disable external site
			$result = $this->update(array('status' => 0));

			if ($result > 0) {
				// Delete menu entry
				$result = $this->deleteMenu();
			}

			return $result;
		}
		else
		{
			return 0;
		}
	}
}
