<?php
/*
 * Copyright (C) 2007-2011 Laurent Destailleur <eldy@users.sourceforge.net>
 * Copyright (C) 2012-2016 Jean-François Ferry <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/**
 * \file domain/whois.php
 * \ingroup domain
 * \brief Résultat d'une recherche whois
 */
$res = '';
if (! $res && file_exists("../main.inc.php")) {
    $res = include "../main.inc.php";
} elseif (! $res && file_exists("../../main.inc.php")) { // For root directory
    $res = include "../../main.inc.php"; // For "custom" directory
} else {
    die('Missing main.inc.php file');
}
// Load composer framework
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require(__DIR__ . '/vendor/autoload.php');
}

use phpWhois\Whois;
use phpWhois\Utils;

dol_include_once('/hosting/class/host.class.php');
dol_include_once('/domain/class/domain.class.php');
dol_include_once('/domain/lib/domain.lib.php');
require_once 'class/domain.class.php';
require_once DOL_DOCUMENT_ROOT . '/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT . "/core/lib/company.lib.php";
require_once DOL_DOCUMENT_ROOT . '/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';

// Load traductions files requiredby by page
$langs->loadLangs(array(
    "companies",
    "domain@domain",
    "hosting@hosting"
));

// Get parameters
// Get parameters
$id = GETPOST('id', 'int');
$ref = GETPOST('ref', 'alpha');
$action = GETPOST('action', 'alpha');
$cancel = GETPOST('cancel', 'aZ09');
$backtopage = GETPOST('backtopage', 'alpha');

$action = GETPOST("action", 'alpha');
$query = GETPOST("query", 'alpha');

$date_registrar = GETPOST("date_registrar", 'int');
$date_expiration = GETPOST("date_expiration", 'int');

// Protection if external user
if ($user->societe_id > 0) {
    $socid = $user->societe_id;
}
if (! $user->rights->domain->read) {
    accessforbidden();
}

$object = new Domain($db);

// Load object
include DOL_DOCUMENT_ROOT . '/core/actions_fetchobject.inc.php'; // Must be include, not include_once // Must be include, not include_once. Include fetch and fetch_thirdparty but not fetch_optionals
                                                               
// Security check
                                                               // TODO bad permissions
                                                               // $return = restrictedArea($user, 'domain', $id, 'domain','domain');
if (! $query && !empty($object->label)) {
    $query = $object->label;
}
/**
 * *****************************************************************
 * ACTIONS
 *
 * Put here all code to do according to value of "action" parameter
 *
 * ******************************************************************
 */

if ($action == 'whois' && ! $query) {
    $error ++;
    setEventMessages('', array(
        $langs->trans("QueryMustProvided")
    ), 'errors');
    $action = '';
} elseif ($action == 'set_expiration_date') {
    if ($object->setDateExpiration($date_expiration)) {
        setEventMessage($langs->trans('DomainSuccessUpdate'));
        $query = $object->label;
        Header("Location: whois.php?id=$id&action=whois&query=".$query);
        exit();
    }
} elseif ($action == 'set_registrar_date') {
    if ($object->setDateRegistrar($date_registrar)) {
        setEventMessage($langs->trans('DomainSuccessUpdate'));
        $query = $object->label;
        Header("Location: whois.php?id=$id&action=whois&query=".$query);
        exit();
    }
}

/**
 * *************************************************
 * PAGE
 *
 * **************************************************
 */
llxHeader('', $langs->trans('Domain'), '', '', '', '', $morejs, '', 0, 0);
$html = new Form($db);

// Part to show record
if ($object->id > 0 && (empty($action) || ($action != 'edit' && $action != 'create'))) {
    $res = $object->fetch_optionals();
    
    $head = domainPrepareHead($object);
    dol_fiche_head($head, 'whois', $langs->trans("Domain"), - 1, 'domain@domain');
    
    $formconfirm = '';
}


$linkback = '<a href="' .dol_buildpath('/domain/domain_list.php', 1) . '?restore_lastsearch_values=1' . (! empty($socid) ? '&socid=' . $socid : '') . '">' . $langs->trans("BackToList") . '</a>';

$morehtmlref='<div class="refidno">';
$morehtmlref.=$object->label.'<br />'.$langs->trans('DateCreation').' : '.dol_print_date($object->date_creation).'</div>';
$moreparams = '&action=whois';
dol_banner_tab($object, 'ref', $linkback, 1, 'ref', 'ref', $morehtmlref, $moreparams);
dol_fiche_end();

print '<div class="underbanner clearboth"></div>';

print_fiche_titre($langs->trans("WhoisQuery"), '', 'img/domain_32.png', 1);

print '<div class="fichecenter">';
print '<div class="fichehalfleft">';


if (!$object->id || empty($action)) {
    print '<form action="' . dol_buildpath('/domain/whois.php', 1) . '" method="post">';
    print '<div class="tagtable border allwidth">';
    
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="action" value="whois">';
    
    $htmlinputname = 'query';
    
    print '<div class="tagtr">';
    
    print '<div class="tagtd ">';
    print '<label for="' . $htmlinputname . '">' . $langs->trans('DomainName') . '</label>';
    print '</div>';
    
    print '<div class="tagtd">';
    print '<input type="text" ';
    if (! empty($conf->global->MAIN_HTML5_PLACEHOLDER)) {
        print ' placeholder="' . $langs->trans("SearchOf") . ' ' . strip_tags($title) . '"';
    } else {
        print ' title="' . $langs->trans("SearchOf") . ' ' . strip_tags($title) . '"';
    }
    print ' name="' . $htmlinputname . '" value="' . $query . '"/>&nbsp;';
    print '</div>';
    
    print '</div>';
    
    print '</div>';
    
    print '<div class="center">';
    print '<input type="submit" class="button" value="' . $langs->trans("Search") . '">';
    print '</div>';
    print '</form>';
}

/* Whois query */
if ($action == "whois") {
    $whois = new Whois();
    
    $allowproxy = false;
    
    // get faster but less acurate results
    // $whois->deep_whois = empty($_GET['fast']);
    
    // To use special whois servers (see README)
    // $whois->UseServer('uk','whois.nic.uk:1043?{hname} {ip} {query}');
    // $whois->UseServer('au','whois-check.ausregistry.net.au');
    
    // Comment the following line to disable support for non ICANN tld's
    $whois->non_icann = true;
    $result = $whois->Lookup($query);
    
//     print '<pre>';
//     var_dump($result['regrinfo']);
//     print '</pre>';
    
    if (! empty($result['rawdata'])) {
        $utils = new utils();
        $winfo = $utils->showHTML($result, 1, 'id=' . $object->id . '&amp;action=whois&amp;query=$0&amp;output=nice');
    } else {
        if (isset($whois->Query['errstr'])) {
            $winfo = implode($whois->Query['errstr'], "\n<br></br>");
        } else {
            $winfo = 'Unexpected error';
        }
    }
    
    print $winfo;
    


     //Display info message about domain statut (created / renew)
    if ($result['regrinfo']['domain'] && (
            $result['regrinfo']['registered'] == "yes" || // .com
            $result['regrinfo']['domain']['status'] == "ACTIVE" || // .com | .fr
            ! empty($result['rawdata']['anniversary'])  // trouver date renouvellement pour .fr
       )
    ) {
        print '</div>';
        print '<div class="fichehalfright">';
        print '<div class="ficheaddleft">';

        $edit_registrar = $edit_expiration = false; // Show link to edit form
        $reqDateModif; // Param to add to edit link
        
        /*
        * Registration date in whois
        * 
        */
        $whois_date_registrar = '';
        $created_date = strtotime($result['regrinfo']['domain']['created']);
    
        // Look for 'Creation Date: ' into raw results
        foreach ($result['rawdata'] as $line) {
            if (preg_match('/Creation Date: (.*)/', $line, $match)) {
                $created_date = strtotime($match[1]);
                $whois_date_registrar = dol_print_date($created_date, 'dayhour');
                break;
            }
        }
        if (! empty($whois_date_registrar)) {
            print '<div class="info">';
            $picto = img_picto('', 'info');
            print '<p>' . $picto . ' ' . $langs->trans('WhoisDomainAlreadyRegisteredSince', $whois_date_registrar) . '</p>';
            print '</div>';
            
            // Warning if date differ in database
            if ($created_date <> $object->date_registrar) {
                print '<div class="warning">';
                $edit_registrar = true;
                $picto = img_picto('', 'warning');
                print '<p>' . $picto . ' ' . $langs->trans('WhoisDomainRegistrationDiffToWhois', dol_print_date($object->date_registrar, 'dayhour')) . '</p>';
                print '</div>';
                
                $reqDateModif.= '&amp;date_registrar='.$created_date;
            }
            // Link to edit datas from whois if needed
            if ($edit_registrar) {
                print ' <a class="butAction" href="'.dol_buildpath('/domain/whois.php', 1).'?action=set_registrar_date&amp;id='.$object->id . $reqDateModif . '">'.$langs->trans('EditDomainWithRegistrationDatas').'</a>';
            }
        }
        
        /*
         *  Expiration date
         */
        $whois_date_expire = '';
        
        // Look for 'Registry Expiry Date: ' into raw results
        foreach ($result['rawdata'] as $line) {
            if (preg_match('/Registry Expiry Date: (.*)/', $line, $match)) {
                $expire_date = strtotime($match[1]);
                $whois_date_expire = dol_print_date($expire_date, 'dayhour');
                break;
            }
        }
        if (! empty($whois_date_expire)) {
            print '<div class="info">';
            print '<p>';
            print  '<strong>' . $langs->trans('DomainExpirationDateWhois') . '</strong> : ' . $whois_date_expire ;
            print '</p>';
            
            $picto = '';
            if ($expire_date <> $object->date_expiration) {
                print '<div class="warning">';
                $edit_expiration = true;
                $picto = img_picto('', 'warning');
                print '<br>'.$picto.' <strong>' . $langs->trans('DomainExpirationDateInDatabase') . '</strong> : ' . dol_print_date($object->date_expiration);
                print '</div>';
                
                $reqDateModif.= '&amp;date_expiration='.$expire_date;
            }
            print '</div>';
        }
        // Link to edit datas from whois if needed
        if ($edit_expiration) {
            print ' <a class="butAction" href="'.dol_buildpath('/domain/whois.php', 1).'?action=set_expiration_date&amp;id='.$object->id . $reqDateModif . '">'.$langs->trans('EditDomainWithExpirationDatas').'</a>';
        }
        if (!$edit_expiration && !$edit_registrar) {
            $picto = img_picto('', 'statut4');
            print '<div class="ok"><p>'.$picto.' '.$langs->trans('DomainDatabaseUpToDateWhois').'</p></div>';
        }

        print '</div>';
    }
}

print '</div></div>';


// End of page
$db->close();
llxFooter();
