<?php
/* Copyright (C) 2007-2011 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2013-2018 Jean-François Ferry    <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/**
 *       \file       domain/expirations.php
 *        \ingroup    domain
 *        \brief      List which are going to expire
 */
$res = '';
if (!$res && file_exists("../main.inc.php")) {
    $res = include "../main.inc.php";
} elseif (!$res && file_exists("../../main.inc.php")) { // For root directory
    $res = include "../../main.inc.php"; // For "custom" directory
} else {
    die('Missing main.inc.php file');
}

dol_include_once('/hosting/class/host.class.php');
dol_include_once('/domain/class/domain.class.php');
require_once 'class/domain.class.php';
require_once DOL_DOCUMENT_ROOT . '/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT . "/core/lib/company.lib.php";
require_once DOL_DOCUMENT_ROOT . '/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';

// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("domain@domain");
$langs->load("hosting@hosting");

// Get parameters
$action = GETPOST("action");
$show_expired = GETPOST("show_expired", 'int');
$socid = GETPOST('socid', 'int');

// Protection if external user
if ($user->societe_id > 0) {
    $socid = $user->societe_id;
}
if (!$user->rights->domain->read || $user->societe_id > 0) {
    accessforbidden();
}

/***************************************************
 * PAGE
 *
 ****************************************************/
llxHeader('', $langs->trans('Domain'), '', '', '', '', $morejs, '', 0, 0);
$html = new Form($db);
$domain = new Domain($db);

dol_htmloutput_mesg($mesg);

print_fiche_titre($langs->trans("DomainsGoingToExpiration"), '', 'img/domain_32.png', 1);

$conf->global->DOMAIN_EXPIRATION_ALERT_DAYS = 30;

$mesg = $show_expired ? $langs->trans('DomainsExpiredInfo') : $langs->trans('DomainsToExpireInfo', $conf->global->DOMAIN_EXPIRATION_ALERT_DAYS);
print '<div class="info"><em>' . $mesg . '</em></div>';

$domain_expired = $domain->fetchExpiration($show_expired, $socid);
    print "<form method=\"POST\" name=\"registration\" enctype=\"multipart/form-data\" action=\"" . $_SERVER['PHP_SELF'] . "\">\n";
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    
    print '<table class="border centpercent"  >';
    print '<tr class="liste_titre">';
    print '<th width="25%">' . $langs->trans('Domain') . '</th>';
    print '<th>'.$langs->trans('DomainName').'</th>';
    print '<th width="15%">' . $langs->trans('Customer') . '</th>';
    print '<th width="15%">' . $langs->trans('Supplier') . '</th>';
    print '<th width="10%">' . $langs->trans('DateCreation') . '</th>';
    print '<th width="10%">' . $langs->trans('DateExpiration') . '</th>';
    $label = $show_expired ? $langs->trans('NbDayExpired') : $langs->trans('NbDayLeft');
    print '<th>'.$label.'</th>';
    print '<th width="15%">' . $langs->trans('Whois') . '</th>';
    print '</tr>';

if ($domain_expired > 0) {
    $num2 = count($domain->line);
    
    if ($num2) {
        $j = 0;
        

        $count = $j = 0;
        while ($j < $num2) {
            print '<tr ' . $style . '>';

            // Domain name ref
            $domainstat = new Domain($db);
            $res = $domainstat->fetch($domain->line[$j]->rowid);
            if ($res) {
                print '<td>' . $domainstat->getNomUrl(1) . '</td>';
            }

            // Domain name
            print '<td>'.$domain->line[$j]->label.'</td>';

            // Customer
            $socstat = new Societe($db);
            print '<td>';
            $res = $socstat->fetch($domain->line[$j]->fk_soc);
            if ($res) {
                // Client
                print $socstat->getNomUrl(1);
            }
            print '</td>';

            // Supplier
            print '<td>';
            $fournstat = new Societe($db);
            $res = $fournstat->fetch($domain->line[$j]->fk_supplier);
            if ($res) {
                // Supplier
                print $fournstat->getNomUrl(1);
            }
            print '</td>';

            // Date validation
            print '<td>' . dol_print_date($domain->line[$j]->date_creation, 'day') . '</td>';

            // Date expiration
            print '<td>' . dol_print_date($domain->line[$j]->date_expiration, 'day') . '</td>';

            // Number of days left
            $dateAlert = dol_print_date(dol_now() - ($conf->global->DOMAIN_EXPIRATION_ALERT_DAYS * 24 * 3600), 'dayrfc');
            $dateNow = dol_print_date(dol_now());
            $datetime1 = new DateTime($dateNow);
            $datetime2 = new DateTime(dol_print_date($domain->line[$j]->date_expiration, 'dayrfc'));
            $interval = $datetime1->diff($datetime2);
            
            print '<td>' . $interval->format('%R%a '.$langs->trans('Days')) . '</td>';

            // Link to whois
            $urlWhois = dol_buildpath('/domain/whois.php', 1);
            $urlWhois.= '?action=whois&id=' . $domain->line[$j]->rowid;
            $urlWhois.= '&query='.$domain->line[$j]->label;
            print '<td><a href="'.$urlWhois.'">'.$langs->trans('Whois').'</a></td>';

            print '</tr>';
            $statut = $domain->line[$j]->fk_statut;
            $j++;
        }
    }
} else {
    print $domain->error;
}

print '</table><br />';

if (!$num2) {
    print '<div class="ok">' . $langs->trans('NoDomainToExpire') . '</div><br />';
}

print '<div class="tabsAction">';
if ($show_expired) {
    print '<a class="butAction" href="' . $_SERVER['PHP_SELF'] . '">' . $langs->trans('ShowDomainGoingToExpire') . '</a>';
} else {
    print '<a class="butAction" href="' . $_SERVER['PHP_SELF'] . '?show_expired=1">' . $langs->trans('ShowDomainExpired') . '</a>';
}

print '<a class="butAction" href="' . dol_buildpath('/domain/domain_list.php', 1) . '">' . $langs->trans('DomainsList') . '</a>';
print '</div>';

// End of page
$db->close();
llxFooter();
