<?php
/* Copyright (C) 2007-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) ---Put here your own copyright and developer email---
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       domain_note.php
 *  \ingroup    domain
 *  \brief      Car with notes on Domain
 */

// Load Dolibarr environment
$res=0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (! $res && ! empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
    $res=@include($_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php");
}
// Try main.inc.php into web root detected using web root caluclated from SCRIPT_FILENAME
$tmp=empty($_SERVER['SCRIPT_FILENAME'])?'':$_SERVER['SCRIPT_FILENAME'];
$tmp2=realpath(__FILE__);
$i=strlen($tmp)-1;
$j=strlen($tmp2)-1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i]==$tmp2[$j]) {
    $i--;
    $j--;
}
if (! $res && $i > 0 && file_exists(substr($tmp, 0, ($i+1))."/main.inc.php")) {
    $res=@include(substr($tmp, 0, ($i+1))."/main.inc.php");
}
if (! $res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php")) {
    $res=@include(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php");
}
// Try main.inc.php using relative path
if (! $res && file_exists("../main.inc.php")) {
    $res=@include("../main.inc.php");
}
if (! $res && file_exists("../../main.inc.php")) {
    $res=@include("../../main.inc.php");
}
if (! $res && file_exists("../../../main.inc.php")) {
    $res=@include("../../../main.inc.php");
}
if (! $res) {
    die("Include of main fails");
}

dol_include_once('/domain/class/domain.class.php');
dol_include_once('/domain/lib/domain.lib.php');

// Load traductions files requiredby by page
$langs->loadLangs(array("domain@domain","companies"));

// Get parameters
$id			= GETPOST('id', 'int');
$ref        = GETPOST('ref', 'alpha');
$action		= GETPOST('action', 'alpha');
$cancel     = GETPOST('cancel', 'aZ09');
$backtopage = GETPOST('backtopage', 'alpha');

// Initialize technical objects
$object=new Domain($db);
$extrafields = new ExtraFields($db);
$diroutputmassaction=$conf->domain->dir_output . '/temp/massgeneration/'.$user->id;
$hookmanager->initHooks(array('domainnote'));     // Note that conf->hooks_modules contains array
// Fetch optionals attributes and labels
$extralabels = $extrafields->fetch_name_optionals_label('domain');

// Security check - Protection if external user
//if ($user->societe_id > 0) access_forbidden();
//if ($user->societe_id > 0) $socid = $user->societe_id;
//$result = restrictedArea($user, 'domain', $id);

// Load object
include DOL_DOCUMENT_ROOT.'/core/actions_fetchobject.inc.php';  // Must be include, not include_once  // Must be include, not include_once. Include fetch and fetch_thirdparty but not fetch_optionals
if ($id > 0 || ! empty($ref)) {
    $upload_dir = $conf->domain->multidir_output[$object->entity] . "/" . $object->id;
}

$permissionnote=1;
//$permissionnote=$user->rights->domain->creer;	// Used by the include of actions_setnotes.inc.php


/*
 * Actions
 */

include DOL_DOCUMENT_ROOT.'/core/actions_setnotes.inc.php';	// Must be include, not include_once


/*
 * View
 */

$form = new Form($db);

//$help_url='EN:Customers_Orders|FR:Commandes_Clients|ES:Pedidos de clientes';
$help_url='';
llxHeader('', $langs->trans('Domain'), $help_url);

if ($id > 0 || ! empty($ref)) {
	$object->fetch_thirdparty();

	$head = domainPrepareHead($object);
	dol_fiche_head($head, 'note', $langs->trans("Domain"), -1, 'domain@domain');

	// Object card
	// ------------------------------------------------------------
	$linkback = '<a href="' .dol_buildpath('/domain/domain_list.php', 1) . '?restore_lastsearch_values=1' . (! empty($socid) ? '&socid=' . $socid : '') . '">' . $langs->trans("BackToList") . '</a>';

	$morehtmlref='<div class="refidno">';
	$morehtmlref.=$object->label.'<br />'.$langs->trans('DateCreation').' : '.dol_print_date($object->date_creation);
	$morehtmlref.='</div>';

	dol_banner_tab($object, 'ref', $linkback, 1, 'ref', 'ref', $morehtmlref);

    dol_fiche_end();
	print '<div class="underbanner clearboth"></div>';
	print '<div class="fichecenter">';


	$cssclass="titlefield";
	include DOL_DOCUMENT_ROOT.'/core/tpl/notes.tpl.php';

	print '</div>';

	dol_fiche_end();
}


llxFooter();
$db->close();
