<?php

/* Copyright (C) 2016-2018   Jean-François Ferry    <hello@librethic.io>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/**
 *       \file       domain/dns.php
 *         \ingroup    domain
 *         \brief      Show DNS records for a domain
 */
$res = '';
if (!$res && file_exists("../main.inc.php")) {
    $res = include "../main.inc.php";
} elseif (!$res && file_exists("../../main.inc.php")) { // For root directory
    $res = include "../../main.inc.php"; // For "custom" directory
} else {
    die('Missing main.inc.php file');
}

dol_include_once('/hosting/class/host.class.php');
dol_include_once('/domain/class/domain.class.php');
require_once 'class/domain.class.php';
dol_include_once('/hosting/lib/hosting.lib.php');
require_once 'lib/domain.lib.php';
require_once DOL_DOCUMENT_ROOT . '/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT . "/core/lib/company.lib.php";
require_once DOL_DOCUMENT_ROOT . '/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT . "/core/lib/functions2.lib.php";

// Load traductions files requiredby by page
$langs->loadLangs(
    array(
        "companies",
        "domain@domain",
        "hosting@hosting"
    )
);

// Get parameters
$action = GETPOST("action");
$query = GETPOST("query");
$id = GETPOST("id", 'int'); // Domain ID
$ref = GETPOST('ref', 'az');
// Protection if external user
if ($user->societe_id > 0) {
    $socid = $user->societe_id;
}
if (!$user->rights->domain->read) {
    accessforbidden();
}

// Security check
$return = restrictedArea($user, 'domain', $id);

/* * *****************************************************************
 * ACTIONS
 *
 * Put here all code to do according to value of "action" parameter

 * ****************************************************************** */

if ($action == 'check' && !$query) {
    $error++;
    setEventMessages('', array($langs->trans("QueryMustProvided")), 'errors');
    $action = '';
}

/* * *************************************************
 * PAGE
 *
 * ************************************************** */
llxHeader('', $langs->trans('Domain'), '', '', '', '', $morejs, '', 0, 0);
$form = new Form($db);

/*
 * View domain info or edit form
 */
if ($id > 0 || !empty($ref)) {
    $domain = new Domain($db);
    $res = $domain->fetch($id, $ref);
    if ($res > 0) {
        $langs->load("companies");

        /*
         * Creation de l'objet client/fournisseur correspondant au socid
         */
        $soc = new Societe($db);
        $result = $soc->fetch($domain->fk_soc);

        /*
         * Creation de l'objet host correspondant au domain
         */
        $host = new Host($db);
        $result = $host->fetch($domain->getHostIdForDef('DOMAIN', $domain->id));

        /*
         * Affichage onglets pour l'hôte
         */
        if ($host->id > 0 && !empty($conf->global->HOSTING_SHOW_HOST_CARD_ON_OBJECT)) {
            $head = hosting_prepare_head($host);
            dol_fiche_head($head, 'tabHosting', $langs->trans("Host"), 0, 'host@hosting');
            $host->showHostCardInfos($user);
            dol_fiche_end();
        }

        $head = domainPrepareHead($domain);
        dol_fiche_head($head, 'dns', $langs->trans("DomainName"), 0, 'domain@domain');
        
        
        $linkback = '<a href="' .dol_buildpath('/domain/domain_list.php', 1) . '?restore_lastsearch_values=1' . (! empty($socid) ? '&socid=' . $socid : '') . '">' . $langs->trans("BackToList") . '</a>';
        
        $morehtmlref='<div class="refidno">';
        $morehtmlref.=$domain->label.'<br />'.$langs->trans('DateCreation').' : '.dol_print_date($domain->date_creation).'</div>';
        dol_banner_tab($domain, 'ref', $linkback, 1, 'ref', 'ref', $morehtmlref);
        

        dol_fiche_end();

        // Set values for DNS lookup
        $action = 'check';
        $query = $domain->label;
    }
} else {
    print_fiche_titre($langs->trans("DnsQuery"), '', 'img/domain_32.png', 1);
    print '<form action="' . dol_buildpath('/domain/dns.php', 1) . '" method="post">';
    print '<div class="tagtable border allwidth">';

    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="action" value="check">';

    $htmlinputname = 'query';

    print '<div class="tagtr">';
    print '<div class="tagtd ">';
    print '<label for="' . $htmlinputname . '">' . $langs->trans('DomainName') . '</label>';
    print '</div>';

    print '<div class="tagtd">';
    print '<input type="text" ';
    if (!empty($conf->global->MAIN_HTML5_PLACEHOLDER)) {
        print ' placeholder="' . $langs->trans("SearchOf") . ' ' . strip_tags($title) . '"';
    } else {
        print ' title="' . $langs->trans("SearchOf") . ' ' . strip_tags($title) . '"';
    }
    print ' name="' . $htmlinputname . '" value="' . $query . '"/>&nbsp;';
    print '</div>';

    print '</div>';
    print '</div>';

    print '<div class="center">';
    print '<input type="submit" class="button" value="' . $langs->trans("Search") . '">';
    print '</div>';
    print '</form>';
}

/* Whois query */
if ($action == "check") {
    $domain = new Domain($db);
    $domain->label = $query;

    $tableoptions = 'class="border';

    if ($domain->getSOARecords()) {
        print '<table class="liste"><tr class="liste_titre"><td colspan="2"></td>';
        print_liste_field_titre('ttl', '', '', '', '', 'colspan=4');
        print_liste_field_titre('serial');
        print_liste_field_titre('refresh');
        print_liste_field_titre('retry');
        print_liste_field_titre('expire');
        print_liste_field_titre('minimumttl');
        print '</tr>';
        print array2table($domain->dns_records, $tableMarkup = 0, $tableoptions = '', $troptions = '', $tdoptions = '');
        print '</table>';
    } else {
        print 'Unexpected error for SOA records';
    }

    print '<table class="liste"><tr class="liste_titre"><td colspan="2"></td>';
    print_liste_field_titre('ttl', '', '', '', '', 'colspan=2');
    print_liste_field_titre('host');
    print '</tr>';
    print '</tr>';
    if ($domain->getNSRecords()) {
        print array2table($domain->dns_records, $tableMarkup = 0, $tableoptions = '', $troptions = '', $tdoptions = '');
    } else {
        print 'Unexpected error for NS records';
    }
    if ($domain->getARecords()) {
        print array2table($domain->dns_records, $tableMarkup = 0, $tableoptions = '', $troptions = '', $tdoptions = '');
    } else {
        print 'Unexpected error for NS records';
    }
    print '</table>';

    if ($domain->getMXRecords()) {
        print '<table class="liste"><tr class="liste_titre"><td colspan="2"></td>';
        print_liste_field_titre('ttl', '', '', '', '', 'colspan=2');
        print_liste_field_titre('Weight');
        print_liste_field_titre('host');
        print '</tr>';
        print array2table($domain->dns_records, $tableMarkup = 0, $tableoptions = '', $troptions = '', $tdoptions = '');
        print '</table>';
    } else {
        print 'Unexpected error for NS records';
    }
}

// End of page
$db->close();
llxFooter();
