<?php
/**
 *  Copyright (C) 2007-2011 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2012-2018 Jean-François Ferry    <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *      \file       domain/class/actions_domain.class.php
 *      \ingroup    domain
 *      \brief      CRUD class file (Create/Read/Update/Delete) to manage internet domain
 */


class ActionsDomain
{

    public $db;
    public $error;
    public $errors = array();

    /**
     *    Constructor
     *
     *  @param DoliDB $db Database handler
     */
    public function __construct($db)
    {
        $this->db = $db;
    }

    /**
     * Overloading the doActions function : replacing the parent's function with the one below
     *
     * @param string      $parameters  meta datas of the hook (context, etc...)
     * @param Object      $object      the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     * @param string      $action      current action (if set). Generally create or edit or null
     * @param HookManager $hookmanager Hook manager
     *
     * @return void
     */
    public function printSearchForm($parameters, &$object, &$action, $hookmanager)
    {
        global $langs;
        if (in_array('searchform', explode(':', $parameters['context']))) {
            $ret = '';
            if (!$conf->use_javascript_ajax && $conf->browser->layout == 'phone' && ! empty($conf->global->MAIN_USE_OLD_SEARCH_FORM)) {
                $title = $langs->trans('Whois');
                $htmlinputname = 'query';
                $urlobject = dol_buildpath('/domain/whois.php', 1);

                $ret.=printSearchForm($urlobject, $urlobject, $title, 'domain', 'sall', 'M', 'searchleftwhois', img_object('', 'domain@domain'));
            }
            $this->resprints = $ret;
            return 0;
        }
    }

    /**
     * Overloading the doActions function : replacing the parent's function with the one below
     *
     * @param string      $parameters  meta datas of the hook (context, etc...)
     * @param Object      $object      the object you want to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     * @param string      $action      current action (if set). Generally create or edit or null
     * @param HookManager $hookmanager Hook manager
     *
     * @return void
     */
    public function addSearchEntry($parameters, &$object, &$action, $hookmanager)
    {
        global $langs;

        if (in_array('searchform', explode(':', $parameters['context']))) {
            $title = $langs->trans('Whois');
            $htmlinputname = 'query';
            $urlobject = dol_buildpath('/domain/whois.php', 1);

            $ret = array();
            $ret['searchintowhois']=array(
              'text'=>img_picto('whois', 'object_domain@domain').' '.$langs->trans("Whois", $parameters['search_boxvalue']),
              'url'=>$urlobject.'?action=whois&query='.urlencode($parameters['search_boxvalue']),
              'position'=>'999'
            );

            $this->results = $ret;
            return 0;
        }
    }

    /**
     * Overloading the addMoreMassActions function : replacing the parent's function with the one below
     *
     * @param array        $parameters  Hook metadatas (context, etc...)
     * @param CommonObject $object      The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     * @param string       $action      Current action (if set). Generally create or edit or null
     * @param HookManager  $hookmanager Hook manager propagated to allow calling another hook
     *
     * @return int  < 0 on error, 0 on success, 1 to replace standard code
     */
    public function showLinkToObjectBlock($parameters, &$object, &$action, $hookmanager)
    {
        global $conf, $user, $langs;

        $error = 0; // Error counter
        if (in_array('commonobject', explode(':', $parameters['context']))) {		// do something only for the context 'somecontext1' or 'somecontext2'
            if (is_object($object->thirdparty) && ! empty($object->thirdparty->id) && $object->thirdparty->id > 0) {
                $listofidcompanytoscan=$object->thirdparty->id;
                if (($object->thirdparty->parent > 0) && ! empty($conf->global->THIRDPARTY_INCLUDE_PARENT_IN_LINKTO)) {
                    $listofidcompanytoscan.=','.$object->thirdparty->parent;
                }
                if (($object->fk_project > 0) && ! empty($conf->global->THIRDPARTY_INCLUDE_PROJECT_THIRDPARY_IN_LINKTO)) {
                    include_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
                    $tmpproject=new Project($this->db);
                    $tmpproject->fetch($object->fk_project);
                    if ($tmpproject->socid > 0 && ($tmpproject->socid != $object->thirdparty->id)) {
                        $listofidcompanytoscan.=','.$tmpproject->socid;
                    }
                    unset($tmpproject);
                }
                
                $this->results=array(
                    'domain'=>array('enabled'=>$conf->domain->enabled, 'perms'=>1, 'label'=>'LinkToDomain', 'sql'=>"SELECT s.rowid as socid, s.nom as name, s.client, t.rowid, t.ref, t.label FROM ".MAIN_DB_PREFIX."societe as s, ".MAIN_DB_PREFIX."domain as t WHERE t.fk_soc = s.rowid AND t.fk_soc IN (".$listofidcompanytoscan.') AND t.entity IN ('.getEntity('domain').')'),
                );
            }
        }

        if (! $error) {
            return 0;                                    // or return 1 to replace standard code
        } else {
            $this->errors[] = 'Error message';
            return -1;
        }
    }
}
