<?php
/**
 * SalesDataShipmentInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Magento Enterprise Edition 2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * SalesDataShipmentInterface Class Doc Comment
 *
 * @category Class
 * @description Shipment interface. A shipment is a delivery package that contains products. A shipment document accompanies the shipment. This document lists the products and their quantities in the delivery package.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SalesDataShipmentInterface implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'sales-data-shipment-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'billing_address_id' => 'int',
        'created_at' => 'string',
        'customer_id' => 'int',
        'email_sent' => 'int',
        'entity_id' => 'int',
        'increment_id' => 'string',
        'order_id' => 'int',
        'packages' => '\Swagger\Client\Model\SalesDataShipmentPackageInterface[]',
        'shipment_status' => 'int',
        'shipping_address_id' => 'int',
        'shipping_label' => 'string',
        'store_id' => 'int',
        'total_qty' => 'float',
        'total_weight' => 'float',
        'updated_at' => 'string',
        'items' => '\Swagger\Client\Model\SalesDataShipmentItemInterface[]',
        'tracks' => '\Swagger\Client\Model\SalesDataShipmentTrackInterface[]',
        'comments' => '\Swagger\Client\Model\SalesDataShipmentCommentInterface[]',
        'extension_attributes' => '\Swagger\Client\Model\SalesDataShipmentExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'billing_address_id' => null,
        'created_at' => null,
        'customer_id' => null,
        'email_sent' => null,
        'entity_id' => null,
        'increment_id' => null,
        'order_id' => null,
        'packages' => null,
        'shipment_status' => null,
        'shipping_address_id' => null,
        'shipping_label' => null,
        'store_id' => null,
        'total_qty' => null,
        'total_weight' => null,
        'updated_at' => null,
        'items' => null,
        'tracks' => null,
        'comments' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'billing_address_id' => 'billingAddressId',
        'created_at' => 'createdAt',
        'customer_id' => 'customerId',
        'email_sent' => 'emailSent',
        'entity_id' => 'entityId',
        'increment_id' => 'incrementId',
        'order_id' => 'orderId',
        'packages' => 'packages',
        'shipment_status' => 'shipmentStatus',
        'shipping_address_id' => 'shippingAddressId',
        'shipping_label' => 'shippingLabel',
        'store_id' => 'storeId',
        'total_qty' => 'totalQty',
        'total_weight' => 'totalWeight',
        'updated_at' => 'updatedAt',
        'items' => 'items',
        'tracks' => 'tracks',
        'comments' => 'comments',
        'extension_attributes' => 'extensionAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'billing_address_id' => 'setBillingAddressId',
        'created_at' => 'setCreatedAt',
        'customer_id' => 'setCustomerId',
        'email_sent' => 'setEmailSent',
        'entity_id' => 'setEntityId',
        'increment_id' => 'setIncrementId',
        'order_id' => 'setOrderId',
        'packages' => 'setPackages',
        'shipment_status' => 'setShipmentStatus',
        'shipping_address_id' => 'setShippingAddressId',
        'shipping_label' => 'setShippingLabel',
        'store_id' => 'setStoreId',
        'total_qty' => 'setTotalQty',
        'total_weight' => 'setTotalWeight',
        'updated_at' => 'setUpdatedAt',
        'items' => 'setItems',
        'tracks' => 'setTracks',
        'comments' => 'setComments',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'billing_address_id' => 'getBillingAddressId',
        'created_at' => 'getCreatedAt',
        'customer_id' => 'getCustomerId',
        'email_sent' => 'getEmailSent',
        'entity_id' => 'getEntityId',
        'increment_id' => 'getIncrementId',
        'order_id' => 'getOrderId',
        'packages' => 'getPackages',
        'shipment_status' => 'getShipmentStatus',
        'shipping_address_id' => 'getShippingAddressId',
        'shipping_label' => 'getShippingLabel',
        'store_id' => 'getStoreId',
        'total_qty' => 'getTotalQty',
        'total_weight' => 'getTotalWeight',
        'updated_at' => 'getUpdatedAt',
        'items' => 'getItems',
        'tracks' => 'getTracks',
        'comments' => 'getComments',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['billing_address_id'] = isset($data['billing_address_id']) ? $data['billing_address_id'] : null;
        $this->container['created_at'] = isset($data['created_at']) ? $data['created_at'] : null;
        $this->container['customer_id'] = isset($data['customer_id']) ? $data['customer_id'] : null;
        $this->container['email_sent'] = isset($data['email_sent']) ? $data['email_sent'] : null;
        $this->container['entity_id'] = isset($data['entity_id']) ? $data['entity_id'] : null;
        $this->container['increment_id'] = isset($data['increment_id']) ? $data['increment_id'] : null;
        $this->container['order_id'] = isset($data['order_id']) ? $data['order_id'] : null;
        $this->container['packages'] = isset($data['packages']) ? $data['packages'] : null;
        $this->container['shipment_status'] = isset($data['shipment_status']) ? $data['shipment_status'] : null;
        $this->container['shipping_address_id'] = isset($data['shipping_address_id']) ? $data['shipping_address_id'] : null;
        $this->container['shipping_label'] = isset($data['shipping_label']) ? $data['shipping_label'] : null;
        $this->container['store_id'] = isset($data['store_id']) ? $data['store_id'] : null;
        $this->container['total_qty'] = isset($data['total_qty']) ? $data['total_qty'] : null;
        $this->container['total_weight'] = isset($data['total_weight']) ? $data['total_weight'] : null;
        $this->container['updated_at'] = isset($data['updated_at']) ? $data['updated_at'] : null;
        $this->container['items'] = isset($data['items']) ? $data['items'] : null;
        $this->container['tracks'] = isset($data['tracks']) ? $data['tracks'] : null;
        $this->container['comments'] = isset($data['comments']) ? $data['comments'] : null;
        $this->container['extension_attributes'] = isset($data['extension_attributes']) ? $data['extension_attributes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['order_id'] === null) {
            $invalidProperties[] = "'order_id' can't be null";
        }
        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        if ($this->container['tracks'] === null) {
            $invalidProperties[] = "'tracks' can't be null";
        }
        if ($this->container['comments'] === null) {
            $invalidProperties[] = "'comments' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['order_id'] === null) {
            return false;
        }
        if ($this->container['items'] === null) {
            return false;
        }
        if ($this->container['tracks'] === null) {
            return false;
        }
        if ($this->container['comments'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets billing_address_id
     *
     * @return int
     */
    public function getBillingAddressId()
    {
        return $this->container['billing_address_id'];
    }

    /**
     * Sets billing_address_id
     *
     * @param int $billing_address_id Billing address ID.
     *
     * @return $this
     */
    public function setBillingAddressId($billing_address_id)
    {
        $this->container['billing_address_id'] = $billing_address_id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at Created-at timestamp.
     *
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int $customer_id Customer ID.
     *
     * @return $this
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets email_sent
     *
     * @return int
     */
    public function getEmailSent()
    {
        return $this->container['email_sent'];
    }

    /**
     * Sets email_sent
     *
     * @param int $email_sent Email-sent flag value.
     *
     * @return $this
     */
    public function setEmailSent($email_sent)
    {
        $this->container['email_sent'] = $email_sent;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return int
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int $entity_id Shipment ID.
     *
     * @return $this
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets increment_id
     *
     * @return string
     */
    public function getIncrementId()
    {
        return $this->container['increment_id'];
    }

    /**
     * Sets increment_id
     *
     * @param string $increment_id Increment ID.
     *
     * @return $this
     */
    public function setIncrementId($increment_id)
    {
        $this->container['increment_id'] = $increment_id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return int
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int $order_id Order ID.
     *
     * @return $this
     */
    public function setOrderId($order_id)
    {
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets packages
     *
     * @return \Swagger\Client\Model\SalesDataShipmentPackageInterface[]
     */
    public function getPackages()
    {
        return $this->container['packages'];
    }

    /**
     * Sets packages
     *
     * @param \Swagger\Client\Model\SalesDataShipmentPackageInterface[] $packages Array of packages, if any. Otherwise, null.
     *
     * @return $this
     */
    public function setPackages($packages)
    {
        $this->container['packages'] = $packages;

        return $this;
    }

    /**
     * Gets shipment_status
     *
     * @return int
     */
    public function getShipmentStatus()
    {
        return $this->container['shipment_status'];
    }

    /**
     * Sets shipment_status
     *
     * @param int $shipment_status Shipment status.
     *
     * @return $this
     */
    public function setShipmentStatus($shipment_status)
    {
        $this->container['shipment_status'] = $shipment_status;

        return $this;
    }

    /**
     * Gets shipping_address_id
     *
     * @return int
     */
    public function getShippingAddressId()
    {
        return $this->container['shipping_address_id'];
    }

    /**
     * Sets shipping_address_id
     *
     * @param int $shipping_address_id Shipping address ID.
     *
     * @return $this
     */
    public function setShippingAddressId($shipping_address_id)
    {
        $this->container['shipping_address_id'] = $shipping_address_id;

        return $this;
    }

    /**
     * Gets shipping_label
     *
     * @return string
     */
    public function getShippingLabel()
    {
        return $this->container['shipping_label'];
    }

    /**
     * Sets shipping_label
     *
     * @param string $shipping_label Shipping label.
     *
     * @return $this
     */
    public function setShippingLabel($shipping_label)
    {
        $this->container['shipping_label'] = $shipping_label;

        return $this;
    }

    /**
     * Gets store_id
     *
     * @return int
     */
    public function getStoreId()
    {
        return $this->container['store_id'];
    }

    /**
     * Sets store_id
     *
     * @param int $store_id Store ID.
     *
     * @return $this
     */
    public function setStoreId($store_id)
    {
        $this->container['store_id'] = $store_id;

        return $this;
    }

    /**
     * Gets total_qty
     *
     * @return float
     */
    public function getTotalQty()
    {
        return $this->container['total_qty'];
    }

    /**
     * Sets total_qty
     *
     * @param float $total_qty Total quantity.
     *
     * @return $this
     */
    public function setTotalQty($total_qty)
    {
        $this->container['total_qty'] = $total_qty;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float $total_weight Total weight.
     *
     * @return $this
     */
    public function setTotalWeight($total_weight)
    {
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string $updated_at Updated-at timestamp.
     *
     * @return $this
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Swagger\Client\Model\SalesDataShipmentItemInterface[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Swagger\Client\Model\SalesDataShipmentItemInterface[] $items Array of items.
     *
     * @return $this
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets tracks
     *
     * @return \Swagger\Client\Model\SalesDataShipmentTrackInterface[]
     */
    public function getTracks()
    {
        return $this->container['tracks'];
    }

    /**
     * Sets tracks
     *
     * @param \Swagger\Client\Model\SalesDataShipmentTrackInterface[] $tracks Array of tracks.
     *
     * @return $this
     */
    public function setTracks($tracks)
    {
        $this->container['tracks'] = $tracks;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return \Swagger\Client\Model\SalesDataShipmentCommentInterface[]
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param \Swagger\Client\Model\SalesDataShipmentCommentInterface[] $comments Array of comments.
     *
     * @return $this
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Swagger\Client\Model\SalesDataShipmentExtensionInterface
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Swagger\Client\Model\SalesDataShipmentExtensionInterface $extension_attributes extension_attributes
     *
     * @return $this
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


