<?php
/**
 * SalesDataOrderPaymentInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Magento Enterprise Edition 2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * SalesDataOrderPaymentInterface Class Doc Comment
 *
 * @category Class
 * @description Order payment interface. An order is a document that a web store issues to a customer. Magento generates a sales order that lists the product items, billing and shipping addresses, and shipping and payment methods. A corresponding external document, known as a purchase order, is emailed to the customer.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SalesDataOrderPaymentInterface implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'sales-data-order-payment-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'account_status' => 'string',
        'additional_data' => 'string',
        'additional_information' => 'string[]',
        'address_status' => 'string',
        'amount_authorized' => 'float',
        'amount_canceled' => 'float',
        'amount_ordered' => 'float',
        'amount_paid' => 'float',
        'amount_refunded' => 'float',
        'anet_trans_method' => 'string',
        'base_amount_authorized' => 'float',
        'base_amount_canceled' => 'float',
        'base_amount_ordered' => 'float',
        'base_amount_paid' => 'float',
        'base_amount_paid_online' => 'float',
        'base_amount_refunded' => 'float',
        'base_amount_refunded_online' => 'float',
        'base_shipping_amount' => 'float',
        'base_shipping_captured' => 'float',
        'base_shipping_refunded' => 'float',
        'cc_approval' => 'string',
        'cc_avs_status' => 'string',
        'cc_cid_status' => 'string',
        'cc_debug_request_body' => 'string',
        'cc_debug_response_body' => 'string',
        'cc_debug_response_serialized' => 'string',
        'cc_exp_month' => 'string',
        'cc_exp_year' => 'string',
        'cc_last4' => 'string',
        'cc_number_enc' => 'string',
        'cc_owner' => 'string',
        'cc_secure_verify' => 'string',
        'cc_ss_issue' => 'string',
        'cc_ss_start_month' => 'string',
        'cc_ss_start_year' => 'string',
        'cc_status' => 'string',
        'cc_status_description' => 'string',
        'cc_trans_id' => 'string',
        'cc_type' => 'string',
        'echeck_account_name' => 'string',
        'echeck_account_type' => 'string',
        'echeck_bank_name' => 'string',
        'echeck_routing_number' => 'string',
        'echeck_type' => 'string',
        'entity_id' => 'int',
        'last_trans_id' => 'string',
        'method' => 'string',
        'parent_id' => 'int',
        'po_number' => 'string',
        'protection_eligibility' => 'string',
        'quote_payment_id' => 'int',
        'shipping_amount' => 'float',
        'shipping_captured' => 'float',
        'shipping_refunded' => 'float',
        'extension_attributes' => '\Swagger\Client\Model\SalesDataOrderPaymentExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'account_status' => null,
        'additional_data' => null,
        'additional_information' => null,
        'address_status' => null,
        'amount_authorized' => null,
        'amount_canceled' => null,
        'amount_ordered' => null,
        'amount_paid' => null,
        'amount_refunded' => null,
        'anet_trans_method' => null,
        'base_amount_authorized' => null,
        'base_amount_canceled' => null,
        'base_amount_ordered' => null,
        'base_amount_paid' => null,
        'base_amount_paid_online' => null,
        'base_amount_refunded' => null,
        'base_amount_refunded_online' => null,
        'base_shipping_amount' => null,
        'base_shipping_captured' => null,
        'base_shipping_refunded' => null,
        'cc_approval' => null,
        'cc_avs_status' => null,
        'cc_cid_status' => null,
        'cc_debug_request_body' => null,
        'cc_debug_response_body' => null,
        'cc_debug_response_serialized' => null,
        'cc_exp_month' => null,
        'cc_exp_year' => null,
        'cc_last4' => null,
        'cc_number_enc' => null,
        'cc_owner' => null,
        'cc_secure_verify' => null,
        'cc_ss_issue' => null,
        'cc_ss_start_month' => null,
        'cc_ss_start_year' => null,
        'cc_status' => null,
        'cc_status_description' => null,
        'cc_trans_id' => null,
        'cc_type' => null,
        'echeck_account_name' => null,
        'echeck_account_type' => null,
        'echeck_bank_name' => null,
        'echeck_routing_number' => null,
        'echeck_type' => null,
        'entity_id' => null,
        'last_trans_id' => null,
        'method' => null,
        'parent_id' => null,
        'po_number' => null,
        'protection_eligibility' => null,
        'quote_payment_id' => null,
        'shipping_amount' => null,
        'shipping_captured' => null,
        'shipping_refunded' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account_status' => 'accountStatus',
        'additional_data' => 'additionalData',
        'additional_information' => 'additionalInformation',
        'address_status' => 'addressStatus',
        'amount_authorized' => 'amountAuthorized',
        'amount_canceled' => 'amountCanceled',
        'amount_ordered' => 'amountOrdered',
        'amount_paid' => 'amountPaid',
        'amount_refunded' => 'amountRefunded',
        'anet_trans_method' => 'anetTransMethod',
        'base_amount_authorized' => 'baseAmountAuthorized',
        'base_amount_canceled' => 'baseAmountCanceled',
        'base_amount_ordered' => 'baseAmountOrdered',
        'base_amount_paid' => 'baseAmountPaid',
        'base_amount_paid_online' => 'baseAmountPaidOnline',
        'base_amount_refunded' => 'baseAmountRefunded',
        'base_amount_refunded_online' => 'baseAmountRefundedOnline',
        'base_shipping_amount' => 'baseShippingAmount',
        'base_shipping_captured' => 'baseShippingCaptured',
        'base_shipping_refunded' => 'baseShippingRefunded',
        'cc_approval' => 'ccApproval',
        'cc_avs_status' => 'ccAvsStatus',
        'cc_cid_status' => 'ccCidStatus',
        'cc_debug_request_body' => 'ccDebugRequestBody',
        'cc_debug_response_body' => 'ccDebugResponseBody',
        'cc_debug_response_serialized' => 'ccDebugResponseSerialized',
        'cc_exp_month' => 'ccExpMonth',
        'cc_exp_year' => 'ccExpYear',
        'cc_last4' => 'ccLast4',
        'cc_number_enc' => 'ccNumberEnc',
        'cc_owner' => 'ccOwner',
        'cc_secure_verify' => 'ccSecureVerify',
        'cc_ss_issue' => 'ccSsIssue',
        'cc_ss_start_month' => 'ccSsStartMonth',
        'cc_ss_start_year' => 'ccSsStartYear',
        'cc_status' => 'ccStatus',
        'cc_status_description' => 'ccStatusDescription',
        'cc_trans_id' => 'ccTransId',
        'cc_type' => 'ccType',
        'echeck_account_name' => 'echeckAccountName',
        'echeck_account_type' => 'echeckAccountType',
        'echeck_bank_name' => 'echeckBankName',
        'echeck_routing_number' => 'echeckRoutingNumber',
        'echeck_type' => 'echeckType',
        'entity_id' => 'entityId',
        'last_trans_id' => 'lastTransId',
        'method' => 'method',
        'parent_id' => 'parentId',
        'po_number' => 'poNumber',
        'protection_eligibility' => 'protectionEligibility',
        'quote_payment_id' => 'quotePaymentId',
        'shipping_amount' => 'shippingAmount',
        'shipping_captured' => 'shippingCaptured',
        'shipping_refunded' => 'shippingRefunded',
        'extension_attributes' => 'extensionAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account_status' => 'setAccountStatus',
        'additional_data' => 'setAdditionalData',
        'additional_information' => 'setAdditionalInformation',
        'address_status' => 'setAddressStatus',
        'amount_authorized' => 'setAmountAuthorized',
        'amount_canceled' => 'setAmountCanceled',
        'amount_ordered' => 'setAmountOrdered',
        'amount_paid' => 'setAmountPaid',
        'amount_refunded' => 'setAmountRefunded',
        'anet_trans_method' => 'setAnetTransMethod',
        'base_amount_authorized' => 'setBaseAmountAuthorized',
        'base_amount_canceled' => 'setBaseAmountCanceled',
        'base_amount_ordered' => 'setBaseAmountOrdered',
        'base_amount_paid' => 'setBaseAmountPaid',
        'base_amount_paid_online' => 'setBaseAmountPaidOnline',
        'base_amount_refunded' => 'setBaseAmountRefunded',
        'base_amount_refunded_online' => 'setBaseAmountRefundedOnline',
        'base_shipping_amount' => 'setBaseShippingAmount',
        'base_shipping_captured' => 'setBaseShippingCaptured',
        'base_shipping_refunded' => 'setBaseShippingRefunded',
        'cc_approval' => 'setCcApproval',
        'cc_avs_status' => 'setCcAvsStatus',
        'cc_cid_status' => 'setCcCidStatus',
        'cc_debug_request_body' => 'setCcDebugRequestBody',
        'cc_debug_response_body' => 'setCcDebugResponseBody',
        'cc_debug_response_serialized' => 'setCcDebugResponseSerialized',
        'cc_exp_month' => 'setCcExpMonth',
        'cc_exp_year' => 'setCcExpYear',
        'cc_last4' => 'setCcLast4',
        'cc_number_enc' => 'setCcNumberEnc',
        'cc_owner' => 'setCcOwner',
        'cc_secure_verify' => 'setCcSecureVerify',
        'cc_ss_issue' => 'setCcSsIssue',
        'cc_ss_start_month' => 'setCcSsStartMonth',
        'cc_ss_start_year' => 'setCcSsStartYear',
        'cc_status' => 'setCcStatus',
        'cc_status_description' => 'setCcStatusDescription',
        'cc_trans_id' => 'setCcTransId',
        'cc_type' => 'setCcType',
        'echeck_account_name' => 'setEcheckAccountName',
        'echeck_account_type' => 'setEcheckAccountType',
        'echeck_bank_name' => 'setEcheckBankName',
        'echeck_routing_number' => 'setEcheckRoutingNumber',
        'echeck_type' => 'setEcheckType',
        'entity_id' => 'setEntityId',
        'last_trans_id' => 'setLastTransId',
        'method' => 'setMethod',
        'parent_id' => 'setParentId',
        'po_number' => 'setPoNumber',
        'protection_eligibility' => 'setProtectionEligibility',
        'quote_payment_id' => 'setQuotePaymentId',
        'shipping_amount' => 'setShippingAmount',
        'shipping_captured' => 'setShippingCaptured',
        'shipping_refunded' => 'setShippingRefunded',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account_status' => 'getAccountStatus',
        'additional_data' => 'getAdditionalData',
        'additional_information' => 'getAdditionalInformation',
        'address_status' => 'getAddressStatus',
        'amount_authorized' => 'getAmountAuthorized',
        'amount_canceled' => 'getAmountCanceled',
        'amount_ordered' => 'getAmountOrdered',
        'amount_paid' => 'getAmountPaid',
        'amount_refunded' => 'getAmountRefunded',
        'anet_trans_method' => 'getAnetTransMethod',
        'base_amount_authorized' => 'getBaseAmountAuthorized',
        'base_amount_canceled' => 'getBaseAmountCanceled',
        'base_amount_ordered' => 'getBaseAmountOrdered',
        'base_amount_paid' => 'getBaseAmountPaid',
        'base_amount_paid_online' => 'getBaseAmountPaidOnline',
        'base_amount_refunded' => 'getBaseAmountRefunded',
        'base_amount_refunded_online' => 'getBaseAmountRefundedOnline',
        'base_shipping_amount' => 'getBaseShippingAmount',
        'base_shipping_captured' => 'getBaseShippingCaptured',
        'base_shipping_refunded' => 'getBaseShippingRefunded',
        'cc_approval' => 'getCcApproval',
        'cc_avs_status' => 'getCcAvsStatus',
        'cc_cid_status' => 'getCcCidStatus',
        'cc_debug_request_body' => 'getCcDebugRequestBody',
        'cc_debug_response_body' => 'getCcDebugResponseBody',
        'cc_debug_response_serialized' => 'getCcDebugResponseSerialized',
        'cc_exp_month' => 'getCcExpMonth',
        'cc_exp_year' => 'getCcExpYear',
        'cc_last4' => 'getCcLast4',
        'cc_number_enc' => 'getCcNumberEnc',
        'cc_owner' => 'getCcOwner',
        'cc_secure_verify' => 'getCcSecureVerify',
        'cc_ss_issue' => 'getCcSsIssue',
        'cc_ss_start_month' => 'getCcSsStartMonth',
        'cc_ss_start_year' => 'getCcSsStartYear',
        'cc_status' => 'getCcStatus',
        'cc_status_description' => 'getCcStatusDescription',
        'cc_trans_id' => 'getCcTransId',
        'cc_type' => 'getCcType',
        'echeck_account_name' => 'getEcheckAccountName',
        'echeck_account_type' => 'getEcheckAccountType',
        'echeck_bank_name' => 'getEcheckBankName',
        'echeck_routing_number' => 'getEcheckRoutingNumber',
        'echeck_type' => 'getEcheckType',
        'entity_id' => 'getEntityId',
        'last_trans_id' => 'getLastTransId',
        'method' => 'getMethod',
        'parent_id' => 'getParentId',
        'po_number' => 'getPoNumber',
        'protection_eligibility' => 'getProtectionEligibility',
        'quote_payment_id' => 'getQuotePaymentId',
        'shipping_amount' => 'getShippingAmount',
        'shipping_captured' => 'getShippingCaptured',
        'shipping_refunded' => 'getShippingRefunded',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account_status'] = isset($data['account_status']) ? $data['account_status'] : null;
        $this->container['additional_data'] = isset($data['additional_data']) ? $data['additional_data'] : null;
        $this->container['additional_information'] = isset($data['additional_information']) ? $data['additional_information'] : null;
        $this->container['address_status'] = isset($data['address_status']) ? $data['address_status'] : null;
        $this->container['amount_authorized'] = isset($data['amount_authorized']) ? $data['amount_authorized'] : null;
        $this->container['amount_canceled'] = isset($data['amount_canceled']) ? $data['amount_canceled'] : null;
        $this->container['amount_ordered'] = isset($data['amount_ordered']) ? $data['amount_ordered'] : null;
        $this->container['amount_paid'] = isset($data['amount_paid']) ? $data['amount_paid'] : null;
        $this->container['amount_refunded'] = isset($data['amount_refunded']) ? $data['amount_refunded'] : null;
        $this->container['anet_trans_method'] = isset($data['anet_trans_method']) ? $data['anet_trans_method'] : null;
        $this->container['base_amount_authorized'] = isset($data['base_amount_authorized']) ? $data['base_amount_authorized'] : null;
        $this->container['base_amount_canceled'] = isset($data['base_amount_canceled']) ? $data['base_amount_canceled'] : null;
        $this->container['base_amount_ordered'] = isset($data['base_amount_ordered']) ? $data['base_amount_ordered'] : null;
        $this->container['base_amount_paid'] = isset($data['base_amount_paid']) ? $data['base_amount_paid'] : null;
        $this->container['base_amount_paid_online'] = isset($data['base_amount_paid_online']) ? $data['base_amount_paid_online'] : null;
        $this->container['base_amount_refunded'] = isset($data['base_amount_refunded']) ? $data['base_amount_refunded'] : null;
        $this->container['base_amount_refunded_online'] = isset($data['base_amount_refunded_online']) ? $data['base_amount_refunded_online'] : null;
        $this->container['base_shipping_amount'] = isset($data['base_shipping_amount']) ? $data['base_shipping_amount'] : null;
        $this->container['base_shipping_captured'] = isset($data['base_shipping_captured']) ? $data['base_shipping_captured'] : null;
        $this->container['base_shipping_refunded'] = isset($data['base_shipping_refunded']) ? $data['base_shipping_refunded'] : null;
        $this->container['cc_approval'] = isset($data['cc_approval']) ? $data['cc_approval'] : null;
        $this->container['cc_avs_status'] = isset($data['cc_avs_status']) ? $data['cc_avs_status'] : null;
        $this->container['cc_cid_status'] = isset($data['cc_cid_status']) ? $data['cc_cid_status'] : null;
        $this->container['cc_debug_request_body'] = isset($data['cc_debug_request_body']) ? $data['cc_debug_request_body'] : null;
        $this->container['cc_debug_response_body'] = isset($data['cc_debug_response_body']) ? $data['cc_debug_response_body'] : null;
        $this->container['cc_debug_response_serialized'] = isset($data['cc_debug_response_serialized']) ? $data['cc_debug_response_serialized'] : null;
        $this->container['cc_exp_month'] = isset($data['cc_exp_month']) ? $data['cc_exp_month'] : null;
        $this->container['cc_exp_year'] = isset($data['cc_exp_year']) ? $data['cc_exp_year'] : null;
        $this->container['cc_last4'] = isset($data['cc_last4']) ? $data['cc_last4'] : null;
        $this->container['cc_number_enc'] = isset($data['cc_number_enc']) ? $data['cc_number_enc'] : null;
        $this->container['cc_owner'] = isset($data['cc_owner']) ? $data['cc_owner'] : null;
        $this->container['cc_secure_verify'] = isset($data['cc_secure_verify']) ? $data['cc_secure_verify'] : null;
        $this->container['cc_ss_issue'] = isset($data['cc_ss_issue']) ? $data['cc_ss_issue'] : null;
        $this->container['cc_ss_start_month'] = isset($data['cc_ss_start_month']) ? $data['cc_ss_start_month'] : null;
        $this->container['cc_ss_start_year'] = isset($data['cc_ss_start_year']) ? $data['cc_ss_start_year'] : null;
        $this->container['cc_status'] = isset($data['cc_status']) ? $data['cc_status'] : null;
        $this->container['cc_status_description'] = isset($data['cc_status_description']) ? $data['cc_status_description'] : null;
        $this->container['cc_trans_id'] = isset($data['cc_trans_id']) ? $data['cc_trans_id'] : null;
        $this->container['cc_type'] = isset($data['cc_type']) ? $data['cc_type'] : null;
        $this->container['echeck_account_name'] = isset($data['echeck_account_name']) ? $data['echeck_account_name'] : null;
        $this->container['echeck_account_type'] = isset($data['echeck_account_type']) ? $data['echeck_account_type'] : null;
        $this->container['echeck_bank_name'] = isset($data['echeck_bank_name']) ? $data['echeck_bank_name'] : null;
        $this->container['echeck_routing_number'] = isset($data['echeck_routing_number']) ? $data['echeck_routing_number'] : null;
        $this->container['echeck_type'] = isset($data['echeck_type']) ? $data['echeck_type'] : null;
        $this->container['entity_id'] = isset($data['entity_id']) ? $data['entity_id'] : null;
        $this->container['last_trans_id'] = isset($data['last_trans_id']) ? $data['last_trans_id'] : null;
        $this->container['method'] = isset($data['method']) ? $data['method'] : null;
        $this->container['parent_id'] = isset($data['parent_id']) ? $data['parent_id'] : null;
        $this->container['po_number'] = isset($data['po_number']) ? $data['po_number'] : null;
        $this->container['protection_eligibility'] = isset($data['protection_eligibility']) ? $data['protection_eligibility'] : null;
        $this->container['quote_payment_id'] = isset($data['quote_payment_id']) ? $data['quote_payment_id'] : null;
        $this->container['shipping_amount'] = isset($data['shipping_amount']) ? $data['shipping_amount'] : null;
        $this->container['shipping_captured'] = isset($data['shipping_captured']) ? $data['shipping_captured'] : null;
        $this->container['shipping_refunded'] = isset($data['shipping_refunded']) ? $data['shipping_refunded'] : null;
        $this->container['extension_attributes'] = isset($data['extension_attributes']) ? $data['extension_attributes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['account_status'] === null) {
            $invalidProperties[] = "'account_status' can't be null";
        }
        if ($this->container['additional_information'] === null) {
            $invalidProperties[] = "'additional_information' can't be null";
        }
        if ($this->container['cc_last4'] === null) {
            $invalidProperties[] = "'cc_last4' can't be null";
        }
        if ($this->container['method'] === null) {
            $invalidProperties[] = "'method' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['account_status'] === null) {
            return false;
        }
        if ($this->container['additional_information'] === null) {
            return false;
        }
        if ($this->container['cc_last4'] === null) {
            return false;
        }
        if ($this->container['method'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets account_status
     *
     * @return string
     */
    public function getAccountStatus()
    {
        return $this->container['account_status'];
    }

    /**
     * Sets account_status
     *
     * @param string $account_status Account status.
     *
     * @return $this
     */
    public function setAccountStatus($account_status)
    {
        $this->container['account_status'] = $account_status;

        return $this;
    }

    /**
     * Gets additional_data
     *
     * @return string
     */
    public function getAdditionalData()
    {
        return $this->container['additional_data'];
    }

    /**
     * Sets additional_data
     *
     * @param string $additional_data Additional data.
     *
     * @return $this
     */
    public function setAdditionalData($additional_data)
    {
        $this->container['additional_data'] = $additional_data;

        return $this;
    }

    /**
     * Gets additional_information
     *
     * @return string[]
     */
    public function getAdditionalInformation()
    {
        return $this->container['additional_information'];
    }

    /**
     * Sets additional_information
     *
     * @param string[] $additional_information Array of additional information.
     *
     * @return $this
     */
    public function setAdditionalInformation($additional_information)
    {
        $this->container['additional_information'] = $additional_information;

        return $this;
    }

    /**
     * Gets address_status
     *
     * @return string
     */
    public function getAddressStatus()
    {
        return $this->container['address_status'];
    }

    /**
     * Sets address_status
     *
     * @param string $address_status Address status.
     *
     * @return $this
     */
    public function setAddressStatus($address_status)
    {
        $this->container['address_status'] = $address_status;

        return $this;
    }

    /**
     * Gets amount_authorized
     *
     * @return float
     */
    public function getAmountAuthorized()
    {
        return $this->container['amount_authorized'];
    }

    /**
     * Sets amount_authorized
     *
     * @param float $amount_authorized Amount authorized.
     *
     * @return $this
     */
    public function setAmountAuthorized($amount_authorized)
    {
        $this->container['amount_authorized'] = $amount_authorized;

        return $this;
    }

    /**
     * Gets amount_canceled
     *
     * @return float
     */
    public function getAmountCanceled()
    {
        return $this->container['amount_canceled'];
    }

    /**
     * Sets amount_canceled
     *
     * @param float $amount_canceled Amount canceled.
     *
     * @return $this
     */
    public function setAmountCanceled($amount_canceled)
    {
        $this->container['amount_canceled'] = $amount_canceled;

        return $this;
    }

    /**
     * Gets amount_ordered
     *
     * @return float
     */
    public function getAmountOrdered()
    {
        return $this->container['amount_ordered'];
    }

    /**
     * Sets amount_ordered
     *
     * @param float $amount_ordered Amount ordered.
     *
     * @return $this
     */
    public function setAmountOrdered($amount_ordered)
    {
        $this->container['amount_ordered'] = $amount_ordered;

        return $this;
    }

    /**
     * Gets amount_paid
     *
     * @return float
     */
    public function getAmountPaid()
    {
        return $this->container['amount_paid'];
    }

    /**
     * Sets amount_paid
     *
     * @param float $amount_paid Amount paid.
     *
     * @return $this
     */
    public function setAmountPaid($amount_paid)
    {
        $this->container['amount_paid'] = $amount_paid;

        return $this;
    }

    /**
     * Gets amount_refunded
     *
     * @return float
     */
    public function getAmountRefunded()
    {
        return $this->container['amount_refunded'];
    }

    /**
     * Sets amount_refunded
     *
     * @param float $amount_refunded Amount refunded.
     *
     * @return $this
     */
    public function setAmountRefunded($amount_refunded)
    {
        $this->container['amount_refunded'] = $amount_refunded;

        return $this;
    }

    /**
     * Gets anet_trans_method
     *
     * @return string
     */
    public function getAnetTransMethod()
    {
        return $this->container['anet_trans_method'];
    }

    /**
     * Sets anet_trans_method
     *
     * @param string $anet_trans_method Anet transaction method.
     *
     * @return $this
     */
    public function setAnetTransMethod($anet_trans_method)
    {
        $this->container['anet_trans_method'] = $anet_trans_method;

        return $this;
    }

    /**
     * Gets base_amount_authorized
     *
     * @return float
     */
    public function getBaseAmountAuthorized()
    {
        return $this->container['base_amount_authorized'];
    }

    /**
     * Sets base_amount_authorized
     *
     * @param float $base_amount_authorized Base amount authorized.
     *
     * @return $this
     */
    public function setBaseAmountAuthorized($base_amount_authorized)
    {
        $this->container['base_amount_authorized'] = $base_amount_authorized;

        return $this;
    }

    /**
     * Gets base_amount_canceled
     *
     * @return float
     */
    public function getBaseAmountCanceled()
    {
        return $this->container['base_amount_canceled'];
    }

    /**
     * Sets base_amount_canceled
     *
     * @param float $base_amount_canceled Base amount canceled.
     *
     * @return $this
     */
    public function setBaseAmountCanceled($base_amount_canceled)
    {
        $this->container['base_amount_canceled'] = $base_amount_canceled;

        return $this;
    }

    /**
     * Gets base_amount_ordered
     *
     * @return float
     */
    public function getBaseAmountOrdered()
    {
        return $this->container['base_amount_ordered'];
    }

    /**
     * Sets base_amount_ordered
     *
     * @param float $base_amount_ordered Base amount ordered.
     *
     * @return $this
     */
    public function setBaseAmountOrdered($base_amount_ordered)
    {
        $this->container['base_amount_ordered'] = $base_amount_ordered;

        return $this;
    }

    /**
     * Gets base_amount_paid
     *
     * @return float
     */
    public function getBaseAmountPaid()
    {
        return $this->container['base_amount_paid'];
    }

    /**
     * Sets base_amount_paid
     *
     * @param float $base_amount_paid Base amount paid.
     *
     * @return $this
     */
    public function setBaseAmountPaid($base_amount_paid)
    {
        $this->container['base_amount_paid'] = $base_amount_paid;

        return $this;
    }

    /**
     * Gets base_amount_paid_online
     *
     * @return float
     */
    public function getBaseAmountPaidOnline()
    {
        return $this->container['base_amount_paid_online'];
    }

    /**
     * Sets base_amount_paid_online
     *
     * @param float $base_amount_paid_online Base amount paid online.
     *
     * @return $this
     */
    public function setBaseAmountPaidOnline($base_amount_paid_online)
    {
        $this->container['base_amount_paid_online'] = $base_amount_paid_online;

        return $this;
    }

    /**
     * Gets base_amount_refunded
     *
     * @return float
     */
    public function getBaseAmountRefunded()
    {
        return $this->container['base_amount_refunded'];
    }

    /**
     * Sets base_amount_refunded
     *
     * @param float $base_amount_refunded Base amount refunded.
     *
     * @return $this
     */
    public function setBaseAmountRefunded($base_amount_refunded)
    {
        $this->container['base_amount_refunded'] = $base_amount_refunded;

        return $this;
    }

    /**
     * Gets base_amount_refunded_online
     *
     * @return float
     */
    public function getBaseAmountRefundedOnline()
    {
        return $this->container['base_amount_refunded_online'];
    }

    /**
     * Sets base_amount_refunded_online
     *
     * @param float $base_amount_refunded_online Base amount refunded online.
     *
     * @return $this
     */
    public function setBaseAmountRefundedOnline($base_amount_refunded_online)
    {
        $this->container['base_amount_refunded_online'] = $base_amount_refunded_online;

        return $this;
    }

    /**
     * Gets base_shipping_amount
     *
     * @return float
     */
    public function getBaseShippingAmount()
    {
        return $this->container['base_shipping_amount'];
    }

    /**
     * Sets base_shipping_amount
     *
     * @param float $base_shipping_amount Base shipping amount.
     *
     * @return $this
     */
    public function setBaseShippingAmount($base_shipping_amount)
    {
        $this->container['base_shipping_amount'] = $base_shipping_amount;

        return $this;
    }

    /**
     * Gets base_shipping_captured
     *
     * @return float
     */
    public function getBaseShippingCaptured()
    {
        return $this->container['base_shipping_captured'];
    }

    /**
     * Sets base_shipping_captured
     *
     * @param float $base_shipping_captured Base shipping captured amount.
     *
     * @return $this
     */
    public function setBaseShippingCaptured($base_shipping_captured)
    {
        $this->container['base_shipping_captured'] = $base_shipping_captured;

        return $this;
    }

    /**
     * Gets base_shipping_refunded
     *
     * @return float
     */
    public function getBaseShippingRefunded()
    {
        return $this->container['base_shipping_refunded'];
    }

    /**
     * Sets base_shipping_refunded
     *
     * @param float $base_shipping_refunded Base shipping refunded amount.
     *
     * @return $this
     */
    public function setBaseShippingRefunded($base_shipping_refunded)
    {
        $this->container['base_shipping_refunded'] = $base_shipping_refunded;

        return $this;
    }

    /**
     * Gets cc_approval
     *
     * @return string
     */
    public function getCcApproval()
    {
        return $this->container['cc_approval'];
    }

    /**
     * Sets cc_approval
     *
     * @param string $cc_approval Credit card approval.
     *
     * @return $this
     */
    public function setCcApproval($cc_approval)
    {
        $this->container['cc_approval'] = $cc_approval;

        return $this;
    }

    /**
     * Gets cc_avs_status
     *
     * @return string
     */
    public function getCcAvsStatus()
    {
        return $this->container['cc_avs_status'];
    }

    /**
     * Sets cc_avs_status
     *
     * @param string $cc_avs_status Credit card avs status.
     *
     * @return $this
     */
    public function setCcAvsStatus($cc_avs_status)
    {
        $this->container['cc_avs_status'] = $cc_avs_status;

        return $this;
    }

    /**
     * Gets cc_cid_status
     *
     * @return string
     */
    public function getCcCidStatus()
    {
        return $this->container['cc_cid_status'];
    }

    /**
     * Sets cc_cid_status
     *
     * @param string $cc_cid_status Credit card CID status.
     *
     * @return $this
     */
    public function setCcCidStatus($cc_cid_status)
    {
        $this->container['cc_cid_status'] = $cc_cid_status;

        return $this;
    }

    /**
     * Gets cc_debug_request_body
     *
     * @return string
     */
    public function getCcDebugRequestBody()
    {
        return $this->container['cc_debug_request_body'];
    }

    /**
     * Sets cc_debug_request_body
     *
     * @param string $cc_debug_request_body Credit card debug request body.
     *
     * @return $this
     */
    public function setCcDebugRequestBody($cc_debug_request_body)
    {
        $this->container['cc_debug_request_body'] = $cc_debug_request_body;

        return $this;
    }

    /**
     * Gets cc_debug_response_body
     *
     * @return string
     */
    public function getCcDebugResponseBody()
    {
        return $this->container['cc_debug_response_body'];
    }

    /**
     * Sets cc_debug_response_body
     *
     * @param string $cc_debug_response_body Credit card debug response body.
     *
     * @return $this
     */
    public function setCcDebugResponseBody($cc_debug_response_body)
    {
        $this->container['cc_debug_response_body'] = $cc_debug_response_body;

        return $this;
    }

    /**
     * Gets cc_debug_response_serialized
     *
     * @return string
     */
    public function getCcDebugResponseSerialized()
    {
        return $this->container['cc_debug_response_serialized'];
    }

    /**
     * Sets cc_debug_response_serialized
     *
     * @param string $cc_debug_response_serialized Credit card debug response serialized.
     *
     * @return $this
     */
    public function setCcDebugResponseSerialized($cc_debug_response_serialized)
    {
        $this->container['cc_debug_response_serialized'] = $cc_debug_response_serialized;

        return $this;
    }

    /**
     * Gets cc_exp_month
     *
     * @return string
     */
    public function getCcExpMonth()
    {
        return $this->container['cc_exp_month'];
    }

    /**
     * Sets cc_exp_month
     *
     * @param string $cc_exp_month Credit card expiration month.
     *
     * @return $this
     */
    public function setCcExpMonth($cc_exp_month)
    {
        $this->container['cc_exp_month'] = $cc_exp_month;

        return $this;
    }

    /**
     * Gets cc_exp_year
     *
     * @return string
     */
    public function getCcExpYear()
    {
        return $this->container['cc_exp_year'];
    }

    /**
     * Sets cc_exp_year
     *
     * @param string $cc_exp_year Credit card expiration year.
     *
     * @return $this
     */
    public function setCcExpYear($cc_exp_year)
    {
        $this->container['cc_exp_year'] = $cc_exp_year;

        return $this;
    }

    /**
     * Gets cc_last4
     *
     * @return string
     */
    public function getCcLast4()
    {
        return $this->container['cc_last4'];
    }

    /**
     * Sets cc_last4
     *
     * @param string $cc_last4 Last four digits of the credit card.
     *
     * @return $this
     */
    public function setCcLast4($cc_last4)
    {
        $this->container['cc_last4'] = $cc_last4;

        return $this;
    }

    /**
     * Gets cc_number_enc
     *
     * @return string
     */
    public function getCcNumberEnc()
    {
        return $this->container['cc_number_enc'];
    }

    /**
     * Sets cc_number_enc
     *
     * @param string $cc_number_enc Encrypted credit card number.
     *
     * @return $this
     */
    public function setCcNumberEnc($cc_number_enc)
    {
        $this->container['cc_number_enc'] = $cc_number_enc;

        return $this;
    }

    /**
     * Gets cc_owner
     *
     * @return string
     */
    public function getCcOwner()
    {
        return $this->container['cc_owner'];
    }

    /**
     * Sets cc_owner
     *
     * @param string $cc_owner Credit card number.
     *
     * @return $this
     */
    public function setCcOwner($cc_owner)
    {
        $this->container['cc_owner'] = $cc_owner;

        return $this;
    }

    /**
     * Gets cc_secure_verify
     *
     * @return string
     */
    public function getCcSecureVerify()
    {
        return $this->container['cc_secure_verify'];
    }

    /**
     * Sets cc_secure_verify
     *
     * @param string $cc_secure_verify Credit card secure verify.
     *
     * @return $this
     */
    public function setCcSecureVerify($cc_secure_verify)
    {
        $this->container['cc_secure_verify'] = $cc_secure_verify;

        return $this;
    }

    /**
     * Gets cc_ss_issue
     *
     * @return string
     */
    public function getCcSsIssue()
    {
        return $this->container['cc_ss_issue'];
    }

    /**
     * Sets cc_ss_issue
     *
     * @param string $cc_ss_issue Credit card SS issue.
     *
     * @return $this
     */
    public function setCcSsIssue($cc_ss_issue)
    {
        $this->container['cc_ss_issue'] = $cc_ss_issue;

        return $this;
    }

    /**
     * Gets cc_ss_start_month
     *
     * @return string
     */
    public function getCcSsStartMonth()
    {
        return $this->container['cc_ss_start_month'];
    }

    /**
     * Sets cc_ss_start_month
     *
     * @param string $cc_ss_start_month Credit card SS start month.
     *
     * @return $this
     */
    public function setCcSsStartMonth($cc_ss_start_month)
    {
        $this->container['cc_ss_start_month'] = $cc_ss_start_month;

        return $this;
    }

    /**
     * Gets cc_ss_start_year
     *
     * @return string
     */
    public function getCcSsStartYear()
    {
        return $this->container['cc_ss_start_year'];
    }

    /**
     * Sets cc_ss_start_year
     *
     * @param string $cc_ss_start_year Credit card SS start year.
     *
     * @return $this
     */
    public function setCcSsStartYear($cc_ss_start_year)
    {
        $this->container['cc_ss_start_year'] = $cc_ss_start_year;

        return $this;
    }

    /**
     * Gets cc_status
     *
     * @return string
     */
    public function getCcStatus()
    {
        return $this->container['cc_status'];
    }

    /**
     * Sets cc_status
     *
     * @param string $cc_status Credit card status.
     *
     * @return $this
     */
    public function setCcStatus($cc_status)
    {
        $this->container['cc_status'] = $cc_status;

        return $this;
    }

    /**
     * Gets cc_status_description
     *
     * @return string
     */
    public function getCcStatusDescription()
    {
        return $this->container['cc_status_description'];
    }

    /**
     * Sets cc_status_description
     *
     * @param string $cc_status_description Credit card status description.
     *
     * @return $this
     */
    public function setCcStatusDescription($cc_status_description)
    {
        $this->container['cc_status_description'] = $cc_status_description;

        return $this;
    }

    /**
     * Gets cc_trans_id
     *
     * @return string
     */
    public function getCcTransId()
    {
        return $this->container['cc_trans_id'];
    }

    /**
     * Sets cc_trans_id
     *
     * @param string $cc_trans_id Credit card transaction ID.
     *
     * @return $this
     */
    public function setCcTransId($cc_trans_id)
    {
        $this->container['cc_trans_id'] = $cc_trans_id;

        return $this;
    }

    /**
     * Gets cc_type
     *
     * @return string
     */
    public function getCcType()
    {
        return $this->container['cc_type'];
    }

    /**
     * Sets cc_type
     *
     * @param string $cc_type Credit card type.
     *
     * @return $this
     */
    public function setCcType($cc_type)
    {
        $this->container['cc_type'] = $cc_type;

        return $this;
    }

    /**
     * Gets echeck_account_name
     *
     * @return string
     */
    public function getEcheckAccountName()
    {
        return $this->container['echeck_account_name'];
    }

    /**
     * Sets echeck_account_name
     *
     * @param string $echeck_account_name eCheck account name.
     *
     * @return $this
     */
    public function setEcheckAccountName($echeck_account_name)
    {
        $this->container['echeck_account_name'] = $echeck_account_name;

        return $this;
    }

    /**
     * Gets echeck_account_type
     *
     * @return string
     */
    public function getEcheckAccountType()
    {
        return $this->container['echeck_account_type'];
    }

    /**
     * Sets echeck_account_type
     *
     * @param string $echeck_account_type eCheck account type.
     *
     * @return $this
     */
    public function setEcheckAccountType($echeck_account_type)
    {
        $this->container['echeck_account_type'] = $echeck_account_type;

        return $this;
    }

    /**
     * Gets echeck_bank_name
     *
     * @return string
     */
    public function getEcheckBankName()
    {
        return $this->container['echeck_bank_name'];
    }

    /**
     * Sets echeck_bank_name
     *
     * @param string $echeck_bank_name eCheck bank name.
     *
     * @return $this
     */
    public function setEcheckBankName($echeck_bank_name)
    {
        $this->container['echeck_bank_name'] = $echeck_bank_name;

        return $this;
    }

    /**
     * Gets echeck_routing_number
     *
     * @return string
     */
    public function getEcheckRoutingNumber()
    {
        return $this->container['echeck_routing_number'];
    }

    /**
     * Sets echeck_routing_number
     *
     * @param string $echeck_routing_number eCheck routing number.
     *
     * @return $this
     */
    public function setEcheckRoutingNumber($echeck_routing_number)
    {
        $this->container['echeck_routing_number'] = $echeck_routing_number;

        return $this;
    }

    /**
     * Gets echeck_type
     *
     * @return string
     */
    public function getEcheckType()
    {
        return $this->container['echeck_type'];
    }

    /**
     * Sets echeck_type
     *
     * @param string $echeck_type eCheck type.
     *
     * @return $this
     */
    public function setEcheckType($echeck_type)
    {
        $this->container['echeck_type'] = $echeck_type;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return int
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int $entity_id Entity ID.
     *
     * @return $this
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets last_trans_id
     *
     * @return string
     */
    public function getLastTransId()
    {
        return $this->container['last_trans_id'];
    }

    /**
     * Sets last_trans_id
     *
     * @param string $last_trans_id Last transaction ID.
     *
     * @return $this
     */
    public function setLastTransId($last_trans_id)
    {
        $this->container['last_trans_id'] = $last_trans_id;

        return $this;
    }

    /**
     * Gets method
     *
     * @return string
     */
    public function getMethod()
    {
        return $this->container['method'];
    }

    /**
     * Sets method
     *
     * @param string $method Method.
     *
     * @return $this
     */
    public function setMethod($method)
    {
        $this->container['method'] = $method;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int $parent_id Parent ID.
     *
     * @return $this
     */
    public function setParentId($parent_id)
    {
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets po_number
     *
     * @return string
     */
    public function getPoNumber()
    {
        return $this->container['po_number'];
    }

    /**
     * Sets po_number
     *
     * @param string $po_number PO number.
     *
     * @return $this
     */
    public function setPoNumber($po_number)
    {
        $this->container['po_number'] = $po_number;

        return $this;
    }

    /**
     * Gets protection_eligibility
     *
     * @return string
     */
    public function getProtectionEligibility()
    {
        return $this->container['protection_eligibility'];
    }

    /**
     * Sets protection_eligibility
     *
     * @param string $protection_eligibility Protection eligibility.
     *
     * @return $this
     */
    public function setProtectionEligibility($protection_eligibility)
    {
        $this->container['protection_eligibility'] = $protection_eligibility;

        return $this;
    }

    /**
     * Gets quote_payment_id
     *
     * @return int
     */
    public function getQuotePaymentId()
    {
        return $this->container['quote_payment_id'];
    }

    /**
     * Sets quote_payment_id
     *
     * @param int $quote_payment_id Quote payment ID.
     *
     * @return $this
     */
    public function setQuotePaymentId($quote_payment_id)
    {
        $this->container['quote_payment_id'] = $quote_payment_id;

        return $this;
    }

    /**
     * Gets shipping_amount
     *
     * @return float
     */
    public function getShippingAmount()
    {
        return $this->container['shipping_amount'];
    }

    /**
     * Sets shipping_amount
     *
     * @param float $shipping_amount Shipping amount.
     *
     * @return $this
     */
    public function setShippingAmount($shipping_amount)
    {
        $this->container['shipping_amount'] = $shipping_amount;

        return $this;
    }

    /**
     * Gets shipping_captured
     *
     * @return float
     */
    public function getShippingCaptured()
    {
        return $this->container['shipping_captured'];
    }

    /**
     * Sets shipping_captured
     *
     * @param float $shipping_captured Shipping captured.
     *
     * @return $this
     */
    public function setShippingCaptured($shipping_captured)
    {
        $this->container['shipping_captured'] = $shipping_captured;

        return $this;
    }

    /**
     * Gets shipping_refunded
     *
     * @return float
     */
    public function getShippingRefunded()
    {
        return $this->container['shipping_refunded'];
    }

    /**
     * Sets shipping_refunded
     *
     * @param float $shipping_refunded Shipping refunded.
     *
     * @return $this
     */
    public function setShippingRefunded($shipping_refunded)
    {
        $this->container['shipping_refunded'] = $shipping_refunded;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Swagger\Client\Model\SalesDataOrderPaymentExtensionInterface
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Swagger\Client\Model\SalesDataOrderPaymentExtensionInterface $extension_attributes extension_attributes
     *
     * @return $this
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


